/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.view;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.view.AbstractViewDisplay;
import com.ibm.etools.fm.editor.template.dialogs.DateTimeDialog;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SingleDisplayComposite
extends AbstractViewDisplay {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int FIELD_INDEX = 0;
    private static final int PICTURE_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int START_INDEX = 3;
    private static final int LEN_INDEX = 4;
    private static final int DATA_INDEX = 5;
    private static final int LINE_INFO_INDEX = 6;
    private static final int KEY_INDEX = 7;
    protected static final String EMPTY = "";
    protected static final String VALUE_LINE = "value";
    protected static final String HEX_LINE_WITH_NO_SEARCH_HIT = "hexNoHit";
    protected static final String HEX_LINE_WITH_SEARCH_HIT = "hexWithHit";
    protected static final String KEY_LINE = "key";
    protected static final String SEARCH_HIT_LINE_MARKER = "searchHitLine";
    protected static final String DATA_IN_ERROR_LINE_MARKER = "dataInError";
    protected ImsEditor currentEditor = null;
    protected DisplayLine currentLine = null;
    protected Table recordTable = null;
    protected TableViewer recordTableViewer = null;
    protected TableCursor tableCursor = null;
    private TraverseListener ignoreTraverseListener;

    public SingleDisplayComposite(ImsEditor currentEditor) {
        this.currentEditor = currentEditor;
    }

    @Override
    public Composite createDisplayComposite(Composite parent) {
        this.displayComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.recordTable = new Table(this.displayComposite, 68354);
        this.recordTable.setHeaderVisible(true);
        this.recordTable.setLinesVisible(true);
        this.recordTable.setFont(JFaceResources.getTextFont());
        this.recordTableViewer = new TableViewer(this.recordTable);
        SingleDisplayComposite.createColumns(this.recordTableViewer);
        this.recordTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.recordTable.setLayoutData((Object)gd);
        this.displayComposite.setLayoutData((Object)gd);
        this.createTableCursor();
        return this.displayComposite;
    }

    private static void createColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_FIELD, 200, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_PIC, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_TYPE, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_START, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_LENGTH, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_VALUE, 700, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new SingleDisplayLabelProvider());
    }

    protected ArrayList<String[]> prepareContents() {
        if (this.currentLine == null || this.currentEditor == null) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        if (this.currentLine instanceof ShadowGroup) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        if (this.currentEditor.getTemplateResource() == null) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        this.recordTable.setEnabled(true);
        ArrayList<String[]> contents = new ArrayList<String[]>();
        HdrType aHdr = this.currentEditor.getCurrentTableHeader(this.currentEditor.getLayout(this.currentLine.getRecord()).getId());
        if (aHdr == null) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        EList columnInfos = aHdr.getHdrfld();
        TemplateType aTemplate = this.currentEditor.getCurrentTemplate();
        int i = 0;
        while (i < columnInfos.size()) {
            HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(this.currentLine.getRecord(), aColumnInfo, aTemplate);
            FieldType aField = FormattedPageUtility.getField(this.currentLine.getRecord(), i + 1);
            if (aField != null) {
                String symbolName = (aSymbol.getHeading() != null && aSymbol.getHeading().length() > 0 ? aSymbol.getHeading() : aSymbol.getName(this.currentEditor.getSystem())) + (aColumnInfo.getDim() != null ? aColumnInfo.getDim() : EMPTY);
                String value = EMPTY;
                if (aField != null) {
                    value = FormattedPageUtility.performLocalStrProc(aSymbol) ? FormattedPageUtility.getANValue(this.currentEditor.getSessionProperties(), this.currentLine.getRecord(), aSymbol, aField, aColumnInfo, false, this.currentEditor.getResource(), this.currentEditor.getSessionIdentifier().getEditorOffset()) : (FormattedPageUtility.performAnVcStrProc(aSymbol) ? FormattedPageUtility.getPliVCValue(this.currentEditor.getSessionProperties(), this.currentLine.getRecord(), aSymbol, aField, aColumnInfo, this.currentEditor.getResource(), true) : aField.getValue());
                }
                String start = aColumnInfo.isSetStart() ? EMPTY + aColumnInfo.getStart() : EMPTY + aSymbol.getStart();
                String length = EMPTY + (aSymbol.isSetLength() ? aSymbol.getLength() : aColumnInfo.getLen());
                String lineType = VALUE_LINE;
                if (aField != null && aField.getFindhit() > 0) {
                    lineType = SEARCH_HIT_LINE_MARKER;
                } else if (aField != null && (aField.isError() || aField.isInerror())) {
                    lineType = DATA_IN_ERROR_LINE_MARKER;
                }
                String keyLine = EMPTY;
                if (aColumnInfo.isKey() || aSymbol.isKey()) {
                    keyLine = KEY_LINE;
                }
                String picture = aSymbol.getPicture() != null ? aSymbol.getPicture() : EMPTY;
                String type = DateTimeDialog.DeletedDateTime(aSymbol.getDatetime()) ? aSymbol.getType().getName() : "DT";
                String[] aLine = new String[]{symbolName, picture, type, start, length, value, lineType, keyLine};
                contents.add(aLine);
                if (this.currentEditor.isHexMode()) {
                    List<HexRecordWrapper> hexLines = null;
                    hexLines = this.currentLine instanceof HexRecordWrapper ? ((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers() : this.currentLine.getHexWrappers();
                    if (hexLines.size() == 2) {
                        value = aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getHexHighOrLowValueVC(this.currentEditor.getSessionProperties(), hexLines.get(0), aSymbol, aField, aColumnInfo) : FormattedPageUtility.getHexHighOrLowValue(this.currentEditor.getSessionProperties(), hexLines.get(0), aSymbol, aField, aColumnInfo);
                        aLine = aField != null && aField.getFindhit() > 0 ? new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_SEARCH_HIT, keyLine} : new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_NO_SEARCH_HIT, keyLine};
                        contents.add(aLine);
                        value = aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getHexHighOrLowValueVC(this.currentEditor.getSessionProperties(), hexLines.get(1), aSymbol, aField, aColumnInfo) : FormattedPageUtility.getHexHighOrLowValue(this.currentEditor.getSessionProperties(), hexLines.get(1), aSymbol, aField, aColumnInfo);
                        aLine = aField != null && aField.getFindhit() > 0 ? new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_SEARCH_HIT, keyLine} : new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_NO_SEARCH_HIT, keyLine};
                        contents.add(aLine);
                    } else {
                        aLine = new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, HEX_LINE_WITH_NO_SEARCH_HIT, keyLine};
                        contents.add(aLine);
                        contents.add(aLine);
                    }
                }
            }
            ++i;
        }
        return contents;
    }

    private void createTableCursor() {
        this.tableCursor = new TableCursor(this.recordTable, 0);
        this.tableCursor.setFont(JFaceResources.getTextFont());
        final ControlEditor cellEditor = new ControlEditor((Composite)this.tableCursor);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.tableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleDisplayComposite.this.recordTable.setSelection(new TableItem[]{SingleDisplayComposite.this.tableCursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Text text2 = SingleDisplayComposite.this.createTextForEdit();
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.tableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    Text text2 = SingleDisplayComposite.this.createTextForEdit();
                    if (text2 != null) {
                        cellEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                } else {
                    SingleDisplayComposite.this.tableCursor.setVisible(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Text text2 = SingleDisplayComposite.this.createTextForEdit();
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.tableCursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    SingleDisplayComposite.this.handleTraverseEvent(e);
                }
            }
        });
        this.tableCursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!Character.isISOControl(e.character)) {
                    Text text2 = SingleDisplayComposite.this.createTextForEdit();
                    if (text2 != null && text2.getEditable()) {
                        text2.setText(SingleDisplayComposite.EMPTY + e.character);
                        text2.setSelection(1, 1);
                        cellEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                } else if (e.keyCode == 0x1000009) {
                    SingleDisplayComposite.this.currentEditor.setInsertMode(!SingleDisplayComposite.this.currentEditor.isInsertMode());
                }
            }
        });
    }

    private void handleTraverseEvent(TraverseEvent te) {
        int columnPos = this.tableCursor.getColumn();
        int rowIndex = this.recordTableViewer.getTable().indexOf(this.tableCursor.getRow());
        int newColumnPos = columnPos;
        int newRowIndex = rowIndex;
        if ((te.stateMask & 0x20000) != 0) {
            if (rowIndex == 0 && columnPos == 0) {
                te.doit = true;
                return;
            }
            if (columnPos == 0) {
                newColumnPos = 5;
                newRowIndex = rowIndex - 1;
            } else {
                newColumnPos = columnPos - 1;
                newRowIndex = rowIndex;
            }
        } else {
            if (rowIndex == this.recordTable.getItemCount() - 1 && columnPos == 5) {
                te.doit = true;
                return;
            }
            if (columnPos == 5) {
                newColumnPos = 0;
                newRowIndex = rowIndex + 1;
            } else {
                newColumnPos = columnPos + 1;
                newRowIndex = rowIndex;
            }
        }
        te.doit = false;
        this.tableCursor.setSelection(newRowIndex, newColumnPos);
        this.recordTable.setSelection(this.tableCursor.getRow());
    }

    private Text createTextForEdit() {
        String[] data;
        if (this.currentLine == null || this.currentEditor == null) {
            return null;
        }
        if (this.currentLine instanceof ShadowGroup) {
            return null;
        }
        if (this.currentEditor.getTemplateResource() == null) {
            return null;
        }
        if (this.tableCursor.getColumn() != 5) {
            return null;
        }
        if (!this.currentEditor.isEditSession()) {
            return null;
        }
        if (this.recordTable.getSelectionIndex() == -1) {
            this.recordTable.setSelection(this.tableCursor.getRow());
        }
        if ((data = (String[])this.tableCursor.getRow().getData())[7].equals(KEY_LINE)) {
            return null;
        }
        boolean isHexUpdate = false;
        int rowIndex = this.recordTable.indexOf(this.tableCursor.getRow());
        if (this.currentEditor.isHexMode()) {
            if (rowIndex % 3 != 0) {
                isHexUpdate = true;
            }
            rowIndex /= 3;
        }
        HdrType aHdr = this.currentEditor.getCurrentTableHeader(this.currentEditor.getLayout(this.currentLine.getRecord()).getId());
        EList columnInfos = aHdr.getHdrfld();
        TemplateType aTemplate = this.currentEditor.getCurrentTemplate();
        HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(rowIndex);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(this.currentLine.getRecord(), aColumnInfo, aTemplate);
        FieldType aField = FormattedPageUtility.getField(this.currentLine.getRecord(), rowIndex + 1);
        if (aField.isFieldUpdatedLocally() && aSymbol.getCreate() != CreateType.AN && aSymbol.getCreate() != CreateType.VC && (isHexUpdate ? aField.isFieldUpdatedLocally() && !aField.isFieldUpdatedByHex() : aField.isFieldUpdatedLocally() && aField.isFieldUpdatedByHex())) {
            return null;
        }
        final Text text2 = new Text((Composite)this.tableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        int length = this.getFieldLength();
        if (length != -1) {
            text2.setTextLimit(length);
        }
        text2.setText(this.tableCursor.getRow().getText(this.tableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        SingleDisplayComposite.this.updateFieldValue(text2.getText());
                        text2.dispose();
                        break;
                    }
                    case 0x1000009: {
                        SingleDisplayComposite.this.currentEditor.setInsertMode(!SingleDisplayComposite.this.currentEditor.isInsertMode());
                        break;
                    }
                    case 27: {
                        text2.dispose();
                        break;
                    }
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (SingleDisplayComposite.this.currentEditor.isHexMode()) {
                    int selIndex = SingleDisplayComposite.this.recordTable.getSelectionIndex();
                    if (selIndex % 3 != 0) {
                        if (!Character.isISOControl(ve.character)) {
                            if (!SingleDisplayComposite.this.currentEditor.isInsertMode()) {
                                if (text2.getSelectionCount() == 0) {
                                    String value = SingleDisplayComposite.EMPTY + ve.character;
                                    if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(value).matches()) {
                                        int pos = text2.getCaretPosition();
                                        text2.setSelection(pos, pos + 1);
                                        ve.doit = true;
                                    } else {
                                        ve.doit = false;
                                    }
                                }
                            } else {
                                FormattedPageUtility.hexEntryTextValue(ve);
                            }
                        } else if (ve.keyCode == 0) {
                            if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(ve.text).matches()) {
                                ve.text = ve.text.toUpperCase();
                                ve.doit = true;
                            } else {
                                ve.doit = false;
                            }
                        }
                    } else if (!Character.isISOControl(ve.character) && !SingleDisplayComposite.this.currentEditor.isInsertMode() && text2.getSelectionCount() == 0) {
                        int pos = text2.getCaretPosition();
                        text2.setSelection(pos, pos + 1);
                        ve.doit = true;
                    }
                } else if (!Character.isISOControl(ve.character) && !SingleDisplayComposite.this.currentEditor.isInsertMode() && text2.getSelectionCount() == 0) {
                    int pos = text2.getCaretPosition();
                    text2.setSelection(pos, pos + 1);
                    ve.doit = true;
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SingleDisplayComposite.this.updateFieldValue(text2.getText());
                text2.dispose();
                SingleDisplayComposite.this.recordTableViewer.refresh();
            }
        });
        text2.addTraverseListener(this.traverseIgnoreListener());
        return text2;
    }

    private void updateFieldValue(String newValue) {
        if (this.recordTable.getSelectionIndex() == -1) {
            return;
        }
        this.tableCursor.getRow().setText(this.tableCursor.getColumn(), newValue);
        if (this.currentEditor.isHexMode()) {
            if (this.recordTable.getSelectionIndex() % 3 == 0) {
                if (this.currentLine instanceof HexRecordWrapper) {
                    this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine(), this.recordTable.getSelectionIndex() / 3, newValue, false);
                } else {
                    this.currentEditor.updateFieldValue(this.currentLine, this.recordTable.getSelectionIndex() / 3, newValue, false);
                }
            } else if (this.recordTable.getSelectionIndex() % 3 == 1) {
                if (this.currentLine instanceof HexRecordWrapper) {
                    this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers().get(0), this.recordTable.getSelectionIndex() / 3, newValue, true);
                } else {
                    this.currentEditor.updateFieldValue(this.currentLine.getHexWrappers().get(0), this.recordTable.getSelectionIndex() / 3, newValue, true);
                }
            } else if (this.currentLine instanceof HexRecordWrapper) {
                this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers().get(1), this.recordTable.getSelectionIndex() / 3, newValue, true);
            } else {
                this.currentEditor.updateFieldValue(this.currentLine.getHexWrappers().get(1), this.recordTable.getSelectionIndex() / 3, newValue, true);
            }
        } else {
            this.currentEditor.updateFieldValue(this.currentLine, this.recordTable.getSelectionIndex(), newValue, false);
        }
    }

    private int getFieldLength() {
        if (this.currentEditor.isHexMode()) {
            if (this.recordTable.getSelectionIndex() % 3 == 0) {
                if (this.tableCursor.getRow().getText(2).equals(CreateType.AN.getName())) {
                    return Integer.parseInt(this.tableCursor.getRow().getText(4));
                }
                return -1;
            }
            int index = this.recordTable.getSelectionIndex() - this.recordTable.getSelectionIndex() % 3;
            return Integer.parseInt(this.recordTable.getItem(index).getText(4));
        }
        if (this.tableCursor.getRow().getText(2).equals(CreateType.AN.getName())) {
            return Integer.parseInt(this.tableCursor.getRow().getText(4));
        }
        return -1;
    }

    @Override
    public void displayCurrentLine(IFMEditor imsEditor, DisplayLine curLine) {
        this.currentEditor = (ImsEditor)imsEditor;
        this.currentLine = curLine;
        this.recordTableViewer.setInput(this.prepareContents());
    }

    @Override
    public void clearViewContents() {
        this.currentEditor = null;
        this.currentLine = null;
        this.recordTableViewer.setInput(this.prepareContents());
    }

    private TraverseListener traverseIgnoreListener() {
        if (this.ignoreTraverseListener != null) {
            return this.ignoreTraverseListener;
        }
        this.ignoreTraverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    e.doit = false;
                }
            }
        };
        return this.ignoreTraverseListener;
    }

    @Override
    public String getDisplayModeName() {
        return Messages.SingleDisplayComposite_4;
    }

    private static class SingleDisplayLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private SingleDisplayLabelProvider() {
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            if (5 == columnIndex) {
                String[] elements = (String[])element;
                if (SingleDisplayComposite.HEX_LINE_WITH_NO_SEARCH_HIT.equals(elements[6])) {
                    return FormattedEditorPreferencePage.getHexForegroundColor();
                }
                if (SingleDisplayComposite.HEX_LINE_WITH_SEARCH_HIT.equals(elements[6])) {
                    return FormattedEditorPreferencePage.getHexForegroundColor();
                }
                if (SingleDisplayComposite.KEY_LINE.equals(elements[7])) {
                    return FormattedEditorPreferencePage.getHighlightColor();
                }
                if (SingleDisplayComposite.DATA_IN_ERROR_LINE_MARKER.equals(elements[6])) {
                    return Display.getDefault().getSystemColor(3);
                }
            }
            return null;
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            if (5 == columnIndex) {
                String[] elements = (String[])element;
                if (SingleDisplayComposite.HEX_LINE_WITH_SEARCH_HIT.equals(elements[6])) {
                    return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
                }
                if (SingleDisplayComposite.SEARCH_HIT_LINE_MARKER.equals(elements[6])) {
                    return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
                }
                if (SingleDisplayComposite.KEY_LINE.equals(elements[7])) {
                    return FormattedEditorPreferencePage.getLenErrTextBackgroundColor();
                }
            }
            return null;
        }
    }
}

