/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.view;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.view.AbstractViewDisplay;
import com.ibm.etools.fm.editor.formatted1.view.DumpDisplayComposite;
import com.ibm.etools.fm.editor.formatted1.view.SingleDisplayComposite;
import com.ibm.etools.fm.editor.formatted1.view.StructureDisplayComposite;
import com.ibm.etools.fm.editor.formatted1.view.UnstructuredDisplayComposite;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ImsEditorView
extends ViewPart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fm.editor.formatted1.view.ImsEditorView";
    private List<AbstractViewDisplay> viewModes;
    private ImsEditor currentEditor;
    private DisplayLine currentLine;
    private String viewDefaultName;
    private Text segmentNameText;
    private Text levelText;
    private Text layoutNameText;
    private Text concatKeyText;
    private Composite stackComposite;
    private StackLayout stackLayout;
    private SingleDisplayComposite singleDisplay;
    private DumpDisplayComposite dumpDisplay;
    private StructureDisplayComposite structureDisplay;
    private UnstructuredDisplayComposite unstructuredDisplay;
    private Combo viewModeCombo;
    private ComboViewer viewModeComboViewer;
    private Text insertModeText;
    private static final Map<IWorkbenchWindow, ImsEditorView> initCompleteInstances = Collections.synchronizedMap(new HashMap());

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        initCompleteInstances.put(site.getWorkbenchWindow(), this);
        this.viewDefaultName = site.getRegisteredName();
    }

    public void dispose() {
        initCompleteInstances.remove(this.getSite().getWorkbenchWindow());
        initCompleteInstances.put(this.getSite().getWorkbenchWindow(), null);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        Composite infoComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)6, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)infoComposite, (String)Messages.SingleDisplayComposite_0, (Object)GUI.grid.d.left1());
        this.segmentNameText = GUI.text.fieldReadOnly((Composite)infoComposite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)infoComposite, (String)Messages.SingleDisplayComposite_1, (Object)GUI.grid.d.left1());
        this.levelText = GUI.text.fieldReadOnly((Composite)infoComposite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)infoComposite, (String)Messages.SingleDisplayComposite_2, (Object)GUI.grid.d.left1());
        this.layoutNameText = GUI.text.fieldReadOnly((Composite)infoComposite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)infoComposite, (String)Messages.SingleDisplayComposite_3, (Object)GUI.grid.d.left1());
        this.concatKeyText = GUI.text.fieldReadOnly((Composite)infoComposite, (Object)GUI.grid.d.fillH((int)5));
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.stackComposite.setLayoutData((Object)gd);
        this.viewModes = new ArrayList<AbstractViewDisplay>();
        this.singleDisplay = new SingleDisplayComposite(this.currentEditor);
        this.singleDisplay.createDisplayComposite(this.stackComposite);
        this.dumpDisplay = new DumpDisplayComposite(this.currentEditor);
        this.dumpDisplay.createDisplayComposite(this.stackComposite);
        this.structureDisplay = new StructureDisplayComposite(this.currentEditor);
        this.structureDisplay.createDisplayComposite(this.stackComposite);
        this.unstructuredDisplay = new UnstructuredDisplayComposite(this.currentEditor);
        this.unstructuredDisplay.createDisplayComposite(this.stackComposite);
        this.viewModes.add(this.singleDisplay);
        this.viewModes.add(this.dumpDisplay);
        this.viewModes.add(this.structureDisplay);
        this.viewModes.add(this.unstructuredDisplay);
        this.stackLayout.topControl = this.singleDisplay.getDisplayComposite();
        this.createBottomComposite(composite);
    }

    private void createBottomComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)composite, (String)Messages.SingleView_InsertMode, (Object)GUI.grid.d.left1());
        GridData data = GUI.grid.d.left1();
        data.widthHint = 150;
        this.insertModeText = GUI.text.fieldReadOnly((Composite)composite, (Object)data);
        this.setInsertModeText();
        GUI.label.left((Composite)composite, (String)Messages.SingleView_View_MODE, (Object)GUI.grid.d.left1());
        GridData modeGridData = GUI.grid.d.left1();
        modeGridData.widthHint = 150;
        this.viewModeCombo = GUI.combo((Composite)composite, (Object)modeGridData, (int)8);
        this.viewModeComboViewer = new ComboViewer(this.viewModeCombo);
        this.viewModeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewModeComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof AbstractViewDisplay) {
                    return ((AbstractViewDisplay)element).getDisplayModeName();
                }
                return "";
            }
        });
        this.viewModeComboViewer.setInput(this.viewModes);
        this.viewModeCombo.select(0);
        this.viewModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImsEditorView.this.setViewMode();
            }
        });
    }

    private void setInsertModeText() {
        if (this.currentEditor == null) {
            this.insertModeText.setText("");
        } else if (this.currentEditor.isInsertMode()) {
            this.insertModeText.setText(Messages.FormattedEditorActionBarContributor_INSERT);
        } else {
            this.insertModeText.setText(Messages.FormattedEditorActionBarContributor_OVERWRITE);
        }
    }

    private void setViewMode() {
        IStructuredSelection selection = (IStructuredSelection)this.viewModeComboViewer.getSelection();
        if (selection != null) {
            this.stackLayout.topControl = ((AbstractViewDisplay)selection.getFirstElement()).getDisplayComposite();
            this.stackComposite.layout();
        }
    }

    public static void displayCurrentRecord(ImsEditor editor2, DisplayLine curLine) {
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        ImsEditorView singleView = ImsEditorView.getImsView(editor2);
        if (singleView != null) {
            singleView.displayCurrentLine(editor2, curLine);
        }
    }

    private static ImsEditorView getImsView(ImsEditor editor2) {
        ImsEditorView singleView;
        block4: {
            Objects.requireNonNull(editor2, "Must provide a non-null editor.");
            singleView = initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
            if (singleView == null) {
                try {
                    IViewPart viewPart = PDPlatformUIUtils.view.showView((String)ID);
                    if (viewPart instanceof ImsEditorView) {
                        singleView = (ImsEditorView)viewPart;
                        break block4;
                    }
                    singleView = null;
                    String errMsg = MessageFormat.format(Messages.SingleView_NO_VIEW_FOUND, viewPart == null ? "null" : viewPart.getClass().getName());
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    PDLogger.get(ImsEditorView.class).error((Object)errMsg);
                    return null;
                }
                catch (Exception e) {
                    String errMsg = Messages.SingleView_NO_VIEW_EX;
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    PDLogger.get(ImsEditorView.class).error((Object)errMsg, (Throwable)e);
                    return null;
                }
            }
        }
        PDPlatformUIUtils.view.showView((String)ID);
        return singleView;
    }

    public static void updateInsertMode(ImsEditor editor2) {
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        ImsEditorView singleView = ImsEditorView.getImsView(editor2);
        if (singleView != null) {
            singleView.setInsertModeText();
        }
    }

    private void displayCurrentLine(ImsEditor editor2, DisplayLine curLine) {
        this.currentEditor = editor2;
        this.currentLine = curLine;
        this.setSegmentInformation(curLine);
        ImsEditorView.getSingleViewFromThisWindow(editor2).setPartName(this.currentEditor.getResource().getFormattedName());
        for (AbstractViewDisplay viewMode : this.viewModes) {
            if (curLine != null) {
                viewMode.displayCurrentLine(editor2, this.currentLine);
                continue;
            }
            viewMode.clearViewContents();
        }
        this.viewModeCombo.setEnabled(true);
        this.setInsertModeText();
    }

    private void setSegmentInformation(DisplayLine aLine) {
        RecType aRec = aLine.getRecord();
        this.segmentNameText.setText(aRec.getSegname());
        this.levelText.setText("" + this.currentEditor.getSegmentLevel(aRec.getSegname()));
        String encoding = this.currentEditor.getResource().getPersistentProperty("encoding");
        String keyForDisplay = DataConversionUtils.hexToDisplayString((String)(aRec.getCkey() != null ? aRec.getCkey() : ""), (String)encoding);
        if (keyForDisplay == null) {
            keyForDisplay = aRec.getCkey() != null ? aRec.getCkey() : "";
        }
        this.concatKeyText.setText(keyForDisplay);
        this.layoutNameText.setText(((Symboltype)this.currentEditor.getLayout(this.currentLine.getRecord()).getSymbol().get(0)).getName(this.currentEditor.getSystem()));
    }

    public static void clearCurrentContents(ImsEditor editor2) {
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        ImsEditorView singleView = ImsEditorView.getSingleViewFromThisWindow(editor2);
        if (singleView != null) {
            singleView.clearViewContents(editor2);
        }
    }

    private void clearViewContents(ImsEditor editor2) {
        if (editor2 == this.currentEditor) {
            this.currentEditor = null;
            this.currentLine = null;
            ImsEditorView.getSingleViewFromThisWindow(editor2).setPartName(this.viewDefaultName);
            for (AbstractViewDisplay display : this.viewModes) {
                display.clearViewContents();
            }
            this.viewModeCombo.setEnabled(false);
            this.setInsertModeText();
        }
    }

    public void setFocus() {
    }

    private static ImsEditorView getSingleViewFromThisWindow(ImsEditor editor2) {
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        return initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
    }
}

