/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.view;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted1.view.AbstractViewDisplay;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DumpDisplayComposite
extends AbstractViewDisplay {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DumpDisplayComposite.class);
    private static final int BYTES_PER_LINE = 16;
    private String hostConCp = null;
    private IFMEditor currentEditor = null;
    private DisplayLine currentLine = null;
    private Table hexValueTable = null;
    private TableViewer hexValueTableViewer = null;
    private Table textValueTable = null;
    private TableViewer textValueTableViewer = null;

    public DumpDisplayComposite(IFMEditor currentEditor) {
        this.currentEditor = currentEditor;
    }

    @Override
    public Composite createDisplayComposite(Composite parent) {
        this.displayComposite = new SashForm(parent, 256);
        this.displayComposite.setLayout((Layout)new FillLayout());
        this.createHexValueTable(this.displayComposite);
        this.createTextValueTable(this.displayComposite);
        return this.displayComposite;
    }

    private void createHexValueTable(Composite parent) {
        this.hexValueTable = new Table(parent, 68354);
        this.hexValueTable.setHeaderVisible(true);
        this.hexValueTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hexValueTable.setLayoutData((Object)gd);
        this.hexValueTableViewer = new TableViewer(this.hexValueTable);
        Font font = JFaceResources.getTextFont();
        this.hexValueTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.hexValueTableViewer.getTable());
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        int charWidth = metrics.getAverageCharWidth();
        DumpDisplayComposite.createHexValueTableColumns(this.hexValueTableViewer, charWidth);
        this.hexValueTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hexValueTableViewer.setInput(this.prepareContents());
    }

    private static void createHexValueTableColumns(TableViewer viewer, int charWidth) {
        TableViewerColumn offsetColumn = FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_OFFSET, 80, viewer, 0x1000000);
        offsetColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                cell.setText(elements[0]);
            }
        });
        int i = 0;
        while (i < 16) {
            DumpDisplayComposite.createHexValueTableColumn(viewer, i + 1, charWidth);
            ++i;
        }
    }

    private static void createHexValueTableColumn(TableViewer viewer, final int index, int charWidth) {
        TableViewerColumn infoColumn = FormattedEditorUtility.createTableViewerColumn(Integer.toHexString(index - 1).toUpperCase(), charWidth * 4, viewer, 0x1000000);
        infoColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                String hexValue = elements[1];
                if ((index - 1) * 2 >= hexValue.length()) {
                    cell.setBackground(Display.getDefault().getSystemColor(15));
                } else {
                    int beginIndex = (index - 1) * 2;
                    String value = hexValue.substring(beginIndex, beginIndex + 2);
                    cell.setText(value);
                }
            }
        });
    }

    private void createTextValueTable(Composite parent) {
        this.textValueTable = new Table(parent, 68354);
        this.textValueTable.setHeaderVisible(true);
        this.textValueTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textValueTable.setLayoutData((Object)gd);
        this.textValueTableViewer = new TableViewer(this.textValueTable);
        Font font = JFaceResources.getTextFont();
        this.textValueTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.textValueTableViewer.getTable());
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        int charWidth = metrics.getAverageCharWidth();
        this.createTextValueTableColumns(this.textValueTableViewer, charWidth);
        this.textValueTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.textValueTableViewer.setInput(this.prepareContents());
    }

    private void createTextValueTableColumns(TableViewer viewer, int charWidth) {
        int i = 0;
        while (i < 16) {
            this.createTextValueTableColumn(viewer, i, charWidth);
            ++i;
        }
    }

    private void createTextValueTableColumn(TableViewer viewer, final int index, int charWidth) {
        TableViewerColumn infoColumn = FormattedEditorUtility.createTableViewerColumn(Integer.toHexString(index).toUpperCase(), charWidth * 3, viewer, 0x1000000);
        infoColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                String hexValue = elements[1];
                if (index * 2 >= hexValue.length()) {
                    cell.setBackground(Display.getDefault().getSystemColor(15));
                } else {
                    int beginIndex = index * 2;
                    String value = hexValue.substring(beginIndex, beginIndex + 2);
                    String ebcdicValue = "";
                    byte[] byteValue = DataConversionUtils.getEBCDICData((String)value);
                    try {
                        ebcdicValue = new String(byteValue, DumpDisplayComposite.this.hostConCp).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
                    }
                    catch (UnsupportedEncodingException e) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.SingleView_CONV_ERR, DumpDisplayComposite.this.currentLine.getRecord().getRecno(), DumpDisplayComposite.this.currentLine.getResource().getFormattedName()), (Throwable)e);
                        ebcdicValue = "";
                    }
                    cell.setText(ebcdicValue);
                }
            }
        });
    }

    private ArrayList<String[]> prepareContents() {
        ArrayList<String[]> contents = new ArrayList<String[]>();
        if (this.currentLine == null) {
            return contents;
        }
        String hexValue = this.currentLine.getRecord().getHex();
        StringBuilder col0 = new StringBuilder();
        StringBuilder col1 = new StringBuilder();
        int i = 0;
        while (i < hexValue.length()) {
            if (i % 32 == 0) {
                if (i == 0) {
                    col0.append("+" + Integer.toHexString(i * 16).toUpperCase());
                } else {
                    String[] aRow = new String[]{col0.toString(), col1.toString()};
                    contents.add(aRow);
                    col0 = new StringBuilder();
                    col0.append("+" + Integer.toHexString(contents.size() * 16).toUpperCase());
                    col1 = new StringBuilder();
                }
            }
            col1.append(hexValue.charAt(i));
            ++i;
        }
        String[] aRow = new String[]{col0.toString(), col1.toString()};
        contents.add(aRow);
        return contents;
    }

    @Override
    public void displayCurrentLine(IFMEditor editor2, DisplayLine currentLine) {
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.clearViewContents();
        } else {
            this.currentEditor = editor2;
            this.hostConCp = this.currentEditor.getResource().getPersistentProperty("encoding");
            this.currentLine = currentLine;
            this.hexValueTable.setEnabled(true);
            this.textValueTable.setEnabled(true);
            this.hexValueTableViewer.setInput(this.prepareContents());
            this.textValueTableViewer.setInput(this.prepareContents());
        }
    }

    @Override
    public void clearViewContents() {
        this.currentEditor = null;
        this.hostConCp = null;
        this.currentLine = null;
        this.hexValueTable.setEnabled(false);
        this.textValueTable.setEnabled(false);
        this.hexValueTableViewer.setInput(this.prepareContents());
        this.textValueTableViewer.setInput(this.prepareContents());
    }

    @Override
    public String getDisplayModeName() {
        return Messages.DumpDisplayComposite_0;
    }
}

