/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsSecondaryIndex;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SecondaryIndexSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TABLE_COLUMN_SIZE = 5;
    private static final int INDEX_SECONDARY_INDEX_COLUMN = 0;
    private static final int INDEX_TARGET_SEGMENT_COLUMN = 1;
    private static final int INDEX_SOURCE_SEGMENT_COLUMN = 2;
    private static final int INDEX_SEARCH_FIELDS_COLUMN = 3;
    private static final int INDEX_DATA_COLUMN = 4;
    private Text subsystemText;
    private Text databaseText;
    private Table secondaryIndiciesTable;
    private TableViewer secondaryIndiciesTableViewer;
    private ImsDatabaseInfo databaseInfo;
    private ImsSecondaryIndex selectedIndex = null;

    public SecondaryIndexSelectionDialog(ImsDatabaseInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SecondaryIndexSelectionDialog_0);
        this.setMessage(Messages.SecondaryIndexSelectionDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createInfoComposite(composite);
        this.createTable(composite);
        this.setTableContents();
        this.secondaryIndiciesTable.setFocus();
        return composite;
    }

    private void createInfoComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        this.subsystemText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        ImsSubsystemConfig canonicalConfig = this.databaseInfo.getName().getSubsystem().getCanonicalConfig();
        this.subsystemText.setText(canonicalConfig.getLabel());
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.databaseText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.databaseText.setText(this.databaseInfo.getName().getName());
    }

    private void createTable(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.secondaryIndiciesTable = new Table(composite, 68352);
        this.secondaryIndiciesTable.setHeaderVisible(true);
        this.secondaryIndiciesTable.setLinesVisible(true);
        this.secondaryIndiciesTable.setFont(JFaceResources.getTextFont());
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 200;
        this.secondaryIndiciesTable.setLayoutData((Object)data);
        this.secondaryIndiciesTableViewer = new TableViewer(this.secondaryIndiciesTable);
        this.secondaryIndiciesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FormattedEditorUtility.createTableViewerColumn(Messages.SecondaryIndexSelectionDialog_2, 200, this.secondaryIndiciesTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SecondaryIndexSelectionDialog_3, 200, this.secondaryIndiciesTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SecondaryIndexSelectionDialog_4, 200, this.secondaryIndiciesTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SecondaryIndexSelectionDialog_5, 300, this.secondaryIndiciesTableViewer, 16384);
        this.secondaryIndiciesTableViewer.setLabelProvider((IBaseLabelProvider)new ImsKeyPositioningTableLabelProvider());
        this.secondaryIndiciesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                SecondaryIndexSelectionDialog.this.okPressed();
            }
        });
    }

    private void setTableContents() {
        ArrayList<Object[]> contents = new ArrayList<Object[]>();
        List indices = this.databaseInfo.getSecondaryIndexes();
        for (ImsSecondaryIndex index : indices) {
            Object[] indexLine = new Object[]{index.getName(), index.getTarget().getName(), index.getSource().getName(), SecondaryIndexSelectionDialog.listToString(index.getSearchFieldNames()), index};
            contents.add(indexLine);
        }
        this.secondaryIndiciesTableViewer.setInput(contents);
        this.secondaryIndiciesTable.select(0);
        this.selectedIndex = (ImsSecondaryIndex)this.databaseInfo.getSecondaryIndexes().get(0);
    }

    private static String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String aStr : list) {
            if (sb.length() == 0) {
                sb.append(aStr);
                continue;
            }
            sb.append(", ").append(aStr);
        }
        return sb.toString();
    }

    protected void okPressed() {
        if (this.secondaryIndiciesTable.getSelectionIndex() == -1) {
            this.setErrorMessage(Messages.SecondaryIndexSelectionDialog_6);
            this.secondaryIndiciesTable.setFocus();
            return;
        }
        this.selectedIndex = (ImsSecondaryIndex)this.databaseInfo.getSecondaryIndexes().get(this.secondaryIndiciesTable.getSelectionIndex());
        super.okPressed();
    }

    public ImsSecondaryIndex getSelectedIndex() {
        return this.selectedIndex;
    }

    private static class ImsKeyPositioningTableLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsKeyPositioningTableLabelProvider() {
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }
    }
}

