/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted1.SegmentTableDisplayComposite;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.fmnxdpos.DbposType;
import com.ibm.etools.fm.model.fmnxdpos.Segtype;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ImsSegmentSelectionDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int TABLE_COLUMN_SIZE = 6;
    private static final int INDEX_SELECTION_COLUMN = 0;
    private static final int INDEX_LEVEL_COLUMN = 1;
    private static final int INDEX_SEGMENT_COLUMN = 2;
    private static final int INDEX_SEGMENT_DESCRIPTION_COLUMN = 3;
    private static final int INDEX_SEGMENT_KEY_LENGTH_COLUMN = 4;
    private static final int INDEX_SEGMENT_INFO_COLUMN = 5;
    private static final String SELECTED_SEGMENT = "S";
    private static final String UNSELECTED_SEGMENT = "";
    private ImsEditorOptions options = null;
    private DbposType initDbpos = null;
    private Text subsystemText;
    private Text databaseText;
    private Table segmentTable;
    private TableViewer segmentTableViewer;
    private String initSelectedSegmentName;
    private String selectedSegmentName = "";

    public ImsSegmentSelectionDialog(ImsEditorOptions options, DbposType initDbpos, String initSelectedSegmentName) {
        this.options = options;
        this.initDbpos = initDbpos;
        this.initSelectedSegmentName = initSelectedSegmentName;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ImsSegmentSelectionDialog_0);
        this.setMessage(Messages.ImsSegmentSelectionDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createInfoComposite(composite);
        this.createTable(composite);
        this.setSegmentTreeContents();
        return composite;
    }

    private void createInfoComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        this.subsystemText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        ImsSubsystemConfig canonicalConfig = this.options.getSubsystem().getCanonicalConfig();
        this.subsystemText.setText(canonicalConfig.getLabel());
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.databaseText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        if (this.options.getImsResource() instanceof ImsDatabase) {
            this.databaseText.setText(((ImsDatabase)this.options.getImsResource()).getName());
        } else if (this.options.getImsResource() instanceof ImsPcb) {
            this.databaseText.setText(((ImsPcb)this.options.getImsResource()).getDbd().getName());
        }
    }

    private void createTable(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.segmentTable = new Table(composite, 68352);
        this.segmentTable.setHeaderVisible(true);
        this.segmentTable.setLinesVisible(true);
        this.segmentTable.setFont(JFaceResources.getTextFont());
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 200;
        this.segmentTable.setLayoutData((Object)data);
        this.segmentTableViewer = new TableViewer(this.segmentTable);
        this.segmentTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FormattedEditorUtility.createTableViewerColumn(UNSELECTED_SEGMENT, 50, this.segmentTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsSegmentSelectionDialog_3, 100, this.segmentTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsSegmentSelectionDialog_4, 200, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsSegmentSelectionDialog_5, 200, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsSegmentSelectionDialog_6, 200, this.segmentTableViewer, 16384);
        this.segmentTableViewer.setLabelProvider((IBaseLabelProvider)new ImsKeyPositioningTableLabelProvider());
        this.segmentTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                if (ImsSegmentSelectionDialog.this.segmentTable.getSelectionCount() == 0) {
                    return;
                }
                TableItem selected = ImsSegmentSelectionDialog.this.segmentTable.getSelection()[0];
                Object[] data = (Object[])selected.getData();
                data[0] = data[0].equals(ImsSegmentSelectionDialog.SELECTED_SEGMENT) ? ImsSegmentSelectionDialog.UNSELECTED_SEGMENT : ImsSegmentSelectionDialog.SELECTED_SEGMENT;
                ImsSegmentSelectionDialog.this.unselectExceptSelected(selected);
                ImsSegmentSelectionDialog.this.segmentTableViewer.refresh();
            }
        });
    }

    private void unselectExceptSelected(TableItem selectedItem) {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.segmentTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem anItem = tableItemArray[n2];
            if (!anItem.equals(selectedItem)) {
                Object[] data = (Object[])anItem.getData();
                data[0] = UNSELECTED_SEGMENT;
            }
            ++n2;
        }
    }

    private void setSegmentTreeContents() {
        String encoding = this.options.getImsResource().getPersistentProperty("encoding");
        ArrayList<Object[]> contents = new ArrayList<Object[]>();
        EList segments = this.initDbpos.getSeg();
        for (Segtype aSegment : segments) {
            Object[] aLine = new Object[6];
            aLine[0] = aSegment.getName().equals(this.initSelectedSegmentName) ? SELECTED_SEGMENT : UNSELECTED_SEGMENT;
            aLine[1] = SegmentTableDisplayComposite.getLevelForDisplay(aSegment.getLvl());
            aLine[2] = aSegment.getName();
            aLine[3] = aSegment.getDesc();
            aLine[4] = UNSELECTED_SEGMENT + aSegment.getKeyl();
            String keyForDisplay = DataConversionUtils.hexToDisplayString((String)(aSegment.getHex() != null ? aSegment.getHex() : UNSELECTED_SEGMENT), (String)encoding);
            if (keyForDisplay == null) {
                keyForDisplay = aSegment.getHex() != null ? aSegment.getHex() : UNSELECTED_SEGMENT;
            }
            aLine[5] = aSegment;
            contents.add(aLine);
        }
        this.segmentTableViewer.setInput(contents);
    }

    protected void okPressed() {
        TableItem[] items;
        this.selectedSegmentName = UNSELECTED_SEGMENT;
        TableItem[] tableItemArray = items = this.segmentTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem anItem = tableItemArray[n2];
            Object[] data = (Object[])anItem.getData();
            if (data[0].equals(SELECTED_SEGMENT)) {
                this.selectedSegmentName = (String)data[2];
                break;
            }
            ++n2;
        }
        super.okPressed();
    }

    public String getSelectedSegmentName() {
        return this.selectedSegmentName;
    }

    private static class ImsKeyPositioningTableLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsKeyPositioningTableLabelProvider() {
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            Object[] elements = (Object[])element;
            if (((String)elements[0]).length() > 0) {
                return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }
    }
}

