/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.util.ImsKeyPositionOptionsUtil;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted1.SegmentTableDisplayComposite;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.fmnxdpos.DbposType;
import com.ibm.etools.fm.model.fmnxdpos.OperType;
import com.ibm.etools.fm.model.fmnxdpos.Segtype;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImsKeyPositioningDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final int TABLE_COLUMN_SIZE = 7;
    protected static final int TABLE_VISIBLE_COLUMN_SIZE = 5;
    protected static final int INDEX_LEVEL_COLUMN = 0;
    protected static final int INDEX_SEGMENT_COLUMN = 1;
    protected static final int INDEX_SEGMENT_DESCRIPTION_COLUMN = 2;
    protected static final int INDEX_SEGMENT_KEY_LENGTH_COLUMN = 3;
    protected static final int INDEX_SEGMENT_KEY_VALUE_COLUMN = 4;
    private static final int INDEX_SEGMENT_INFO_COLUMN = 5;
    private static final int INDEX_HEX_LINE_MARKER = 6;
    private static final String HEX_TOP = "hexTop";
    private static final String HEX_BOTTOM = "hexBot";
    private AbstractSessionFormatted session;
    private ImsEditorOptions options = null;
    private DbposType initDbpos = null;
    private String[] originalHexValues = null;
    private boolean inSessionAlready = false;
    private boolean hexOn = false;
    private Text subsystemText;
    private Text databaseText;
    private Table segmentTable;
    private TableViewer segmentTableViewer;
    private TableCursor segmentTableCursor;
    private Button selectAllSegmentButton;
    private Button deselectAllSegmentButton;
    private Button hexOnOffButton;
    private Button useGEOpeButton;

    public ImsKeyPositioningDialog(AbstractSessionFormatted session, ImsEditorOptions options, DbposType initDbpos, boolean inSessionAlready) {
        this.session = session;
        this.options = options;
        this.initDbpos = initDbpos;
        this.inSessionAlready = inSessionAlready;
        EList segments = initDbpos.getSeg();
        this.originalHexValues = new String[segments.size()];
        int i = 0;
        while (i < segments.size()) {
            this.originalHexValues[i] = ((Segtype)segments.get(i)).getHex();
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ImsKeyPositioningDialog_0);
        this.setMessage(Messages.ImsKeyPositioningDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createInfoComposite(composite);
        this.createTable(composite);
        this.createButtonsComposite(composite);
        this.setupSegmentTreeCursor();
        Composite checkComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.useGEOpeButton = GUI.button.checkbox((Composite)checkComposite, (String)Messages.ImsKeyPositioningDialog_2, (Object)GUI.grid.d.left1());
        this.useGEOpeButton.setToolTipText(Messages.ImsKeyPositioningDialog_3);
        this.setSegmentTreeContents();
        if (this.segmentTable.getItemCount() > 0) {
            this.initPositioningAndOperator();
        }
        return composite;
    }

    private void createInfoComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        GridData data1 = GUI.grid.d.left1();
        data1.widthHint = 300;
        this.subsystemText = GUI.text.fieldReadOnly((Composite)composite, (Object)data1);
        ImsSubsystemConfig canonicalConfig = this.options.getSubsystem().getCanonicalConfig();
        if (canonicalConfig != null) {
            this.subsystemText.setText(canonicalConfig.getLabel());
        } else {
            this.subsystemText.setText(Messages.ImsKeyPositioningDialog_ErrorConfigCouldNotBeLoaded);
        }
        GUI.label.left((Composite)composite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        GridData data2 = GUI.grid.d.left1();
        data2.widthHint = 100;
        this.databaseText = GUI.text.fieldReadOnly((Composite)composite, (Object)data2);
        if (this.options.getImsResource() instanceof ImsDatabase) {
            this.databaseText.setText(((ImsDatabase)this.options.getImsResource()).getName());
        } else if (this.options.getImsResource() instanceof ImsPcb) {
            this.databaseText.setText(((ImsPcb)this.options.getImsResource()).getDbd().getName());
        }
    }

    private void createTable(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.segmentTable = new Table(composite, 68384);
        this.segmentTable.setHeaderVisible(true);
        this.segmentTable.setLinesVisible(true);
        this.segmentTable.setFont(JFaceResources.getTextFont());
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 200;
        this.segmentTable.setLayoutData((Object)data);
        this.segmentTableViewer = new TableViewer(this.segmentTable);
        this.segmentTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsKeyPositioningDialog_4, 100, this.segmentTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsKeyPositioningDialog_5, 200, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsKeyPositioningDialog_6, 200, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsKeyPositioningDialog_7, 100, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.ImsKeyPositioningDialog_8, 300, this.segmentTableViewer, 16384);
        this.segmentTableViewer.setLabelProvider((IBaseLabelProvider)new ImsKeyPositioningTableLabelProvider());
        this.segmentTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ImsKeyPositioningDialog.this.hexOn) {
                    return;
                }
                TableItem row = ImsKeyPositioningDialog.this.segmentTableCursor.getRow();
                if (row == null) {
                    return;
                }
                Object[] rowValues = (Object[])row.getData();
                if (ImsKeyPositioningDialog.HEX_TOP.equals(rowValues[6])) {
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) - 1).setChecked(row.getChecked());
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) + 1).setChecked(row.getChecked());
                } else if (ImsKeyPositioningDialog.HEX_BOTTOM.equals(rowValues[6])) {
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) - 2).setChecked(row.getChecked());
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) - 1).setChecked(row.getChecked());
                } else {
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) + 1).setChecked(row.getChecked());
                    ImsKeyPositioningDialog.this.segmentTable.getItem(ImsKeyPositioningDialog.this.segmentTable.indexOf(row) + 2).setChecked(row.getChecked());
                }
            }
        });
    }

    private void createButtonsComposite(Composite parent) {
        Composite buttonsComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)3, (boolean)false), (Object)GUI.grid.d.left1());
        this.selectAllSegmentButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/selectall.png"), (String)Messages.ImsKeyPositioningDialog_9, (Object)GUI.grid.d.left1());
        this.selectAllSegmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsKeyPositioningDialog.this.setAllSegmentSelection(true);
            }
        });
        this.deselectAllSegmentButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/deselectall.png"), (String)Messages.ImsKeyPositioningDialog_10, (Object)GUI.grid.d.left1());
        this.deselectAllSegmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsKeyPositioningDialog.this.setAllSegmentSelection(false);
            }
        });
        this.hexOnOffButton = GUI.button.push((Composite)buttonsComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/convertto_hexdec2.gif"), (String)Messages.ImsKeyPositioningDialog_11, (Object)GUI.grid.d.left1());
        this.hexOnOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsKeyPositioningDialog.this.hexOn = !ImsKeyPositioningDialog.this.hexOn;
                ImsKeyPositioningDialog.this.setSegmentTreeContents();
            }
        });
    }

    private void setSegmentTreeContents() {
        String encoding = this.options.getImsResource().getPersistentProperty("encoding");
        ArrayList<Object[]> contents = new ArrayList<Object[]>();
        EList segments = this.initDbpos.getSeg();
        for (Segtype aSegment : segments) {
            String keyForDisplay;
            Object[] aLine;
            if (!this.hexOn) {
                aLine = new Object[7];
                aLine[0] = SegmentTableDisplayComposite.getLevelForDisplay(aSegment.getLvl());
                aLine[1] = aSegment.getName();
                aLine[2] = aSegment.getDesc();
                aLine[3] = "" + aSegment.getKeyl();
                keyForDisplay = DataConversionUtils.hexToDisplayString((String)(aSegment.getHex() != null ? aSegment.getHex() : ""), (String)encoding);
                if (keyForDisplay == null) {
                    keyForDisplay = aSegment.getHex() != null ? aSegment.getHex() : "";
                }
                aLine[4] = keyForDisplay;
                aLine[5] = aSegment;
                aLine[6] = "";
                contents.add(aLine);
                continue;
            }
            aLine = new Object[7];
            aLine[0] = SegmentTableDisplayComposite.getLevelForDisplay(aSegment.getLvl());
            aLine[1] = aSegment.getName();
            aLine[2] = aSegment.getDesc();
            aLine[3] = "" + aSegment.getKeyl();
            keyForDisplay = DataConversionUtils.hexToDisplayString((String)(aSegment.getHex() != null ? aSegment.getHex() : ""), (String)encoding);
            if (keyForDisplay == null) {
                keyForDisplay = aSegment.getHex() != null ? aSegment.getHex() : "";
            }
            aLine[4] = keyForDisplay;
            aLine[5] = aSegment;
            aLine[6] = "";
            contents.add(aLine);
            String[] highAndLow = ImsKeyPositioningDialog.prepareHexTopAndBottom(aSegment.getHex() != null ? aSegment.getHex() : "");
            Object[] hexLine = new Object[]{"", "", "", "", highAndLow[0], aSegment, HEX_TOP};
            contents.add(hexLine);
            hexLine = new Object[]{"", "", "", "", highAndLow[1], aSegment, HEX_BOTTOM};
            contents.add(hexLine);
        }
        this.segmentTableViewer.setInput(contents);
        this.setCheckStatus();
    }

    private static String[] prepareHexTopAndBottom(String hexValue) {
        StringBuilder sbHigh = new StringBuilder();
        StringBuilder sbLow = new StringBuilder();
        int i = 0;
        while (i < hexValue.length()) {
            if (i % 2 == 0) {
                sbHigh.append(hexValue.charAt(i));
            } else {
                sbLow.append(hexValue.charAt(i));
            }
            ++i;
        }
        return new String[]{sbHigh.toString(), sbLow.toString()};
    }

    private void initPositioningAndOperator() {
        int posIndex = 0;
        OperType opr = OperType.EQ;
        EList segments = this.initDbpos.getSeg();
        int i = 0;
        while (i < segments.size()) {
            Segtype aSegment = (Segtype)segments.get(i);
            if (aSegment.isPos()) {
                posIndex = i;
                if (!aSegment.isSetOper()) break;
                opr = aSegment.getOper();
                break;
            }
            ++i;
        }
        this.segmentTable.select(posIndex);
        if (opr == OperType.EQ) {
            this.useGEOpeButton.setSelection(false);
        } else {
            this.useGEOpeButton.setSelection(true);
        }
    }

    private void setAllSegmentSelection(boolean selection) {
        if (this.segmentTable.getItemCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.segmentTable.getItemCount()) {
            TableItem item = this.segmentTable.getItem(i);
            item.setChecked(selection);
            ++i;
        }
        this.segmentTableViewer.refresh();
    }

    private void setCheckStatus() {
        if (this.segmentTable.getItemCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.segmentTable.getItemCount()) {
            TableItem item = this.segmentTable.getItem(i);
            Segtype aSegment = (Segtype)((Object[])item.getData())[5];
            item.setChecked(aSegment.isSel());
            ++i;
        }
        this.segmentTableViewer.refresh();
    }

    private void setupSegmentTreeCursor() {
        this.segmentTableCursor = new TableCursor(this.segmentTable, 2048);
        this.segmentTableCursor.setFont(JFaceResources.getTextFont());
        final ControlEditor controlEditor = new ControlEditor((Composite)this.segmentTableCursor);
        controlEditor.grabHorizontal = true;
        controlEditor.grabVertical = true;
        this.segmentTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = ImsKeyPositioningDialog.this.segmentTableCursor.getRow();
                int column = ImsKeyPositioningDialog.this.segmentTableCursor.getColumn();
                Text text2 = ImsKeyPositioningDialog.this.getTextEditor((Object[])row.getData(), column);
                if (text2 != null) {
                    text2.setText(row.getText(column));
                    controlEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.segmentTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ImsKeyPositioningDialog.this.okPressed();
            }
        });
        this.segmentTableCursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!Character.isISOControl(e.character) && e.keyCode != 0x1000001 && e.keyCode != 0x1000005 && e.keyCode != 0x1000002 && e.keyCode != 0x1000005 && e.keyCode != 0x1000003 && e.keyCode != 0x1000004) {
                    TableItem row = ImsKeyPositioningDialog.this.segmentTableCursor.getRow();
                    int column = ImsKeyPositioningDialog.this.segmentTableCursor.getColumn();
                    Text text2 = ImsKeyPositioningDialog.this.getTextEditor((Object[])row.getData(), column);
                    if (text2 != null) {
                        text2.setText("" + e.character);
                        text2.setSelection(1, 1);
                        controlEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                }
            }
        });
        this.segmentTableCursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    if ((e.stateMask & 0x20000) != 0) {
                        ImsKeyPositioningDialog.this.moveCursorBackward(e);
                    } else {
                        ImsKeyPositioningDialog.this.moveCursorForward(e);
                    }
                }
            }
        });
    }

    private void moveCursorForward(TraverseEvent te) {
        TableItem item = this.segmentTableCursor.getRow();
        int rowIndex = this.segmentTable.indexOf(item);
        int columnIndex = this.segmentTableCursor.getColumn();
        if (columnIndex + 1 < 5) {
            this.segmentTableCursor.setSelection(rowIndex, columnIndex + 1);
            te.doit = false;
            return;
        }
        if (rowIndex + 1 < this.segmentTable.getItemCount()) {
            this.segmentTableCursor.setSelection(rowIndex + 1, 0);
            te.doit = false;
            return;
        }
    }

    private void moveCursorBackward(TraverseEvent te) {
        TableItem item = this.segmentTableCursor.getRow();
        int rowIndex = this.segmentTable.indexOf(item);
        int columnIndex = this.segmentTableCursor.getColumn();
        if (columnIndex == 0) {
            if (rowIndex - 1 >= 0) {
                this.segmentTableCursor.setSelection(rowIndex - 1, 4);
                te.doit = false;
                return;
            }
            return;
        }
        this.segmentTableCursor.setSelection(rowIndex, columnIndex - 1);
        te.doit = false;
    }

    private Text getTextEditor(final Object[] selectedRow, int columnIndex) {
        if (columnIndex == 4) {
            final Text text2 = new Text((Composite)this.segmentTableCursor, 0);
            text2.setEditable(true);
            text2.setFont(JFaceResources.getTextFont());
            text2.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.keyCode == 9) {
                        e.doit = false;
                    }
                }
            });
            text2.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r') {
                        TableItem row = ImsKeyPositioningDialog.this.segmentTableCursor.getRow();
                        int column = ImsKeyPositioningDialog.this.segmentTableCursor.getColumn();
                        ImsKeyPositioningDialog.this.setModifiedValue(column, ImsKeyPositioningDialog.this.segmentTable.indexOf(row), text2.getText());
                        text2.dispose();
                        ImsKeyPositioningDialog.this.setSegmentTreeContents();
                    } else if (e.character == '\u001b') {
                        text2.dispose();
                    }
                }
            });
            text2.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    TableItem row = ImsKeyPositioningDialog.this.segmentTableCursor.getRow();
                    int column = ImsKeyPositioningDialog.this.segmentTableCursor.getColumn();
                    ImsKeyPositioningDialog.this.setModifiedValue(column, ImsKeyPositioningDialog.this.segmentTable.indexOf(row), text2.getText());
                    text2.dispose();
                    ImsKeyPositioningDialog.this.setSegmentTreeContents();
                }
            });
            text2.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent ve) {
                    if (ImsKeyPositioningDialog.HEX_TOP.equals(selectedRow[6]) || ImsKeyPositioningDialog.HEX_BOTTOM.equals(selectedRow[6])) {
                        FormattedPageUtility.hexEntryTextValue(ve);
                    }
                }
            });
            return text2;
        }
        return null;
    }

    private void setModifiedValue(int columnIndex, int rowIndex, String newValue) {
        Object[] selectedRow = (Object[])this.segmentTable.getItem(rowIndex).getData();
        if (columnIndex == 4) {
            if (HEX_TOP.equals(selectedRow[6])) {
                Object[] textRow = (Object[])this.segmentTable.getItem(rowIndex - 1).getData();
                Object[] hexBot = (Object[])this.segmentTable.getItem(rowIndex + 1).getData();
                int keyLength = Integer.parseInt((String)textRow[3]);
                ((Segtype)selectedRow[5]).setHex(ImsKeyPositioningDialog.updateHex(keyLength, newValue, (String)hexBot[4], true));
            } else if (HEX_BOTTOM.equals(selectedRow[6])) {
                Object[] textRow = (Object[])this.segmentTable.getItem(rowIndex - 2).getData();
                Object[] hexTop = (Object[])this.segmentTable.getItem(rowIndex - 1).getData();
                int keyLength = Integer.parseInt((String)textRow[3]);
                ((Segtype)selectedRow[5]).setHex(ImsKeyPositioningDialog.updateHex(keyLength, newValue, (String)hexTop[4], false));
            } else {
                String hex = "";
                try {
                    hex = DataConversionUtils.getHexString((String)newValue, (String)this.options.getImsResource().getPersistentProperty("encoding"));
                }
                catch (Exception e) {
                    String errMsg = Messages.ImsKeyPositioningDialog_20;
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    logger.error((Object)errMsg, (Throwable)e);
                }
                ((Segtype)selectedRow[5]).setHex(hex);
            }
        }
    }

    private static String updateHex(int keyLength, String newValue, String otherHex, boolean topModified) {
        if (newValue.length() > keyLength) {
            newValue = newValue.substring(0, keyLength);
        }
        if (newValue.length() < otherHex.length()) {
            otherHex = otherHex.substring(0, newValue.length());
        } else if (newValue.length() > otherHex.length()) {
            otherHex = ImsKeyPositioningDialog.padZerosIfRequired(otherHex, newValue.length());
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < newValue.length()) {
            if (topModified) {
                sb.append(newValue.charAt(i));
                sb.append(otherHex.charAt(i));
            } else {
                sb.append(otherHex.charAt(i));
                sb.append(newValue.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    private static String padZerosIfRequired(String value, int length) {
        if (value.length() == length) {
            return value;
        }
        if (value.length() > length) {
            return value.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(value);
        int i = 0;
        while (i < length - value.length()) {
            sb.append("0");
            ++i;
        }
        return sb.toString();
    }

    protected void okPressed() {
        if (this.segmentTable.getSelectionCount() <= 0) {
            this.setErrorMessage(Messages.ImsKeyPositioningDialog_21);
            return;
        }
        if (!this.atLeastOneSegmentSelected()) {
            this.setErrorMessage(Messages.ImsKeyPositioningDialog_22);
            return;
        }
        int i = 0;
        while (i < this.segmentTable.getItemCount()) {
            TableItem item = this.segmentTable.getItem(i);
            Segtype aSegment = (Segtype)((Object[])item.getData())[5];
            aSegment.unsetPos();
            aSegment.setSel(item.getChecked());
            ++i;
        }
        TableItem[] selection = this.segmentTable.getSelection();
        Segtype aSegment = (Segtype)((Object[])selection[0].getData())[5];
        aSegment.setPos(true);
        if (this.useGEOpeButton.getSelection()) {
            aSegment.setOper(OperType.GE);
        } else {
            aSegment.setOper(OperType.EQ);
        }
        if (this.inSessionAlready && !PDDialogs.openConfirm((String)Messages.Confirm, (String)Messages.ImsKeyPositioningDialog_23)) {
            return;
        }
        if (!this.setKeyPosition()) {
            return;
        }
        super.okPressed();
    }

    private boolean atLeastOneSegmentSelected() {
        int i = 0;
        while (i < this.segmentTable.getItemCount()) {
            TableItem item = this.segmentTable.getItem(i);
            if (item.getChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean close() {
        if (this.getReturnCode() != 0) {
            EList segments = this.initDbpos.getSeg();
            int i = 0;
            while (i < this.originalHexValues.length) {
                ((Segtype)segments.get(i)).setHex(this.originalHexValues[i]);
                ++i;
            }
        }
        return super.close();
    }

    private boolean setKeyPosition() {
        final Result result = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ImsKeyPositioningDialog_24, 1);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result setKeyPosResult = ImsKeyPositioningDialog.this.session.setImsKeyPosition(ImsKeyPositionOptionsUtil.save((DbposType)ImsKeyPositioningDialog.this.initDbpos), howIsGoing);
                    if (!setKeyPosResult.isSuccessfulWithoutWarnings()) {
                        PDDialogs.openInfoThreadSafe((String)Messages.Information, (String)Messages.ImsKeyPositioningDialog_25, (String)setKeyPosResult.dumpOutputAndMessages(true));
                        result.addSubResult(setKeyPosResult);
                        return;
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            String errMsg = Messages.ImsKeyPositioningDialog_26;
            PDDialogs.openErrorThreadSafe((String)errMsg);
            logger.error((Object)errMsg, (Throwable)e);
            return false;
        }
        return result.isSuccessfulWithoutWarnings();
    }

    public DbposType getKeyPositioningInfo() {
        return this.initDbpos;
    }

    private static class ImsKeyPositioningTableLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private ImsKeyPositioningTableLabelProvider() {
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            Object[] elements = (Object[])element;
            if (4 == columnIndex && (((String)elements[6]).equals(ImsKeyPositioningDialog.HEX_TOP) || ((String)elements[6]).equals(ImsKeyPositioningDialog.HEX_BOTTOM))) {
                return FormattedEditorPreferencePage.getHexForegroundColor();
            }
            return null;
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }
    }
}

