/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsKeyField;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImsInsertDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IFMEditor editor;
    private ImsSegment segInfo;
    private ImsKeyField aKeyField;
    private String initHexValue;
    private Text segNameText = null;
    private Text keyLengthText = null;
    private Text keyEntryText = null;
    private Text keyEntryHexText = null;
    private Button insertAtTopButton = null;
    private String enteredKeyValue = null;
    private boolean insertAtTop = false;
    private static final String HEX_CHARACTERS = "[0-9A-Fa-f]*";
    private static final Pattern HEX_CHARACTERS_REGEXP = Pattern.compile("[0-9A-Fa-f]*", 2);

    public ImsInsertDialog(IFMEditor editor2, ImsSegment segInfo, String initHexValue) {
        this.editor = editor2;
        this.segInfo = segInfo;
        if (this.segInfo.getKeyFields().size() > 0) {
            this.aKeyField = (ImsKeyField)this.segInfo.getKeyFields().get(0);
        }
        this.enteredKeyValue = "";
        this.insertAtTop = false;
        this.initHexValue = initHexValue != null && ImsInsertDialog.isValidHexString(initHexValue) ? initHexValue : "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.setTitle(Messages.InsertDialog_TITLE);
        this.setMessage(Messages.ImsInsertDialog_0);
        GUI.label.left((Composite)composite, (String)Messages.ImsInsertDialog_1, (Object)GUI.grid.d.left1());
        this.segNameText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.segNameText.setText(this.segInfo.getName());
        this.segNameText.setToolTipText(Messages.ImsInsertDialog_2);
        GUI.label.left((Composite)composite, (String)Messages.ImsInsertDialog_3, (Object)GUI.grid.d.left1());
        this.keyEntryText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.ImsInsertDialog_4, (Object)GUI.grid.d.left1());
        this.keyEntryHexText = GUI.text.field((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        if (this.aKeyField == null || this.aKeyField.getLength() == 0) {
            this.keyEntryText.setEditable(false);
            this.keyEntryHexText.setEditable(false);
        } else {
            this.addKeyListenerForKeyTextFields();
            this.setInitValue();
        }
        GUI.label.left((Composite)composite, (String)Messages.ImsInsertDialog_5, (Object)GUI.grid.d.left1());
        this.keyLengthText = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        this.keyLengthText.setText((String)(this.aKeyField != null && this.aKeyField.getLength() > 0 ? "" + this.aKeyField.getLength() : "0"));
        this.keyLengthText.setToolTipText(Messages.ImsInsertDialog_6);
        this.insertAtTopButton = GUI.button.checkbox((Composite)composite, (String)Messages.InsertDialog_INSERT_TOP, (Object)GUI.grid.d.fillH((int)2));
        this.insertAtTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImsInsertDialog.this.insertAtTop = ImsInsertDialog.this.insertAtTopButton.getSelection();
            }
        });
        this.keyEntryText.setFocus();
        return composite;
    }

    private void addKeyListenerForKeyTextFields() {
        this.keyEntryText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String hexValue = ImsInsertDialog.this.validateKeyValueText(false);
                if (hexValue != null) {
                    ImsInsertDialog.this.keyEntryHexText.setText(hexValue);
                }
            }
        });
        this.keyEntryHexText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String textValue = ImsInsertDialog.this.validateHexThenText();
                if (textValue != null) {
                    ImsInsertDialog.this.keyEntryText.setText(textValue);
                }
            }
        });
    }

    private void setInitValue() {
        if (this.initHexValue == null || this.initHexValue.isEmpty()) {
            return;
        }
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData((String)this.initHexValue);
            String textValue = new String(byteValue, this.editor.getResource().getPersistentProperty("encoding")).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
            this.keyEntryText.setText(textValue);
            this.keyEntryHexText.setText(this.initHexValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void okPressed() {
        if (this.aKeyField != null && this.aKeyField.getLength() > 0) {
            this.enteredKeyValue = this.validateKeyValueHex();
            if (this.enteredKeyValue == null) {
                this.keyEntryText.setFocus();
                return;
            }
        }
        super.okPressed();
    }

    private String validateKeyValueText(boolean appendZeros) {
        String hexString;
        block4: {
            String enteredText = this.keyEntryText.getText().trim();
            String encoding = this.editor.getResource().getPersistentProperty("encoding");
            try {
                byte[] byteValue = enteredText.getBytes(encoding);
                hexString = ImsInsertDialog.toHexString(byteValue, 1, byteValue.length);
                if (hexString.length() / 2 <= this.aKeyField.getLength()) break block4;
                this.setErrorMessage(Messages.ImsInsertDialog_8);
                return null;
            }
            catch (UnsupportedEncodingException e) {
                this.setErrorMessage(MessageFormat.format(Messages.ImsInsertDialog_9, encoding));
                return null;
            }
        }
        this.setErrorMessage(null);
        if (appendZeros) {
            return ImsInsertDialog.appendSpaces(hexString, this.aKeyField.getLength());
        }
        return hexString;
    }

    private String validateKeyValueHex() {
        String hexString = this.keyEntryHexText.getText().trim().toUpperCase();
        if (hexString.length() % 2 != 0) {
            this.setErrorMessage(Messages.ImsInsertDialog_10);
            return null;
        }
        if (!ImsInsertDialog.isValidHexString(hexString)) {
            this.setErrorMessage(Messages.ImsInsertDialog_11);
            return null;
        }
        if (hexString.length() / 2 > this.aKeyField.getLength()) {
            this.setErrorMessage(Messages.ImsInsertDialog_12);
            return null;
        }
        return ImsInsertDialog.appendSpaces(hexString, this.aKeyField.getLength());
    }

    private String validateHexThenText() {
        String hexString = this.keyEntryHexText.getText().trim().toUpperCase();
        if (hexString.length() % 2 != 0) {
            this.setErrorMessage(Messages.ImsInsertDialog_13);
            return null;
        }
        if (!ImsInsertDialog.isValidHexString(hexString)) {
            this.setErrorMessage(Messages.ImsInsertDialog_14);
            return null;
        }
        if (hexString.length() / 2 > this.aKeyField.getLength()) {
            this.setErrorMessage(Messages.ImsInsertDialog_15);
            return null;
        }
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexString);
        try {
            this.setErrorMessage(null);
            return new String(byteValue, this.editor.getResource().getPersistentProperty("encoding")).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
        }
        catch (UnsupportedEncodingException e) {
            this.setErrorMessage(Messages.ImsInsertDialog_17);
            return null;
        }
    }

    private static String appendSpaces(String hexString, int length) {
        if (hexString.length() / 2 == length) {
            return hexString;
        }
        StringBuilder sb = new StringBuilder(hexString);
        int size = length - hexString.length() / 2;
        int i = 0;
        while (i < size) {
            sb.append("40");
            ++i;
        }
        return sb.toString();
    }

    public String getEnteredKeyValueInHex() {
        return this.enteredKeyValue;
    }

    public boolean isInsertAtTop() {
        return this.insertAtTop;
    }

    public static String toHexString(byte[] data, int start, int length) {
        return DataConversionUtils.getHexString((byte[])data, (int)(start - 1), (int)length);
    }

    public static boolean isValidHexString(String hexString) {
        if (hexString == null) {
            return false;
        }
        if (hexString.length() % 2 != 0) {
            return false;
        }
        return HEX_CHARACTERS_REGEXP.matcher(hexString).matches();
    }
}

