/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1.dialogs;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ZRLs;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsPsb;
import com.ibm.etools.fm.core.model.ims.ImsPsbQuery;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSecondaryIndex;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.editor.formatted1.dialogs.SecondaryIndexSelectionDialog;
import com.ibm.etools.fm.editor.template.TemplateEditorUtilities;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.dialog.lookup.ImsDatabaseLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsPcbLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsPsbLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.ImsSubsystemLookupDialog;
import com.ibm.etools.fm.ui.dialog.lookup.LookupButton;
import com.ibm.etools.fm.ui.dialog.lookup.callback.IOnSelectionEvent;
import com.ibm.etools.fm.ui.dialog.lookup.callback.ISelectedValueFormatter;
import com.ibm.etools.fm.ui.dialog.lookup.factory.LookupDialogFactory;
import com.ibm.etools.fm.ui.views.systems.handlers.ModifyImsSubsystemConfig;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.ComboValueSaver;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProvider;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImsEditorOptionsDialog
extends BaseTitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ImsEditorOptions options;
    private Text subsystemText;
    private Button subsystemOptsButton;
    private Button subsystemLookupButton;
    private Button bmpRegionButton;
    private Button dliRegionButton;
    private Button dliEditDataSetButton;
    private Button dynamicPsbButton;
    private Button staticPsbButton;
    private Composite stackLayoutComposite;
    private Composite dynamicPsbComposite;
    private Combo dynamicPsbDatabaseNameCombo;
    private Button dynamicPsbDatabaseNameLookupButton;
    private Combo dynamicPsbSecIndexNameCombo;
    private Button dynamicPsbSecIndexLookupButton;
    private Composite staticPsbComposite;
    private Combo staticPsbMemberNameCombo;
    private Button staticPsbMemberLookupButton;
    private Combo staticPsbDatabaseNameFilterCombo;
    private Button staticPcbNameLookupButton;
    private Combo viewCombo;
    private Button useTemplateButton;
    private Combo encodingCombo;
    private Combo dbcsEncodingCombo;
    private Button imsLogKeepButton;
    private Button imsLogDeleteButton;
    private Button imsLogNoneButton;
    private ModifyListener clearErrorModifyListener;

    public ImsEditorOptionsDialog(ImsEditorOptions options) throws IllegalArgumentException {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        this.options = options.clone();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ImsEditorOptionsDialog_0);
        this.setMessage(Messages.ImsEditorOptionsDialog_1);
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        this.createImsDetailsComposite(composite);
        this.databaseInfoComposite(composite);
        this.createViewGroup(composite);
        this.setValues(false);
        return composite;
    }

    private void setValues(boolean subsystemEdited) {
        ImsSubsystemConfig canonicalConfig = this.options.getSubsystem().getCanonicalConfig();
        this.subsystemText.setText(canonicalConfig.getLabel());
        if (subsystemEdited) {
            return;
        }
        if (this.options.getRegionType() == ImsRegionType.BMP) {
            this.bmpRegionButton.setSelection(true);
            this.dliRegionButton.setSelection(false);
            this.dliEditDataSetButton.setEnabled(false);
        } else {
            this.bmpRegionButton.setSelection(false);
            this.dliRegionButton.setSelection(true);
            this.dliEditDataSetButton.setEnabled(true);
        }
        if (canonicalConfig.isDir()) {
            this.dynamicPsbButton.setEnabled(true);
            this.options.setAccessMode(ImsAccessMode.DYNAMIC);
        } else if (canonicalConfig.isStaticOnly(this.options.getRegionType())) {
            this.staticPsbButton.setEnabled(true);
            this.dynamicPsbButton.setEnabled(false);
            this.options.setAccessMode(ImsAccessMode.STATIC);
        } else if (canonicalConfig.isDynamicOnly(this.options.getRegionType())) {
            this.staticPsbButton.setEnabled(false);
            this.dynamicPsbButton.setEnabled(true);
            this.options.setAccessMode(ImsAccessMode.DYNAMIC);
        } else {
            this.staticPsbButton.setEnabled(true);
            this.dynamicPsbButton.setEnabled(true);
        }
        if (this.options.getAccessMode() == ImsAccessMode.DYNAMIC) {
            this.dynamicPsbButton.setSelection(true);
            this.staticPsbButton.setSelection(false);
        } else {
            this.dynamicPsbButton.setSelection(false);
            this.staticPsbButton.setSelection(true);
        }
        if (this.options.getAccessMode() == ImsAccessMode.DYNAMIC) {
            this.showMode(true);
            if (this.options.getDatabase() != null) {
                this.dynamicPsbDatabaseNameCombo.setText(this.options.getDatabase().getName());
            }
            if (this.dynamicPsbDatabaseNameCombo.getText().trim().isEmpty()) {
                this.dynamicPsbDatabaseNameCombo.setFocus();
            } else {
                this.viewCombo.setFocus();
            }
        } else {
            this.showMode(false);
            if (this.options.getDatabase() != null) {
                this.staticPsbDatabaseNameFilterCombo.setText(this.options.getDatabase().getName());
            } else if (this.options.getPcb() != null) {
                this.staticPsbMemberNameCombo.setText(this.options.getPcb().getPsb().getName());
                this.staticPsbDatabaseNameFilterCombo.setText(this.options.getPcb().getDbd().getName());
            } else if (this.options.getImsResource() instanceof ImsPsb) {
                this.staticPsbMemberNameCombo.setText(((ImsPsb)this.options.getImsResource()).getName());
            }
            if (this.staticPsbMemberNameCombo.getText().trim().isEmpty()) {
                this.staticPsbMemberNameCombo.setFocus();
            } else {
                this.viewCombo.setFocus();
            }
        }
        ComboValueSaver.getInstance((Combo)this.encodingCombo).setCustomItems(EncodingUtils.getDefaultEncodingValues(), false);
        ComboValueSaver.getInstance((Combo)this.dbcsEncodingCombo).setCustomItems(EncodingUtils.getDefaultDBCSEncodingValues(), false);
        this.encodingCombo.setText(this.options.getEncoding());
        if (this.options.isDbcsEcndoingValueSet()) {
            this.dbcsEncodingCombo.setText(this.options.getDbcsEncoding());
        } else {
            this.dbcsEncodingCombo.setText("");
        }
        this.dynamicPsbSecIndexNameCombo.setText(this.options.getDynamicPsbSecondaryIndexName());
    }

    private void createImsDetailsComposite(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.ImsEditorOptionsDialog_2, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.ImsWizardFirstPageHeader_Subsystem, (Object)GUI.grid.d.left1());
        this.subsystemText = GUI.text.fieldReadOnly((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.subsystemOptsButton = GUI.button.push((Composite)group, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/ims_customize_subsystem_config.gif"), (String)Messages.CUSTOMIZE_IMS_SUBSYSTEM, (Object)GUI.grid.d.left1());
        this.subsystemOptsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig config = ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig();
                boolean editSuccess = ModifyImsSubsystemConfig.editConfigAndSaveIfSuccessful(config);
                if (editSuccess) {
                    ImsEditorOptionsDialog.this.setValues(true);
                }
            }
        });
        this.subsystemLookupButton = LookupButton.createLookupButtonLeft1((Composite)group);
        this.subsystemLookupButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsSubsystemConfig selectedConfig = ImsSubsystemLookupDialog.promptForValidConfig(ImsEditorOptionsDialog.this.options.getSystem(), null);
                if (selectedConfig != null) {
                    ImsEditorOptionsDialog.this.options.setSubsystem(selectedConfig.getSubsystem());
                    ImsEditorOptionsDialog.this.setValues(false);
                }
            }
        });
        GUI.label.left((Composite)group, (String)Messages.ImsWizardFirstPageHeader_RegionType, (Object)new GridData(16384, 128, false, false, 1, 1));
        Composite regionTypeComp = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
        this.bmpRegionButton = GUI.button.radio((Composite)regionTypeComp, (String)Messages.ImsWizardFirstPageHeader_BMP, (Object)GUI.grid.d.fillH((int)1));
        this.bmpRegionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsEditorOptionsDialog.this.dliEditDataSetButton.setEnabled(!ImsEditorOptionsDialog.this.bmpRegionButton.getSelection());
            }
        });
        this.dliRegionButton = GUI.button.radio((Composite)regionTypeComp, (String)Messages.ImsWizardFirstPageHeader_DLI, (Object)GUI.grid.d.fillH((int)1));
        Composite displayDatabaseNamesButtonComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.dliEditDataSetButton = GUI.button.checkbox((Composite)displayDatabaseNamesButtonComposite, (String)Messages.ImsWizardProcessingKeysOptions_DisplayDBDatasetNames, (Object)GUI.grid.d.fillH((int)1));
    }

    private void databaseInfoComposite(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.ImsEditorOptionsDialog_7, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.ImsWizardFirstPageHeader_PSBType, (Object)GUI.grid.d.left1());
        Composite modeComp = GUI.composite((Composite)group, (Layout)GUI.grid.l.noMargins((int)2, (boolean)true), (Object)GUI.grid.d.fillH((int)3));
        this.dynamicPsbButton = GUI.button.radio((Composite)modeComp, (String)Messages.ImsWizardFirstPageHeader_Dynamic, (Object)GUI.grid.d.fillH((int)1));
        this.staticPsbButton = GUI.button.radio((Composite)modeComp, (String)Messages.ImsWizardFirstPageHeader_Static, (Object)GUI.grid.d.fillH((int)1));
        this.dynamicPsbButton.setSelection(true);
        this.dynamicPsbButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsEditorOptionsDialog.this.showMode(ImsEditorOptionsDialog.this.dynamicPsbButton.getSelection());
            }
        });
        this.staticPsbButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImsEditorOptionsDialog.this.showMode(ImsEditorOptionsDialog.this.dynamicPsbButton.getSelection());
            }
        });
        this.stackLayoutComposite = GUI.composite((Composite)group, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)4));
        this.stackLayoutComposite.setLayout((Layout)new StackLayout());
        this.createStaticComposite(this.stackLayoutComposite);
        this.createDynamicComposite(this.stackLayoutComposite);
        this.showMode(this.dynamicPsbButton.getSelection());
    }

    private void showMode(boolean isDynamic) {
        Layout layout = this.stackLayoutComposite.getLayout();
        if (layout instanceof StackLayout) {
            if (isDynamic) {
                ((StackLayout)layout).topControl = this.dynamicPsbComposite;
                this.dynamicPsbButton.setSelection(true);
                this.staticPsbButton.setSelection(false);
            } else {
                ((StackLayout)layout).topControl = this.staticPsbComposite;
                this.dynamicPsbButton.setSelection(false);
                this.staticPsbButton.setSelection(true);
            }
            this.stackLayoutComposite.layout();
        }
    }

    private void createStaticComposite(Composite parent) {
        this.staticPsbComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)5, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this.staticPsbComposite, (String)Messages.ImsWizardFirstPageHeader_PSBName, (Object)GUI.grid.d.left1());
        this.staticPsbMemberNameCombo = GUI.combo.editable((Composite)this.staticPsbComposite, (Object)GUI.grid.d.fillH((int)3));
        this.staticPsbMemberNameCombo.setToolTipText(Messages.ImsWizardFirstPageHeader_PSBNameTooltip);
        this.staticPsbMemberNameCombo.addModifyListener(this.getClearErrorModifyListener());
        new ComboValueSaver(this.staticPsbMemberNameCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "Psb");
        this.staticPsbMemberLookupButton = LookupButton.createLookupButtonLeft1(this.staticPsbComposite);
        this.staticPsbMemberLookupButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsPsb selectedPsb = ImsPsbLookupDialog.promptForValidPsb(ImsEditorOptionsDialog.this.options.getSystem(), ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig(), ImsEditorOptionsDialog.this.options.getPcb() != null ? ImsEditorOptionsDialog.this.options.getPcb().getPsb().getName() : "", ImsEditorOptionsDialog.this.bmpRegionButton.getSelection() ? ImsRegionType.BMP : ImsRegionType.DLI, ImsEditorOptionsDialog.this.staticPsbButton.getSelection() ? ImsAccessMode.STATIC : ImsAccessMode.DYNAMIC);
                if (selectedPsb != null) {
                    ImsEditorOptionsDialog.this.options.setImsResource((IZRL)selectedPsb);
                    ImsEditorOptionsDialog.this.staticPsbMemberNameCombo.setText(selectedPsb.getName());
                }
            }
        });
        GUI.label.left((Composite)this.staticPsbComposite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.staticPsbDatabaseNameFilterCombo = GUI.combo.editable((Composite)this.staticPsbComposite, (Object)GUI.grid.d.fillH((int)3));
        this.staticPsbDatabaseNameFilterCombo.setToolTipText(Messages.ImsWizardFirstPageHeader_DBNameTooltip);
        this.staticPsbDatabaseNameFilterCombo.addModifyListener(this.getClearErrorModifyListener());
        new ComboValueSaver(this.staticPsbDatabaseNameFilterCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "DatabaseStatic");
        String tempDbName = this.staticPsbDatabaseNameFilterCombo.getText();
        if ((tempDbName == null || tempDbName.trim().isEmpty()) && this.options.getDatabase() != null) {
            this.staticPsbDatabaseNameFilterCombo.setText(this.options.getDatabase().getName());
        }
        this.staticPcbNameLookupButton = LookupButton.createLookupButtonLeft1(this.staticPsbComposite);
        this.staticPcbNameLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String psbName = ImsEditorOptionsDialog.this.staticPsbMemberNameCombo.getText().trim();
                if (!ImsPsb.isValidName((String)psbName, (String)ImsEditorOptionsDialog.this.options.getSystem().getCodePage())) {
                    ImsEditorOptionsDialog.this.setErrorMessage(Messages.ImsEditorOptionsDialog_22);
                    return;
                }
                ImsEditorOptionsDialog.this.setErrorMessage(null);
                ImsPsb aPsb = new ImsPsb(ImsEditorOptionsDialog.this.options.getSubsystem(), psbName);
                ImsRegionType regionType = ImsEditorOptionsDialog.this.dliRegionButton.getSelection() ? ImsRegionType.DLI : ImsRegionType.BMP;
                ImsSubsystemConfig canonicalConfig = ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig();
                ImsPcb selectedPcb = ImsPcbLookupDialog.promptForValidPcb(canonicalConfig.getRegionConfig(regionType), aPsb, null, ImsEditorOptionsDialog.this.staticPsbDatabaseNameFilterCombo.getText().trim().toUpperCase());
                if (selectedPcb != null) {
                    ImsEditorOptionsDialog.this.staticPsbDatabaseNameFilterCombo.setText(selectedPcb.getDbd().getName());
                    ImsEditorOptionsDialog.this.options.setImsResource((IZRL)selectedPcb);
                }
            }
        });
    }

    private void createDynamicComposite(Composite parent) {
        this.dynamicPsbComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)this.dynamicPsbComposite, (String)Messages.ImsWizardFirstPageHeader_DBName, (Object)GUI.grid.d.left1());
        this.dynamicPsbDatabaseNameCombo = GUI.combo.editable((Composite)this.dynamicPsbComposite, (Object)GUI.grid.d.fillH((int)2));
        this.dynamicPsbDatabaseNameCombo.setToolTipText(Messages.ImsWizardFirstPageHeader_DBNameTooltip);
        this.dynamicPsbDatabaseNameCombo.addModifyListener(this.getClearErrorModifyListener());
        new ComboValueSaver(this.dynamicPsbDatabaseNameCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "DatabaseDynamic");
        this.dynamicPsbDatabaseNameLookupButton = LookupButton.createLookupButtonLeft1(this.dynamicPsbComposite);
        this.dynamicPsbDatabaseNameLookupButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImsDatabase selectedDatabase = ImsDatabaseLookupDialog.promptForValidConfig(ImsEditorOptionsDialog.this.options.getSystem(), ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig(), null, ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.getText(), ImsEditorOptionsDialog.this.options.getRegionType(), ImsEditorOptionsDialog.this.options.getAccessMode(), null);
                if (selectedDatabase != null) {
                    ImsEditorOptionsDialog.this.options.setImsResource((IZRL)selectedDatabase);
                    ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.setText(selectedDatabase.getName());
                }
            }
        });
        GUI.label.left((Composite)this.dynamicPsbComposite, (String)Messages.ImsEditorOptionsDialog_9, (Object)GUI.grid.d.left1());
        this.dynamicPsbSecIndexNameCombo = GUI.combo.editable((Composite)this.dynamicPsbComposite, (Object)GUI.grid.d.fillH((int)2));
        this.dynamicPsbSecIndexNameCombo.addModifyListener(this.getClearErrorModifyListener());
        new ComboValueSaver(this.dynamicPsbSecIndexNameCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "DatabaseDynamicSecondaryIndex");
        this.dynamicPsbSecIndexLookupButton = LookupButton.createLookupButtonLeft1(this.dynamicPsbComposite);
        this.dynamicPsbSecIndexLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dbName = ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.getText().trim().toUpperCase();
                if (!ImsDatabase.isValidName((String)dbName, (String)ImsEditorOptionsDialog.this.options.getSystem().getCodePage())) {
                    ImsEditorOptionsDialog.this.setErrorMessage(Messages.ImsEditorOptionsDialog_10);
                    ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.setFocus();
                    return;
                }
                final Result result = new Result();
                final ImsDatabase db = new ImsDatabase(ImsEditorOptionsDialog.this.options.getSubsystem(), dbName);
                final ImsRegionType regionType = ImsEditorOptionsDialog.this.bmpRegionButton.getSelection() ? ImsRegionType.BMP : ImsRegionType.DLI;
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            result.addSubResultWithOutput(db.loadInfo(howIsGoing, "", regionType));
                        }
                    });
                }
                catch (InvocationTargetException e1) {
                    String errMsg = Messages.ImsEditorOptionsDialog_12;
                    logger.error((Object)errMsg, (Throwable)e1);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.setFocus();
                    return;
                }
                catch (InterruptedException e1) {
                    return;
                }
                if (!result.isSuccessfulWithoutWarnings()) {
                    PDDialogs.openErrorThreadSafe((String)Messages.ImsEditorOptionsDialog_13, (String)result.dumpOutputAndMessages(true));
                    ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.setFocus();
                    return;
                }
                ImsDatabaseInfo dbInfo = (ImsDatabaseInfo)result.getOutput();
                if (dbInfo.getSecondaryIndexes().isEmpty()) {
                    ImsEditorOptionsDialog.this.setErrorMessage(Messages.ImsEditorOptionsDialog_14);
                    ImsEditorOptionsDialog.this.dynamicPsbDatabaseNameCombo.setFocus();
                } else {
                    SecondaryIndexSelectionDialog secIndexDialog = new SecondaryIndexSelectionDialog(dbInfo);
                    if (secIndexDialog.open() == 0) {
                        ImsSecondaryIndex selected = secIndexDialog.getSelectedIndex();
                        ImsEditorOptionsDialog.this.dynamicPsbSecIndexNameCombo.setText(selected.getName());
                    }
                }
            }
        });
    }

    private void createViewGroup(Composite parent) {
        Group group = GUI.group((Composite)parent, (String)Messages.ImsEditorOptionsDialog_15, (Layout)GUI.grid.l.margins((int)3, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)group, (String)Messages.ImsEditorOptionsDialog_16, (Object)GUI.grid.d.left1());
        this.viewCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)1));
        this.viewCombo.setToolTipText(Messages.ImsEditorOptionsDialog_17);
        this.viewCombo.addModifyListener(this.getClearErrorModifyListener());
        final Button viewLookupButton = LookupButton.createLookupViewButtonLeft1((Composite)group);
        LookupDialogFactory.defaults(viewLookupButton, this.viewCombo, (IHostProvider)this.options).onSelect(new IOnSelectionEvent(){

            @Override
            public void onResourceSelected(IPDHost selectedHost, IZRL zrl) {
                ImsEditorOptionsDialog.this.options.setTemplate((DataSetOrMember)zrl);
            }
        }).formatter(new ISelectedValueFormatter(){

            @Override
            public String getNewValue(IPDHost selectedHost, IZRL zrl) {
                return ImsEditorOptionsDialog.this.options.getTemplate().getFormattedName();
            }
        }).types(FMHost.getPermittedTemplateResourceType((IPDHost)this.options.getSystem())).addComboValueSaver(((Object)((Object)this)).getClass().getCanonicalName() + "viewCombo").addResourceContentProposals(((Object)((Object)this)).getClass().getCanonicalName() + "ViewResource").create();
        List assocs = FMHost.getSystem((IPDHost)this.options.getSystem()).getTemplateAssociations(this.options.getImsResource());
        if (!assocs.isEmpty()) {
            ComboValueSaver.getInstance((Combo)this.viewCombo).setCustomItems(assocs.toArray(new String[0]), false, false);
            this.viewCombo.select(0);
        }
        this.useTemplateButton = GUI.button.checkbox((Composite)group, (String)Messages.ImsEditorOptionsDialog_19, (Object)GUI.grid.d.fillH((int)3));
        this.useTemplateButton.setToolTipText(Messages.ImsEditorOptionsDialog_20);
        this.useTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImsEditorOptionsDialog.this.useTemplateButton.getSelection()) {
                    ImsEditorOptionsDialog.this.viewCombo.setEnabled(false);
                    viewLookupButton.setEnabled(false);
                } else {
                    ImsEditorOptionsDialog.this.viewCombo.setEnabled(true);
                    viewLookupButton.setEnabled(true);
                }
            }
        });
        GUI.label.left((Composite)group, (String)Messages.Db2EditorDialog_17, (Object)GUI.grid.d.left1());
        this.encodingCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)2));
        this.encodingCombo.setToolTipText(Messages.Db2EditorDialog_18);
        new ComboValueSaver(this.encodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "encodingCombo");
        this.encodingCombo.addModifyListener(this.getClearErrorModifyListener());
        GUI.label.left((Composite)group, (String)Messages.Db2EditorDialog_GraphicEncoding, (Object)GUI.grid.d.left1());
        this.dbcsEncodingCombo = GUI.combo.editable((Composite)group, (Object)GUI.grid.d.fillH((int)2));
        this.dbcsEncodingCombo.setToolTipText(Messages.Db2EditorDialog_GraphicEncodingDesc);
        new ComboValueSaver(this.dbcsEncodingCombo, ((Object)((Object)this)).getClass().getCanonicalName() + "dbcsEncodingCombo");
        this.dbcsEncodingCombo.addModifyListener(this.getClearErrorModifyListener());
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBarTmp = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)3, (boolean)true), (Object)new GridData(0x1000008, 4, false, false));
        this.createButtonsForButtonBar(buttonBarTmp);
        return buttonBarTmp;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData();
        data.widthHint = 100;
        Button editButton = GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_EDIT, (Object)data, (String)Messages.EditorOptionDialog_EDIT_TIP);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImsEditorOptionsDialog.this.options.setEditSession(true);
                ImsEditorOptionsDialog.this.validateAndClose();
            }
        });
        GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_VIEW, (Object)data, (String)Messages.EditorOptionDialog_VIEW_TIP).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImsEditorOptionsDialog.this.options.setEditSession(false);
                ImsEditorOptionsDialog.this.validateAndClose();
            }
        });
        GUI.button.push((Composite)parent, (String)Messages.EditorOptionDialog_CANCEL, (Object)data).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ImsEditorOptionsDialog.this.cancelPressed();
            }
        });
        this.getShell().setDefaultButton(editButton);
    }

    private boolean validateAndClose() {
        if (this.bmpRegionButton.getSelection()) {
            this.options.setRegionType(ImsRegionType.BMP);
        } else {
            this.options.setRegionType(ImsRegionType.DLI);
        }
        if (this.dynamicPsbButton.getSelection()) {
            this.options.setAccessMode(ImsAccessMode.DYNAMIC);
            String dbName = this.dynamicPsbDatabaseNameCombo.getText().trim().toUpperCase();
            if (!ImsDatabase.isValidName((String)dbName, (String)this.options.getSystem().getCodePage())) {
                this.setErrorMessage(Messages.ImsEditorOptionsDialog_21);
                this.dynamicPsbDatabaseNameCombo.setFocus();
                return false;
            }
            this.options.setImsResource((IZRL)new ImsDatabase(this.options.getSubsystem(), dbName));
            if (!this.validateDatabaseInfo()) {
                return false;
            }
        } else {
            this.options.setAccessMode(ImsAccessMode.STATIC);
            String psbName = this.staticPsbMemberNameCombo.getText().trim().toUpperCase();
            if (!ImsPsb.isValidName((String)psbName, (String)this.options.getSystem().getCodePage())) {
                this.setErrorMessage(Messages.ImsEditorOptionsDialog_22);
                this.staticPsbMemberNameCombo.setFocus();
                return false;
            }
            if (!this.validatePcbName()) {
                return false;
            }
        }
        if (!this.validateViewDataSetName()) {
            return false;
        }
        if (!this.validateEncoding()) {
            return false;
        }
        if (!this.validateDbcsEncoding()) {
            return false;
        }
        if (!this.dliDatabaseDSNEdit()) {
            return false;
        }
        return this.close();
    }

    private boolean validateViewDataSetName() {
        String result;
        block8: {
            if (this.useTemplateButton.getSelection()) {
                this.options.setTemplate(DummyMember.createDummyMember((IPDHost)this.options.getSystem()));
                this.options.setUseTemplate(true);
                return true;
            }
            this.options.setUseTemplate(false);
            String value = this.viewCombo.getText().toUpperCase().trim();
            if (value.isEmpty()) {
                this.options.setTemplate(DummyMember.createDummyMember((IPDHost)this.options.getSystem()));
                return true;
            }
            if (!ZRLs.isParseable((IPDHost)this.options.getSystem(), (String)value)) {
                this.options.setTemplate(null);
                this.viewCombo.setFocus();
                this.setErrorMessage(Messages.ImsEditorOptionsDialog_23);
                return false;
            }
            if (this.options.getTemplate() != null && value.equalsIgnoreCase(this.options.getTemplate().getFormattedName())) {
                return true;
            }
            this.options.setTemplate(null);
            this.setErrorMessage(null);
            result = TemplateEditorUtilities.okAsTemplate(ZRLs.parseZRL((IPDHost)this.options.getSystem(), (String)value), true, null);
            if (result != null) break block8;
            this.options.setTemplate((DataSetOrMember)ZRLs.parseZRL((IPDHost)this.options.getSystem(), (String)value));
            return true;
        }
        try {
            this.setErrorMessage(result);
            this.viewCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InvocationTargetException e) {
            String errMsg = Messages.ImsEditorOptionsDialog_24;
            logger.error((Object)errMsg, (Throwable)e);
            this.setErrorMessage(errMsg);
            this.viewCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
        catch (InterruptedException e) {
            this.viewCombo.setFocus();
            this.options.setTemplate(null);
            return false;
        }
    }

    private boolean validateEncoding() {
        String value = this.encodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setEncoding(this.options.getSystem().getHostType().getDefaultEncoding());
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.encodingCombo.setFocus();
            this.options.setEncoding(this.options.getSystem().getHostType().getDefaultEncoding());
            return false;
        }
        this.options.setEncoding(value);
        return true;
    }

    private boolean validateDbcsEncoding() {
        String value = this.dbcsEncodingCombo.getText();
        if (value.isEmpty()) {
            this.options.setDbcsEncoding("");
            return true;
        }
        if (!EncodingUtils.isValidCodePage((String)(value = EncodingUtils.parseCodePage((String)value)))) {
            this.setErrorMessage(Messages.Db2EditorDialog_31);
            this.dbcsEncodingCombo.setFocus();
            this.options.setDbcsEncoding("");
            return false;
        }
        this.options.setDbcsEncoding(value);
        return true;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    public ImsEditorOptions getOptions() {
        return this.options;
    }

    private boolean validatePcbName() {
        ImsAccessMode selectedAccess;
        ImsRegionType selectedRegionType;
        String dbFilter;
        String psbName;
        block5: {
            psbName = this.staticPsbMemberNameCombo.getText().toUpperCase().trim();
            dbFilter = this.staticPsbDatabaseNameFilterCombo.getText().trim();
            selectedRegionType = this.dliRegionButton.getSelection() ? ImsRegionType.DLI : ImsRegionType.BMP;
            ImsAccessMode imsAccessMode = selectedAccess = this.dynamicPsbButton.getSelection() ? ImsAccessMode.DYNAMIC : ImsAccessMode.STATIC;
            if (!(this.options.getImsResource() instanceof ImsPcb) || !((ImsPcb)this.options.getImsResource()).getDbd().getName().equals(dbFilter) || !((ImsPcb)this.options.getImsResource()).getPsb().getName().equals(psbName)) break block5;
            return true;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block12: {
                        try {
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            if (ImsPsb.isValidName((String)psbName, (String)ImsEditorOptionsDialog.this.options.getSystem().getCodePage())) {
                                Result result = ImsPsb.loadPSBsResults((ImsPsbQuery)new ImsPsbQuery(ImsEditorOptionsDialog.this.options.getSubsystem(), "*", selectedRegionType, selectedAccess), (IHowIsGoing)howIsGoing);
                                if (result.isSuccessfulWithoutWarnings()) {
                                    monitor.worked(1);
                                    List psbs = (List)result.getOutput();
                                    boolean psbExists = false;
                                    for (Member psb : psbs) {
                                        if (!psb.getName().equals(psbName)) continue;
                                        psbExists = true;
                                        break;
                                    }
                                    final ImsPsb aPsb = new ImsPsb(ImsEditorOptionsDialog.this.options.getSubsystem(), psbName);
                                    monitor.worked(1);
                                    if (psbExists) {
                                        List pcbs = ImsPcb.loadPCBsFiltered((IHowIsGoing)howIsGoing, (ImsSubsystem)ImsEditorOptionsDialog.this.options.getSubsystem(), (ImsSubsystemConfig)ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig(), (ImsRegionType)ImsEditorOptionsDialog.this.options.getRegionType(), (String)psbName, (String)dbFilter, (String)"");
                                        monitor.worked(1);
                                        if (pcbs != null) {
                                            switch (pcbs.size()) {
                                                case 0: {
                                                    result.setRC(8);
                                                    result.add(Messages.ImsRunnable_SelectPSBHasNoPCBs);
                                                    throw new CommunicationException(Messages.ImsRunnable_SelectPSBHasNoPCBs);
                                                }
                                                case 1: {
                                                    ImsPcb pcb = (ImsPcb)pcbs.get(0);
                                                    ImsEditorOptionsDialog.this.options.setImsResource((IZRL)pcb);
                                                    break;
                                                }
                                                default: {
                                                    Display.getDefault().syncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            ImsPcb aPcb = ImsPcbLookupDialog.promptForValidPcb((this).ImsEditorOptionsDialog.this.options.getSubsystem().getCanonicalConfig().getRegionConfig((this).ImsEditorOptionsDialog.this.options.getRegionType()), aPsb, null, "");
                                                            (this).ImsEditorOptionsDialog.this.options.setImsResource((IZRL)aPcb);
                                                        }
                                                    });
                                                }
                                            }
                                            if (ImsEditorOptionsDialog.this.options.getPcb() != null && ImsEditorOptionsDialog.this.options.getPcb().getUseabilityNote() != null) {
                                                throw new CommunicationException(ImsEditorOptionsDialog.this.options.getPcb().getUseabilityNote());
                                            }
                                            break block12;
                                        }
                                        throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBHasNoUseablePCBs, aPsb.getName()));
                                    }
                                    throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBNotFoundInLibs, aPsb.getName()));
                                }
                                throw new CommunicationException(result.getMessagesCombined().toString());
                            }
                            throw new CommunicationException(MessageFormat.format(Messages.ImsRunnable_PSBHasInvalidName, psbName));
                        }
                        catch (CommunicationException ce) {
                            throw new InvocationTargetException(ce);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CommunicationException) {
                PDDialogs.openInfoThreadSafe((String)Messages.Information, (String)Messages.ImsEditorOptionsDialog_26, (String)e.getTargetException().getMessage());
                this.setErrorMessage(Messages.ImsEditorOptionsDialog_26);
                this.staticPsbMemberNameCombo.setFocus();
                return false;
            }
            String errMsg = Messages.ImsEditorOptionsDialog_27;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        return true;
    }

    private boolean dliDatabaseDSNEdit() {
        if (this.bmpRegionButton.getSelection()) {
            this.options.setEditDliDatabaseDatasets(false);
            return true;
        }
        if (!this.dliEditDataSetButton.getSelection()) {
            this.options.setEditDliDatabaseDatasets(false);
            return true;
        }
        this.options.setEditDliDatabaseDatasets(true);
        return true;
    }

    private boolean validateDatabaseInfo() {
        if (this.options.getAccessMode() == ImsAccessMode.STATIC) {
            this.options.setDynamicPsbSecondaryIndexName(null);
            return true;
        }
        final ImsDatabase aDatabase = this.options.getDatabase();
        if (aDatabase == null) {
            this.setErrorMessage(Messages.ImsEditorOptionsDialog_28);
            this.dynamicPsbDatabaseNameCombo.setFocus();
            return false;
        }
        final Result overallResult = new Result();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.ImsEditorOptionsDialog_8, aDatabase.getName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    monitor.worked(1);
                    Result infoResult = aDatabase.loadInfo(howIsGoing, "", ImsEditorOptionsDialog.this.options.getRegionType());
                    overallResult.addSubResultWithOutput(infoResult);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            String errMsg = Messages.ImsEditorOptionsDialog_29;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        catch (InterruptedException e) {
            this.dynamicPsbDatabaseNameCombo.setFocus();
            return false;
        }
        if (!overallResult.isSuccessfulWithoutWarnings()) {
            if (!overallResult.dumpOutputAndMessages(true).isEmpty()) {
                PDDialogs.openErrorThreadSafe((String)Messages.ImsEditorOptionsDialog_30, (String)overallResult.dumpOutputAndMessages(true));
            }
            this.setErrorMessage(Messages.ImsEditorOptionsDialog_30);
            this.dynamicPsbDatabaseNameCombo.setFocus();
            return false;
        }
        ImsDatabaseInfo validatedDbInfo = (ImsDatabaseInfo)overallResult.getOutput();
        String secondaryIndexName = this.dynamicPsbSecIndexNameCombo.getText().trim().toUpperCase();
        if (secondaryIndexName.isEmpty()) {
            this.options.setDynamicPsbSecondaryIndexName(null);
            return true;
        }
        if (!validatedDbInfo.isValidSecondaryIndexName(secondaryIndexName)) {
            this.setErrorMessage(Messages.ImsEditorOptionsDialog_31);
            this.dynamicPsbSecIndexNameCombo.setFocus();
            return false;
        }
        this.options.setDynamicPsbSecondaryIndexName(secondaryIndexName);
        return true;
    }

    private ModifyListener getClearErrorModifyListener() {
        if (this.clearErrorModifyListener != null) {
            return this.clearErrorModifyListener;
        }
        this.clearErrorModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ImsEditorOptionsDialog.this.setErrorMessage(null);
            }
        };
        return this.clearErrorModifyListener;
    }
}

