/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.view.ImsEditorView;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IPropertyListener;

public class SegmentTableDisplayComposite
implements IPropertyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int TABLE_COLUMN_COUNT = 5;
    public static final int INDEX_LEVEL_COLUMN = 0;
    public static final int INDEX_SEGNAME_COLUMN = 1;
    public static final int INDEX_CKEY_COLUMN = 2;
    public static final int INDEX_DESC_COLUMN = 3;
    public static final int INDEX_DISPLAY_LINE_OBJECT_COLUMN = 4;
    private ImsEditor imsEditor;
    private Table segmentTable = null;
    private TableViewer segmentTableViewer = null;
    private Menu segmentTableMenu = null;
    private Composite contents = null;
    private Clipboard clipboard;

    public SegmentTableDisplayComposite(ImsEditor imsEditor) {
        this.imsEditor = imsEditor;
    }

    public void createSegmentTableComposite(Composite parent) {
        this.contents = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.segmentTable = new Table(this.contents, 68354);
        this.segmentTable.setHeaderVisible(true);
        this.segmentTable.setLinesVisible(true);
        GridData data = GUI.grid.d.fillAll();
        data.heightHint = 200;
        this.segmentTable.setLayoutData((Object)data);
        this.segmentTableViewer = new TableViewer(this.segmentTable);
        this.segmentTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.segmentTableViewer.getTable().setFont(JFaceResources.getTextFont());
        this.addSelectionListener();
        this.addTableKeyListener();
        this.createTableColumns();
        this.createPopupMenu();
        this.setTableContents();
        this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public Composite getContents() {
        return this.contents;
    }

    private void addSelectionListener() {
        this.segmentTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selectedItems = SegmentTableDisplayComposite.this.segmentTable.getSelection();
                if (selectedItems.length == 0) {
                    return;
                }
                Object[] selectedRow = (Object[])selectedItems[0].getData();
                DisplayLine aLine = (DisplayLine)selectedRow[4];
                SegmentTableDisplayComposite.this.imsEditor.setCurrentSelection(aLine);
            }
        });
    }

    private void addTableKeyListener() {
        this.segmentTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    SegmentTableDisplayComposite.this.moveUpAction();
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    SegmentTableDisplayComposite.this.moveDownAction();
                } else if (e.stateMask == 262144 && e.keyCode == 99) {
                    SegmentTableDisplayComposite.this.copySelectionToClipboard();
                }
            }
        });
    }

    public void performSelectAll() {
        this.segmentTable.selectAll();
    }

    public void copySelectionToClipboard() {
        TableItem[] selectedItems = this.segmentTable.getSelection();
        if (selectedItems.length == 0) {
            return;
        }
        Object lines = "";
        TableItem[] tableItemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem selectedItem = tableItemArray[n2];
            String encoding = this.imsEditor.getResource().getPersistentProperty("encoding");
            Object[] selectedRow = (Object[])selectedItem.getData();
            DisplayLine aLine = (DisplayLine)selectedRow[4];
            Object[] aLineContents = new Object[5];
            this.formatDisplayLine(encoding, aLine, aLineContents, true);
            Object line = "";
            Object[] objectArray = aLineContents;
            int n3 = aLineContents.length;
            int n4 = 0;
            while (n4 < n3) {
                Object content = objectArray[n4];
                if (content != null) {
                    line = (String)line + "\t" + String.valueOf(content);
                }
                ++n4;
            }
            if (!((String)line).isEmpty()) {
                lines = (String)lines + "\n" + (String)line;
            }
            ++n2;
        }
        StringSelection data = new StringSelection((String)lines);
        this.clipboard.setContents(data, data);
    }

    private void moveUpAction() {
        if (this.imsEditor.isNeedScrolling()) {
            if (this.segmentTable.getSelectionIndex() != 0) {
                this.imsEditor.setNeedScrolling(false);
                return;
            }
            this.imsEditor.setNeedScrolling(false);
            PageUp action = new PageUp();
            action.run(this.imsEditor);
            return;
        }
        if (this.segmentTable.getSelectionIndex() == 0) {
            this.imsEditor.setNeedScrolling(true);
            return;
        }
    }

    private void moveDownAction() {
        if (this.imsEditor.isNeedScrolling()) {
            if (this.segmentTable.getSelectionIndex() != this.segmentTable.getItemCount() - 1) {
                this.imsEditor.setNeedScrolling(false);
                return;
            }
            this.imsEditor.setNeedScrolling(false);
            PageDown action = new PageDown();
            action.run(this.imsEditor);
            return;
        }
        if (this.segmentTable.getSelectionIndex() == this.segmentTable.getItemCount() - 1) {
            this.imsEditor.setNeedScrolling(true);
            return;
        }
    }

    private void createTableColumns() {
        FormattedEditorUtility.createTableViewerColumn(Messages.SegmentTableDisplayComposite_0, 100, this.segmentTableViewer, 131072);
        FormattedEditorUtility.createTableViewerColumn(Messages.SegmentTableDisplayComposite_1, 200, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SegmentTableDisplayComposite_2, 400, this.segmentTableViewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.SegmentTableDisplayComposite_3, 400, this.segmentTableViewer, 16384);
        this.segmentTableViewer.setLabelProvider((IBaseLabelProvider)new SegTableLabelProvider());
    }

    public void justRefreshContents() {
        this.setTableContents();
    }

    public void setTableContents() {
        ArrayList<Object[]> tableContents = new ArrayList<Object[]>();
        ArrayList<DisplayLine> editorContents = this.imsEditor.getCurrentEditorContents();
        if (editorContents.isEmpty()) {
            this.segmentTableViewer.setInput(tableContents);
            return;
        }
        String encoding = this.imsEditor.getResource().getPersistentProperty("encoding");
        for (DisplayLine aLine : editorContents) {
            Object[] aLineContents = new Object[5];
            if (aLine instanceof HexRecordWrapper) {
                HexRecordWrapper aHexLine = (HexRecordWrapper)aLine;
                aLineContents[0] = "";
                aLineContents[1] = "";
                aLineContents[2] = aLine instanceof ShadowGroup ? "" : aHexLine.getEntireHighOrLowHexString();
                aLineContents[3] = "";
                aLineContents[4] = aLine;
            } else {
                this.formatDisplayLine(encoding, aLine, aLineContents, false);
                aLineContents[4] = aLine;
            }
            tableContents.add(aLineContents);
        }
        this.segmentTableViewer.setInput(tableContents);
    }

    private void formatDisplayLine(String encoding, DisplayLine aLine, Object[] aLineContents, boolean suppressShadowLines) {
        if (aLine instanceof ShadowGroup && suppressShadowLines) {
            return;
        }
        RecType aRec = aLine.getRecord();
        int segLvl = this.imsEditor.getSegmentLevel(aRec.getSegname());
        aLineContents[0] = SegmentTableDisplayComposite.getLevelForDisplay(segLvl);
        Object object = aLineContents[1] = aRec.getSegname() != null ? aRec.getSegname() : "";
        if (aLine instanceof ShadowGroup) {
            ShadowGroup aGroup = (ShadowGroup)aLine;
            aLineContents[2] = "";
            String desc = MessageFormat.format(Messages.SegmentTableDisplayComposite_4, this.imsEditor.getLayoutName(aGroup.getRecord().getId()), aGroup.getRecord().getSet());
            aLineContents[3] = desc;
        } else {
            String keyForDisplay = DataConversionUtils.hexToDisplayString((String)(aRec.getCkey() != null ? aRec.getCkey() : ""), (String)encoding);
            if (keyForDisplay == null) {
                keyForDisplay = aRec.getCkey() != null ? aRec.getCkey() : "";
            }
            aLineContents[2] = keyForDisplay;
            aLineContents[3] = "";
        }
    }

    private void createPopupMenu() {
        MenuManager popupMenu = this.imsEditor.getActionManager().getPopupMenu();
        this.segmentTableMenu = popupMenu.createContextMenu((Control)this.segmentTable);
        this.segmentTable.setMenu(this.segmentTableMenu);
        this.imsEditor.getSite().registerContextMenu(popupMenu, this.imsEditor.getSite().getSelectionProvider());
    }

    public static String getLevelForDisplay(int level) {
        if (level <= 1) {
            return "" + level;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < level - 1) {
            sb.append(" ");
            ++i;
        }
        sb.append(level);
        return sb.toString();
    }

    public void propertyChanged(Object source, int propId) {
        if (this.imsEditor.getCurrentEditorMode() != IFMEditor.EditorMode.FORMATTED) {
            return;
        }
        if (propId == 2048) {
            this.setTableContents();
            if (this.segmentTable.getItemCount() > 0) {
                this.setSelection(new int[1]);
                DisplayLine currentLine = this.imsEditor.getCurrentEditorContents().get(0);
                if (currentLine != null) {
                    ImsEditorView.displayCurrentRecord(this.imsEditor, currentLine);
                }
            }
        } else if (propId == 2049) {
            int newIndexForSelection = 0;
            int[] selectedLines = this.getSelection();
            if (selectedLines != null && selectedLines.length > 0) {
                int firstLine = selectedLines[0];
                newIndexForSelection = this.imsEditor.isHexMode() ? firstLine * 3 : firstLine / 3;
            }
            this.setTableContents();
            this.setSelection(new int[]{newIndexForSelection});
            DisplayLine currentLine = this.imsEditor.getCurrentEditorContents().get(newIndexForSelection);
            if (currentLine != null) {
                ImsEditorView.displayCurrentRecord(this.imsEditor, currentLine);
            }
        }
    }

    public int[] getSelection() {
        if (this.segmentTable.getSelectionCount() > 0) {
            return this.segmentTable.getSelectionIndices();
        }
        return new int[1];
    }

    public void setSelection(int[] selection) {
        this.segmentTable.setSelection(selection);
    }

    public void setCursor(NavigationSpecification navSpec) {
        if (navSpec.getLocationType() == NavigationSpecification.LocationType.TOP) {
            this.segmentTable.setFocus();
            this.segmentTable.select(0);
            this.segmentTable.showItem(this.segmentTable.getItem(0));
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.BOTTOM) {
            this.segmentTable.setFocus();
            this.segmentTable.select(this.segmentTable.getItemCount() - 1);
            this.segmentTable.showItem(this.segmentTable.getItem(this.segmentTable.getItemCount() - 1));
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_NUMBER || navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_OFFSET || navSpec.getLocationType() == NavigationSpecification.LocationType.COLUMN_NUMBER) {
            int index = this.imsEditor.getIndexOf(navSpec.getRecordToken());
            if (index == -1) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CharModePage_NO_RECFOUND, navSpec.getRecordToken()));
                return;
            }
            this.segmentTable.setFocus();
            this.segmentTable.setSelection(index);
            this.segmentTable.showItem(this.segmentTable.getItem(index));
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.JUST_FOCUS) {
            this.segmentTable.setFocus();
        } else {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_UNSUPPORTED_NAV_SPEC, new Object[]{navSpec.getLocationType()}));
        }
    }

    public ArrayList<RecType> getSelectedNonShadowLines() {
        ArrayList<RecType> list = new ArrayList<RecType>();
        TableItem[] selectedRows = this.segmentTable.getSelection();
        if (selectedRows.length == 0) {
            return list;
        }
        int i = 0;
        while (i < selectedRows.length) {
            Object[] aRow = (Object[])selectedRows[i].getData();
            DisplayLine aLine = (DisplayLine)aRow[4];
            if (!(aLine instanceof ShadowGroup)) {
                if (aLine instanceof HexRecordWrapper) {
                    IFormattedEditorPage.addIfNew(list, ((HexRecordWrapper)aLine).getDisplayLine());
                } else {
                    IFormattedEditorPage.addIfNew(list, aLine);
                }
            }
            ++i;
        }
        return list;
    }

    private static class SegTableLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private SegTableLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            return (String)((Object[])element)[columnIndex];
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            DisplayLine aLine;
            if (2 == columnIndex && (aLine = (DisplayLine)((Object[])element)[4]) instanceof HexRecordWrapper) {
                return FormattedEditorPreferencePage.getHexForegroundColor();
            }
            return null;
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            DisplayLine aLine;
            if (2 == columnIndex && SegTableLabelProvider.isSearchHitFound(aLine = (DisplayLine)((Object[])element)[4])) {
                return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
            }
            return null;
        }

        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                DisplayLine aLine = (DisplayLine)((Object[])element)[4];
                if (aLine instanceof SuppressedRecordsShadowGroup) {
                    return FMUIPlugin.getDefault().getImageRegistry().get("icons/SuppressRecord_1.gif");
                }
                if (SegTableLabelProvider.isModifiedRecord(aLine)) {
                    return FMUIPlugin.getDefault().getImageRegistry().get("icons/ChangedRecord.gif");
                }
            }
            return super.getColumnImage(element, columnIndex);
        }

        private static boolean isSearchHitFound(DisplayLine aLine) {
            if (aLine instanceof HexRecordWrapper) {
                return false;
            }
            if (aLine instanceof SuppressedRecordsShadowGroup) {
                return false;
            }
            EList fields = aLine.getRecord().getField();
            for (FieldType aField : fields) {
                if (aField.getFindhit() <= 0) continue;
                return true;
            }
            return false;
        }

        private static boolean isModifiedRecord(DisplayLine aLine) {
            if (aLine instanceof HexRecordWrapper) {
                return false;
            }
            if (aLine instanceof SuppressedRecordsShadowGroup) {
                return false;
            }
            return aLine.getRecord().isSetChg();
        }
    }
}

