/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsKeyField;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.view.ImsEditorView;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IPropertyListener;

public class SegmentCharDisplayComposite
implements IPropertyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private ImsEditor imsEditor;
    private Composite contents = null;
    private StyledText infoDisplayText;
    private StyledText charDisplayText;
    private ScrollBar infoFieldVerticalScrollBar = null;
    private ScrollBar textFieldVerticalScrollBar = null;
    private ArrayList<String> lineContents = null;
    private ArrayList<String> infoContents = null;
    private Menu charDisplayTextMenu = null;
    private Menu infoDisplayTextMenu = null;

    public SegmentCharDisplayComposite(ImsEditor imsEditor) {
        this.imsEditor = imsEditor;
    }

    public void createSegmentTableComposite(Composite parent) {
        this.contents = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        SashForm sashForm = new SashForm(this.contents, 256);
        sashForm.setLayoutData((Object)GUI.grid.d.fillAll());
        this.infoDisplayText = new StyledText((Composite)sashForm, 2826);
        this.infoDisplayText.setFont(JFaceResources.getTextFont());
        this.infoFieldVerticalScrollBar = this.infoDisplayText.getVerticalBar();
        this.infoFieldVerticalScrollBar.setVisible(false);
        this.charDisplayText = new StyledText((Composite)sashForm, 2826);
        this.charDisplayText.setLayoutData((Object)GUI.grid.d.fillAll());
        this.charDisplayText.setFont(JFaceResources.getTextFont());
        this.textFieldVerticalScrollBar = this.charDisplayText.getVerticalBar();
        this.addInfoAreaListeners();
        this.addTextAreaListeners();
        this.createPopupMenu();
        sashForm.setWeights(new int[]{10, 90});
    }

    private void addInfoAreaListeners() {
        this.infoFieldVerticalScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SegmentCharDisplayComposite.this.alignTopLine(false);
            }
        });
        this.infoDisplayText.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                int[] selection = SegmentCharDisplayComposite.this.getSelectionOfInfoDisplay();
                if (selection == null || selection.length == 0) {
                    SegmentCharDisplayComposite.this.imsEditor.setCurrentSelection(null);
                    return;
                }
                SegmentCharDisplayComposite.this.imsEditor.setCurrentSelection(SegmentCharDisplayComposite.this.imsEditor.getCurrentEditorContents().get(selection[0]));
                SegmentCharDisplayComposite.this.infoDisplayText.setFocus();
            }
        });
        this.infoDisplayText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    SegmentCharDisplayComposite.this.moveUpAction();
                    SegmentCharDisplayComposite.this.alignTopLine(false);
                    SegmentCharDisplayComposite.this.infoDisplayText.setFocus();
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    SegmentCharDisplayComposite.this.moveDownAction();
                    SegmentCharDisplayComposite.this.alignTopLine(false);
                    SegmentCharDisplayComposite.this.infoDisplayText.setFocus();
                }
            }
        });
    }

    private void addTextAreaListeners() {
        this.textFieldVerticalScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SegmentCharDisplayComposite.this.alignTopLine(true);
            }
        });
        this.charDisplayText.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                int[] selection = SegmentCharDisplayComposite.this.getSelection();
                if (selection == null || selection.length == 0) {
                    SegmentCharDisplayComposite.this.imsEditor.setCurrentSelection(null);
                    return;
                }
                SegmentCharDisplayComposite.this.imsEditor.setCurrentSelection(SegmentCharDisplayComposite.this.imsEditor.getCurrentEditorContents().get(selection[0]));
                SegmentCharDisplayComposite.this.charDisplayText.setFocus();
            }
        });
        this.charDisplayText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    SegmentCharDisplayComposite.this.moveUpAction();
                    SegmentCharDisplayComposite.this.alignTopLine(true);
                    SegmentCharDisplayComposite.this.charDisplayText.setFocus();
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    SegmentCharDisplayComposite.this.moveDownAction();
                    SegmentCharDisplayComposite.this.alignTopLine(true);
                    SegmentCharDisplayComposite.this.charDisplayText.setFocus();
                }
            }
        });
    }

    private void alignTopLine(boolean alignByContentText) {
        int topLineIndex = 0;
        topLineIndex = alignByContentText ? this.charDisplayText.getTopIndex() : this.infoDisplayText.getTopIndex();
        this.infoDisplayText.setTopIndex(topLineIndex);
        this.charDisplayText.setTopIndex(topLineIndex);
    }

    private void createPopupMenu() {
        MenuManager popupMenu = this.imsEditor.getActionManager().getPopupMenu();
        this.charDisplayTextMenu = popupMenu.createContextMenu((Control)this.charDisplayText);
        this.charDisplayText.setMenu(this.charDisplayTextMenu);
        this.infoDisplayTextMenu = popupMenu.createContextMenu((Control)this.infoDisplayText);
        this.infoDisplayText.setMenu(this.infoDisplayTextMenu);
        this.imsEditor.getSite().registerContextMenu(popupMenu, this.imsEditor.getSite().getSelectionProvider());
    }

    public Composite getContents() {
        return this.contents;
    }

    public void propertyChanged(Object source, int propId) {
        if (this.imsEditor.getCurrentEditorMode() != IFMEditor.EditorMode.CHARACTER) {
            return;
        }
        if (propId == 2048) {
            this.setTextContents();
            if (this.imsEditor.getCurrentEditorContents().size() > 0) {
                this.setSelection(new int[1]);
                DisplayLine currentLine = this.imsEditor.getCurrentEditorContents().get(0);
                if (currentLine != null) {
                    ImsEditorView.displayCurrentRecord(this.imsEditor, currentLine);
                }
            }
        } else if (propId == 2049) {
            int newIndexForSelection = 0;
            int[] selectedLines = this.getSelection();
            if (selectedLines != null && selectedLines.length > 0) {
                int firstLine = selectedLines[0];
                newIndexForSelection = this.imsEditor.isHexMode() ? firstLine * 3 : firstLine / 3;
            }
            this.setTextContents();
            this.setSelection(new int[]{newIndexForSelection});
            DisplayLine currentLine = this.imsEditor.getCurrentEditorContents().get(newIndexForSelection);
            if (currentLine != null) {
                ImsEditorView.displayCurrentRecord(this.imsEditor, currentLine);
            }
        }
    }

    public void setSelection(int[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        int selectedLine = selection[0];
        if (this.lineContents == null || selectedLine >= this.lineContents.size()) {
            return;
        }
        int startLocation = 0;
        int i = 0;
        while (i < selectedLine) {
            startLocation += this.lineContents.get(i).length();
            ++i;
        }
        int length = this.lineContents.get(selectedLine).length() - 1;
        this.charDisplayText.setSelection(startLocation, startLocation + length);
        this.alignTopLine(true);
        this.setSelectionForInfoText(selection);
        this.charDisplayText.setFocus();
    }

    private void setSelectionForInfoText(int[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        int selectedLine = selection[0];
        if (this.infoContents == null || selectedLine >= this.infoContents.size()) {
            return;
        }
        int startLocation = 0;
        int i = 0;
        while (i < selectedLine) {
            startLocation += this.infoContents.get(i).length();
            ++i;
        }
        int length = this.infoContents.get(selectedLine).length() - 1;
        this.infoDisplayText.setSelection(startLocation, startLocation + length);
        this.alignTopLine(true);
    }

    public int[] getSelection() {
        if (this.infoDisplayText.isFocusControl()) {
            return this.getSelectionOfInfoDisplay();
        }
        return this.getSelectionOfCharDisplay();
    }

    private int[] getSelectionOfCharDisplay() {
        int offset = this.charDisplayText.getCaretOffset();
        int lineCount = 0;
        String contents = this.charDisplayText.getText();
        int i = 0;
        while (i < offset) {
            if (contents.charAt(i) == '\n') {
                ++lineCount;
            }
            ++i;
        }
        return new int[]{lineCount};
    }

    private int[] getSelectionOfInfoDisplay() {
        int offset = this.infoDisplayText.getCaretOffset();
        int lineCount = 0;
        String contents = this.infoDisplayText.getText();
        int i = 0;
        while (i < offset) {
            if (contents.charAt(i) == '\n') {
                ++lineCount;
            }
            ++i;
        }
        return new int[]{lineCount};
    }

    public void setTextContents() {
        StringBuilder infoTextContents = new StringBuilder();
        StringBuilder editorContents = new StringBuilder();
        ArrayList<DisplayLine> contents = this.imsEditor.getCurrentEditorContents();
        this.lineContents = new ArrayList();
        this.infoContents = new ArrayList();
        for (DisplayLine aLine : contents) {
            String strLine = null;
            if (aLine instanceof HexRecordWrapper) {
                HexRecordWrapper aWrapper = (HexRecordWrapper)aLine;
                strLine = aWrapper.getEntireHighOrLowHexString() + "\n";
            } else {
                strLine = aLine instanceof ShadowGroup ? SegmentCharDisplayComposite.hexToString(aLine.getRecord().getHex(), HostType.ZOS.getDefaultEncoding()) + "\n" : SegmentCharDisplayComposite.hexToString(aLine.getRecord().getHex(), this.imsEditor.getResource().getPersistentProperty("encoding")) + "\n";
            }
            this.lineContents.add(strLine);
            editorContents.append(strLine);
            String segInfo = this.imsEditor.getSegmentInfoText(aLine);
            this.infoContents.add(segInfo);
            infoTextContents.append(segInfo);
        }
        if (editorContents.length() > 0) {
            String str = this.lineContents.get(this.lineContents.size() - 1);
            str = str.substring(0, str.length() - 1);
            this.lineContents.remove(this.lineContents.size() - 1);
            this.lineContents.add(str);
            this.charDisplayText.setText(editorContents.substring(0, editorContents.length() - 1));
            this.annotateContents(contents, this.lineContents);
            this.infoDisplayText.setText(infoTextContents.toString().substring(0, infoTextContents.length() - 1));
            str = this.infoContents.get(this.infoContents.size() - 1);
            str = str.substring(0, str.length() - 1);
            this.infoContents.remove(this.infoContents.size() - 1);
            this.infoContents.add(str);
        } else {
            this.charDisplayText.setText(editorContents.toString());
            this.annotateContents(contents, this.lineContents);
            this.infoDisplayText.setText(infoTextContents.toString());
        }
    }

    private void annotateContents(ArrayList<DisplayLine> contents, ArrayList<String> lineContents) {
        ArrayList<StyleRange> styleRangeList = new ArrayList<StyleRange>();
        Color textForegroundColor = FormattedEditorPreferencePage.getTextForegroundColor();
        Color keyForegroundColor = FormattedEditorPreferencePage.getHighlightColor();
        Color textBackgroundColor = Display.getCurrent().getSystemColor(1);
        Color highlightBackgroundColor = FormattedEditorPreferencePage.getLenErrTextBackgroundColor();
        Color hexForegroundColor = FormattedEditorPreferencePage.getHexForegroundColor();
        int position = 0;
        int i = 0;
        while (i < lineContents.size()) {
            String aLine = lineContents.get(i);
            DisplayLine aDispLine = contents.get(i);
            if (this.imsEditor.isHexMode()) {
                if (i % 3 == 0) {
                    if (aDispLine instanceof SuppressedRecordsShadowGroup) {
                        StyleRange sr = new StyleRange(position, aLine.length(), textForegroundColor, highlightBackgroundColor);
                        styleRangeList.add(sr);
                    } else {
                        this.annoteKeyField(position, aLine, aDispLine, styleRangeList, textForegroundColor, keyForegroundColor, textBackgroundColor, highlightBackgroundColor);
                    }
                } else {
                    this.annoteKeyField(position, aLine, aDispLine, styleRangeList, hexForegroundColor, hexForegroundColor, textBackgroundColor, highlightBackgroundColor);
                }
            } else {
                this.annoteKeyField(position, aLine, aDispLine, styleRangeList, textForegroundColor, keyForegroundColor, textBackgroundColor, highlightBackgroundColor);
            }
            position += aLine.length();
            ++i;
        }
        StyleRange[] ranges = new StyleRange[styleRangeList.size()];
        int i2 = 0;
        while (i2 < ranges.length) {
            ranges[i2] = (StyleRange)styleRangeList.get(i2);
            ++i2;
        }
        this.charDisplayText.setStyleRanges(ranges);
    }

    private void annoteKeyField(int position, String aLine, DisplayLine aDispLine, ArrayList<StyleRange> styleRangeList, Color textForegroundColor, Color keyForegroundColor, Color textBackgroundColor, Color highlightBackgroundColor) {
        ImsSegment aSegment = this.imsEditor.getSegmentInformation(aDispLine.getRecord().getSegname());
        if (aSegment == null) {
            StyleRange sr = new StyleRange(position, aLine.length(), textForegroundColor, textBackgroundColor);
            styleRangeList.add(sr);
            return;
        }
        List keys = aSegment.getKeyFields();
        if (keys == null || keys.isEmpty()) {
            StyleRange sr = new StyleRange(position, aLine.length(), textForegroundColor, textBackgroundColor);
            styleRangeList.add(sr);
            return;
        }
        ImsKeyField aKey = (ImsKeyField)keys.get(0);
        int start = Integer.parseInt(aKey.getPos()) - 1;
        int length = aKey.getLength();
        StyleRange sr = new StyleRange(position, start, textForegroundColor, textBackgroundColor);
        styleRangeList.add(sr);
        sr = new StyleRange(position += start, length, keyForegroundColor, highlightBackgroundColor);
        styleRangeList.add(sr);
        sr = new StyleRange(position += length, aLine.length() - (start + length), textForegroundColor, textBackgroundColor);
        styleRangeList.add(sr);
    }

    private static String hexToString(String hexValue, String encoding) {
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
            return new String(byteValue, HostType.ZOS.getDefaultEncoding()).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
        }
        catch (UnsupportedEncodingException e) {
            return hexValue;
        }
    }

    public void setCursor(NavigationSpecification navSpec) {
        if (navSpec.getLocationType() == NavigationSpecification.LocationType.TOP) {
            this.charDisplayText.setFocus();
            this.setSelection(new int[1]);
            this.charDisplayText.showSelection();
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.BOTTOM) {
            this.charDisplayText.setFocus();
            this.setSelection(new int[]{this.lineContents.size() - 1});
            this.charDisplayText.showSelection();
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_NUMBER || navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_OFFSET || navSpec.getLocationType() == NavigationSpecification.LocationType.COLUMN_NUMBER) {
            int index = this.imsEditor.getIndexOf(navSpec.getRecordToken());
            if (index == -1) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CharModePage_NO_RECFOUND, navSpec.getRecordToken()));
                return;
            }
            this.charDisplayText.setFocus();
            this.setSelection(new int[]{index});
            this.charDisplayText.showSelection();
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.JUST_FOCUS) {
            this.charDisplayText.setFocus();
        } else {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_UNSUPPORTED_NAV_SPEC, new Object[]{navSpec.getLocationType()}));
        }
    }

    public void justRefreshContents() {
        this.setTextContents();
    }

    public ArrayList<RecType> getSelectedNonShadowLines() {
        ArrayList<RecType> list = new ArrayList<RecType>();
        int[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            return list;
        }
        int i = 0;
        while (i < selection.length) {
            DisplayLine aLine = this.imsEditor.getCurrentEditorContents().get(selection[i]);
            if (!(aLine instanceof ShadowGroup)) {
                if (aLine instanceof HexRecordWrapper) {
                    IFormattedEditorPage.addIfNew(list, ((HexRecordWrapper)aLine).getDisplayLine());
                } else {
                    IFormattedEditorPage.addIfNew(list, aLine);
                }
            }
            ++i;
        }
        return list;
    }

    private void moveUpAction() {
        if (this.imsEditor.isNeedScrolling()) {
            int[] selection = this.getSelection();
            if (selection != null && selection.length > 0 && selection[0] != 0) {
                this.imsEditor.setNeedScrolling(false);
                return;
            }
            this.imsEditor.setNeedScrolling(false);
            PageUp action = new PageUp();
            action.run(this.imsEditor);
            return;
        }
        int[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        if (selection[0] == 0) {
            this.imsEditor.setNeedScrolling(true);
            return;
        }
    }

    private void moveDownAction() {
        if (this.imsEditor.isNeedScrolling()) {
            int[] selection = this.getSelection();
            if (selection != null && selection.length > 0 && selection[0] != this.lineContents.size() - 1) {
                this.imsEditor.setNeedScrolling(false);
                return;
            }
            this.imsEditor.setNeedScrolling(false);
            PageDown action = new PageDown();
            action.run(this.imsEditor);
            return;
        }
        int[] selection = this.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        if (selection[0] == this.lineContents.size() - 1) {
            this.imsEditor.setNeedScrolling(true);
            return;
        }
    }
}

