/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.editor.formatted.handler.JumpToRecord;
import com.ibm.etools.fm.editor.formatted.handler.PageDown;
import com.ibm.etools.fm.editor.formatted.handler.PageUp;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.handler.SetKeyPosition;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImsNavigationBar {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String TOP = "TOP";
    public static final String BOTTOM = "BOT";
    public static final String UP = "UP";
    public static final String UP_SHORTCUT = "-";
    public static final String DOWN = "DOWN";
    public static final String DOWN_SHORTCUT = "+";
    private ImsEditor editor;
    private Combo navigationCombo;
    private static final String NAVIGATION_COMBO = "com.ibm.etools.fm.editor.formatted1.ImsNavigationBar.navCombo";
    private Button goButton;
    private Button stepUpButton;
    private Button stepDownButton;
    private Button hierarchyButton;
    private Text editorModeText;

    public ImsNavigationBar(ImsEditor editor2) {
        this.editor = editor2;
    }

    public Control createControl(Composite parent) {
        Composite toolbarComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)2, (boolean)false), (Object)GUI.grid.d.left1());
        this.createNavigationComposite(toolbarComposite);
        this.createEditTypeComposite(toolbarComposite);
        return parent;
    }

    private void createNavigationComposite(Composite p) {
        Composite composite = GUI.composite((Composite)p, (Layout)GUI.grid.l.noMargins((int)6, (boolean)false), (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)composite, (String)Messages.TopNavigationBar_NAV, (Object)GUI.grid.d.left1());
        GridData data = GUI.grid.d.left1();
        data.widthHint = 150;
        this.navigationCombo = GUI.combo.editable((Composite)composite, (Object)data);
        String[] history = FMUIPlugin.getDefault().getDialogValues(NAVIGATION_COMBO);
        if (history.length > 0) {
            this.navigationCombo.setItems(history);
            this.navigationCombo.select(0);
        }
        this.navigationCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String cmd;
                if (!(e.character != '\n' && e.character != '\r' || (cmd = ImsNavigationBar.this.navigationCombo.getText().trim()).isEmpty())) {
                    if (!ImsNavigationBar.this.editor.updateDirtyContents()) {
                        return;
                    }
                    String formattedCommand = ImsNavigationBar.validateNavigationCommand(cmd);
                    if (formattedCommand != null) {
                        FMUIPlugin.getDefault().renewDialogValue(ImsNavigationBar.NAVIGATION_COMBO, formattedCommand);
                    }
                    ImsNavigationBar.this.executeCommand(formattedCommand, cmd);
                }
            }
        });
        this.navigationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String cmd = ImsNavigationBar.this.navigationCombo.getText().trim();
                if (!cmd.isEmpty()) {
                    if (!ImsNavigationBar.this.editor.updateDirtyContents()) {
                        return;
                    }
                    String formattedCommand = ImsNavigationBar.validateNavigationCommand(cmd);
                    if (formattedCommand != null) {
                        FMUIPlugin.getDefault().renewDialogValue(ImsNavigationBar.NAVIGATION_COMBO, formattedCommand);
                    }
                    ImsNavigationBar.this.executeCommand(formattedCommand, cmd);
                }
            }
        });
        this.navigationCombo.setToolTipText(Messages.ImsNavigationBar_0);
        this.goButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/run.gif"), (String)Messages.TopNavigationBar_GO_TIP, (Object)GUI.grid.d.left1());
        this.goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String cmd = ImsNavigationBar.this.navigationCombo.getText().trim();
                if (!cmd.isEmpty()) {
                    String formattedCommand = ImsNavigationBar.validateNavigationCommand(cmd);
                    if (formattedCommand != null) {
                        FMUIPlugin.getDefault().renewDialogValue(ImsNavigationBar.NAVIGATION_COMBO, formattedCommand);
                    }
                    ImsNavigationBar.this.executeCommand(formattedCommand, cmd);
                }
            }
        });
        this.stepUpButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowup.gif"), (String)Messages.StepUpAction_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PageUp action = new PageUp();
                action.run(ImsNavigationBar.this.editor);
            }
        });
        this.stepDownButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowdown.gif"), (String)Messages.StepDownAction_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PageDown action = new PageDown();
                action.run(ImsNavigationBar.this.editor);
            }
        });
        this.hierarchyButton = GUI.button.push((Composite)composite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/hierarchy.gif"), (String)Messages.ImsNavigationBar_1, (Object)GUI.grid.d.left1());
        this.hierarchyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                new SetKeyPosition().run(ImsNavigationBar.this.editor);
            }
        });
    }

    private boolean executeCommand(String formattedCommand, String enteredValue) {
        if (formattedCommand == null) {
            PDDialogs.openErrorThreadSafe((String)Messages.TopNavigationBar_INVALID_CMD, (String)(MessageFormat.format(Messages.TopNavigationBar_INVALID_CMD_DESC, enteredValue) + "\n\n" + Messages.TopNavigationBar_NAV_CMD_DESC));
            return false;
        }
        new JumpToRecord(formattedCommand).run(this.editor);
        return true;
    }

    private static String validateNavigationCommand(String cmd) {
        int value;
        block9: {
            if (TOP.equals(cmd = cmd.toUpperCase())) {
                return cmd;
            }
            if ("BOTTOM".equals(cmd) || BOTTOM.equals(cmd)) {
                return BOTTOM;
            }
            if (cmd.startsWith(UP)) {
                return ImsNavigationBar.validateLocationWithCommad(UP, cmd);
            }
            if (cmd.startsWith(DOWN)) {
                return ImsNavigationBar.validateLocationWithCommad(DOWN, cmd);
            }
            if (cmd.startsWith(UP_SHORTCUT)) {
                return ImsNavigationBar.validateLocationWithCommad(UP_SHORTCUT, cmd);
            }
            if (cmd.startsWith(DOWN_SHORTCUT)) {
                return ImsNavigationBar.validateLocationWithCommad(DOWN_SHORTCUT, cmd);
            }
            try {
                value = Integer.parseInt(cmd);
                if (value > 0) break block9;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return ImsNavigationBar.validateLocationWithCommad(DOWN_SHORTCUT, "+ " + value);
    }

    private static String validateLocationWithCommad(String commandString, String enteredValue) {
        String location = enteredValue.substring(commandString.length()).trim();
        if (location.isEmpty()) {
            return null;
        }
        try {
            int recno = Integer.parseInt(location);
            if (recno > 0) {
                if (UP_SHORTCUT.equals(commandString)) {
                    return "UP " + recno;
                }
                if (DOWN_SHORTCUT.equals(commandString)) {
                    return "DOWN " + recno;
                }
                return commandString + " " + recno;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createEditTypeComposite(Composite parent) {
        Composite editTypeComposite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false), (Object)GUI.grid.d.left1());
        GUI.label.left((Composite)editTypeComposite, (String)Messages.TopNavigationBar_EDIT_MODE, (Object)GUI.grid.d.left1());
        GridData editTypeData = GUI.grid.d.left1();
        editTypeData.widthHint = 100;
        this.editorModeText = GUI.text.fieldReadOnly((Composite)editTypeComposite, (Object)editTypeData);
        if (!this.editor.isEditSession()) {
            this.editorModeText.setText(BaseEditorOptions.EditType.VIEW.name());
        } else {
            this.editorModeText.setText(this.editor.getSessionProperties().isInplaceEdit() ? BaseEditorOptions.EditType.INPLACE.name() : BaseEditorOptions.EditType.FULL.name());
        }
    }
}

