/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.pdtools.common.component.core.util.GUI;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImsLayoutNavigationBar {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    public static void createBottomNavigationComposite(Composite parent, final ImsEditor editor2) {
        Objects.requireNonNull(parent, "Must provide a non-null parent.");
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)4, (boolean)false), (Object)GUI.grid.d.fillH((int)1));
        GUI.label.left((Composite)composite, (String)Messages.TopNavigationBar_LAYOUT, (Object)GUI.grid.d.left1());
        GridData layoutData = GUI.grid.d.left1();
        layoutData.widthHint = 200;
        final Combo layoutCombo = GUI.combo.readOnly((Composite)composite, (Object)layoutData, (Object[])new String[0]);
        EditType input = editor2.getActiveModel();
        if (input.getAssocitedTemplate() != null) {
            EList layouts = input.getAssocitedTemplate().getLayout();
            int i = 0;
            while (i < layouts.size()) {
                Layouttype l2 = (Layouttype)layouts.get(i);
                layoutCombo.add(((Symboltype)l2.getSymbol().get(0)).getName(editor2.getSystem()));
                layoutCombo.setData("" + i, (Object)l2.getId());
                ++i;
            }
            layoutCombo.setData((Object)layouts);
            layoutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!editor2.updateDirtyContents()) {
                        return;
                    }
                    String layout = layoutCombo.getText();
                    if (editor2.getActiveLayoutID() == Integer.parseInt(layoutCombo.getData("" + layoutCombo.getSelectionIndex()).toString())) {
                        return;
                    }
                    editor2.setActiveLayout(Integer.parseInt(layoutCombo.getData("" + layoutCombo.getSelectionIndex()).toString()), layout);
                }
            });
            if (editor2.getActiveLayoutID() == -1) {
                layoutCombo.select(0);
            } else {
                i = 0;
                while (i < layoutCombo.getItemCount()) {
                    if (Integer.parseInt(layoutCombo.getData("" + i).toString()) == editor2.getActiveLayoutID()) {
                        layoutCombo.select(i);
                    }
                    ++i;
                }
            }
        }
        if (editor2.getTemplateResource() == null) {
            layoutCombo.setEnabled(false);
        }
        GUI.label.left((Composite)composite, (String)Messages.ImsLayoutNavigationBar_0, (Object)GUI.grid.d.left1());
        Text templateTxt = GUI.text.fieldReadOnly((Composite)composite, (Object)GUI.grid.d.fillH((int)1));
        templateTxt.setText(editor2.getTemplateResource().getFormattedName());
    }
}

