/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.core.model.ims.ImsSegmentsInformation;
import com.ibm.etools.fm.editor.formatted.EditorActionManager;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexForImsOperation;
import com.ibm.etools.fm.editor.formatted.operations.ValidateFormattedValuesdOperation;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted1.FormattedEditorContext1;
import com.ibm.etools.fm.editor.formatted1.ImsLayoutNavigationBar;
import com.ibm.etools.fm.editor.formatted1.ImsNavigationBar;
import com.ibm.etools.fm.editor.formatted1.SegmentCharDisplayComposite;
import com.ibm.etools.fm.editor.formatted1.SegmentTableDisplayComposite;
import com.ibm.etools.fm.editor.formatted1.view.ImsEditorView;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.util.TemplateSerializeUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.history.action.OpenAsFormattedEditorActionItem;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.EclipseUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class ImsEditor
extends EditorPart
implements IFMEditor {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ImsEditor.class);
    public static final String ID = "com.ibm.etools.fm.editor.formatted1.ImsEditor";
    public static final String HIERARCHY_ICON = "icons/hierarchy.gif";
    public static final int PROP_NEW_DATA = 2048;
    public static final int PROP_HEX = 2049;
    public static final int PROP_CLOSE_FIND = 2051;
    private FMEditorInputWithTemplate fmiEditorInput = null;
    private boolean isEditorDirty = false;
    private boolean showSuppressedRecords = false;
    private boolean showLengthErrorRecords = true;
    private boolean searchRunning = false;
    private boolean hexOn = false;
    private boolean insertMode = true;
    private boolean disableAllActions = false;
    private ArrayList<DisplayLine> cachedContents = null;
    private EditType currentContents = null;
    private TemplateType template = null;
    private ImsDatabaseInfo databaseInfo = null;
    private Composite stackComposite = null;
    private StackLayout stackLayout = null;
    private SegmentTableDisplayComposite segmentTableComposite = null;
    private SegmentCharDisplayComposite segmentCharComposite = null;
    private EditorActionManager actionManager = null;
    private FormattedEditorContext1 editorContext;
    private boolean needScrolling = false;
    private boolean busyNow = false;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.setSite((IWorkbenchPartSite)site);
        super.setInput(editorInput);
        if (!(editorInput instanceof FMEditorInputWithTemplate)) {
            String errMsg = MessageFormat.format(Messages.FMIFormattedDataEditor_INVALID_INPUT_ERR_MSG, editorInput.getClass().getName());
            logger.error((Object)errMsg);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.fmiEditorInput = (FMEditorInputWithTemplate)editorInput;
        IEditorReference[] existingEditor = this.getSite().getWorkbenchWindow().getActivePage().findEditors(editorInput, this.getSite().getId(), 3);
        if (existingEditor != null && existingEditor.length > 0) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_DUP_INSTANCE, this.fmiEditorInput.getResource().getFormattedName(), this.fmiEditorInput.getTemplateResource() != null ? this.fmiEditorInput.getTemplateResource().getFormattedName() : Messages.NONE));
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        this.initShowAndGroupOptions();
        this.getSessionProperties().dumpEditSessionProperties(this.getResource(), this.getTemplateResource());
        this.actionManager = new EditorActionManager();
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.editor1", (String)"actionsEnabled");
        this.initEditSession();
        this.setPartName(this.fmiEditorInput.getName());
        this.editorContext = new FormattedEditorContext1(this.getSite());
    }

    public void dispose() {
        ImsEditor.saveFMPreferenceStore();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    FMUIPlugin.getDefault().removeDSEditSession(ImsEditor.this.fmiEditorInput.getResource());
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    ImsEditor.this.fmiEditorInput.getSessionIdentifer().removeCacheFile(howIsGoing);
                    ImsEditor.this.fmiEditorInput.getSessionIdentifer().end(howIsGoing);
                }
            });
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FMIFormattedDataEditor_DISPOSE_EX, this.fmiEditorInput.getResource(), this.getTemplateResource() == null ? Messages.NONE : this.getTemplateResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
        }
        ImsEditorView.clearCurrentContents(this);
        OpenAsFormattedEditorActionItem.refreshIconDecorations();
        this.firePropertyChange(2051);
        if (this.getTemplateResource() != null) {
            FormattedPageUtility.clearEncodingErrors(this.getResource());
        }
        this.editorContext.disable();
        super.dispose();
    }

    private static void saveFMPreferenceStore() {
        if (FMUIPlugin.getDefault().getPreferenceStore() instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)FMUIPlugin.getDefault().getPreferenceStore()).save();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void createPartControl(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        ImsNavigationBar navigatorBar = new ImsNavigationBar(this);
        navigatorBar.createControl(composite);
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.stackComposite.setLayoutData((Object)gd);
        this.segmentTableComposite = new SegmentTableDisplayComposite(this);
        this.segmentTableComposite.createSegmentTableComposite(this.stackComposite);
        this.addPropertyListener(this.segmentTableComposite);
        this.segmentCharComposite = new SegmentCharDisplayComposite(this);
        this.segmentCharComposite.createSegmentTableComposite(this.stackComposite);
        this.addPropertyListener(this.segmentCharComposite);
        this.editorContext.enable();
        this.stackLayout.topControl = this.segmentTableComposite.getContents();
        this.stackComposite.layout();
        this.refresh();
        ImsLayoutNavigationBar.createBottomNavigationComposite(composite, this);
    }

    private void initShowAndGroupOptions() {
        this.showSuppressedRecords = FormattedEditorPreferencePage.showSuppressedRecords();
        this.showLengthErrorRecords = FormattedEditorPreferencePage.showLengthErrorRecords();
        this.hexOn = FormattedEditorPreferencePage.useHexMode();
    }

    private void initEditSession() {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    if (ImsEditor.this.fmiEditorInput.getTemplateResource() != null && !ImsEditor.this.loadTemplate(howIsGoing)) {
                        return;
                    }
                    ImsEditor.this.readCachedRecords(howIsGoing);
                }
            });
        }
        catch (InvocationTargetException e) {
            logger.error((Throwable)e);
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    private boolean loadTemplate(IHowIsGoing monitor) {
        try {
            this.fmiEditorInput.getTemplateFile().refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.template = TemplateSerializeUtils.load((IFile)this.fmiEditorInput.getTemplateFile(), (IZRL)this.getResource());
            return true;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditor_LOAD_TEMPL_ERR, this.fmiEditorInput.getTemplateResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
    }

    private boolean readCachedRecords(IHowIsGoing monitor) {
        FileInputStream dataReader = null;
        try {
            this.fmiEditorInput.getFile().refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            dataReader = new FileInputStream(this.fmiEditorInput.getFile().getLocation().toFile());
            this.currentContents = EditorDataSerializeUtils.load((InputStream)dataReader, (IZRL)this.getResource());
            FormattedEditor.prepareErrorFieldsInRecords(this.currentContents);
            this.currentContents.setTemplate(this.template);
            this.cachedContents = null;
            this.setStartPosition();
            this.refresh();
            return true;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setStartPosition() {
        if (this.getActiveModel() == null || this.getActiveModel().getRec() == null) {
            return;
        }
        EList list = this.getActiveModel().getRec();
        int i = 0;
        while (i < list.size()) {
            RecType aRec = (RecType)list.get(i);
            if (aRec.isSetRecno()) {
                logger.debug((Object)("Setting the start record to " + aRec.getRecno()));
                this.fmiEditorInput.getEditSessionProperties().setCurrentStartPosition(aRec.getRecno());
                return;
            }
            ++i;
        }
        this.fmiEditorInput.getEditSessionProperties().setCurrentStartPosition(0);
    }

    @Override
    public FMEditSessionProperties getSessionProperties() {
        return this.fmiEditorInput.getEditSessionProperties();
    }

    @Override
    public IZRL getResource() {
        return this.fmiEditorInput.getResource();
    }

    @Override
    public IZRL getTemplateResource() {
        return this.fmiEditorInput.getTemplateResource();
    }

    @Override
    public TemplateType getCurrentTemplate() {
        return this.template;
    }

    public Layouttype getLayout(RecType aRecord) {
        TemplateType aTemplate = this.getCurrentTemplate();
        if (aTemplate == null) {
            return null;
        }
        if (!aRecord.isSetId()) {
            return null;
        }
        int layoutID = aRecord.getId();
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == layoutID) {
                return aLayout;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isSearchActive() {
        return this.searchRunning;
    }

    @Override
    public void setSearchActive(boolean active) {
        this.searchRunning = active;
    }

    @Override
    public boolean isHexMode() {
        return this.hexOn;
    }

    @Override
    public void setHexMode(boolean newValue) {
        if (newValue != this.isHexMode()) {
            this.hexOn = newValue;
            this.cachedContents = null;
            this.firePropertyChange(2049);
            return;
        }
    }

    @Override
    public boolean isEditSession() {
        return this.fmiEditorInput.isEditSession();
    }

    public boolean isInsertMode() {
        return this.insertMode;
    }

    public void setInsertMode(boolean insertMode) {
        this.insertMode = insertMode;
        ImsEditorView.updateInsertMode(this);
    }

    @Override
    public ArrayList<DisplayLine> getCurrentEditorContents() {
        if (this.cachedContents != null) {
            return this.cachedContents;
        }
        this.cachedContents = new ArrayList();
        if (this.getActiveModel() == null) {
            return this.cachedContents;
        }
        EList recs = this.getActiveModel().getRec();
        int i = 0;
        while (i < recs.size()) {
            RecType aRec = (RecType)recs.get(i);
            DisplayLine dl = FormattedEditor.prepareDisplayLine(aRec, this.fmiEditorInput.getResource(), this.getActiveLayoutID());
            if (dl != null) {
                this.cachedContents.add(dl);
                if (this.isHexMode()) {
                    HexRecordWrapper hexWrapper = new HexRecordWrapper(this.fmiEditorInput.getResource(), dl, true);
                    dl.addHexRecordWrapper(hexWrapper);
                    this.cachedContents.add(hexWrapper);
                    hexWrapper = new HexRecordWrapper(this.fmiEditorInput.getResource(), dl, false);
                    this.cachedContents.add(hexWrapper);
                    dl.addHexRecordWrapper(hexWrapper);
                }
            }
            ++i;
        }
        return this.cachedContents;
    }

    @Override
    public int getActiveLayoutID() {
        if (this.currentContents == null) {
            return -1;
        }
        return this.currentContents.getId();
    }

    @Override
    public String getLayoutName(int layoutID) {
        if (this.template == null) {
            return null;
        }
        EList layouts = this.template.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == layoutID) {
                return ((Symboltype)aLayout.getSymbol().get(0)).getName(this.getSystem());
            }
            ++i;
        }
        return null;
    }

    public void setCurrentSelection(DisplayLine selectedLine) {
        ImsEditorView.displayCurrentRecord(this, selectedLine);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
    }

    public boolean updateFieldValue(DisplayLine dl, int fieldIndex, String newValue, boolean hexUpdate) {
        if (this.getTemplateResource() == null) {
            logger.debug((Object)"Cannot update a field without a template.");
            return false;
        }
        if (dl instanceof ShadowGroup) {
            logger.debug((Object)"Cannot update shadowline!");
            return false;
        }
        FieldType aField = FormattedPageUtility.getField(dl.getRecord(), fieldIndex + 1);
        if (aField == null) {
            logger.debug((Object)"No field to update..");
            return false;
        }
        int index = this.getIndexOf(dl);
        if (index == -1) {
            return false;
        }
        HdrType headers = this.getCurrentTableHeader(dl.getRecord().getId());
        HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(dl.getRecord(), aHeader, this.getCurrentTemplate());
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        int minFieldLen = FormattedPageUtility.getFieldMinLength(this.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        if (maxFieldLen == -1) {
            return false;
        }
        logger.debug((Object)("Current column is at " + fieldIndex + ". start=" + (aHeader.isSetStart() ? aHeader.getStart() : aSymbol.getStart()) + " length=" + (aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen()) + " type=" + aSymbol.getType().getName()));
        if (dl instanceof HexRecordWrapper && hexUpdate) {
            if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValueVC(this.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    FormattedPageUtility.setHexHighOrLowValueVC(this.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            } else {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValue(this.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    if (hexValue.length() < minFieldLen) {
                        hexValue = FormattedEditorUtility.addPaddingForString(hexValue, minFieldLen, '0');
                    }
                    FormattedPageUtility.setHexHighOrLowValue(this.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            }
        } else if (!hexUpdate) {
            String textValue = newValue;
            if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getANValue(this.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, false, this.getResource());
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.getSessionProperties(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, this.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (FormattedPageUtility.performAnVcStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getPliVCValue(this.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, this.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.getSessionProperties(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, this.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String oldTexValue = FormattedPageUtility.getVCValue(this.getSessionProperties(), this.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aSymbol, aField, aHeader, this.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateVCHexValue(this.getSessionProperties(), this.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aField, aHeader, this.getCurrentTemplate(), textValue, aSymbol, this.getResource());
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (!textValue.equals(aField.getValue())) {
                aField.setValue(textValue);
                dl.getRecord().setChg(true);
                dl.getRecord().updateOnHostRequired(true);
                this.setDirty(true);
                aField.setFieldUpdatedLocally(true, false);
            }
        } else {
            logger.error((Object)("Invalid request for field update. LineType: " + dl.getClass().getName() + " fieldIndex=" + fieldIndex + " newValue: " + newValue + " hexUpdate? " + hexUpdate));
            return false;
        }
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            this.segmentTableComposite.justRefreshContents();
        } else {
            this.segmentCharComposite.justRefreshContents();
        }
        return true;
    }

    public int getIndexOf(DisplayLine dl) {
        ArrayList<DisplayLine> list = this.getCurrentEditorContents();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == dl) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public HdrType getCurrentTableHeader(int layoutID) {
        return ImsEditor.getCurrentTableHeader(this.getActiveModel(), layoutID);
    }

    public EditType getActiveModel() {
        return this.currentContents;
    }

    public static HdrType getCurrentTableHeader(EditType editType, int layoutID) {
        if (editType == null) {
            return null;
        }
        EList layouts = editType.getHdr();
        for (HdrType hdrType : layouts) {
            if (hdrType.getId() != layoutID) continue;
            return hdrType;
        }
        return null;
    }

    @Override
    public boolean updateDirtyContents() {
        this.setInsertMode(true);
        int[] selection = this.getSelection();
        boolean selectionChanged = false;
        try {
            if (this.isDirty()) {
                selectionChanged = true;
                String[] errors = null;
                try {
                    errors = this.validateContents();
                }
                catch (InterruptedException e) {
                    PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                    this.disableEditorActions();
                    if (selectionChanged) {
                        this.setSelection(selection);
                    }
                    return false;
                }
                if (errors != null && !PDDialogWithText.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FMPlugin_QUESTION_TITLE, (String)errors[0], (String)errors[1])) {
                    return false;
                }
                boolean bl = this.updateHostEditorChain();
                return bl;
            }
            return true;
        }
        finally {
            if (selectionChanged) {
                this.setSelection(selection);
            }
        }
    }

    public void setActiveLayout(final int layoutID, final String layoutName) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.FMIFormattedDataEditor_CHANGE_LAYOUT, layoutName), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = ImsEditor.this.fmiEditorInput.getSessionIdentifer().requestLayoutChange(layoutID, howIsGoing);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_CHANGE_LAYOUT_ERR, layoutName), (String)result.getMessagesCombined().toString());
                        monitor.done();
                        return;
                    }
                    monitor.worked(1);
                    if (!ImsEditor.this.loadRecordsFromHost(howIsGoing)) {
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException ie) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            return;
        }
        catch (Exception e) {
            String errMsg = Messages.FMIFormattedDataEditor_CHANGE_LAYOUT_EX;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return;
        }
    }

    @Override
    public boolean loadRecordsFromHost(IHowIsGoing monitor) throws InterruptedException {
        boolean bl;
        FileInputStream dataReader = null;
        try {
            Result readResult = new Result((Object)new StringBuffer());
            IFile newFile = this.fmiEditorInput.getSessionIdentifer().readRecords(monitor, readResult, FormattedEditorPreferencePage.getRecordCacheSize());
            if (newFile == null || !readResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)Messages.FormattedEditor_READ_RECORD_ERR, (String)readResult.getMessagesCombined().toString());
                return false;
            }
            newFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.fmiEditorInput.setFile(newFile);
            bl = this.readCachedRecords(monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public String[] validateContents() throws InterruptedException {
        ArrayList<RecType> recsToUpdate = this.getModifiedRecords();
        if (recsToUpdate.size() > 0) {
            ValidateFormattedValuesdOperation.execute(this, recsToUpdate);
            ArrayList<RecType> recordsWithErrors = this.getRecordsWithError();
            if (recordsWithErrors.isEmpty()) {
                return null;
            }
            String errMsg = MessageFormat.format(Messages.FormattedPage_ERR_FIELDS_EXISTS, recordsWithErrors.size());
            return new String[]{errMsg, errMsg};
        }
        return null;
    }

    @Override
    public RecType getTopRecord() {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        if (contents.isEmpty()) {
            return null;
        }
        return contents.get(0).getRecord();
    }

    private ArrayList<RecType> getModifiedRecords() {
        ArrayList<DisplayLine> lines = this.getCurrentEditorContents();
        ArrayList<RecType> recordsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && aLine.getRecord().isUpdateOnHostRequired()) {
                recordsToUpdate.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsToUpdate;
    }

    private ArrayList<RecType> getRecordsWithError() {
        ArrayList<DisplayLine> lines = this.getCurrentEditorContents();
        ArrayList<RecType> recordsWithErrors = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            RecType aRec;
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && (aRec = aLine.getRecord()).isUpdateOnHostRequired() && (aRec.isSetDataError() || aRec.isDataError() || aRec.isSetLenError() || aRec.isLenError())) {
                recordsWithErrors.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsWithErrors;
    }

    public boolean updateHostEditorChain() {
        ArrayList<RecType> modified = this.getModifiedRecords();
        ArrayList<RecType> recsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < modified.size()) {
            recsToUpdate.add(this.createRecToUpdate(modified.get(i)));
            ++i;
        }
        try {
            return UpdateHostEditorChainInHexForImsOperation.execute(this, recsToUpdate, this.getTopRecord());
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            return false;
        }
    }

    public RecType createRecToUpdate(RecType oldRec) {
        RecType recToUpdate = FMNXEDITFactory.eINSTANCE.createRecType();
        recToUpdate.setToken(oldRec.getToken());
        if (oldRec.isSetSeq()) {
            recToUpdate.setSeq(oldRec.getSeq());
        }
        if (oldRec.isSetSeg()) {
            recToUpdate.setSeg(oldRec.getSeg());
        }
        recToUpdate.setHex(oldRec.getHex());
        recToUpdate.setChg(true);
        recToUpdate.setRecno(oldRec.getRecno());
        return recToUpdate;
    }

    public int getSegmentLevel(String segmentName) {
        return this.fmiEditorInput.getSessionIdentifer().getImsSegInfo().getSegmentLevel(segmentName);
    }

    public String getSegmentInfoText(DisplayLine aLine) {
        if (aLine instanceof ShadowGroup) {
            return MessageFormat.format(Messages.SegmentTableDisplayComposite_4, this.getLayoutName(aLine.getRecord().getId()), aLine.getRecord().getSet()) + "\n";
        }
        if (aLine instanceof HexRecordWrapper) {
            HexRecordWrapper hexLine = (HexRecordWrapper)aLine;
            if (hexLine.getDisplayLine() instanceof ShadowGroup) {
                return "\n";
            }
            return "\n";
        }
        return this.getSegmentInfoText(this.getSegmentLevel(aLine.getRecord().getSegname()), aLine.getRecord().getSegname());
    }

    private String getSegmentInfoText(int level, String segmentName) {
        return String.format("%-" + this.calculateLevelInfoWidth() + "s %s\n", SegmentTableDisplayComposite.getLevelForDisplay(level), segmentName);
    }

    private int calculateLevelInfoWidth() {
        int deepestLevel = 1;
        ImsDatabaseInfo dbInfo = this.getDatabaseInformation();
        List segments = dbInfo.getSegments();
        for (ImsSegment aSegment : segments) {
            if (aSegment.getLevel() <= deepestLevel) continue;
            deepestLevel = aSegment.getLevel();
        }
        return deepestLevel + (deepestLevel >= 10 ? deepestLevel - 10 : 0);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.isAllActionsDisabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            return;
        }
        this.attemptToSave();
    }

    private boolean attemptToSave() {
        int[] selection = this.getSelection();
        if (!this.updateDirtyContents()) {
            return false;
        }
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.FormattedEditor_SAVE_OP, ImsEditor.this.getResource().getFormattedName()), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result rsb = ImsEditor.this.getSessionIdentifier().save(howIsGoing);
                    result.copy(rsb);
                    monitor.worked(1);
                    ImsEditor.this.loadRecordsFromHost(howIsGoing);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            String errMsg = MessageFormat.format(Messages.FormattedEditor_SAVE_OP_EX, this.getResource().getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg, (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            PDDialogs.openWarningThreadSafe((String)Messages.FMPlugin_WARNING_TITLE, (String)Messages.EditorAction_CACELLED);
            this.disableEditorActions();
            return false;
        }
        if (result.getRC() > 4) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SAVE_OP_ERR, this.getResource().getFormattedName()), (String)result.getMessagesCombined().toString());
            return false;
        }
        this.setDirty(false);
        this.setSelection(selection);
        this.setFocus();
        return true;
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isEditorDirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isEditorDirty = dirty;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ImsEditor.this.firePropertyChange(257);
            }
        });
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void disableEditorActions() {
        this.disableAllActions = true;
        EclipseUtils.retestEclipseProperty((String)"com.ibm.etools.fm.ui.editor1", (String)"actionsEnabled");
        if (PDPlatformUIUtils.view.showView((String)"com.ibm.etools.fm.editor.formatted1.view.ImsEditorView") == null) {
            logger.error((Object)"Error occurred while enforcing to disable the editor actions.");
        }
        this.setCursor(NavigationSpecification.TOP);
    }

    @Override
    public boolean isAllActionsDisabled() {
        return this.disableAllActions;
    }

    public void setFocus() {
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            this.segmentTableComposite.setCursor(NavigationSpecification.JUST_FOCUS);
        } else {
            this.segmentCharComposite.setCursor(NavigationSpecification.JUST_FOCUS);
        }
    }

    @Override
    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ImsEditor.this.firePropertyChange(2048);
            }
        });
    }

    @Override
    public AbstractSessionFormatted getSessionIdentifier() {
        return this.fmiEditorInput.getSessionIdentifer();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean loadRecordsFromHostSetLocationFirst(IHowIsGoing monitor, RecType topRecord) throws InterruptedException {
        FileInputStream dataReader = null;
        try {
            Result cursorResult = this.fmiEditorInput.getSessionIdentifer().setCursorPosition(monitor, topRecord, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            if (!cursorResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_SET_CURSOR_ERR, topRecord.getRecno(), topRecord.getSeq(), topRecord.getToken()), (String)cursorResult.getMessagesCombined().toString());
                return false;
            }
            Result readResult = new Result((Object)new StringBuffer());
            IFile newFile = this.fmiEditorInput.getSessionIdentifer().readRecords(monitor, readResult, FormattedEditorPreferencePage.getRecordCacheSize());
            if (newFile == null || !readResult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)Messages.FormattedEditor_READ_RECORD_ERR, (String)readResult.getMessagesCombined().toString());
                return false;
            }
            newFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.fmiEditorInput.setFile(newFile);
            boolean bl = this.readCachedRecords(monitor);
            return bl;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_LOAD_DATA, this.fmiEditorInput.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        finally {
            if (dataReader != null) {
                try {
                    dataReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int[] getSelection() {
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            return this.segmentTableComposite.getSelection();
        }
        return this.segmentCharComposite.getSelection();
    }

    @Override
    public void setSelection(int[] selection) {
        if (this.getCurrentEditorContents().isEmpty()) {
            return;
        }
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            this.segmentTableComposite.setSelection(selection);
        } else {
            this.segmentCharComposite.setSelection(selection);
        }
    }

    @Override
    public RecType getLastVisibleRecord() {
        ArrayList<DisplayLine> contents = this.getCurrentEditorContents();
        if (contents.isEmpty()) {
            return null;
        }
        return contents.get(contents.size() - 1).getRecord();
    }

    public ImsEditorOptions getImsEditorOptions() {
        return this.fmiEditorInput.getSessionIdentifer().getImsEditOptions();
    }

    public ImsSegmentsInformation getImsSegmentInformation() {
        return this.fmiEditorInput.getSessionIdentifer().getImsSegInfo();
    }

    public ImsDatabaseInfo getDatabaseInformation() {
        if (this.databaseInfo != null) {
            return this.databaseInfo;
        }
        final Result infoResult = new Result();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(MessageFormat.format(Messages.ImsEditor_0, ImsEditor.this.getResource().getFormattedName()), 1);
                            infoResult.addSubResultWithOutput(ImsEditor.this.getImsEditorOptions().getDatabase().loadInfo(PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor), "", ImsEditor.this.getImsEditorOptions().getRegionType()));
                            monitor.worked(1);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    String errMsg = MessageFormat.format(Messages.ImsEditor_1, ImsEditor.this.getResource().getFormattedName());
                    logger.error((Object)errMsg, (Throwable)e);
                    PDDialogs.openErrorThreadSafe((String)errMsg);
                    infoResult.setRC(8);
                    infoResult.add(errMsg);
                }
                catch (InterruptedException e) {
                    infoResult.setRC(8);
                }
            }
        });
        if (infoResult.isSuccessfulWithoutWarnings()) {
            this.databaseInfo = (ImsDatabaseInfo)infoResult.getOutput();
            return this.databaseInfo;
        }
        return null;
    }

    public ImsSegment getSegmentInformation(String segmentName) {
        ImsDatabaseInfo dbInfo = this.getDatabaseInformation();
        List segments = dbInfo.getSegments();
        for (ImsSegment aSegment : segments) {
            if (!aSegment.getName().equals(segmentName)) continue;
            return aSegment;
        }
        return null;
    }

    public EditorActionManager getActionManager() {
        return this.actionManager;
    }

    @Override
    public void setCursor(NavigationSpecification navSpec) {
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            this.segmentTableComposite.setCursor(navSpec);
        } else {
            this.segmentCharComposite.setCursor(navSpec);
        }
    }

    @Override
    public int getCursorIndexOnSelectedLine() {
        return 0;
    }

    @Override
    public void setShowNotSelectedRecords(boolean newValue) {
    }

    @Override
    public boolean isShowNotSelectedRecords() {
        return false;
    }

    @Override
    public void setShowSuppressedRecords(boolean newValue) {
        if (this.showSuppressedRecords != newValue) {
            this.showSuppressedRecords = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isShowSuppressedRecords() {
        return this.showSuppressedRecords;
    }

    @Override
    public void setShowLengthErrorRecords(boolean newValue) {
        if (this.showLengthErrorRecords != newValue) {
            this.showLengthErrorRecords = newValue;
            this.cachedContents = null;
        }
    }

    @Override
    public boolean isShowLengthErrorRecords() {
        return this.showLengthErrorRecords;
    }

    @Override
    public void setDisplayShdowLinesForEx(boolean newValue) {
    }

    @Override
    public boolean isDisplayShadowLinesForEx() {
        return false;
    }

    @Override
    public void setDisplayShdowLinesForNot(boolean newValue) {
    }

    @Override
    public boolean isDisplayShadowLinesForNot() {
        return false;
    }

    @Override
    public void setDisplayShdowLinesForSup(boolean newValue) {
    }

    @Override
    public boolean isDisplayShadowLinesForSup() {
        return false;
    }

    @Override
    public void updateLocationInformation(int caretPosition) {
    }

    @Override
    public ArrayList<RecType> getSelectedNonShadowLines() {
        if (this.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
            return this.segmentTableComposite.getSelectedNonShadowLines();
        }
        return this.segmentCharComposite.getSelectedNonShadowLines();
    }

    @Override
    public Shell getEditorShell() {
        return this.getEditorSite().getShell();
    }

    public boolean isNeedScrolling() {
        return this.needScrolling;
    }

    public void setNeedScrolling(boolean needScrolling) {
        this.needScrolling = needScrolling;
    }

    @Override
    public IFMEditor.EditorMode getCurrentEditorMode() {
        if (this.stackLayout.topControl == this.segmentTableComposite.getContents()) {
            return IFMEditor.EditorMode.FORMATTED;
        }
        return IFMEditor.EditorMode.CHARACTER;
    }

    @Override
    public void switchEditorMode(IFMEditor.EditorMode mode) {
        if (IFMEditor.EditorMode.FORMATTED == mode) {
            this.segmentTableComposite.setTableContents();
            this.stackLayout.topControl = this.segmentTableComposite.getContents();
        } else {
            this.segmentCharComposite.setTextContents();
            this.stackLayout.topControl = this.segmentCharComposite.getContents();
        }
        this.stackComposite.layout();
    }

    @Override
    public IPDHost getSystem() {
        return this.fmiEditorInput != null ? this.fmiEditorInput.getSystem() : null;
    }

    @Override
    public boolean isBusyNow() {
        return this.busyNow;
    }

    @Override
    public void setBusyNow(boolean busyNow) {
        this.busyNow = busyNow;
    }

    @Override
    public void setFindActive(boolean active) {
    }

    @Override
    public boolean isFindModeActive() {
        return false;
    }

    public SegmentTableDisplayComposite getSegmentTableComposite() {
        return this.segmentTableComposite;
    }

    public SegmentCharDisplayComposite getSegmentCharComposite() {
        return this.segmentCharComposite;
    }
}

