/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted1;

import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorPropertyTester1
extends PropertyTester {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(EditorPropertyTester1.class);
    public static final String NAMESPACE = "com.ibm.etools.fm.ui.editor1";
    public static final String PROPERTY_IS_EDIT_MODE = "isEditMode";
    public static final String PROPERTY_IS_TEMPLATE_BEING_USED = "isTemplateBeingUsed";
    public static final String PROPERTY_ACTIONS_ENABLED = "actionsEnabled";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean status = false;
        if (PROPERTY_IS_EDIT_MODE.equals(property)) {
            status = EditorPropertyTester1.isEditSession();
        } else if (PROPERTY_IS_TEMPLATE_BEING_USED.equals(property)) {
            status = EditorPropertyTester1.isTemplateBeingUsed();
        } else if (PROPERTY_ACTIONS_ENABLED.equals(property)) {
            status = EditorPropertyTester1.isAllActionsEnabled();
        } else {
            logger.trace((Object)("Can't test for property=" + property));
        }
        return status;
    }

    private static boolean isAllActionsEnabled() {
        ImsEditor editor2 = EditorPropertyTester1.getEditor();
        boolean status = false;
        if (editor2 != null) {
            status = !editor2.isAllActionsDisabled();
        }
        return status;
    }

    private static boolean isTemplateBeingUsed() {
        ImsEditor editor2 = EditorPropertyTester1.getEditor();
        boolean status = false;
        if (editor2 != null) {
            status = editor2.getTemplateResource() != null;
        }
        return status;
    }

    private static boolean isEditSession() {
        ImsEditor editor2 = EditorPropertyTester1.getEditor();
        boolean status = false;
        if (editor2 != null) {
            status = editor2.isEditSession();
        }
        return status;
    }

    private static ImsEditor getEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow activeWindow;
        ImsEditor editor2 = null;
        IEditorPart editorPart = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWindow = workbench.getActiveWorkbenchWindow()) != null && (page = activeWindow.getActivePage()) != null && (editorPart = page.getActiveEditor()) instanceof ImsEditor) {
            editor2 = (ImsEditor)editorPart;
        }
        return editor2;
    }
}

