/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.single;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPropertyListener;

public class UnstructuredDisplay
extends SingleDisplay
implements IPropertyListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(UnstructuredDisplay.class);
    private Text textArea;
    private String textAreaText = "";

    public UnstructuredDisplay(SingleView view2) {
        super(view2);
    }

    public Composite createUnstructuredDisplayComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)new FillLayout(), (Object)GUI.grid.d.fillAll());
        this.createTextArea(composite);
        return composite;
    }

    private Text createTextArea(Composite parent) {
        final ControlEditor cellEditor = new ControlEditor(parent);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.textArea = new Text(parent, 2626);
        this.textArea.setText(this.textAreaText);
        this.textArea.setFont(JFaceResources.getTextFont());
        this.textArea.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
                cellEditor.setEditor((Control)UnstructuredDisplay.this.textArea);
                UnstructuredDisplay.this.textArea.setFocus();
            }
        });
        this.textArea.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
                cellEditor.setEditor((Control)UnstructuredDisplay.this.textArea);
                UnstructuredDisplay.this.textArea.setFocus();
            }

            public void mouseDoubleClick(MouseEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
                cellEditor.setEditor((Control)UnstructuredDisplay.this.textArea);
                UnstructuredDisplay.this.textArea.setFocus();
            }
        });
        this.textArea.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
            }
        });
        this.textArea.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                UnstructuredDisplay.this.setCursor(UnstructuredDisplay.this.textArea.getCaretPosition());
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    UnstructuredDisplay.this.updateRecordValue(UnstructuredDisplay.this.textArea.getText());
                    e.doit = false;
                }
            }
        });
        return this.textArea;
    }

    @Override
    public void displayCurrentLine(FormattedEditor editor2, DisplayLine curLine) {
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.clearViewContents();
        } else {
            this.currentEditor = editor2;
            this.currentLine = curLine;
            this.textAreaText = this.prepareTextArea();
            this.textArea.setText(PDBiDiHelpers.translateIfBidiRequired((IZRL)this.currentEditor.getResource(), (String)this.textAreaText, (boolean)true));
            this.textArea.setEditable(editor2.isEditSession());
        }
    }

    protected String prepareTextArea() {
        if (this.currentLine == null || this.currentEditor == null) {
            this.textArea.setEnabled(false);
            return new String();
        }
        if (this.currentLine instanceof ShadowGroup) {
            this.textArea.setEnabled(false);
            return new String();
        }
        this.textArea.setEnabled(true);
        try {
            String tmpStr = new String(DataConversionUtils.getEBCDICData((String)this.currentLine.getRecord().getHex()), this.currentEditor.getResource().getPersistentProperty("encoding"));
            String tmpStr1 = tmpStr.replaceAll("\\p{C}", ".");
            this.textArea.setEnabled(tmpStr1.equals(tmpStr));
            return tmpStr1;
        }
        catch (UnsupportedEncodingException e) {
            this.textArea.setEnabled(false);
            String errMsg = MessageFormat.format(Messages.CharModePage_CONV_ERR, this.currentLine.getRecord().getRecno());
            logger.error((Object)errMsg, (Throwable)e);
            return errMsg;
        }
    }

    private void setCursor(int caretPos) {
        this.singleView.updateCursorPosition(Integer.toString(caretPos + 1));
    }

    private void updateRecordValue(String text2) {
        try {
            byte[] textBytes = text2.getBytes(this.currentEditor.getResource().getPersistentProperty("encoding"));
            String hexString = DataConversionUtils.getHexString((byte[])textBytes);
            this.currentEditor.updateHexValue(this.currentLine, hexString);
            this.currentEditor.updateDirtyContents();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    public void clearViewContents() {
        this.currentEditor = null;
        this.currentLine = null;
        if (this.textArea != null) {
            this.textArea.setText(this.prepareTextArea());
        }
    }

    public void propertyChanged(Object source, int propId) {
    }
}

