/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.single;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLineUtility;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.charmode.CharModePage;
import com.ibm.etools.fm.editor.formatted.pages.single.Db2SingleDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.DumpDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.StructureDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.UnstructuredDisplay;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class SingleView
extends ViewPart {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String ID = "com.ibm.etools.fm.editor.formatted.pages.single.SingleView";
    private static final PDLogger logger = PDLogger.get(SingleView.class);
    private static final int SINGLE_MODE_INDEX = 0;
    private static final int DUMP_MODE_INDEX = 1;
    private static final int DB2_MODE_INDEX = 2;
    private static final String[] VIEW_MODES = new String[]{Messages.SingleView_FORMATTED, Messages.SingleView_DUMP, Messages.SingleView_DB2_SINGLE, Messages.SingleView_STRUCTURED, Messages.SingleView_UNSTRUCTURED};
    private Text layoutNameText = null;
    private Button stepUpButton = null;
    private Button stepDownButton = null;
    private Text currentLocationText = null;
    private Text totalText = null;
    private Text cursorText = null;
    private Combo viewModeCombo = null;
    private Text insertModeText = null;
    private FormattedEditor currentEditor = null;
    private DisplayLine currentLine = null;
    private String viewDefaultName = null;
    private SingleDisplay singleDisplay = null;
    private DumpDisplay dumpDisplay = null;
    private Db2SingleDisplay db2SingleDisplay = null;
    private StructureDisplay structureDisplay = null;
    private UnstructuredDisplay unstructuredDisplay = null;
    private Composite stackComposite = null;
    private StackLayout stackLayout = null;
    private Composite singleDisplayComposite = null;
    private Composite dumpDisplayComposite = null;
    private Composite db2SingleDisplayComposite = null;
    private Composite structureDisplayComposite = null;
    private Composite unstructuredDisplayComposite = null;
    private static final Map<IWorkbenchWindow, SingleView> initCompleteInstances = Collections.synchronizedMap(new HashMap());

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        initCompleteInstances.put(site.getWorkbenchWindow(), this);
        this.viewDefaultName = site.getRegisteredName();
    }

    public void dispose() {
        initCompleteInstances.remove(this.getSite().getWorkbenchWindow());
        initCompleteInstances.put(this.getSite().getWorkbenchWindow(), null);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.createLayoutNameComposite(composite);
        this.stackComposite = new Composite(composite, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.stackComposite.setLayoutData((Object)gd);
        this.singleDisplay = new SingleDisplay(this);
        this.db2SingleDisplay = new Db2SingleDisplay(this);
        this.dumpDisplay = new DumpDisplay(this);
        this.structureDisplay = new StructureDisplay(this);
        this.unstructuredDisplay = new UnstructuredDisplay(this);
        this.singleDisplayComposite = this.singleDisplay.createSingleDisplayComposite(this.stackComposite);
        this.dumpDisplayComposite = this.dumpDisplay.createDumpDisplayComposite(this.stackComposite);
        this.db2SingleDisplayComposite = this.db2SingleDisplay.createDb2SingleDisplayComposite(this.stackComposite);
        this.structureDisplayComposite = this.structureDisplay.createSingleDisplayComposite(this.stackComposite);
        this.unstructuredDisplayComposite = this.unstructuredDisplay.createUnstructuredDisplayComposite(this.stackComposite);
        this.stackLayout.topControl = this.singleDisplayComposite;
        this.createBottomComposite(composite);
    }

    private void createLayoutNameComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)5, (boolean)false), (Object)GUI.grid.d.fillH((int)1, (int)400));
        Composite layoutComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)layoutComposite, (String)Messages.SingleView_LAYOUT, (Object)GUI.grid.d.left1());
        this.layoutNameText = GUI.text.fieldReadOnly((Composite)layoutComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        Composite buttonComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.left1());
        this.stepUpButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowup.gif"), (String)Messages.SingleView_UP_REC_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DisplayLine prevLine = SingleView.this.currentEditor.getPreviousLine(true);
                if (prevLine != null) {
                    SingleView.this.displayCurrentLine(SingleView.this.currentEditor, prevLine);
                }
            }
        });
        this.stepUpButton.setEnabled(false);
        this.stepDownButton = GUI.button.push((Composite)buttonComposite, (Image)FMUIPlugin.getDefault().getImageRegistry().get("icons/windowdown.gif"), (String)Messages.SingleView_DOWN_REC_TOOLTIP, (Object)GUI.grid.d.left1());
        this.stepDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DisplayLine nextLine = SingleView.this.currentEditor.getNextLine(true);
                if (nextLine != null) {
                    SingleView.this.displayCurrentLine(SingleView.this.currentEditor, nextLine);
                }
            }
        });
        this.stepDownButton.setEnabled(false);
        Composite currentComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)currentComposite, (String)Messages.SingleView_CURR_LOC, (Object)GUI.grid.d.left1());
        this.currentLocationText = GUI.text.fieldReadOnly((Composite)currentComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        Composite totalComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)totalComposite, (String)Messages.SingleView_TOTAL, (Object)GUI.grid.d.left1());
        this.totalText = GUI.text.fieldReadOnly((Composite)totalComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        Composite cursorComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)100));
        GUI.label.left((Composite)cursorComposite, (String)Messages.SingleView_0, (Object)GUI.grid.d.left1());
        this.cursorText = GUI.text.fieldReadOnly((Composite)cursorComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
    }

    private void createBottomComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.noMargins((int)4, (boolean)true), (Object)GUI.grid.d.fillH((int)1, (int)350));
        Composite modeComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)200));
        GUI.label.left((Composite)modeComposite, (String)Messages.SingleView_View_MODE, (Object)GUI.grid.d.left1());
        this.viewModeCombo = GUI.combo.readOnly((Composite)modeComposite, (Object)GUI.grid.d.fillH((int)1, (int)50), (Object[])VIEW_MODES);
        this.viewModeCombo.select(0);
        this.viewModeCombo.setEnabled(false);
        this.viewModeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SingleView.this.setViewMode();
            }
        });
        Composite insertModeComposite = GUI.composite((Composite)composite, (Layout)GUI.grid.l.noMargins((int)2, (boolean)false, (int)0), (Object)GUI.grid.d.fillH((int)1, (int)200));
        GUI.label.left((Composite)insertModeComposite, (String)Messages.SingleView_InsertMode, (Object)GUI.grid.d.left1());
        this.insertModeText = GUI.text.fieldReadOnly((Composite)insertModeComposite, (Object)GUI.grid.d.fillH((int)1, (int)50));
        this.setInsertModeText();
    }

    private void setViewMode() {
        switch (this.viewModeCombo.getSelectionIndex()) {
            case 0: {
                this.stackLayout.topControl = this.singleDisplayComposite;
                break;
            }
            case 1: {
                this.stackLayout.topControl = this.dumpDisplayComposite;
                break;
            }
            case 2: {
                this.stackLayout.topControl = this.db2SingleDisplayComposite;
                break;
            }
            case 3: {
                this.stackLayout.topControl = this.structureDisplayComposite;
                break;
            }
            case 4: {
                this.stackLayout.topControl = this.unstructuredDisplayComposite;
                break;
            }
        }
        this.stackComposite.layout();
    }

    private void setInsertModeText() {
        if (this.currentEditor == null) {
            this.insertModeText.setText("");
        } else if (this.currentEditor.isInsertMode()) {
            this.insertModeText.setText(Messages.FormattedEditorActionBarContributor_INSERT);
        } else {
            this.insertModeText.setText(Messages.FormattedEditorActionBarContributor_OVERWRITE);
        }
    }

    public static void displayCurrentRecord(FormattedEditor editor2, DisplayLine curLine) {
        Objects.requireNonNull(editor2, "Must provide a non-null editor.");
        SingleView singleView = initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
        if (SingleView.hasThisSingleViewBeenOpened(editor2) && singleView == null) {
            return;
        }
        if (singleView == null && (singleView = (SingleView)PDPlatformUIUtils.view.showView((String)ID, SingleView.class)) == null) {
            String errMsg = MessageFormat.format(Messages.SingleView_NO_VIEW_FOUND, singleView == null ? "null" : ((Object)((Object)singleView)).getClass().getName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return;
        }
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            if (singleView.viewModeCombo.getSelectionIndex() != 2) {
                singleView.viewModeCombo.select(2);
                singleView.setViewMode();
            }
        } else if (singleView.viewModeCombo.getSelectionIndex() == 2) {
            singleView.viewModeCombo.select(editor2.getTemplateResource() != null ? 0 : 1);
            singleView.setViewMode();
        }
        if (editor2.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER) {
            CharModePage page = (CharModePage)editor2.getCurrentPage();
            if (page != null) {
                if (page.isTextDirty()) {
                    singleView.displayCurrentLine(editor2, null);
                } else {
                    singleView.displayCurrentLine(editor2, curLine);
                }
            }
        } else {
            singleView.displayCurrentLine(editor2, curLine);
        }
    }

    public static void updateInsertMode(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor");
        SingleView singleView = initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
        if (SingleView.hasThisSingleViewBeenOpened(editor2) && singleView == null) {
            return;
        }
        if (singleView == null && (singleView = (SingleView)PDPlatformUIUtils.view.showView((String)ID, SingleView.class)) == null) {
            String errMsg = MessageFormat.format(Messages.SingleView_NO_VIEW_FOUND, singleView == null ? "null" : ((Object)((Object)singleView)).getClass().getName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return;
        }
        singleView.updateInsertModeText(editor2);
    }

    private void updateInsertModeText(FormattedEditor editor2) {
        if (this.currentEditor != editor2) {
            return;
        }
        this.setInsertModeText();
    }

    private void displayCurrentLine(FormattedEditor editor2, DisplayLine curLine) throws NullPointerException {
        this.currentEditor = Objects.requireNonNull(editor2);
        this.currentLine = curLine;
        if (this.currentLine == null || this.currentEditor == null) {
            this.layoutNameText.setText("");
        } else if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.layoutNameText.setText(editor2.getSessionIdentifier().getDb2EditOptions().getTable().getFormattedName());
        } else if (this.currentLine instanceof ShadowGroup) {
            this.layoutNameText.setText(DisplayLineUtility.formatForDisplay(this.currentLine, -1));
        } else if (this.currentEditor.getTemplateResource() == null) {
            this.layoutNameText.setText(Messages.SingleView_NO_TEMPL);
        } else {
            try {
                this.layoutNameText.setText(this.currentEditor.getLayoutName(this.currentEditor.getLayout(this.currentLine.getRecord()).getId()));
            }
            catch (Exception e) {
                this.layoutNameText.setText(((Symboltype)this.currentEditor.getActiveLayout().getSymbol().get(0)).getName(this.currentEditor.getSystem()));
            }
        }
        this.cursorText.setText("");
        this.setInsertModeText();
        if (this.currentEditor.getTemplateResource() == null) {
            this.viewModeCombo.setEnabled(true);
        } else {
            this.viewModeCombo.setEnabled(true);
        }
        SingleView.getSingleViewFromThisWindow(editor2).setPartName(this.currentEditor.getResource().getFormattedName());
        if (curLine != null) {
            this.currentLocationText.setText(DisplayLineUtility.formatForDisplay(curLine, -1));
            if (this.currentEditor.getSessionProperties().getNumRecords() > 0) {
                this.totalText.setText("" + this.currentEditor.getSessionProperties().getNumRecords());
            } else {
                this.totalText.setText(Messages.SingleView_UNKNOWN);
            }
            this.singleDisplay.displayCurrentLine(editor2, curLine);
            this.dumpDisplay.displayCurrentLine(editor2, curLine);
            this.db2SingleDisplay.displayCurrentLine(editor2, curLine);
            this.structureDisplay.displayCurrentLine(editor2, curLine);
            this.unstructuredDisplay.displayCurrentLine(editor2, curLine);
            this.stepUpButton.setEnabled(true);
            this.stepDownButton.setEnabled(true);
        } else {
            this.currentLocationText.setText("");
            this.totalText.setText("");
            this.singleDisplay.clearViewContents();
            this.dumpDisplay.clearViewContents();
            this.db2SingleDisplay.clearViewContents();
            this.structureDisplay.clearViewContents();
            this.unstructuredDisplay.clearViewContents();
            this.stepUpButton.setEnabled(false);
            this.stepDownButton.setEnabled(false);
        }
    }

    public static void displayCurrentColumn(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor");
        SingleView singleView = initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
        if (SingleView.hasThisSingleViewBeenOpened(editor2) && singleView == null) {
            return;
        }
        if (singleView == null && (singleView = (SingleView)PDPlatformUIUtils.view.showView((String)ID, SingleView.class)) == null) {
            String errMsg = MessageFormat.format(Messages.SingleView_NO_VIEW_FOUND, singleView == null ? "null" : ((Object)((Object)singleView)).getClass().getName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return;
        }
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            singleView.db2SingleDisplay.displayCurrentColumn(editor2);
        } else {
            singleView.singleDisplay.displayCurrentColumn(editor2);
        }
    }

    public void updateCursorPosition(String position) {
        if (position == null || position.trim().isEmpty()) {
            this.cursorText.setText("");
        } else {
            this.cursorText.setText(position);
        }
    }

    public static void clearCurrentContents(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must provide a non-null " + String.valueOf(FormattedEditor.class));
        SingleView singleView = SingleView.getSingleViewFromThisWindow(editor2);
        if (singleView == null) {
            return;
        }
        singleView.clearViewContents(editor2);
    }

    private void clearViewContents(FormattedEditor editor2) {
        if (editor2 != this.currentEditor) {
            return;
        }
        this.currentEditor = null;
        this.currentLine = null;
        SingleView.getSingleViewFromThisWindow(editor2).setPartName(this.viewDefaultName);
        this.stepUpButton.setEnabled(false);
        this.stepDownButton.setEnabled(false);
        this.layoutNameText.setText("");
        this.currentLocationText.setText("");
        this.totalText.setText("");
        this.cursorText.setText("");
        this.singleDisplay.clearViewContents();
        this.dumpDisplay.clearViewContents();
        this.db2SingleDisplay.clearViewContents();
        this.structureDisplay.clearViewContents();
        this.unstructuredDisplay.clearViewContents();
        this.insertModeText.setText("");
        this.viewModeCombo.setEnabled(false);
    }

    public void setFocus() {
        CharModePage page;
        if (this.currentEditor == null) {
            return;
        }
        if (this.currentEditor.getCurrentEditorMode() == IFMEditor.EditorMode.CHARACTER && (page = (CharModePage)this.currentEditor.getCurrentPage()) != null && page.isTextDirty()) {
            this.currentEditor.updateDirtyContents();
        }
    }

    private static SingleView getSingleViewFromThisWindow(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        return initCompleteInstances.get(editor2.getSite().getWorkbenchWindow());
    }

    private static boolean hasThisSingleViewBeenOpened(FormattedEditor editor2) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        return initCompleteInstances.containsKey(editor2.getSite().getWorkbenchWindow());
    }
}

