/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.single;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DumpDisplay {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(DumpDisplay.class);
    private static final int BYTES_PER_LINE = 16;
    private String hostConCp = null;
    private FormattedEditor currentEditor = null;
    private DisplayLine currentLine = null;
    private SingleView singleView = null;
    private TableViewer hexValueTableViewer = null;
    private Table hexValueTable = null;
    private TableCursor hexValueTableCursor = null;
    private TableViewer textValueTableViewer = null;
    private Table textValueTable = null;
    private TableCursor textValueTableCursor = null;

    public DumpDisplay(SingleView view2) {
        this.singleView = view2;
    }

    public Composite createDumpDisplayComposite(Composite parent) {
        SashForm composite = new SashForm(parent, 256);
        composite.setLayout((Layout)new FillLayout());
        this.createHexValueTable((Composite)composite);
        this.createTextValueTable((Composite)composite);
        return composite;
    }

    private void createHexValueTable(Composite parent) {
        this.hexValueTable = new Table(parent, 68354);
        this.hexValueTable.setHeaderVisible(true);
        this.hexValueTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.hexValueTable.setLayoutData((Object)gd);
        this.hexValueTableViewer = new TableViewer(this.hexValueTable);
        Font font = JFaceResources.getTextFont();
        this.hexValueTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.hexValueTableViewer.getTable());
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        int charWidth = metrics.getAverageCharWidth();
        DumpDisplay.createHexValueTableColumns(this.hexValueTableViewer, charWidth);
        this.hexValueTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hexValueTableViewer.setInput(this.prepareContents());
        this.hexValueTableCursor = new TableCursor(this.hexValueTable, 0);
        this.hexValueTableCursor.setFont(JFaceResources.getDefaultFont());
        final ControlEditor cellEditor = new ControlEditor((Composite)this.hexValueTableCursor);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.hexValueTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem row = DumpDisplay.this.hexValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.hexValueTable.indexOf(row);
                int columnIndex = DumpDisplay.this.hexValueTableCursor.getColumn();
                DumpDisplay.this.hexValueTable.setSelection(rowIndex);
                DumpDisplay.this.textValueTable.setSelection(rowIndex);
                if (columnIndex > 0) {
                    DumpDisplay.this.textValueTableCursor.setSelection(rowIndex, columnIndex - 1);
                } else {
                    DumpDisplay.this.textValueTableCursor.setSelection(rowIndex, 0);
                }
                int pos = rowIndex * 16 + columnIndex;
                DumpDisplay.this.singleView.updateCursorPosition("" + pos);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = DumpDisplay.this.hexValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.hexValueTable.indexOf(row);
                int columnIndex = DumpDisplay.this.hexValueTableCursor.getColumn();
                DumpDisplay.this.hexValueTable.setSelection(rowIndex);
                Text text2 = DumpDisplay.this.createHexTextForEdit(rowIndex, columnIndex);
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.hexValueTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    TableItem row = DumpDisplay.this.hexValueTableCursor.getRow();
                    int rowIndex = DumpDisplay.this.hexValueTable.indexOf(row);
                    int columnIndex = DumpDisplay.this.hexValueTableCursor.getColumn();
                    DumpDisplay.this.hexValueTable.setSelection(rowIndex);
                    Text text2 = DumpDisplay.this.createHexTextForEdit(rowIndex, columnIndex);
                    if (text2 != null) {
                        cellEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                } else {
                    DumpDisplay.this.hexValueTableCursor.setVisible(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                TableItem row = DumpDisplay.this.hexValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.hexValueTable.indexOf(row);
                int columnIndex = DumpDisplay.this.hexValueTableCursor.getColumn();
                DumpDisplay.this.hexValueTable.setSelection(rowIndex);
                Text text2 = DumpDisplay.this.createHexTextForEdit(rowIndex, columnIndex);
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
    }

    private Text createHexTextForEdit(int row, int column) {
        if (this.currentLine == null || this.currentEditor == null) {
            return null;
        }
        if (this.currentLine instanceof ShadowGroup) {
            return null;
        }
        if (!this.currentEditor.isEditSession()) {
            return null;
        }
        if (this.hexValueTableCursor.getColumn() == 0) {
            return null;
        }
        if (!this.isValidSelection(row, column)) {
            return null;
        }
        final Text text2 = new Text((Composite)this.hexValueTableCursor, 0);
        text2.setFont(JFaceResources.getDefaultFont());
        text2.setFocus();
        text2.setTextLimit(2);
        text2.setText(this.hexValueTableCursor.getRow().getText(this.hexValueTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        Object newValue = text2.getText();
                        if (((String)newValue).isEmpty()) {
                            newValue = "00";
                        } else if (((String)newValue).length() == 1) {
                            newValue = "0" + (String)newValue;
                        }
                        DumpDisplay.this.hexValueTableCursor.getRow().setText(DumpDisplay.this.hexValueTableCursor.getColumn(), (String)newValue);
                        int row1 = DumpDisplay.this.hexValueTable.getSelectionIndex();
                        int column1 = DumpDisplay.this.hexValueTableCursor.getColumn();
                        if (DumpDisplay.this.isValidSelection(row1, column1)) {
                            DumpDisplay.this.updateRecord((String)newValue, DumpDisplay.this.hexValueTable.getSelectionIndex(), DumpDisplay.this.hexValueTableCursor.getColumn() - 1);
                            DumpDisplay.this.hexValueTableCursor.setSelection(row1, column1);
                            DumpDisplay.this.hexValueTable.setSelection(row1);
                            DumpDisplay.this.textValueTable.setSelection(row1);
                        }
                        text2.dispose();
                        break;
                    }
                    case 0x1000009: {
                        DumpDisplay.this.currentEditor.setInsertMode(!DumpDisplay.this.currentEditor.isInsertMode());
                        break;
                    }
                    case 27: {
                        text2.dispose();
                        break;
                    }
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (!Character.isISOControl(ve.character)) {
                    if (!DumpDisplay.this.currentEditor.isInsertMode()) {
                        if (text2.getSelectionCount() == 0) {
                            String value = "" + ve.character;
                            if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(value).matches()) {
                                int pos = text2.getCaretPosition();
                                text2.setSelection(pos, pos + 1);
                                ve.doit = true;
                            } else {
                                ve.doit = false;
                            }
                        }
                    } else {
                        FormattedPageUtility.hexEntryTextValue(ve);
                    }
                } else if (ve.keyCode == 0) {
                    if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(ve.text).matches()) {
                        ve.text = ve.text.toUpperCase();
                        ve.doit = true;
                    } else {
                        ve.doit = false;
                    }
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Object newValue = text2.getText();
                if (((String)newValue).isEmpty()) {
                    newValue = "00";
                } else if (((String)newValue).length() == 1) {
                    newValue = "0" + (String)newValue;
                }
                DumpDisplay.this.hexValueTableCursor.getRow().setText(DumpDisplay.this.hexValueTableCursor.getColumn(), (String)newValue);
                int row1 = DumpDisplay.this.hexValueTable.getSelectionIndex();
                int column1 = DumpDisplay.this.hexValueTableCursor.getColumn();
                if (DumpDisplay.this.isValidSelection(row1, column1)) {
                    DumpDisplay.this.updateRecord((String)newValue, DumpDisplay.this.hexValueTable.getSelectionIndex(), DumpDisplay.this.hexValueTableCursor.getColumn() - 1);
                    DumpDisplay.this.hexValueTableCursor.setSelection(row1, column1);
                    DumpDisplay.this.hexValueTable.setSelection(row1);
                    DumpDisplay.this.textValueTable.setSelection(row1);
                }
                text2.dispose();
            }
        });
        return text2;
    }

    private void createTextValueTable(Composite parent) {
        this.textValueTable = new Table(parent, 68354);
        this.textValueTable.setHeaderVisible(true);
        this.textValueTable.setLinesVisible(true);
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textValueTable.setLayoutData((Object)gd);
        this.textValueTableViewer = new TableViewer(this.textValueTable);
        Font font = JFaceResources.getTextFont();
        this.textValueTableViewer.getTable().setFont(font);
        GC gc = new GC((Drawable)this.textValueTableViewer.getTable());
        gc.setFont(font);
        FontMetrics metrics = gc.getFontMetrics();
        int charWidth = metrics.getAverageCharWidth();
        this.createTextValueTableColumns(this.textValueTableViewer, charWidth);
        this.textValueTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.textValueTableViewer.setInput(this.prepareContents());
        this.textValueTableCursor = new TableCursor(this.textValueTable, 0);
        this.textValueTableCursor.setFont(JFaceResources.getDefaultFont());
        final ControlEditor cellEditor = new ControlEditor((Composite)this.textValueTableCursor);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.textValueTableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem row = DumpDisplay.this.textValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.textValueTable.indexOf(row);
                int columnIndex = DumpDisplay.this.textValueTableCursor.getColumn();
                DumpDisplay.this.textValueTable.setSelection(rowIndex);
                DumpDisplay.this.hexValueTable.setSelection(rowIndex);
                DumpDisplay.this.hexValueTableCursor.setSelection(rowIndex, columnIndex + 1);
                int pos = rowIndex * 16 + columnIndex + 1;
                DumpDisplay.this.singleView.updateCursorPosition("" + pos);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                int columnIndex;
                TableItem row = DumpDisplay.this.textValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.textValueTable.indexOf(row);
                Text text2 = DumpDisplay.this.createTextForEdit(rowIndex, columnIndex = DumpDisplay.this.textValueTableCursor.getColumn());
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.textValueTableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    int columnIndex;
                    TableItem row = DumpDisplay.this.textValueTableCursor.getRow();
                    int rowIndex = DumpDisplay.this.textValueTable.indexOf(row);
                    Text text2 = DumpDisplay.this.createTextForEdit(rowIndex, columnIndex = DumpDisplay.this.textValueTableCursor.getColumn());
                    if (text2 != null) {
                        cellEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                } else {
                    DumpDisplay.this.textValueTableCursor.setVisible(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                int columnIndex;
                TableItem row = DumpDisplay.this.textValueTableCursor.getRow();
                int rowIndex = DumpDisplay.this.textValueTable.indexOf(row);
                Text text2 = DumpDisplay.this.createTextForEdit(rowIndex, columnIndex = DumpDisplay.this.textValueTableCursor.getColumn());
                if (text2 != null) {
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
    }

    private Text createTextForEdit(int row, int column) {
        if (this.currentLine == null || this.currentEditor == null) {
            return null;
        }
        if (this.currentLine instanceof ShadowGroup) {
            return null;
        }
        if (!this.currentEditor.isEditSession()) {
            return null;
        }
        if (!this.isValidSelection(row, column)) {
            return null;
        }
        final Text text2 = new Text((Composite)this.textValueTableCursor, 0);
        text2.setFont(JFaceResources.getDefaultFont());
        text2.setTextLimit(1);
        text2.setFocus();
        text2.setText(this.textValueTableCursor.getRow().getText(this.textValueTableCursor.getColumn()));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        String newValue = text2.getText();
                        if (newValue.isEmpty()) {
                            newValue = " ";
                        }
                        try {
                            byte[] newHexValueBytes = newValue.getBytes(DumpDisplay.this.currentEditor.getResource().getSystem().getHostType().getCommunicationEncoding());
                            String enteredHexValue = DataConversionUtils.getHexString((byte[])newHexValueBytes).toUpperCase();
                            DumpDisplay.this.textValueTableCursor.getRow().setText(DumpDisplay.this.textValueTableCursor.getColumn(), newValue);
                            int row1 = DumpDisplay.this.textValueTable.getSelectionIndex();
                            int column1 = DumpDisplay.this.textValueTableCursor.getColumn();
                            if (DumpDisplay.this.isValidSelection(row1, column1)) {
                                DumpDisplay.this.updateRecord(enteredHexValue, DumpDisplay.this.textValueTable.getSelectionIndex(), DumpDisplay.this.textValueTableCursor.getColumn());
                                DumpDisplay.this.textValueTableCursor.setSelection(row1, column1);
                                DumpDisplay.this.hexValueTable.setSelection(row1);
                                DumpDisplay.this.textValueTable.setSelection(row1);
                            }
                        }
                        catch (Exception exe) {
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.SingleView_CONV_ERR, DumpDisplay.this.currentLine.getRecord().getRecno(), DumpDisplay.this.currentLine.getResource().getFormattedName()), (Throwable)exe);
                        }
                        text2.dispose();
                        break;
                    }
                    case 0x1000009: {
                        DumpDisplay.this.currentEditor.setInsertMode(!DumpDisplay.this.currentEditor.isInsertMode());
                        break;
                    }
                    case 27: {
                        text2.dispose();
                        break;
                    }
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (!StringUtils.isAsciiCharacters((String)ve.text)) {
                    ve.doit = false;
                } else if (!Character.isISOControl(ve.character) && !DumpDisplay.this.currentEditor.isInsertMode() && text2.getSelectionCount() == 0) {
                    int pos = text2.getCaretPosition();
                    text2.setSelection(pos, pos + 1);
                    ve.doit = true;
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String newValue = text2.getText();
                if (newValue.isEmpty()) {
                    newValue = " ";
                }
                try {
                    byte[] newHexValueBytes = newValue.getBytes(DumpDisplay.this.currentEditor.getResource().getSystem().getHostType().getCommunicationEncoding());
                    String enteredHexValue = DataConversionUtils.getHexString((byte[])newHexValueBytes).toUpperCase();
                    DumpDisplay.this.textValueTableCursor.getRow().setText(DumpDisplay.this.textValueTableCursor.getColumn(), newValue);
                    int row1 = DumpDisplay.this.textValueTable.getSelectionIndex();
                    int column1 = DumpDisplay.this.textValueTableCursor.getColumn();
                    if (DumpDisplay.this.isValidSelection(row1, column1)) {
                        DumpDisplay.this.updateRecord(enteredHexValue, DumpDisplay.this.textValueTable.getSelectionIndex(), DumpDisplay.this.textValueTableCursor.getColumn());
                        DumpDisplay.this.textValueTableCursor.setSelection(row1, column1);
                        DumpDisplay.this.hexValueTable.setSelection(row1);
                        DumpDisplay.this.textValueTable.setSelection(row1);
                    }
                }
                catch (Exception exe) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.SingleView_CONV_ERR, DumpDisplay.this.currentLine.getRecord().getRecno(), DumpDisplay.this.currentLine.getResource().getFormattedName()), (Throwable)exe);
                }
                text2.dispose();
            }
        });
        return text2;
    }

    private static void createHexValueTableColumns(TableViewer viewer, int charWidth) {
        TableViewerColumn offsetColumn = FormattedEditorUtility.createTableViewerColumn(Messages.SingleView_OFFSET, 80, viewer, 0x1000000);
        offsetColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                cell.setText(elements[0]);
            }
        });
        int i = 0;
        while (i < 16) {
            DumpDisplay.createHexValueTableColumn(viewer, i + 1, charWidth);
            ++i;
        }
    }

    private static void createHexValueTableColumn(TableViewer viewer, final int index, int charWidth) {
        TableViewerColumn infoColumn = FormattedEditorUtility.createTableViewerColumn(Integer.toHexString(index - 1).toUpperCase(), charWidth * 4, viewer, 0x1000000);
        infoColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                String hexValue = elements[1];
                if ((index - 1) * 2 >= hexValue.length()) {
                    cell.setBackground(Display.getDefault().getSystemColor(15));
                } else {
                    int beginIndex = (index - 1) * 2;
                    int endIndex = beginIndex + 2;
                    if (endIndex > hexValue.length()) {
                        logger.trace((Object)MessageFormat.format("endIndex is out of range: beginIndex={0} endIndex={1} hexLength={2} = {3}", beginIndex, endIndex, hexValue.length(), hexValue));
                    } else {
                        String value = hexValue.substring(beginIndex, endIndex);
                        cell.setText(value);
                    }
                }
            }
        });
    }

    private void createTextValueTableColumns(TableViewer viewer, int charWidth) {
        int i = 0;
        while (i < 16) {
            this.createTextValueTableColumn(viewer, i, charWidth);
            ++i;
        }
    }

    private void createTextValueTableColumn(TableViewer viewer, final int index, int charWidth) {
        TableViewerColumn infoColumn = FormattedEditorUtility.createTableViewerColumn(Integer.toHexString(index).toUpperCase(), charWidth * 3, viewer, 0x1000000);
        infoColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String[] elements = (String[])cell.getElement();
                String hexValue = elements[1];
                if (index * 2 >= hexValue.length()) {
                    cell.setBackground(Display.getDefault().getSystemColor(15));
                } else {
                    int beginIndex = index * 2;
                    int endIndex = beginIndex + 2;
                    if (endIndex > hexValue.length()) {
                        logger.trace((Object)MessageFormat.format("{0} endIndex is out of range: beginIndex={1} endIndex={2} hexLength={3} = {4}", index, beginIndex, endIndex, hexValue.length(), hexValue));
                        return;
                    }
                    String value = hexValue.substring(beginIndex, endIndex);
                    String ebcdicValue = "";
                    byte[] byteValue = DataConversionUtils.getEBCDICData((String)value);
                    try {
                        ebcdicValue = new String(byteValue, DumpDisplay.this.hostConCp).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
                    }
                    catch (UnsupportedEncodingException e) {
                        PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.SingleView_CONV_ERR, DumpDisplay.this.currentLine.getRecord().getRecno(), DumpDisplay.this.currentLine.getResource().getFormattedName()), (Throwable)e);
                        ebcdicValue = "";
                    }
                    cell.setText(ebcdicValue);
                }
            }
        });
    }

    private ArrayList<String[]> prepareContents() {
        ArrayList<String[]> contents = new ArrayList<String[]>();
        if (this.currentLine == null) {
            return contents;
        }
        String hexValue = this.currentLine.getRecord().getHex();
        StringBuilder col0 = new StringBuilder();
        StringBuilder col1 = new StringBuilder();
        int i = 0;
        while (i < hexValue.length()) {
            if (i % 32 == 0) {
                if (i == 0) {
                    col0.append("+" + Integer.toHexString(i * 16).toUpperCase());
                } else {
                    String[] aRow = new String[]{col0.toString(), col1.toString()};
                    contents.add(aRow);
                    col0 = new StringBuilder();
                    col0.append("+" + Integer.toHexString(contents.size() * 16).toUpperCase());
                    col1 = new StringBuilder();
                }
            }
            col1.append(hexValue.charAt(i));
            ++i;
        }
        String[] aRow = new String[]{col0.toString(), col1.toString()};
        contents.add(aRow);
        return contents;
    }

    private boolean isValidSelection(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || columnIndex < 0) {
            return false;
        }
        int newHexIndex = 32 * rowIndex + columnIndex * 2;
        return newHexIndex < this.currentLine.getRecord().getHex().length();
    }

    private void updateRecord(String enteredHexValue, int rowIndex, int columnIndex) {
        String newTailingHex;
        String newLeadingHex;
        String newHexValue;
        int newHexIndex = 32 * rowIndex + columnIndex * 2;
        String oldHexValue = this.currentLine.getRecord().getHex();
        if (!oldHexValue.equalsIgnoreCase(newHexValue = (newLeadingHex = oldHexValue.substring(0, newHexIndex)) + enteredHexValue + (newTailingHex = oldHexValue.substring(newHexIndex + 2)))) {
            this.currentEditor.updateHexValue(this.currentLine, newHexValue);
        }
    }

    public void displayCurrentLine(FormattedEditor editor2, DisplayLine curLine) {
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.clearViewContents();
        } else {
            this.currentEditor = editor2;
            this.hostConCp = this.currentEditor.getResource().getPersistentProperty("encoding");
            this.currentLine = curLine;
            this.hexValueTable.setEnabled(true);
            this.textValueTable.setEnabled(true);
            this.hexValueTableViewer.setInput(this.prepareContents());
            this.textValueTableViewer.setInput(this.prepareContents());
        }
    }

    public void clearViewContents() {
        this.currentEditor = null;
        this.hostConCp = null;
        this.currentLine = null;
        this.hexValueTable.setEnabled(false);
        this.textValueTable.setEnabled(false);
        this.hexValueTableViewer.setInput(this.prepareContents());
        this.textValueTableViewer.setInput(this.prepareContents());
    }
}

