/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.single;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.editor.template1.StringArrayElementTableLabelProvider;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.bidi.ui.VisualField;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class Db2SingleDisplay {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int INDEX_COLUMN_NUMBER = 0;
    private static final int INDEX_KEYS = 1;
    private static final int INDEX_COLUMN_NAME = 2;
    private static final int INDEX_TYPE = 3;
    private static final int INDEX_DATA = 4;
    private static final int INDEX_SEARCH_INFO = 5;
    private static final int INDEX_FIELD_MAX_LENGTH = 6;
    private static final String EMPTY = "";
    private static final String VALUE_LINE = "value";
    private static final String HEX_LINE_WITH_NO_SEARCH_HIT = "hexNoHit";
    private static final String HEX_LINE_WITH_SEARCH_HIT = "hexWithHit";
    private static final String KEY_LINE = "key";
    private static final String SEARCH_HIT_LINE = "searchHitLine";
    private Table recordTable = null;
    private TableViewer recordTableViewer = null;
    private TableCursor tableCursor = null;
    private AtomicReference<VisualField> visualFld = new AtomicReference();
    private FormattedEditor currentEditor = null;
    private DisplayLine currentLine = null;
    private SingleView singleView = null;
    private TraverseListener ignoreTraverseListener;

    public Db2SingleDisplay(SingleView view2) {
        this.singleView = view2;
    }

    public Composite createDb2SingleDisplayComposite(Composite parent) {
        Composite composite = GUI.composite((Composite)parent, (Layout)GUI.grid.l.margins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        this.recordTable = new Table(composite, 68354);
        this.recordTable.setHeaderVisible(true);
        this.recordTable.setLinesVisible(true);
        this.recordTable.setFont(JFaceResources.getTextFont());
        this.recordTableViewer = new TableViewer(this.recordTable);
        Db2SingleDisplay.createColumns(this.recordTableViewer);
        this.recordTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.recordTable.setLayoutData((Object)gd);
        composite.setLayoutData((Object)gd);
        this.createTableCursor();
        return composite;
    }

    private static void createColumns(TableViewer viewer) {
        FormattedEditorUtility.createTableViewerColumn(Messages.CriteriaSpecDialog_REF_COLUMN, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_KEY, 100, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_COLUMN_NAME, 200, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA_TYPE, 250, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_DATA, 400, viewer, 16384);
        FormattedEditorUtility.createTableViewerColumn(Messages.TE_NULLABLE, 400, viewer, 16384);
        viewer.setLabelProvider((IBaseLabelProvider)new SingleDisplayLabelProvider());
    }

    private ArrayList<String[]> prepareContents() {
        if (this.currentLine == null || this.currentEditor == null) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        if (this.currentEditor.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        if (this.currentLine instanceof ShadowGroup) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        this.recordTable.setEnabled(true);
        ArrayList<String[]> contents = new ArrayList<String[]>();
        HdrType aHdr = this.currentEditor.getCurrentTableHeader(this.currentEditor.getLayout(this.currentLine.getRecord()).getId());
        if (aHdr == null) {
            this.recordTable.setEnabled(false);
            return new ArrayList<String[]>();
        }
        EList columnInfos = aHdr.getHdrfld();
        TemplateType aTemplate = this.currentEditor.getCurrentTemplate();
        PDBiDiHelpers.ifNotVisualAndRTLRequiredUseRTLOrientation((IZRL)this.currentEditor.getResource(), (Control)this.recordTableViewer.getControl());
        int i = 0;
        while (i < columnInfos.size()) {
            HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(i);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(this.currentLine.getRecord(), aColumnInfo, aTemplate);
            FieldType aField = FormattedPageUtility.getField(this.currentLine.getRecord(), i + 1);
            if (aField != null) {
                String refName = EMPTY + aSymbol.getDb2col();
                String key = Db2SingleDisplay.keyStatusValue(aSymbol);
                String columnName = aSymbol.getHeading() != null && aSymbol.getHeading().length() > 0 ? aSymbol.getHeading() : aSymbol.getName(this.currentEditor.getSystem());
                String db2Type = aSymbol.getDb2typ();
                String value = EMPTY;
                String nullable = EMPTY;
                nullable = !aSymbol.isNull() ? "No" : "Yes";
                if (aField != null) {
                    value = FormattedPageUtility.isDb2Nullfield(this.currentEditor, this.currentLine.getRecord(), aSymbol, aField, aColumnInfo) ? this.currentEditor.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getDNULLIND() : (FormattedPageUtility.performLocalStrProc(aSymbol) ? FormattedPageUtility.getANValue(this.currentEditor.getSessionProperties(), this.currentLine.getRecord(), aSymbol, aField, aColumnInfo, false, this.currentEditor.getResource(), this.currentEditor.getSessionIdentifier().getEditorOffset()) : (aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getVCValue(this.currentEditor.getSessionProperties(), this.currentEditor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), this.currentLine.getRecord(), aSymbol, aField, aColumnInfo, this.currentEditor.getResource(), true) : (FormattedPageUtility.performAnVcStrProc(aSymbol) ? FormattedPageUtility.getPliVCValue(this.currentEditor.getSessionProperties(), this.currentLine.getRecord(), aSymbol, aField, aColumnInfo, this.currentEditor.getResource(), true) : aField.getValue())));
                }
                Object length = EMPTY;
                if (FormattedPageUtility.performLocalStrProc(aSymbol) || aSymbol.getCreate() == CreateType.VC) {
                    length = EMPTY + (aSymbol.isSetLength() ? aSymbol.getLength() : aColumnInfo.getLen());
                }
                String lineType = VALUE_LINE;
                if (aField != null && aField.getFindhit() > 0) {
                    lineType = SEARCH_HIT_LINE;
                } else if (aColumnInfo.isKey() || aSymbol.isPkey() || aSymbol.isFkey()) {
                    lineType = KEY_LINE;
                }
                String[] aLine = new String[]{refName, key, columnName, db2Type, value, nullable, lineType, length};
                contents.add(aLine);
                if (this.currentEditor.isHexMode()) {
                    List<HexRecordWrapper> hexLines = null;
                    hexLines = this.currentLine instanceof HexRecordWrapper ? ((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers() : this.currentLine.getHexWrappers();
                    if (hexLines.size() == 2) {
                        value = aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getHexHighOrLowValueVC(this.currentEditor.getSessionProperties(), hexLines.get(0), aSymbol, aField, aColumnInfo) : FormattedPageUtility.getHexHighOrLowValue(this.currentEditor.getSessionProperties(), hexLines.get(0), aSymbol, aField, aColumnInfo);
                        value = PDBiDiHelpers.reverseIfVisualRTLRequired((IZRL)this.currentEditor.getResource(), (String)value);
                        aLine = aField != null && aField.getFindhit() > 0 ? new String[]{EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_SEARCH_HIT, length} : new String[]{EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_NO_SEARCH_HIT, length};
                        contents.add(aLine);
                        value = aSymbol.getCreate() == CreateType.VC ? FormattedPageUtility.getHexHighOrLowValueVC(this.currentEditor.getSessionProperties(), hexLines.get(1), aSymbol, aField, aColumnInfo) : FormattedPageUtility.getHexHighOrLowValue(this.currentEditor.getSessionProperties(), hexLines.get(1), aSymbol, aField, aColumnInfo);
                        value = PDBiDiHelpers.reverseIfVisualRTLRequired((IZRL)this.currentEditor.getResource(), (String)value);
                        aLine = aField != null && aField.getFindhit() > 0 ? new String[]{EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_SEARCH_HIT, length} : new String[]{EMPTY, EMPTY, EMPTY, EMPTY, value, HEX_LINE_WITH_NO_SEARCH_HIT, length};
                        contents.add(aLine);
                    } else {
                        aLine = new String[]{EMPTY, EMPTY, EMPTY, EMPTY, EMPTY, HEX_LINE_WITH_NO_SEARCH_HIT, length};
                        contents.add(aLine);
                        contents.add(aLine);
                    }
                }
            }
            ++i;
        }
        return contents;
    }

    private void createTableCursor() {
        this.tableCursor = new TableCursor(this.recordTable, 0);
        this.tableCursor.setFont(JFaceResources.getTextFont());
        final ControlEditor cellEditor = new ControlEditor((Composite)this.tableCursor);
        cellEditor.grabHorizontal = true;
        cellEditor.grabVertical = true;
        this.tableCursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Db2SingleDisplay.this.recordTable.setSelection(new TableItem[]{Db2SingleDisplay.this.tableCursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Text text2 = Db2SingleDisplay.this.createTextForEdit();
                if (text2 != null) {
                    Db2SingleDisplay.this.singleView.updateCursorPosition("0");
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.tableCursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    Text text2 = Db2SingleDisplay.this.createTextForEdit();
                    if (text2 != null) {
                        Db2SingleDisplay.this.singleView.updateCursorPosition("0");
                        cellEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                } else {
                    Db2SingleDisplay.this.tableCursor.setVisible(false);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Text text2 = Db2SingleDisplay.this.createTextForEdit();
                if (text2 != null) {
                    Db2SingleDisplay.this.singleView.updateCursorPosition("0");
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
        this.tableCursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    Db2SingleDisplay.this.handleTraverseEvent(e);
                }
            }
        });
        this.tableCursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Text text2;
                if (!Character.isISOControl(e.character) && (text2 = Db2SingleDisplay.this.createTextForEdit()) != null && text2.getEditable()) {
                    Db2SingleDisplay.this.singleView.updateCursorPosition("0");
                    text2.setText(Db2SingleDisplay.EMPTY + e.character);
                    text2.setSelection(1, 1);
                    cellEditor.setEditor((Control)text2);
                    text2.setFocus();
                }
            }
        });
    }

    private void handleTraverseEvent(TraverseEvent te) {
        int columnPos = this.tableCursor.getColumn();
        int rowIndex = this.recordTableViewer.getTable().indexOf(this.tableCursor.getRow());
        int newColumnPos = columnPos;
        int newRowIndex = rowIndex;
        if ((te.stateMask & 0x20000) != 0) {
            if (rowIndex == 0 && columnPos == 0) {
                te.doit = true;
                return;
            }
            if (columnPos == 0) {
                newColumnPos = 4;
                newRowIndex = rowIndex - 1;
            } else {
                newColumnPos = columnPos - 1;
                newRowIndex = rowIndex;
            }
        } else {
            if (rowIndex == this.recordTable.getItemCount() - 1 && columnPos == 4) {
                te.doit = true;
                return;
            }
            if (columnPos == 4) {
                newColumnPos = 0;
                newRowIndex = rowIndex + 1;
            } else {
                newColumnPos = columnPos + 1;
                newRowIndex = rowIndex;
            }
        }
        te.doit = false;
        this.tableCursor.setSelection(newRowIndex, newColumnPos);
        this.recordTable.setSelection(this.tableCursor.getRow());
    }

    private Text createTextForEdit() {
        if (this.currentLine == null || this.currentEditor == null) {
            return null;
        }
        if (this.currentLine instanceof ShadowGroup) {
            return null;
        }
        if (this.currentEditor.getTemplateResource() == null) {
            return null;
        }
        if (this.tableCursor.getColumn() != 4) {
            return null;
        }
        if (!this.currentEditor.isEditSession()) {
            return null;
        }
        if (this.recordTable.getSelectionIndex() == -1) {
            this.recordTable.setSelection(this.tableCursor.getRow());
        }
        boolean isHexUpdate = false;
        int rowIndex = this.recordTable.indexOf(this.tableCursor.getRow());
        if (this.currentEditor.isHexMode()) {
            if (rowIndex % 3 != 0) {
                isHexUpdate = true;
            }
            rowIndex /= 3;
        }
        HdrType aHdr = this.currentEditor.getCurrentTableHeader(this.currentEditor.getLayout(this.currentLine.getRecord()).getId());
        EList columnInfos = aHdr.getHdrfld();
        TemplateType aTemplate = this.currentEditor.getCurrentTemplate();
        HdrfldType aColumnInfo = (HdrfldType)columnInfos.get(rowIndex);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(this.currentLine.getRecord(), aColumnInfo, aTemplate);
        FieldType aField = FormattedPageUtility.getField(this.currentLine.getRecord(), rowIndex + 1);
        if (aField.isFieldUpdatedLocally() && aSymbol.getCreate() != CreateType.AN && aSymbol.getCreate() != CreateType.VC && (isHexUpdate ? aField.isFieldUpdatedLocally() && !aField.isFieldUpdatedByHex() : aField.isFieldUpdatedLocally() && aField.isFieldUpdatedByHex())) {
            return null;
        }
        if (this.currentEditor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2 && !this.currentEditor.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getUPKEY() && aSymbol.isPkey()) {
            return null;
        }
        final Text text2 = new Text((Composite)this.tableCursor, 0);
        text2.setFont(JFaceResources.getTextFont());
        text2.setFocus();
        int length = this.getFieldLength();
        if (length != -1) {
            text2.setTextLimit(length);
        }
        this.visualFld.set(null);
        String rowText = this.tableCursor.getRow().getText(this.tableCursor.getColumn());
        PDBiDiHelpers.prepareTextForEdit(this.visualFld, (IZRL)this.currentEditor.getResource(), (String)rowText, (Text)text2);
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        Db2SingleDisplay.this.updateFieldValue(text2.getText());
                        Db2SingleDisplay.this.singleView.updateCursorPosition(null);
                        text2.dispose();
                        break;
                    }
                    case 0x1000009: {
                        Db2SingleDisplay.this.currentEditor.setInsertMode(!Db2SingleDisplay.this.currentEditor.isInsertMode());
                        break;
                    }
                    case 27: {
                        Db2SingleDisplay.this.singleView.updateCursorPosition(null);
                        text2.dispose();
                        break;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 13 && e.keyCode != 0x1000009 && e.keyCode != 27) {
                    Db2SingleDisplay.this.singleView.updateCursorPosition(Db2SingleDisplay.EMPTY + text2.getCaretPosition());
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (Db2SingleDisplay.this.currentEditor.isHexMode()) {
                    int selIndex = Db2SingleDisplay.this.recordTable.getSelectionIndex();
                    if (selIndex % 3 != 0) {
                        if (!Character.isISOControl(ve.character)) {
                            if (!Db2SingleDisplay.this.currentEditor.isInsertMode()) {
                                if (text2.getSelectionCount() == 0) {
                                    String value = Db2SingleDisplay.EMPTY + ve.character;
                                    if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(value).matches()) {
                                        int pos = text2.getCaretPosition();
                                        text2.setSelection(pos, pos + 1);
                                        ve.doit = true;
                                    } else {
                                        ve.doit = false;
                                    }
                                }
                            } else {
                                FormattedPageUtility.hexEntryTextValue(ve);
                            }
                        } else if (ve.keyCode == 0) {
                            if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(ve.text).matches()) {
                                ve.text = ve.text.toUpperCase();
                                ve.doit = true;
                            } else {
                                ve.doit = false;
                            }
                        }
                    } else if (!Character.isISOControl(ve.character) && !Db2SingleDisplay.this.currentEditor.isInsertMode() && text2.getSelectionCount() == 0) {
                        int pos = text2.getCaretPosition();
                        text2.setSelection(pos, pos + 1);
                        ve.doit = true;
                    }
                } else if (!Character.isISOControl(ve.character) && !Db2SingleDisplay.this.currentEditor.isInsertMode() && text2.getSelectionCount() == 0) {
                    int pos = text2.getCaretPosition();
                    text2.setSelection(pos, pos + 1);
                    ve.doit = true;
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Db2SingleDisplay.this.singleView.updateCursorPosition(null);
                Db2SingleDisplay.this.updateFieldValue(text2.getText());
                text2.dispose();
                Db2SingleDisplay.this.recordTableViewer.refresh();
            }
        });
        text2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Db2SingleDisplay.this.singleView.updateCursorPosition(Db2SingleDisplay.EMPTY + text2.getCaretPosition());
            }
        });
        text2.addTraverseListener(this.traverseIgnoreListener());
        return text2;
    }

    private void updateFieldValue(String newValue) {
        newValue = PDBiDiHelpers.updateFieldValue((IZRL)this.currentEditor.getResource(), this.visualFld, (String)newValue);
        this.tableCursor.getRow().setText(this.tableCursor.getColumn(), newValue);
        if (this.currentEditor.isHexMode()) {
            if (this.recordTable.getSelectionIndex() % 3 == 0) {
                if (this.currentLine instanceof HexRecordWrapper) {
                    this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine(), this.recordTable.getSelectionIndex() / 3, newValue, false);
                } else {
                    this.currentEditor.updateFieldValue(this.currentLine, this.recordTable.getSelectionIndex() / 3, newValue, false);
                }
            } else if (this.recordTable.getSelectionIndex() % 3 == 1) {
                if (this.currentLine instanceof HexRecordWrapper) {
                    this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers().get(0), this.recordTable.getSelectionIndex() / 3, newValue, true);
                } else {
                    this.currentEditor.updateFieldValue(this.currentLine.getHexWrappers().get(0), this.recordTable.getSelectionIndex() / 3, newValue, true);
                }
            } else if (this.currentLine instanceof HexRecordWrapper) {
                this.currentEditor.updateFieldValue(((HexRecordWrapper)this.currentLine).getDisplayLine().getHexWrappers().get(1), this.recordTable.getSelectionIndex() / 3, newValue, true);
            } else {
                this.currentEditor.updateFieldValue(this.currentLine.getHexWrappers().get(1), this.recordTable.getSelectionIndex() / 3, newValue, true);
            }
        } else {
            this.currentEditor.updateFieldValue(this.currentLine, this.recordTable.getSelectionIndex(), newValue, false);
        }
    }

    private int getFieldLength() {
        String[] data = (String[])this.tableCursor.getRow().getData();
        if (data[6].equals(EMPTY)) {
            return -1;
        }
        return Integer.parseInt(data[6]);
    }

    public void displayCurrentLine(FormattedEditor editor2, DisplayLine curLine) {
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            this.currentEditor = editor2;
            this.currentLine = curLine;
            this.recordTableViewer.setInput(this.prepareContents());
        } else {
            this.clearViewContents();
        }
    }

    public void displayCurrentColumn(FormattedEditor editor2) {
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            int[] selection = editor2.getSelection();
            editor2.getCurrentPage().setSelectedLines(selection);
            this.recordTableViewer.setSelection((ISelection)new StructuredSelection(this.recordTableViewer.getElementAt(editor2.getCurrentColumn())), true);
        } else {
            this.clearViewContents();
        }
    }

    public void clearViewContents() {
        this.currentEditor = null;
        this.currentLine = null;
        this.recordTableViewer.setInput(this.prepareContents());
    }

    public static String keyStatusValue(Symboltype aSymbol) {
        Objects.requireNonNull(aSymbol, "Must provide a non-null aSymbol");
        Object key = aSymbol.isPkey() ? "P" : " ";
        key = (String)key + (aSymbol.isUniqx() ? "U" : " ");
        key = (String)key + (aSymbol.isNonuniqx() ? "N" : " ");
        key = (String)key + (aSymbol.isFkey() ? "F" : " ");
        return key;
    }

    private TraverseListener traverseIgnoreListener() {
        if (this.ignoreTraverseListener != null) {
            return this.ignoreTraverseListener;
        }
        this.ignoreTraverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    e.doit = false;
                }
            }
        };
        return this.ignoreTraverseListener;
    }

    private static class SingleDisplayLabelProvider
    extends StringArrayElementTableLabelProvider {
        public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

        private SingleDisplayLabelProvider() {
        }

        @Override
        public Color getForeground(Object element, int columnIndex) {
            if (4 == columnIndex) {
                String[] elements = (String[])element;
                if (Db2SingleDisplay.HEX_LINE_WITH_NO_SEARCH_HIT.equals(elements[5])) {
                    return FormattedEditorPreferencePage.getHexForegroundColor();
                }
                if (Db2SingleDisplay.HEX_LINE_WITH_SEARCH_HIT.equals(elements[5])) {
                    return FormattedEditorPreferencePage.getHexForegroundColor();
                }
                if (!elements[1].trim().isEmpty()) {
                    return FormattedEditorPreferencePage.getHighlightColor();
                }
            }
            return null;
        }

        @Override
        public Color getBackground(Object element, int columnIndex) {
            if (4 == columnIndex) {
                String[] elements = (String[])element;
                if (Db2SingleDisplay.HEX_LINE_WITH_SEARCH_HIT.equals(elements[5])) {
                    return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
                }
                if (Db2SingleDisplay.SEARCH_HIT_LINE.equals(elements[5])) {
                    return FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
                }
            }
            return null;
        }
    }
}

