/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.prefs.ccsid.EncodingMappingList;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.DataUtilities;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.VerifyEvent;

public class FormattedPageUtility {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FormattedPageUtility.class);
    private static final String DBCS_ENCODING = "DBCS";
    private static HashMap<IZRL, HashSet<Symboltype>> encodingErrorList = null;

    public static FieldType getField(RecType aRec, int columnIndex) {
        Objects.requireNonNull(aRec, "Must specify a non-null aRec.");
        EList fields = aRec.getField();
        if (fields == null) {
            return null;
        }
        int i = 0;
        while (i < fields.size()) {
            FieldType aField = (FieldType)fields.get(i);
            if (aField.getSeq() == columnIndex) {
                return aField;
            }
            ++i;
        }
        return null;
    }

    public static Symboltype getSymbol(RecType aRec, HdrfldType aHeaderColumn, TemplateType aTemplate) {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        Layouttype currentLayout = null;
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == aRec.getId()) {
                currentLayout = aLayout;
                break;
            }
            ++i;
        }
        if (currentLayout == null) {
            return null;
        }
        EList symbols = currentLayout.getSymbol();
        int i2 = 0;
        while (i2 < symbols.size()) {
            Symboltype aSymbol = (Symboltype)symbols.get(i2);
            if (aSymbol.getRef() == aHeaderColumn.getSym()) {
                return aSymbol;
            }
            ++i2;
        }
        return null;
    }

    public static Symboltype getSymbol(HdrType aHeader, HdrfldType aHeaderColumn, TemplateType aTemplate) {
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        Layouttype currentLayout = null;
        EList layouts = aTemplate.getLayout();
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == aHeader.getId()) {
                currentLayout = aLayout;
                break;
            }
            ++i;
        }
        if (currentLayout == null) {
            return null;
        }
        EList symbols = currentLayout.getSymbol();
        int i2 = 0;
        while (i2 < symbols.size()) {
            Symboltype aSymbol = (Symboltype)symbols.get(i2);
            if (aSymbol.getRef() == aHeaderColumn.getSym()) {
                return aSymbol;
            }
            ++i2;
        }
        return null;
    }

    public static boolean checkFieldLength(FMEditSessionProperties props, RecType aRecord, HdrfldType aHdr, FieldType aField, TemplateType aTemplate) {
        int recordLength;
        int fieldLength;
        Objects.requireNonNull(aTemplate, "Must specify a non-null aTemplate.");
        Symboltype aSymbol = FormattedPageUtility.getSymbol(aRecord, aHdr, aTemplate);
        if (aSymbol == null) {
            return false;
        }
        int fieldStartIndex = (aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1;
        return fieldStartIndex + (fieldLength = aField.isSetLen() ? aField.getLen() : aSymbol.getLength()) <= (recordLength = props.getMaxRECL());
    }

    public static int getRecordMaxLength(FMEditSessionProperties props, RecType aRecord) {
        Objects.requireNonNull(props, "Must specify a non-null props.");
        if (props.isInplaceEdit()) {
            return aRecord.getLen();
        }
        return props.getMaxRECL();
    }

    public static String updateHexValue(FMEditSessionProperties props, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, IZRL aResource, Symboltype aSymbol) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            return FormattedPageUtility.updateHexDBCSValue(props, aRecord, aField, aFieldInfo, aTemplate, newValue, aResource, aSymbol);
        }
        if (TypeType.G.equals((Object)aSymbol.getType())) {
            return FormattedPageUtility.updateHexDBCSValue(props, aRecord, aField, aFieldInfo, aTemplate, newValue, aResource, aSymbol);
        }
        return FormattedPageUtility.updateHexNonDBCSValue(props, aRecord, aField, aFieldInfo, aTemplate, newValue, aResource, aSymbol);
    }

    private static String updateHexNonDBCSValue(FMEditSessionProperties props, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, IZRL aResource, Symboltype aSymbol) {
        int end;
        int start;
        StringBuffer oldHexValue;
        String hexString;
        block7: {
            int maxFieldLen;
            int minFieldLen;
            String encoding;
            block6: {
                Objects.requireNonNull(newValue, "Must specify a non-null newValue.");
                encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
                try {
                    if (newValue.getBytes(encoding).length < aSymbol.getLength()) {
                        newValue = FormattedEditorUtility.addSpacePaddingForString(newValue, aSymbol.getLength(), encoding);
                    }
                    byte[] newHexValueBytes = newValue.getBytes(encoding);
                    hexString = DataConversionUtils.getHexString((byte[])newHexValueBytes);
                    minFieldLen = FormattedPageUtility.getFieldMinLength(props, aRecord, aSymbol, aFieldInfo);
                    maxFieldLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
                    if (maxFieldLen != -1) break block6;
                    return null;
                }
                catch (Exception e) {
                    String errMsg = MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR, encoding, newValue);
                    logger.error((Object)errMsg, (Throwable)e);
                    return errMsg;
                }
            }
            hexString = FormattedEditorUtility.checkAndFixFieldLength(hexString, minFieldLen, maxFieldLen, FormattedEditorUtility.getSpaceHexValue(encoding));
            hexString = hexString.toUpperCase();
            oldHexValue = new StringBuffer(aRecord.getHex());
            start = (aFieldInfo.getStart() - 1) * 2;
            end = start + hexString.length();
            if (start >= oldHexValue.length()) {
                return MessageFormat.format(Messages.FormattedPageUtility_REPLACE_ERR1, start, end, maxFieldLen);
            }
            if (end > oldHexValue.length()) break block7;
            StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
            aRecord.setHex(newHexValue.toString());
            return null;
        }
        end = oldHexValue.length();
        StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
        aRecord.setHex(newHexValue.toString());
        return null;
    }

    private static String updateHexDBCSValue(FMEditSessionProperties props, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, IZRL aResource, Symboltype aSymbol) {
        int end;
        int start;
        StringBuffer oldHexValue;
        String hexString;
        block6: {
            Objects.requireNonNull(newValue, "Must specify a non-null newValue.");
            String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
            try {
                if (newValue.getBytes(encoding).length < aSymbol.getLength() + 2) {
                    newValue = FormattedEditorUtility.addSpaceDBCSPaddingForString(newValue, aSymbol.getLength() + 2, encoding);
                }
                byte[] newHexValueBytes = newValue.getBytes(encoding);
                hexString = DataConversionUtils.getHexString((byte[])newHexValueBytes);
                hexString = hexString.toUpperCase();
                logger.debug((Object)("Before removing x0E x0F:" + hexString));
                hexString = hexString.substring(2, hexString.length() - 2);
                logger.debug((Object)("After removing x0E x0F:" + hexString));
                if (hexString.length() / 2 > aSymbol.getLength()) {
                    hexString = hexString.substring(0, aSymbol.getLength() * 2);
                }
                oldHexValue = new StringBuffer(aRecord.getHex());
                start = (aFieldInfo.getStart() - 1) * 2;
                end = start + hexString.length();
                if (start >= oldHexValue.length()) {
                    return MessageFormat.format(Messages.FormattedPageUtility_REPLACE_ERR1, start, end, FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo));
                }
                if (end > oldHexValue.length()) break block6;
                StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
                aRecord.setHex(newHexValue.toString());
                return null;
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR, encoding, newValue);
                logger.error((Object)errMsg, (Throwable)e);
                return errMsg;
            }
        }
        end = oldHexValue.length() - 1;
        StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
        aRecord.setHex(newHexValue.toString());
        return null;
    }

    public static String updateVCHexValue(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, Symboltype aSymbol, IZRL aResource) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            return FormattedPageUtility.updateVCHexDBCSValue(props, editorOptions, aRecord, aField, aFieldInfo, aTemplate, newValue, aSymbol, aResource);
        }
        return FormattedPageUtility.updateVCHexNonDBCSValue(props, editorOptions, aRecord, aField, aFieldInfo, aTemplate, newValue, aSymbol, aResource);
    }

    private static String updateVCHexNonDBCSValue(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, Symboltype aSymbol, IZRL aResource) {
        int end;
        int start;
        StringBuffer oldHexValue;
        String hexString;
        block10: {
            Objects.requireNonNull(editorOptions, "Must specify a non-null editorOptions.");
            String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
            String endChar = editorOptions.getVCDELIM();
            String endMarker = editorOptions.getDVCDELIM();
            if (endChar == null || endChar.isEmpty()) {
                endChar = "<";
            }
            if (newValue.lastIndexOf(endChar) != -1) {
                newValue = newValue.substring(0, newValue.lastIndexOf(endChar));
            } else if (newValue.endsWith(endMarker)) {
                newValue = newValue.substring(0, newValue.length() - 1);
            }
            try {
                byte[] newHexValueBytes;
                int enteredValueLength = newValue.getBytes(FormattedPageUtility.getEncodingForField(aSymbol, aResource)).length;
                if (enteredValueLength < aSymbol.getLength()) {
                    newValue = FormattedEditorUtility.addSpacePaddingForString(newValue, aSymbol.getLength(), encoding);
                }
                if ((hexString = DataConversionUtils.getHexString((byte[])(newHexValueBytes = newValue.getBytes(FormattedPageUtility.getEncodingForField(aSymbol, aResource))))).length() / 2 > aSymbol.getLength()) {
                    hexString = hexString.substring(0, aSymbol.getLength() * 2);
                    enteredValueLength = hexString.length() / 2;
                }
                oldHexValue = new StringBuffer(aRecord.getHex());
                start = (aFieldInfo.getStart() - 1) * 2;
                end = start + hexString.length();
                byte[] newLength = DataUtilities.intToByteArray((int)enteredValueLength);
                String hex = DataConversionUtils.getHexString((byte[])newLength).substring(4).toUpperCase();
                if (start >= (oldHexValue = oldHexValue.replace(start - 4, start, hex)).length()) {
                    return MessageFormat.format(Messages.FormattedPageUtility_REPLACE_ERR1, start, end, FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo));
                }
                if (end > (aFieldInfo.getStart() - 1 + aSymbol.getLength()) * 2) break block10;
                StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
                aRecord.setHex(newHexValue.toString());
                return null;
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR, FormattedPageUtility.getEncodingForField(aSymbol, aResource), newValue);
                logger.error((Object)errMsg, (Throwable)e);
                return errMsg;
            }
        }
        end = oldHexValue.length() - 1;
        StringBuffer newHexValue = oldHexValue.replace(start, end, hexString);
        aRecord.setHex(newHexValue.toString());
        return null;
    }

    private static String updateVCHexDBCSValue(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, TemplateType aTemplate, String newValue, Symboltype aSymbol, IZRL aResource) {
        int end;
        int start;
        StringBuffer oldHexValue;
        Object hexString;
        block11: {
            Objects.requireNonNull(editorOptions, "Must specify a non-null editorOptions.");
            String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
            String endChar = editorOptions.getVCDELIM();
            String endMarker = editorOptions.getDVCDELIM();
            if (endChar == null || endChar.isEmpty()) {
                endChar = "<";
            }
            if (newValue.lastIndexOf(endChar) != -1) {
                newValue = newValue.substring(0, newValue.lastIndexOf(endChar));
            } else if (newValue.endsWith(endMarker)) {
                newValue = newValue.substring(0, newValue.length() - 1);
            }
            try {
                byte[] newHexValueBytes;
                int enteredValueLength = newValue.getBytes(FormattedPageUtility.getEncodingForField(aSymbol, aResource)).length;
                if (enteredValueLength > 0) {
                    enteredValueLength -= 2;
                }
                if (enteredValueLength < aSymbol.getLength()) {
                    newValue = FormattedEditorUtility.addSpaceDBCSPaddingForString(newValue, aSymbol.getLength(), encoding);
                }
                if (((String)(hexString = DataConversionUtils.getHexString((byte[])(newHexValueBytes = newValue.getBytes(FormattedPageUtility.getEncodingForField(aSymbol, aResource)))))).length() / 2 > aSymbol.getLength() + 4) {
                    hexString = ((String)hexString).substring(2, ((String)hexString).length() - 2);
                    hexString = ((String)hexString).substring(0, aSymbol.getLength() * 2);
                    enteredValueLength = ((String)hexString).length() / 2;
                    hexString = "0E" + (String)hexString + "0F";
                }
                hexString = ((String)hexString).toUpperCase();
                logger.debug((Object)("Before removing x0E x0F:" + (String)hexString));
                hexString = ((String)hexString).substring(2, ((String)hexString).length() - 2);
                logger.debug((Object)("After removing x0E x0F:" + (String)hexString));
                oldHexValue = new StringBuffer(aRecord.getHex());
                start = (aFieldInfo.getStart() - 1) * 2;
                end = start + ((String)hexString).length();
                byte[] newLength = DataUtilities.intToByteArray((int)(enteredValueLength /= 2));
                String hex = DataConversionUtils.getHexString((byte[])newLength).substring(4).toUpperCase();
                oldHexValue = oldHexValue.replace(start - 4, start, hex);
                if (start >= oldHexValue.length()) {
                    return MessageFormat.format(Messages.FormattedPageUtility_REPLACE_ERR1, start, end, FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo));
                }
                if (end > (aFieldInfo.getStart() - 1 + aSymbol.getLength()) * 2) break block11;
                StringBuffer newHexValue = oldHexValue.replace(start, end, (String)hexString);
                aRecord.setHex(newHexValue.toString());
                return null;
            }
            catch (Exception e) {
                String errMsg = MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR, FormattedPageUtility.getEncodingForField(aSymbol, aResource), newValue);
                logger.error((Object)errMsg, (Throwable)e);
                return errMsg;
            }
        }
        end = oldHexValue.length() - 1;
        StringBuffer newHexValue = oldHexValue.replace(start, end, (String)hexString);
        aRecord.setHex(newHexValue.toString());
        return null;
    }

    public static String getANValue(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, boolean unMaskCharacters, IZRL aResource) {
        return FormattedPageUtility.getANValue(props, aRecord, aSymbol, aField, aFieldInfo, unMaskCharacters, aResource, 0);
    }

    public static String getANValue(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, boolean unMaskCharacters, IZRL aResource, int offset) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
        int start = ((aField.isSetStart() ? aField.getStart() + offset : aSymbol.getStart() + offset) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        if (start < 0) {
            start = 0;
        }
        Object hexValue = "";
        hexValue = start < aRecord.getHex().length() ? (end < aRecord.getHex().length() ? aRecord.getHex().substring(start, end) : aRecord.getHex().substring(start)) : "";
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            hexValue = "0E" + (String)hexValue + "0F";
        } else if (TypeType.G.equals((Object)aSymbol.getType())) {
            hexValue = "0E" + (String)hexValue + "0F";
        }
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            if (unMaskCharacters) {
                return new String(byteValue, encoding);
            }
            return new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", "\uff0e");
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, hexValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    public static String getPliVCValue(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            return FormattedPageUtility.getPliVCValueDBCS(props, aRecord, aSymbol, aField, aFieldInfo, aResource, includeEndMarker);
        }
        return FormattedPageUtility.getPliVCValueNoneDBCS(props, aRecord, aSymbol, aField, aFieldInfo, aResource, includeEndMarker);
    }

    public static String getVCValue(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            return FormattedPageUtility.getVCValueDBCS(props, editorOptions, aRecord, aSymbol, aField, aFieldInfo, aResource, includeEndMarker);
        }
        return FormattedPageUtility.getVCValueNoneDBCS(props, editorOptions, aRecord, aSymbol, aField, aFieldInfo, aResource, includeEndMarker);
    }

    private static String getPliVCValueNoneDBCS(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        int start = ((aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        String hexVarcharLenValue = aRecord.getHex().substring(start - 4, start);
        int hexVarcharLen = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexVarcharLenValue));
        String hexValue = "";
        hexValue = start < aRecord.getHex().length() ? (end < aRecord.getHex().length() ? aRecord.getHex().substring(start, end) : aRecord.getHex().substring(start)) : "";
        hexValue = hexValue.substring(0, hexVarcharLen * 2);
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            String value = new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
            return value;
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, byteValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    private static String getVCValueNoneDBCS(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        int start = ((aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        String hexVarcharLenValue = aRecord.getHex().substring(start - 4, start);
        int hexVarcharLen = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexVarcharLenValue));
        String hexValue = "";
        hexValue = start < aRecord.getHex().length() ? (end < aRecord.getHex().length() ? aRecord.getHex().substring(start, end) : aRecord.getHex().substring(start)) : "";
        hexValue = hexValue.substring(0, hexVarcharLen * 2);
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            Object value = new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
            if (((String)value).length() < fieldMaxLen) {
                String endChar = editorOptions.getDVCDELIM();
                if (endChar == null || endChar.isEmpty()) {
                    endChar = "<";
                }
                if (!editorOptions.getSHWENDVC()) {
                    endChar = "";
                }
                if (includeEndMarker) {
                    value = (String)value + endChar;
                }
            }
            return value;
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, byteValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    private static String getPliVCValueDBCS(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        int start = ((aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        String hexVarcharLenValue = aRecord.getHex().substring(start - 4, start);
        int hexVarcharLen = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexVarcharLenValue));
        Object hexValue = "";
        hexValue = start < aRecord.getHex().length() ? (end < aRecord.getHex().length() ? aRecord.getHex().substring(start, end) : aRecord.getHex().substring(start)) : "";
        hexValue = ((String)hexValue).substring(0, hexVarcharLen * 2 * 2);
        hexValue = "0E" + (String)hexValue + "0F";
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            String value = new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
            return value;
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, byteValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    private static String getVCValueDBCS(FMEditSessionProperties props, Db2EditorOptions editorOptions, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, IZRL aResource, boolean includeEndMarker) {
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        String encoding = FormattedPageUtility.getEncodingForField(aSymbol, aResource);
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        int start = ((aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        String hexVarcharLenValue = aRecord.getHex().substring(start - 4, start);
        int hexVarcharLen = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexVarcharLenValue));
        Object hexValue = "";
        hexValue = start < aRecord.getHex().length() ? (end < aRecord.getHex().length() ? aRecord.getHex().substring(start, end) : aRecord.getHex().substring(start)) : "";
        hexValue = ((String)hexValue).substring(0, hexVarcharLen * 2 * 2);
        hexValue = "0E" + (String)hexValue + "0F";
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            Object value = new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
            if (((String)value).length() < fieldMaxLen) {
                String endChar = editorOptions.getDVCDELIM();
                if (endChar == null || endChar.isEmpty()) {
                    endChar = "<";
                }
                if (!editorOptions.getSHWENDVC()) {
                    endChar = "";
                }
                if (includeEndMarker) {
                    value = (String)value + endChar;
                }
            }
            return value;
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, byteValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    public static String getHexHighOrLowValue(FMEditSessionProperties props, HexRecordWrapper aHexWrap, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo) {
        String highOrLowHexValue;
        Objects.requireNonNull(aHexWrap, "Must specify a non-null aHexWrap.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aHexWrap.getRecord(), aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        int start = (aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1;
        if (start < 0) {
            start = 0;
        }
        if (start >= (highOrLowHexValue = aHexWrap.getEntireHighOrLowHexString()).length()) {
            return "";
        }
        if (start + fieldMaxLen <= highOrLowHexValue.length()) {
            return highOrLowHexValue.substring(start, start + fieldMaxLen);
        }
        return highOrLowHexValue.substring(start);
    }

    public static String getHexHighOrLowValueVC(FMEditSessionProperties props, HexRecordWrapper aHexWrap, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo) {
        int max;
        Objects.requireNonNull(aHexWrap, "Must specify a non-null aHexWrap.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aHexWrap.getRecord(), aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return "";
        }
        int start = (aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1;
        String highOrLowHexValue = aHexWrap.getEntireHighOrLowHexString();
        String hexVarcharLenValue = aHexWrap.getRecord().getHex().substring(start * 2 - 4, start * 2);
        int hexVarcharLen = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexVarcharLenValue));
        int n = max = hexVarcharLen < fieldMaxLen ? hexVarcharLen : fieldMaxLen;
        if (start >= highOrLowHexValue.length()) {
            return "";
        }
        if (start + max <= highOrLowHexValue.length()) {
            return highOrLowHexValue.substring(start, start + max);
        }
        return highOrLowHexValue.substring(start);
    }

    public static void setHexHighOrLowValue(FMEditSessionProperties props, HexRecordWrapper aHexWrap, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, String newHexHighOrLowValue) {
        Objects.requireNonNull(aHexWrap, "Must specify a non-null aHexWrap.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aHexWrap.getRecord(), aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return;
        }
        int start = (aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1;
        StringBuilder high = new StringBuilder();
        StringBuilder low = new StringBuilder();
        aHexWrap.prepareHighAndLow(high, low);
        FormattedPageUtility.appendHighAndLowIfRequired(high, low, start, fieldMaxLen);
        if (aHexWrap.isHighBits()) {
            high.replace(start, start + fieldMaxLen, newHexHighOrLowValue);
        } else {
            low.replace(start, start + fieldMaxLen, newHexHighOrLowValue);
        }
        aHexWrap.setHighAndLowHexValues(high.toString(), low.toString());
    }

    public static void setHexHighOrLowValueVC(FMEditSessionProperties props, HexRecordWrapper aHexWrap, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo, String newHexHighOrLowValue) {
        Objects.requireNonNull(aHexWrap, "Must specify a non-null aHexWrap.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aHexWrap.getRecord(), aSymbol, aFieldInfo);
        if (fieldMaxLen == -1 || fieldMaxLen == 0) {
            return;
        }
        fieldMaxLen = newHexHighOrLowValue.length() < fieldMaxLen ? newHexHighOrLowValue.length() : fieldMaxLen;
        int start = (aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1;
        StringBuilder high = new StringBuilder();
        StringBuilder low = new StringBuilder();
        aHexWrap.prepareHighAndLow(high, low);
        FormattedPageUtility.appendHighAndLowIfRequired(high, low, start, fieldMaxLen);
        if (aHexWrap.isHighBits()) {
            high.replace(start, start + fieldMaxLen, newHexHighOrLowValue);
        } else {
            low.replace(start, start + fieldMaxLen, newHexHighOrLowValue);
        }
        aHexWrap.setHighAndLowHexValues(high.toString(), low.toString());
        try {
            byte[] newLength = DataUtilities.intToByteArray((int)newHexHighOrLowValue.length());
            String hex = DataConversionUtils.getHexString((byte[])newLength).substring(4).toUpperCase();
            StringBuffer oldHexValue = new StringBuffer(aHexWrap.getRecord().getHex());
            oldHexValue = oldHexValue.replace(start * 2 - 4, start * 2, hex);
            aHexWrap.getRecord().setHex(oldHexValue.toString());
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown while setting VARCHAR length field.", (Throwable)e);
        }
    }

    private static void appendHighAndLowIfRequired(StringBuilder high, StringBuilder low, int start, int length) {
        Objects.requireNonNull(high, "Must specify a non-null high StringBuilder.");
        if (start + length < high.length()) {
            return;
        }
        int i = 0;
        while (i < start + length - high.length()) {
            high.append('0');
            low.append('0');
            ++i;
        }
    }

    public static int getFieldMaxLen(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, HdrfldType aHeader) {
        int recMax;
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        Objects.requireNonNull(aRecord, "Must specify a non-null aRecord.");
        Objects.requireNonNull(aHeader, "Must specify a non-null aHeader.");
        int start = aSymbol.isSetStart() ? aSymbol.getStart() : aHeader.getStart();
        int length = aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen();
        int n = recMax = props.isInplaceEdit() ? aRecord.getLen() : props.getMaxRECL();
        if (start > recMax) {
            return -1;
        }
        if (start - 1 + length <= recMax) {
            return length;
        }
        return recMax - start;
    }

    public static int getFieldMaxLen1(FMEditSessionProperties props, RecType aRecord, FieldType aField, HdrfldType aHeader) {
        int recMax;
        Objects.requireNonNull(aField, "Must specify a non-null aField.");
        int start = aField.isSetStart() ? aField.getStart() : aHeader.getStart();
        int length = aField.isSetLen() ? aField.getLen() : aHeader.getLen();
        int n = recMax = props.isInplaceEdit() ? aRecord.getLen() : props.getMaxRECL();
        if (start > recMax) {
            return -1;
        }
        if (start - 1 + length <= recMax) {
            return length;
        }
        return recMax - start;
    }

    public static int getFieldMinLength(FMEditSessionProperties props, RecType aRecord, Symboltype aSymbol, HdrfldType aHeader) {
        Objects.requireNonNull(props, "Must specify a non-null props.");
        int fieldMaxLen = FormattedPageUtility.getFieldMaxLen(props, aRecord, aSymbol, aHeader);
        if (props.isFixedLen()) {
            return fieldMaxLen;
        }
        return Math.min(fieldMaxLen, props.getMinRECL());
    }

    public static void hexEntryTextValue(VerifyEvent e) {
        Objects.requireNonNull(e, "Must specify a non-null VerifyEvent.");
        switch (e.keyCode) {
            case 0: {
                if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(e.text).matches()) {
                    e.text = e.text.toUpperCase();
                    e.doit = true;
                    break;
                }
                e.doit = false;
                break;
            }
            case 8: 
            case 13: 
            case 127: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                e.doit = true;
                break;
            }
            default: {
                String value = "" + e.character;
                if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(value.toUpperCase()).matches()) {
                    e.text = value.toUpperCase();
                    e.doit = true;
                    break;
                }
                e.doit = false;
            }
        }
    }

    public static void digitEntryTextValue(VerifyEvent e) {
        Objects.requireNonNull(e, "Must specify a non-null VerifyEvent.");
        switch (e.keyCode) {
            case 0: {
                if (FormattedEditorUtility.DIGIT_CHARACTERS_REGEXP.matcher(e.text).matches()) {
                    e.doit = true;
                    break;
                }
                e.doit = false;
                break;
            }
            case 8: 
            case 13: 
            case 127: 
            case 0x1000003: 
            case 0x1000004: 
            case 0x1000007: 
            case 0x1000008: {
                e.doit = true;
                break;
            }
            default: {
                String value = "" + e.character;
                if (FormattedEditorUtility.DIGIT_CHARACTERS_REGEXP.matcher(value.toUpperCase()).matches()) {
                    e.text = value.toUpperCase();
                    e.doit = true;
                    break;
                }
                e.doit = false;
            }
        }
    }

    public static boolean isDb2Nullfield(FormattedEditor editor2, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        return FormattedPageUtility.isDb2Nullfield(editor2.getSessionIdentifier().getSessionType(), aRecord, aSymbol, aField, aFieldInfo);
    }

    public static boolean isDb2Nullfield(AbstractSessionFormatted.SessionType aType, RecType aRecord, Symboltype aSymbol, FieldType aField, HdrfldType aFieldInfo) {
        if (!FormattedPageUtility.isDb2NullableField(aType, aSymbol)) {
            return false;
        }
        int nullIndicatorOffset = 4;
        if (aSymbol.getCreate() == CreateType.VC) {
            nullIndicatorOffset = 8;
        }
        int start = ((aField.isSetStart() ? aField.getStart() : aSymbol.getStart()) - 1) * 2;
        String hexNullIndicatorValue = aRecord.getHex().substring(start - nullIndicatorOffset, start);
        int nullIndicator = DataUtilities.byteArrayToShort((byte[])DataConversionUtils.getEBCDICData((String)hexNullIndicatorValue));
        return nullIndicator != 0;
    }

    public static boolean isDb2NullableField(FormattedEditor editor2, Symboltype aSymbol) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (editor2.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            return false;
        }
        return aSymbol.isNull();
    }

    public static boolean isDb2NullableField(AbstractSessionFormatted.SessionType aType, Symboltype aSymbol) {
        if (aType != AbstractSessionFormatted.SessionType.DB2) {
            return false;
        }
        return aSymbol.isNull();
    }

    public static String updateDb2NullableFieldIfRequired(FormattedEditor editor2, String newValue, Symboltype aSymbol, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, boolean includeEndMarker) {
        int nullIndicatorOffset;
        int start;
        StringBuffer oldHexValue;
        block8: {
            try {
                String NULL_INDICATOR = editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getNULLIND();
                boolean CONVERT_SPACE_TO_NULL = editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getCNVSPNUL();
                oldHexValue = new StringBuffer(aRecord.getHex());
                start = (aFieldInfo.getStart() - 1) * 2;
                nullIndicatorOffset = 4;
                if (aSymbol.getCreate() == CreateType.VC) {
                    nullIndicatorOffset = 8;
                }
                if (newValue.trim().equals(NULL_INDICATOR) || CONVERT_SPACE_TO_NULL && newValue.trim().isEmpty()) {
                    byte[] indicatorBytes = DataUtilities.intToByteArray((int)1);
                    String hex = DataConversionUtils.getHexString((byte[])indicatorBytes).substring(4).toUpperCase();
                    oldHexValue = oldHexValue.replace(start - nullIndicatorOffset, start - nullIndicatorOffset + hex.length(), hex);
                    aRecord.setHex(oldHexValue.toString());
                    aRecord.setChg(true);
                    aRecord.updateOnHostRequired(true);
                    editor2.setDirty(true);
                    aField.setFieldUpdatedLocally(true, false);
                    if (aSymbol.getCreate() == CreateType.VC) {
                        String result = FormattedPageUtility.updateVCHexValue(editor2.getSessionProperties(), editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), aRecord, aField, aFieldInfo, editor2.getCurrentTemplate(), newValue, aSymbol, editor2.getResource());
                        aField.setValue(NULL_INDICATOR);
                        return result;
                    }
                    String result = FormattedPageUtility.updateHexValue(editor2.getSessionProperties(), aRecord, aField, aFieldInfo, editor2.getCurrentTemplate(), newValue, editor2.getResource(), aSymbol);
                    aField.setValue(NULL_INDICATOR);
                    return result;
                }
                String originalValue = FormattedPageUtility.getDb2OriginalValue(editor2, aSymbol, aRecord, aField, aFieldInfo, includeEndMarker);
                if (!originalValue.equals(newValue)) break block8;
                return null;
            }
            catch (Exception e) {
                String errMsg = Messages.FormattedPage_SetNullErr;
                logger.error((Object)errMsg, (Throwable)e);
                return errMsg;
            }
        }
        byte[] indicatorBytes = DataUtilities.intToByteArray((int)0);
        String hex = DataConversionUtils.getHexString((byte[])indicatorBytes).substring(4).toUpperCase();
        oldHexValue = oldHexValue.replace(start - nullIndicatorOffset, start - nullIndicatorOffset + hex.length(), hex);
        aRecord.setHex(oldHexValue.toString());
        aRecord.setChg(true);
        aRecord.updateOnHostRequired(true);
        editor2.setDirty(true);
        aField.setFieldUpdatedLocally(true, false);
        if (aSymbol.getCreate() == CreateType.VC) {
            return FormattedPageUtility.updateVCHexValue(editor2.getSessionProperties(), editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), aRecord, aField, aFieldInfo, editor2.getCurrentTemplate(), newValue, aSymbol, editor2.getResource());
        }
        if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
            return FormattedPageUtility.updateHexValue(editor2.getSessionProperties(), aRecord, aField, aFieldInfo, editor2.getCurrentTemplate(), newValue, editor2.getResource(), aSymbol);
        }
        aField.setValue(newValue);
        return null;
    }

    private static String getDb2OriginalValue(FormattedEditor editor2, Symboltype aSymbol, RecType aRecord, FieldType aField, HdrfldType aFieldInfo, boolean includeEndMarker) {
        if (FormattedPageUtility.isDb2Nullfield(editor2, aRecord, aSymbol, aField, aFieldInfo)) {
            return editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getDNULLIND();
        }
        if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
            return FormattedPageUtility.getANValue(editor2.getSessionProperties(), aRecord, aSymbol, aField, aFieldInfo, false, editor2.getResource(), editor2.getSessionIdentifier().getEditorOffset());
        }
        if (aSymbol.getCreate() == CreateType.VC) {
            return FormattedPageUtility.getVCValue(editor2.getSessionProperties(), editor2.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), aRecord, aSymbol, aField, aFieldInfo, editor2.getResource(), includeEndMarker);
        }
        if (aField.isSetError() || aField.isError()) {
            if ("".equals(aField.getValue())) {
                String errStr = "*";
                int len = aSymbol.isSetLength() ? aSymbol.getLength() : aFieldInfo.getLen();
                errStr = FormattedEditorUtility.addPaddingForString(errStr, len, '*');
                return errStr;
            }
            return aField.getValue();
        }
        return aField.getValue();
    }

    public static String getEncodingForField(Symboltype aSymbol, IZRL aResource) {
        String ccsid;
        if (aResource.getSystem().supports((PDFeature)FMFeature.TEMPLATE_FIELD_CCSID) && (ccsid = aSymbol.getCcsid()) != null) {
            String javaEncoding = EncodingMappingList.INSTANCE.getJavaEncoding(ccsid);
            if (javaEncoding == null) {
                FormattedPageUtility.reportEncodingError(aSymbol, aResource, MessageFormat.format("No encoding defined for CCSID: {0}", ccsid));
            } else if (!Charset.isSupported(javaEncoding)) {
                FormattedPageUtility.reportEncodingError(aSymbol, aResource, MessageFormat.format("Encoding is not supported: {0}", javaEncoding));
            } else {
                return javaEncoding;
            }
        }
        String encoding = aResource.getPersistentProperty("encoding");
        String fieldEncoding = aSymbol.getEncoding();
        if (fieldEncoding != null && fieldEncoding.length() > 0) {
            if (Charset.isSupported(fieldEncoding)) {
                encoding = fieldEncoding;
            } else if (DBCS_ENCODING.equalsIgnoreCase(fieldEncoding)) {
                encoding = aResource.getPersistentProperty("dbcsEncoding");
            }
        }
        return encoding;
    }

    private static void reportEncodingError(Symboltype aSymbol, IZRL aResource, String errMsg) {
        HashSet<Object> errSet;
        if (encodingErrorList == null) {
            encodingErrorList = new HashMap();
        }
        if ((errSet = encodingErrorList.get(aResource)) == null) {
            errSet = new HashSet();
            encodingErrorList.put(aResource, errSet);
            errSet.add(aSymbol);
            logger.error((Object)errMsg);
            return;
        }
        if (errSet.contains(aSymbol)) {
            return;
        }
        errSet.add(aSymbol);
        logger.error((Object)errMsg);
    }

    public static void clearEncodingErrors(IZRL aResource) {
        if (encodingErrorList == null) {
            return;
        }
        encodingErrorList.remove(aResource);
    }

    public static boolean performLocalStrProc(Symboltype aSymbol) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (aSymbol.getDatetime() != null) {
            return false;
        }
        if (aSymbol.getCreate().equals((Object)CreateType.AN) && aSymbol.getType() == TypeType.AN) {
            return true;
        }
        if (aSymbol.getCreate().equals((Object)CreateType.AN) && aSymbol.getType() == TypeType.G) {
            return true;
        }
        if (aSymbol.getCreate().equals((Object)CreateType.AN) && aSymbol.getDb2typ() != null) {
            return true;
        }
        if (aSymbol.getType() == TypeType.ZA || aSymbol.getType() == TypeType.ZE) {
            return true;
        }
        return aSymbol.getType() == TypeType.FE;
    }

    public static boolean performAnVcStrProc(Symboltype aSymbol) {
        Objects.requireNonNull(aSymbol, "Must specify a non-null aSymbol.");
        if (aSymbol.getDatetime() != null) {
            return false;
        }
        return aSymbol.getCreate().equals((Object)CreateType.AN) && aSymbol.getType() == TypeType.VC;
    }
}

