/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.formatted;

import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.ShadowLine;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.BidiCharsetUtils;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;

public class FormattedPageCellLabelProvider
extends StyledCellLabelProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private HdrfldType columnInfo = null;
    private int columnIndex = 0;

    public FormattedPageCellLabelProvider(FormattedEditor editor2, HdrfldType columnInfo, int columnIndex) {
        super(1);
        this.editor = editor2;
        this.columnInfo = columnInfo;
        this.columnIndex = columnIndex;
    }

    public void update(ViewerCell cell) {
        if (!(cell.getElement() instanceof DisplayLine)) {
            return;
        }
        DisplayLine dl = (DisplayLine)cell.getElement();
        RecType aRec = dl.getRecord();
        if (dl instanceof ShadowLine) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        if (dl instanceof HexRecordWrapper && ((HexRecordWrapper)dl).getDisplayLine() instanceof ShadowLine) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        if (dl instanceof ShadowGroup) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        if (dl instanceof HexRecordWrapper && ((HexRecordWrapper)dl).getDisplayLine() instanceof ShadowGroup) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        Symboltype aSymbol = FormattedPageUtility.getSymbol(aRec, this.columnInfo, this.editor.getCurrentTemplate());
        FieldType aField = FormattedPageUtility.getField(aRec, this.columnIndex);
        if (aField == null) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        if (aSymbol.getCreate() == CreateType.NA) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
            return;
        }
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, this.columnInfo);
        if (maxFieldLen == -1) {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            return;
        }
        if (aField.isSetError() || aField.isSetInerror()) {
            cell.setBackground(FormattedEditorPreferencePage.getLenErrTextBackgroundColor());
            cell.setForeground(FormattedEditorPreferencePage.getLenErrTextForegroundColor());
        } else if (!FormattedPageUtility.checkFieldLength(this.editor.getSessionProperties(), dl.getRecord(), this.columnInfo, aField, this.editor.getCurrentTemplate())) {
            cell.setBackground(FormattedEditorPreferencePage.getLenErrTextBackgroundColor());
            cell.setForeground(FormattedEditorPreferencePage.getLenErrTextForegroundColor());
        } else if (this.columnInfo.isKey() || aSymbol.isPkey() || aSymbol.isFkey()) {
            cell.setBackground(FormattedEditorPreferencePage.getHighlightColorBackground());
            cell.setForeground(FormattedEditorPreferencePage.getHighlightColor());
        } else {
            cell.setBackground(FormattedEditorPreferencePage.getTextBackgroundColor());
            cell.setForeground(FormattedEditorPreferencePage.getTextForegroundColor());
        }
        if (aField.isSetFindhit() && aField.getFindhit() > 0) {
            cell.setBackground(FormattedEditorPreferencePage.getSearchMatchBackgroundColor());
        }
        if (dl instanceof HexRecordWrapper) {
            if (aSymbol.getCreate() == CreateType.VC) {
                cell.setForeground(FormattedEditorPreferencePage.getHexForegroundColor());
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                cell.setText(FormattedPageUtility.getHexHighOrLowValueVC(this.editor.getSessionProperties(), hrw, aSymbol, aField, this.columnInfo));
            } else {
                cell.setForeground(FormattedEditorPreferencePage.getHexForegroundColor());
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                cell.setText(FormattedPageUtility.getHexHighOrLowValue(this.editor.getSessionProperties(), hrw, aSymbol, aField, this.columnInfo));
            }
            cell.setText(PDBiDiHelpers.reverseIfVisualRTLRequired((IZRL)this.editor.getResource(), (String)cell.getText()));
        } else if (FormattedPageUtility.isDb2Nullfield(this.editor, aRec, aSymbol, aField, this.columnInfo)) {
            cell.setText(this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getDNULLIND());
        } else if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
            String value = FormattedPageUtility.getANValue(this.editor.getSessionProperties(), aRec, aSymbol, aField, this.columnInfo, false, this.editor.getResource(), this.editor.getSessionIdentifier().getEditorOffset());
            cell.setText(PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)value, (boolean)true));
            Table table = (Table)cell.getControl();
            if (BidiCharsetUtils.doesTextContainBidiCharacters((String)value)) {
                table.getColumn(cell.getColumnIndex()).setAlignment(131072);
            } else {
                table.getColumn(cell.getColumnIndex()).setAlignment(16384);
            }
            PDBiDiHelpers.ifNotVisualAndRTLRequiredUseRTLOrientation((IZRL)this.editor.getResource(), (Control)cell.getControl());
        } else if (FormattedPageUtility.performAnVcStrProc(aSymbol)) {
            String value = FormattedPageUtility.getPliVCValue(this.editor.getSessionProperties(), aRec, aSymbol, aField, this.columnInfo, this.editor.getResource(), true);
            cell.setText(PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)value, (boolean)true));
            PDBiDiHelpers.ifNotVisualAndRTLRequiredUseRTLOrientation((IZRL)this.editor.getResource(), (Control)cell.getControl());
        } else if (aSymbol.getCreate() == CreateType.VC) {
            String value = FormattedPageUtility.getVCValue(this.editor.getSessionProperties(), this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), aRec, aSymbol, aField, this.columnInfo, this.editor.getResource(), true);
            cell.setText(PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)value, (boolean)true));
            PDBiDiHelpers.ifNotVisualAndRTLRequiredUseRTLOrientation((IZRL)this.editor.getResource(), (Control)cell.getControl());
        } else if (aField.isSetError() || aField.isError()) {
            if ("".equals(aField.getValue())) {
                String errStr = "*";
                int len = aSymbol.isSetLength() ? aSymbol.getLength() : this.columnInfo.getLen();
                errStr = FormattedEditorUtility.addPaddingForString(errStr, len, '*');
                cell.setText(errStr);
            } else {
                cell.setText(aField.getValue());
            }
        } else {
            cell.setText(aField.getValue());
        }
        cell.setFont(FormattedEditorPreferencePage.getFontStyle());
        this.fillDisplayLineValues(cell, dl);
    }

    private void fillDisplayLineValues(ViewerCell cell, DisplayLine dl) {
        String key = String.valueOf(dl) + "-" + cell.getColumnIndex();
        if (!this.editor.getColNoToValuesMap().containsKey(key)) {
            this.editor.getColNoToValuesMap().put(key, cell.getText());
        }
    }

    public void paint(Event event, Object element) {
        DisplayLine dl;
        FieldType aField;
        if (element instanceof DisplayLine && (aField = FormattedPageUtility.getField((dl = (DisplayLine)element).getRecord(), this.columnIndex)) != null && !dl.getRecord().isWasSup() && aField.isSetFindhit() && aField.getFindhit() > 0) {
            GC gc = event.gc;
            gc.setBackground(FormattedEditorPreferencePage.getSearchMatchBackgroundColor());
            gc.fillRectangle(event.x, event.y, 1000, event.height);
        }
        super.paint(event, element);
    }
}

