/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.ScrollSupportStrategy;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.EmptyRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.ExcludedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.NotSelectedRecordsGroup;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.ShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordShadowLine;
import com.ibm.etools.fm.editor.formatted.contents.SuppressedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.handler.SortRecords;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.editor.formatted.operations.ValidateFormattedValuesdOperation;
import com.ibm.etools.fm.editor.formatted.pages.formatted.DummyFormattedPageCellLabelProvider;
import com.ibm.etools.fm.editor.formatted.pages.formatted.EncodedString;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedCellEditor;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedModePageTableContentProvider;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageCellLabelProvider;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageSelectionProvider;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.Db2SingleDisplay;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.bidi.BidiUtils;
import com.ibm.pdtools.common.component.bidi.ui.VisualField;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.util.BidiCharsetUtils;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.util.PDPlatformUIUtils;
import com.ibm.pdtools.common.component.ui.util.PDSafeUIRunner;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class FormattedPage
extends IFormattedEditorPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(FormattedPage.class);
    private static final String DATA_ERROR = "=DATA";
    private static final String LEN_ERROR = "=LGTH";
    private static final String SQL_ERROR = "=SQL ERROR: {0}";
    private static final String RECLEN_COL = "REC-LEN";
    private static final Image ERROR_IMAGE = JFaceResources.getImage((String)"dialog_message_error_image");
    private static final Image EXCLUDED_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/excluded_icon.gif");
    private static final Image SUPPRESSED_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/SuppressRecord_1.gif");
    private static final Image NOT_SELECTED_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/unselected_icon.gif");
    private static final Image CHANGED_RECORD_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/ChangedRecord.gif");
    private static final Image NEW_RECORD_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/NewRecord.gif");
    private static final Image EMPTY_RECORD_IMAGE = FMUIPlugin.getDefault().getImageRegistry().get("icons/UnselectedRecord_2.gif");
    private FormattedEditor editor = null;
    private TableViewer heldColumnTableViewer = null;
    private TableViewer otherColumnTableViewer = null;
    private TableCursor heldColumnTableCursor = null;
    private TableCursor otherColumntablCursor = null;
    private ControlEditor heldColumnTableControlEditor = null;
    private ControlEditor otherColumnTableControlEditor = null;
    private ArrayList<HdrfldType> heldColumns = null;
    private ArrayList<HdrfldType> otherColumns = null;
    private int maxShowColumns = 50;
    private int showFromColumnIndex;
    private int showFromHeldColumnIndexCur = -1;
    private int showFromOtherColumnIndexCur = -1;
    private AtomicReference<VisualField> visualFld = new AtomicReference();
    private FormattedPageSelectionProvider selectionProvider = null;
    private TraverseListener ignoreTraverseListener;
    private TableViewer hideOrOtherForRecLenViewer = null;
    private static Clipboard clipboard;
    private static String LTR_INPUT;
    private static String LTR_OUTPUT;
    private static int columnCount;
    private TableViewer viewer;
    Menu otherColumnMenu = null;
    Menu heldMenu = null;
    private EList<HdrfldType> keptHeaders = null;
    private HdrType keptHeader = null;
    private Layouttype keptLayout = null;
    private int keptCharWidth = 0;
    int totalHeldColumnsChar = 0;
    int totalHeldColumnsWidth = 0;
    int totalMainColumnsChar = 0;
    int totalMainColumnsWidth = 0;

    static {
        LTR_INPUT = "ILYNN";
        LTR_OUTPUT = "VRYNN";
        columnCount = 0;
    }

    public FormattedPage(FormattedEditor editor2, Composite parent, int showFromColumnIndex, int maxShowColumns) {
        this.editor = editor2;
        this.showFromColumnIndex = showFromColumnIndex;
        this.maxShowColumns = maxShowColumns;
        this.createControl(parent);
    }

    private void createControl(Composite p) {
        clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        SashForm editorComposite = new SashForm(p, 256);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        editorComposite.setLayoutData((Object)data);
        if (this.editor.getTemplateResource() == null || this.editor.getCurrentTemplate() == null) {
            return;
        }
        TemplateType template = this.editor.getCurrentTemplate();
        EList layouts = template.getLayout();
        Layouttype currentLayout = null;
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == this.editor.getActiveLayoutID()) {
                currentLayout = aLayout;
                break;
            }
            if (currentLayout == null && aLayout.isSel()) {
                currentLayout = aLayout;
            }
            ++i;
        }
        this.createTables((Composite)editorComposite, currentLayout);
        this.setTableContents();
        if (this.editor.getCurrentEditorContents().size() > 0) {
            SingleView.displayCurrentRecord(this.editor, this.editor.getCurrentEditorContents().get(0));
        }
        if (this.heldColumns == null || this.heldColumns.isEmpty()) {
            return;
        }
        editorComposite.setWeights(new int[]{40, 60});
    }

    private Control createTables(Composite parent, Layouttype aLayout) {
        HdrType header = this.editor.getCurrentTableHeader(aLayout.getId());
        if (header == null) {
            return null;
        }
        EList headers = header.getHdrfld();
        this.keptHeader = header;
        this.keptHeaders = headers;
        this.keptLayout = aLayout;
        this.heldColumns = new ArrayList();
        this.otherColumns = new ArrayList();
        this.prepareHeaders((EList<HdrfldType>)headers, this.heldColumns, this.otherColumns, aLayout);
        int charWidth = 0;
        this.totalHeldColumnsChar = 0;
        this.totalHeldColumnsWidth = 0;
        this.totalMainColumnsChar = 0;
        this.totalMainColumnsWidth = 0;
        MenuManager popupMenu = this.editor.getActionManager().getPopupMenu();
        if (this.heldColumns.size() > 0) {
            this.heldColumnTableViewer = new TableViewer(parent, 68354);
            Font font = FormattedEditorPreferencePage.getFontStyle();
            this.heldColumnTableViewer.getTable().setFont(font);
            this.heldColumnTableViewer.getTable().setHeaderVisible(true);
            this.heldColumnTableViewer.getTable().setLinesVisible(true);
            GC gc = new GC((Drawable)this.heldColumnTableViewer.getTable());
            gc.setFont(font);
            FontMetrics metrics = gc.getFontMetrics();
            this.keptCharWidth = charWidth = metrics.getAverageCharWidth();
            this.heldColumnTableViewer.setContentProvider((IContentProvider)new FormattedModePageTableContentProvider());
            this.createStatusColumn(parent, this.heldColumnTableViewer);
            this.hideOrOtherForRecLenViewer = this.heldColumnTableViewer;
            this.createRecordLengthColumn(parent, this.heldColumnTableViewer);
            FormattedPage.addTableKeyListener(this.heldColumnTableViewer);
            if (this.heldColumns.size() > 0) {
                this.addColumnsToHeldColumnTable(false);
            }
            this.otherColumnTableViewer = new TableViewer(parent, 68354);
            this.otherColumnTableViewer.getTable().setFont(font);
            this.otherColumnTableViewer.getTable().setHeaderVisible(true);
            this.otherColumnTableViewer.getTable().setLinesVisible(true);
            this.otherColumnTableViewer.setContentProvider((IContentProvider)new FormattedModePageTableContentProvider());
            if (this.otherColumns.size() > 0) {
                this.addColumnsToOtherColumnTable(false);
            } else {
                this.createDummyColumn(this.otherColumnTableViewer);
            }
            if (this.heldMenu == null) {
                this.heldMenu = popupMenu.createContextMenu((Control)this.heldColumnTableViewer.getTable());
            }
            FormattedPage.addTableKeyListener(this.otherColumnTableViewer);
            this.heldColumnTableViewer.getTable().setMenu(this.heldMenu);
        } else {
            this.otherColumnTableViewer = new TableViewer(parent, 68354);
            Font font = FormattedEditorPreferencePage.getFontStyle();
            this.otherColumnTableViewer.getTable().setFont(font);
            this.otherColumnTableViewer.getTable().setHeaderVisible(true);
            this.otherColumnTableViewer.getTable().setLinesVisible(true);
            GC gc = new GC((Drawable)this.otherColumnTableViewer.getTable());
            gc.setFont(font);
            FontMetrics metrics = gc.getFontMetrics();
            charWidth = metrics.getAverageCharWidth();
            gc.dispose();
            this.keptCharWidth = charWidth;
            this.otherColumnTableViewer.setContentProvider((IContentProvider)new FormattedModePageTableContentProvider());
            this.createStatusColumn(parent, this.otherColumnTableViewer);
            this.hideOrOtherForRecLenViewer = this.otherColumnTableViewer;
            this.createRecordLengthColumn(parent, this.otherColumnTableViewer);
            if (this.otherColumns.size() > 0) {
                this.addColumnsToOtherColumnTable(false);
            }
            FormattedPage.addTableKeyListener(this.otherColumnTableViewer);
        }
        if (this.otherColumnMenu == null) {
            this.otherColumnMenu = popupMenu.createContextMenu((Control)this.otherColumnTableViewer.getTable());
        }
        this.otherColumnTableViewer.getTable().setMenu(this.otherColumnMenu);
        this.editor.getSite().registerContextMenu(popupMenu, (ISelectionProvider)this.selectionProvider);
        this.addSelectionListeners();
        this.addScrollBarListeners();
        logger.debug((Object)("Average font width: " + charWidth));
        logger.debug((Object)("Number of held columns: " + this.heldColumns.size() + " total char: " + this.totalHeldColumnsChar + " total width: " + this.totalHeldColumnsWidth));
        logger.debug((Object)("Number of main columns: " + this.otherColumns.size() + " total char: " + this.totalMainColumnsChar + " total width: " + this.totalMainColumnsWidth));
        this.addTableCursor();
        this.prepareSelectionProvider();
        return parent;
    }

    private static void addTableKeyListener(final TableViewer viewer) {
        viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 99) {
                    ISelection selection = viewer.getSelection();
                    FormattedPage.copyContentsToClipboard(selection);
                }
            }
        });
    }

    public static void copyContentsToClipboard(ISelection selection) {
        if (selection != null && selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            List list = structuredSelection.toList();
            FormattedEditor editor2 = (FormattedEditor)PDPlatformUIUtils.editor.getActiveEditor();
            Object rows = "";
            int count = 1;
            int i = 0;
            while (i < list.size()) {
                Object row = "";
                int j = 1;
                while (j <= columnCount) {
                    DisplayLine line = (DisplayLine)list.get(i);
                    if (!(line instanceof ShadowGroup) && !(line instanceof ShadowLine)) {
                        if (j == 1) {
                            row = (String)row + String.format("%-10s", count);
                            ++count;
                        } else {
                            String key = String.valueOf(line) + "-" + j;
                            String value = editor2.getColNoToValuesMap().get(key);
                            if (value == null) {
                                value = "";
                            }
                            row = (String)row + String.format("%-20s", value);
                        }
                    }
                    ++j;
                }
                if (!((String)row).isEmpty()) {
                    rows = i == 0 ? (String)rows + (String)row : (String)rows + "\n" + (String)row;
                }
                ++i;
            }
            StringSelection data = new StringSelection((String)rows);
            clipboard.setContents(data, data);
        }
    }

    private void addColumnsToHeldColumnTable(boolean deleteColumnsFirst) {
        int showFromHeldColumnIndex = this.showFromColumnIndex;
        if (showFromHeldColumnIndex > this.getHeldColumnSize() - this.maxShowColumns) {
            showFromHeldColumnIndex = this.getHeldColumnSize() - this.maxShowColumns;
        }
        if (showFromHeldColumnIndex < 0) {
            showFromHeldColumnIndex = 0;
        }
        if (showFromHeldColumnIndex == this.showFromHeldColumnIndexCur) {
            return;
        }
        this.showFromHeldColumnIndexCur = showFromHeldColumnIndex;
        this.heldColumnTableViewer.getTable().setRedraw(false);
        if (deleteColumnsFirst) {
            int columnNo;
            while ((columnNo = this.heldColumnTableViewer.getTable().getColumnCount()) > 1) {
                this.heldColumnTableViewer.getTable().getColumns()[columnNo - 1].dispose();
            }
        }
        int i = 0;
        while (i < this.maxShowColumns) {
            int showIndex = i + showFromHeldColumnIndex;
            if (showIndex < this.getHeldColumnSize()) {
                HdrfldType aColumn = this.heldColumns.get(showIndex);
                Symboltype currentSymbol = this.getSymbol(this.keptLayout, aColumn.getSym());
                String columnName = (currentSymbol.getHeading() != null && currentSymbol.getHeading().length() > 0 ? currentSymbol.getHeading() : currentSymbol.getName(this.editor.getSystem())) + (aColumn.getDim() != null ? aColumn.getDim() : "");
                int columnWidth = Math.max(((HdrfldType)this.keptHeaders.get(showIndex)).getLen(), columnName.length()) * this.keptCharWidth + 20;
                if (currentSymbol.getCreate() == CreateType.AN || currentSymbol.getCreate() == CreateType.DT || currentSymbol.getCreate() == CreateType.VC) {
                    this.createAColumn(this.heldColumnTableViewer, currentSymbol, this.keptHeader, aColumn, columnName, columnWidth, showIndex + 1, 16384);
                } else {
                    this.createAColumn(this.heldColumnTableViewer, currentSymbol, this.keptHeader, aColumn, columnName, columnWidth, showIndex + 1, 131072);
                }
                this.totalHeldColumnsChar += columnName.length();
                this.totalHeldColumnsWidth += columnWidth;
            }
            ++i;
        }
        this.heldColumnTableViewer.getTable().setRedraw(true);
    }

    private void addColumnsToOtherColumnTable(boolean deleteColumnsFirst) {
        int showFromOtherColumnIndex = this.showFromColumnIndex - this.getHeldColumnSize();
        if (showFromOtherColumnIndex >= this.otherColumns.size()) {
            showFromOtherColumnIndex = this.otherColumns.size() - 1;
        }
        if (showFromOtherColumnIndex < 0) {
            showFromOtherColumnIndex = 0;
        }
        if (showFromOtherColumnIndex == this.showFromOtherColumnIndexCur) {
            return;
        }
        this.showFromOtherColumnIndexCur = showFromOtherColumnIndex;
        this.otherColumnTableViewer.getTable().setRedraw(false);
        if (deleteColumnsFirst) {
            int columnNo;
            int firstColumnNo = this.getHeldColumnSize() > 0 ? 0 : 2;
            while ((columnNo = this.otherColumnTableViewer.getTable().getColumnCount()) > firstColumnNo) {
                this.otherColumnTableViewer.getTable().getColumns()[columnNo - 1].dispose();
            }
            if (firstColumnNo == 0) {
                this.otherColumnTableViewer.getTable().clearAll();
            }
        }
        int i = 0;
        while (i < this.maxShowColumns) {
            int showIndex = i + showFromOtherColumnIndex;
            if (showIndex >= this.otherColumns.size()) break;
            HdrfldType aColumn = this.otherColumns.get(showIndex);
            Symboltype currentSymbol = this.getSymbol(this.keptLayout, aColumn.getSym());
            String columnName = (currentSymbol.getHeading() != null && currentSymbol.getHeading().length() > 0 ? currentSymbol.getHeading() : currentSymbol.getName(this.editor.getSystem())) + (aColumn.getDim() != null ? aColumn.getDim() : "");
            int columnWidth = Math.max(((HdrfldType)this.keptHeaders.get(showIndex)).getLen(), columnName.length()) * this.keptCharWidth + 20;
            if (currentSymbol.getCreate() == CreateType.AN || currentSymbol.getCreate() == CreateType.DT || currentSymbol.getCreate() == CreateType.VC) {
                this.createAColumn(this.otherColumnTableViewer, currentSymbol, this.keptHeader, aColumn, columnName, columnWidth, showIndex + 1 + this.getHeldColumnSize(), 16384);
            } else if (currentSymbol.getCreate() == CreateType.NU) {
                this.createAColumn(this.otherColumnTableViewer, currentSymbol, this.keptHeader, aColumn, columnName, columnWidth, showIndex + 1 + this.getHeldColumnSize(), 131072);
            } else {
                this.createAColumn(this.otherColumnTableViewer, currentSymbol, this.keptHeader, aColumn, columnName, columnWidth, showIndex + 1 + this.getHeldColumnSize(), 131072);
            }
            this.totalMainColumnsChar += columnName.length();
            this.totalMainColumnsWidth += columnWidth;
            ++i;
        }
        this.otherColumnTableViewer.getTable().setRedraw(true);
    }

    private void prepareSelectionProvider() {
        this.selectionProvider = new FormattedPageSelectionProvider();
        if (this.heldColumnTableViewer != null) {
            this.heldColumnTableViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        }
        this.otherColumnTableViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionProvider);
        this.editor.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
    }

    private void setSelection(int selectionIndex, TableViewer selectionSourceTable) {
        if (this.heldColumnTableViewer != null) {
            this.heldColumnTableViewer.getTable().setSelection(selectionIndex);
        }
        this.otherColumnTableViewer.getTable().setSelection(selectionIndex);
        if (selectionSourceTable == this.heldColumnTableViewer) {
            this.otherColumnTableViewer.getTable().setTopIndex(this.heldColumnTableViewer.getTable().getTopIndex());
        }
        if (selectionSourceTable == this.otherColumnTableViewer && this.heldColumnTableViewer != null) {
            this.heldColumnTableViewer.getTable().setTopIndex(this.otherColumnTableViewer.getTable().getTopIndex());
        }
    }

    private void prepareTableCursor(final TableViewer tableViewer) {
        final TableCursor cursor = new TableCursor(tableViewer.getTable(), 0);
        cursor.setFont(FormattedEditorPreferencePage.getFontStyle());
        final ControlEditor controlEditor = new ControlEditor((Composite)cursor);
        controlEditor.grabHorizontal = true;
        controlEditor.grabVertical = true;
        if (tableViewer == this.heldColumnTableViewer) {
            this.heldColumnTableCursor = cursor;
            this.heldColumnTableControlEditor = controlEditor;
        } else {
            this.otherColumntablCursor = cursor;
            this.otherColumnTableControlEditor = controlEditor;
        }
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableViewer.getTable().setSelection(new TableItem[]{cursor.getRow()});
                FormattedPage.this.setSelection(tableViewer.getTable().indexOf(cursor.getRow()), tableViewer);
                FormattedPage.this.selectionProvider.setSelection(tableViewer.getSelection());
                cursor.setBackground(cursor.getRow().getBackground(cursor.getColumn()));
                cursor.setToolTipText(null);
                int index = tableViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    DisplayLine dl = FormattedPage.this.editor.getCurrentEditorContents().get(index);
                    FormattedPage.this.setToolTipOnCursor(cursor, dl);
                    SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FormattedPage.this.openTextNonPrintCompatible(tableViewer, cursor, controlEditor);
            }
        });
        cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FormattedPage.this.openTextNonPrintCompatible(tableViewer, cursor, controlEditor);
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    FormattedPage.this.openTextNonPrintCompatible(tableViewer, cursor, controlEditor);
                    cursor.setMenu(null);
                } else {
                    cursor.setVisible(false);
                    cursor.setMenu(tableViewer.getTable().getMenu());
                }
            }
        });
        if (System.getenv("UI-Testing") != null) {
            tableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    FormattedPage.this.openTextNonPrintCompatible(tableViewer, cursor, controlEditor);
                }
            });
        }
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || (e.stateMask & 0x40000) != 0) {
                    cursor.setVisible(false);
                } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
                    int selectionIndex;
                    FormattedPage.this.editor.updateLocationInformation(-1);
                    int n = selectionIndex = tableViewer.getTable().getSelectionIndex() != -1 ? tableViewer.getTable().getSelectionIndex() : tableViewer.getTable().indexOf(cursor.getRow());
                    if (selectionIndex == 0) {
                        if (FormattedPage.this.editor.isNeedScrolling()) {
                            DisplayLine dl = FormattedPage.this.editor.getPreviousLine(false);
                            FormattedPage.this.editor.setNeedScrolling(false);
                            if (dl != null) {
                                SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                            }
                        } else {
                            FormattedPage.this.editor.setNeedScrolling(true);
                        }
                    } else {
                        FormattedPage.this.editor.setNeedScrolling(false);
                    }
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
                    int selectionIndex;
                    FormattedPage.this.editor.updateLocationInformation(-1);
                    int n = selectionIndex = tableViewer.getTable().getSelectionIndex() != -1 ? tableViewer.getTable().getSelectionIndex() : tableViewer.getTable().indexOf(cursor.getRow());
                    if (selectionIndex == tableViewer.getTable().getItemCount() - 1) {
                        if (FormattedPage.this.editor.isNeedScrolling()) {
                            DisplayLine dl = FormattedPage.this.editor.getNextLine(false);
                            FormattedPage.this.editor.setNeedScrolling(false);
                            if (dl != null) {
                                SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                            }
                        } else {
                            FormattedPage.this.editor.setNeedScrolling(true);
                        }
                    } else {
                        FormattedPage.this.editor.setNeedScrolling(false);
                    }
                } else if (!Character.isISOControl(e.character)) {
                    TableItem row = cursor.getRow();
                    int column = cursor.getColumn();
                    Text text2 = FormattedPage.this.getTextEditor((DisplayLine)row.getData(), column, tableViewer, cursor);
                    if (text2 != null && text2.getEditable()) {
                        text2.setText("" + e.character);
                        text2.setSelection(1, 1);
                        FormattedPage.this.editor.updateCursorLocation("0");
                        controlEditor.setEditor((Control)text2);
                        text2.setFocus();
                    }
                }
            }
        });
        cursor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    FormattedPage.this.moveCursor(e, cursor);
                }
            }
        });
        tableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                TableItem[] selection = tableViewer.getTable().getSelection();
                TableItem row = selection.length == 0 ? tableViewer.getTable().getItem(tableViewer.getTable().getTopIndex()) : selection[0];
                tableViewer.getTable().showItem(row);
                cursor.setSelection(row, 0);
                cursor.setBackground(cursor.getRow().getBackground(cursor.getColumn()));
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
    }

    private void openTextNonPrintCompatible(TableViewer tableViewer, TableCursor cursor, ControlEditor controlEditor) {
        int column;
        TableItem row = cursor.getRow();
        char[] charArray = row.getText(column = cursor.getColumn()).toCharArray();
        boolean containsNonPrintable = FormattedPage.searchForNonPrintables(charArray);
        if (containsNonPrintable && this.editor.isEditSession()) {
            final DisplayLine dl = (DisplayLine)row.getData();
            int fieldIndex = column + this.showFromColumnIndex;
            if (tableViewer == this.otherColumnTableViewer && this.heldColumnTableViewer != null) {
                fieldIndex += this.heldColumns.size() + 1;
            }
            final RecType record = dl.getRecord();
            HdrType headers = this.editor.getCurrentTableHeader(dl.getRecord().getId());
            HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex - 1);
            Symboltype aSymbol = FormattedPageUtility.getSymbol(record, (HdrfldType)this.editor.getCurrentTableHeader(record.getId()).getHdrfld().get(fieldIndex - 1), this.editor.getCurrentTemplate());
            final int len = aSymbol.getLength();
            final int start = aSymbol.getStart() - 1;
            final String encoding = FormattedPageUtility.getEncodingForField(aSymbol, this.editor.getResource());
            final FieldType aField = FormattedPageUtility.getField(record, fieldIndex);
            final StringBuilder hex2 = new StringBuilder(record.getHex());
            logger.trace((Object)MessageFormat.format("encoding= {0} fieldindex={1} symStart={2} symLength={3} record: {4}", encoding, fieldIndex, start, len, hex2.length()));
            int end = 2 * start + 2 * len;
            if (end > hex2.length()) {
                end = hex2.length();
            }
            final String hexBefore = hex2.substring(2 * start, end);
            PDSafeUIRunner.asyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    FormattedCellEditor ed = new FormattedCellEditor(EncodedString.createFromHexValues(hexBefore, Charset.forName(encoding)));
                    int open = ed.open();
                    if (open == 0) {
                        FormattedPage.updateRecordAndRefresh(FormattedPage.this.editor, dl, record, len, start, aField, hex2, ed);
                    }
                }
            });
        } else {
            this.openTextEditor(tableViewer, cursor, controlEditor);
        }
    }

    public static void updateRecordAndRefresh(FormattedEditor editor2, DisplayLine dl, RecType record, int len, int start, FieldType aField, StringBuilder hex2, FormattedCellEditor ed) {
        hex2.replace(2 * start, 2 * start + 2 * len, ed.getHex());
        record.setHex(hex2.toString());
        if (editor2.isHexMode()) {
            editor2.setHexMode(false);
            editor2.setHexMode(true);
        } else {
            editor2.setHexMode(true);
            editor2.setHexMode(false);
        }
        record.updateOnHostRequired(true);
        editor2.setDirty(true);
        aField.setFieldUpdatedLocally(true, false);
        SingleView.displayCurrentRecord(editor2, dl);
        editor2.refresh();
    }

    private void openTextEditor(TableViewer tableViewer, TableCursor cursor, ControlEditor controlEditor) {
        TableItem row = cursor.getRow();
        int column = cursor.getColumn();
        this.visualFld.set(null);
        Text text2 = this.getTextEditor((DisplayLine)row.getData(), column, tableViewer, cursor);
        if (text2 != null) {
            PDBiDiHelpers.prepareTextForEdit(this.visualFld, (IZRL)this.editor.getResource(), (String)row.getText(column), (Text)text2);
            this.editor.updateCursorLocation("0");
            controlEditor.setEditor((Control)text2);
            text2.setFocus();
        }
    }

    private void setToolTipOnCursor(TableCursor cursor, DisplayLine dl) {
        if (dl instanceof ExcludedRecordsShadowGroup) {
            String msg = ((ExcludedRecordsShadowGroup)dl).getMessage();
            String text2 = cursor.getRow().getText();
            if (text2.trim().equals(msg)) {
                cursor.setToolTipText(msg);
            }
        }
    }

    public static boolean searchForNonPrintables(char[] charArray) {
        boolean containsNonPrintable = false;
        char[] cArray = charArray;
        int n = charArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            int FULL_WIDTH_FULLSTOP = 65294;
            if (Character.isISOControl(c.charValue()) || c.charValue() == '\n' || c.charValue() == '\r' || c.charValue() == '\uff0e' || c.charValue() == '\ufffd') {
                containsNonPrintable = true;
                break;
            }
            ++n2;
        }
        return containsNonPrintable;
    }

    private void moveCursor(TraverseEvent te, TableCursor aCursor) {
        if (this.heldColumns.isEmpty()) {
            if ((te.stateMask & 0x20000) != 0) {
                this.moveCursorSimpleBackward(te, aCursor);
            } else {
                this.moveCursorSimpleForward(te, aCursor);
            }
        } else if ((te.stateMask & 0x20000) != 0) {
            this.moveCursorWithHeldColumnsBackward(te, aCursor);
        } else {
            this.moveCursorWithHeldColumnsForward(te, aCursor);
        }
    }

    private void moveCursorSimpleForward(TraverseEvent te, TableCursor aCursor) {
        int nextRowIndex;
        int nextColumnIndex;
        int columnPos = aCursor.getColumn();
        int rowIndex = this.otherColumnTableViewer.getTable().indexOf(this.otherColumntablCursor.getRow());
        boolean lastColumn = false;
        boolean lastRow = false;
        if (this.otherColumns.size() == columnPos) {
            lastColumn = true;
        }
        if (this.otherColumnTableViewer.getTable().getItemCount() - 1 == rowIndex) {
            lastRow = true;
        }
        if (lastColumn && lastRow) {
            te.doit = true;
            return;
        }
        te.doit = false;
        if (lastColumn) {
            nextColumnIndex = 0;
            nextRowIndex = rowIndex + 1;
            DisplayLine dl = this.editor.getNextLine(false);
            if (dl != null) {
                SingleView.displayCurrentRecord(this.editor, dl);
            }
        } else {
            nextColumnIndex = columnPos + 1;
            nextRowIndex = rowIndex;
        }
        aCursor.setSelection(nextRowIndex, nextColumnIndex);
        this.setSelectedLines(new int[]{nextRowIndex});
    }

    private void moveCursorSimpleBackward(TraverseEvent te, TableCursor aCursor) {
        int nextRowIndex;
        int nextColumnIndex;
        int columnPos = aCursor.getColumn();
        int rowIndex = this.otherColumnTableViewer.getTable().indexOf(this.otherColumntablCursor.getRow());
        boolean firstColumn = false;
        boolean firstRow = false;
        if (columnPos == 0) {
            firstColumn = true;
        }
        if (rowIndex == 0) {
            firstRow = true;
        }
        if (firstColumn && firstRow) {
            te.doit = true;
            return;
        }
        te.doit = false;
        if (firstColumn) {
            nextColumnIndex = this.otherColumns.size();
            nextRowIndex = rowIndex - 1;
            DisplayLine dl = this.editor.getPreviousLine(false);
            if (dl != null) {
                SingleView.displayCurrentRecord(this.editor, dl);
            }
        } else {
            nextColumnIndex = columnPos - 1;
            nextRowIndex = rowIndex;
        }
        aCursor.setSelection(nextRowIndex, nextColumnIndex);
        this.setSelectedLines(new int[]{nextRowIndex});
    }

    private void moveCursorWithHeldColumnsForward(TraverseEvent te, TableCursor aCursor) {
        if (aCursor == this.heldColumnTableCursor) {
            this.moveCursorWithHeldColumnsForwardHeld(te, aCursor);
        } else {
            this.moveCursorWithHeldColumnsForwardOther(te, aCursor);
        }
    }

    private void moveCursorWithHeldColumnsForwardHeld(TraverseEvent te, TableCursor aCursor) {
        te.doit = false;
        int columnPos = aCursor.getColumn();
        int rowIndex = this.heldColumnTableViewer.getTable().indexOf(aCursor.getRow());
        boolean lastColumn = false;
        if (columnPos == this.heldColumns.size()) {
            lastColumn = true;
        }
        this.setSelectedLines(new int[]{rowIndex});
        if (lastColumn) {
            aCursor.setVisible(false);
            this.otherColumntablCursor.setVisible(true);
            this.otherColumntablCursor.setSelection(rowIndex, 0);
            this.otherColumntablCursor.setFocus();
        } else {
            aCursor.setSelection(rowIndex, columnPos + 1);
        }
    }

    private void moveCursorWithHeldColumnsForwardOther(TraverseEvent te, TableCursor aCursor) {
        int columnPos = aCursor.getColumn();
        int rowIndex = this.otherColumnTableViewer.getTable().indexOf(aCursor.getRow());
        boolean lastColumn = false;
        boolean lastRow = false;
        if (columnPos == this.otherColumns.size() - 1) {
            lastColumn = true;
        }
        if (rowIndex == this.otherColumnTableViewer.getTable().getItemCount() - 1) {
            lastRow = true;
        }
        if (lastColumn && lastRow) {
            te.doit = true;
            return;
        }
        te.doit = false;
        if (lastColumn) {
            DisplayLine dl = this.editor.getNextLine(false);
            if (dl != null) {
                SingleView.displayCurrentRecord(this.editor, dl);
            }
            this.setSelectedLines(new int[]{rowIndex + 1});
            aCursor.setVisible(false);
            this.heldColumnTableCursor.setVisible(true);
            this.heldColumnTableCursor.setSelection(rowIndex + 1, 0);
            this.heldColumnTableCursor.setFocus();
        } else {
            this.setSelectedLines(new int[]{rowIndex});
            aCursor.setSelection(rowIndex, columnPos + 1);
        }
    }

    private void moveCursorWithHeldColumnsBackward(TraverseEvent te, TableCursor aCursor) {
        if (aCursor == this.heldColumnTableCursor) {
            this.moveCursorWithHeldColumnsBackwardHeld(te, aCursor);
        } else {
            this.moveCursorWithHeldColumnsBackwardOther(te, aCursor);
        }
    }

    private void moveCursorWithHeldColumnsBackwardHeld(TraverseEvent te, TableCursor aCursor) {
        int columnPos = aCursor.getColumn();
        int rowIndex = this.heldColumnTableViewer.getTable().indexOf(aCursor.getRow());
        boolean firstColumn = false;
        boolean firstRow = false;
        if (rowIndex == 0) {
            firstRow = true;
        }
        if (columnPos == 0) {
            firstColumn = true;
        }
        if (firstRow && firstColumn) {
            te.doit = true;
            return;
        }
        te.doit = false;
        if (firstColumn) {
            DisplayLine dl = this.editor.getPreviousLine(false);
            if (dl != null) {
                SingleView.displayCurrentRecord(this.editor, dl);
            }
            this.setSelectedLines(new int[]{rowIndex - 1});
            aCursor.setVisible(false);
            this.otherColumntablCursor.setVisible(true);
            this.otherColumntablCursor.setSelection(rowIndex - 1, this.otherColumns.size() - 1);
            this.otherColumntablCursor.setFocus();
        } else {
            this.setSelectedLines(new int[]{rowIndex});
            aCursor.setSelection(rowIndex, columnPos - 1);
        }
    }

    private void moveCursorWithHeldColumnsBackwardOther(TraverseEvent te, TableCursor aCursor) {
        te.doit = false;
        int columnPos = aCursor.getColumn();
        int rowIndex = this.otherColumnTableViewer.getTable().indexOf(aCursor.getRow());
        if (columnPos == 0) {
            this.setSelectedLines(new int[]{rowIndex});
            aCursor.setVisible(false);
            this.heldColumnTableCursor.setVisible(true);
            this.heldColumnTableCursor.setSelection(rowIndex, this.heldColumns.size());
            this.heldColumnTableCursor.setFocus();
        } else {
            this.setSelectedLines(new int[]{rowIndex});
            aCursor.setSelection(rowIndex, columnPos - 1);
        }
    }

    private Text getTextEditor(DisplayLine dl, int tableColumnIndex, TableViewer tableViewer, TableCursor cursor) {
        Text text2 = this.getTextEditor2(dl, tableColumnIndex += this.showFromColumnIndex, tableViewer, cursor);
        if (text2 == null) {
            return null;
        }
        if (!this.editor.isEditSession()) {
            text2.setEditable(false);
        }
        return text2;
    }

    private Text getTextEditor2(DisplayLine dl, int tableColumnIndex, TableViewer tableViewer, TableCursor cursor) {
        boolean isANField;
        if (dl instanceof ShadowLine || dl instanceof ShadowGroup) {
            logger.debug((Object)"Cannot edit shadowline!");
            return null;
        }
        if (this.heldColumns.isEmpty() ? tableColumnIndex == 0 || tableColumnIndex == 1 : tableViewer == this.heldColumnTableViewer && (tableColumnIndex == 0 || tableColumnIndex == 1)) {
            return null;
        }
        int fieldIndex = tableColumnIndex;
        fieldIndex = tableViewer == this.otherColumnTableViewer && this.heldColumnTableViewer != null ? (fieldIndex += this.heldColumns.size() + 1) : tableColumnIndex - 1;
        FieldType aField = FormattedPageUtility.getField(dl.getRecord(), fieldIndex);
        if (aField == null) {
            return null;
        }
        HdrType headers = this.editor.getCurrentTableHeader(dl.getRecord().getId());
        HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex - 1);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(dl.getRecord(), aHeader, this.editor.getCurrentTemplate());
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        int minFieldLen = FormattedPageUtility.getFieldMinLength(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        boolean bl = isANField = FormattedPageUtility.performLocalStrProc(aSymbol) || FormattedPageUtility.performAnVcStrProc(aSymbol) || aSymbol.getCreate() == CreateType.VC;
        if (minFieldLen < 0) {
            logger.debug((Object)"record too short to edit here...");
            return null;
        }
        if (aSymbol.getCreate() == CreateType.NA) {
            return null;
        }
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2 && !this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions().getUPKEY() && aSymbol.isPkey()) {
            return null;
        }
        logger.debug((Object)("Current column is at " + fieldIndex + ". start=" + (aHeader.isSetStart() ? aHeader.getStart() : aSymbol.getStart()) + " length=" + (aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen()) + " type=" + aSymbol.getType().getName()));
        if (dl instanceof HexRecordWrapper) {
            if (!isANField && aField.isFieldUpdatedLocally() && !aField.isFieldUpdatedByHex()) {
                return null;
            }
            Text text2 = new Text((Composite)cursor, 0);
            text2.setEditable(true);
            if (FormattedPageUtility.performLocalStrProc(aSymbol) || aSymbol.getCreate() == CreateType.VC) {
                text2.setTextLimit(maxFieldLen);
            }
            text2.setFont(FormattedEditorPreferencePage.getFontStyle());
            this.addOverwriteModeSupport(text2, tableViewer, cursor, true, false);
            if (!this.editor.isEditSession()) {
                text2.setEditable(false);
            }
            text2.addTraverseListener(this.traverseIgnoreListener());
            return text2;
        }
        if (!isANField && aField.isFieldUpdatedLocally() && aField.isFieldUpdatedByHex()) {
            return null;
        }
        Text text3 = new Text((Composite)cursor, 0);
        text3.setEditable(true);
        if (FormattedPageUtility.performLocalStrProc(aSymbol) || aSymbol.getCreate() == CreateType.VC) {
            text3.setTextLimit(maxFieldLen);
        } else {
            text3.setTextLimit(aHeader.getLen());
        }
        text3.setFont(FormattedEditorPreferencePage.getFontStyle());
        this.addOverwriteModeSupport(text3, tableViewer, cursor, false, isANField);
        if (!this.editor.isEditSession()) {
            text3.setEditable(false);
        }
        text3.addTraverseListener(this.traverseIgnoreListener());
        return text3;
    }

    private TraverseListener traverseIgnoreListener() {
        if (this.ignoreTraverseListener != null) {
            return this.ignoreTraverseListener;
        }
        this.ignoreTraverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 9) {
                    e.doit = false;
                }
            }
        };
        return this.ignoreTraverseListener;
    }

    private void addOverwriteModeSupport(final Text text2, final TableViewer tableViewer, final TableCursor cursor, final boolean addHexValidation, final boolean anField) {
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TableItem row = cursor.getRow();
                    int column = cursor.getColumn();
                    FormattedPage.this.setModifiedValue((DisplayLine)row.getData(), column + FormattedPage.this.showFromColumnIndex, PDBiDiHelpers.updateFieldValue((IZRL)FormattedPage.this.editor.getResource(), FormattedPage.this.visualFld, (String)text2.getText()), tableViewer);
                    text2.dispose();
                    FormattedPage.this.editor.updateCursorLocation(null);
                    tableViewer.refresh();
                } else if (e.keyCode == 0x1000009) {
                    FormattedPage.this.editor.setInsertMode(!FormattedPage.this.editor.isInsertMode());
                } else if (e.character == '\u001b') {
                    text2.dispose();
                    FormattedPage.this.editor.updateCursorLocation(null);
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.character != '\r' && e.keyCode != 0x1000009 && e.character != '\u001b') {
                    FormattedPage.this.editor.updateCursorLocation("" + text2.getCaretPosition());
                }
            }
        });
        text2.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent ve) {
                if (!Character.isISOControl(ve.character)) {
                    if (!anField && !FormattedPage.this.isValidChar(ve.character)) {
                        ve.doit = false;
                        return;
                    }
                    if (!FormattedPage.this.editor.isInsertMode()) {
                        if (text2.getSelectionCount() == 0) {
                            if (addHexValidation) {
                                String value = "" + ve.character;
                                if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(value).matches()) {
                                    int pos = text2.getCaretPosition();
                                    text2.setSelection(pos, pos + 1);
                                    ve.doit = true;
                                } else {
                                    ve.doit = false;
                                }
                            } else {
                                int pos = text2.getCaretPosition();
                                text2.setSelection(pos, pos + 1);
                            }
                        }
                    } else if (addHexValidation) {
                        FormattedPageUtility.hexEntryTextValue(ve);
                    }
                } else if (ve.keyCode == 0) {
                    if (addHexValidation) {
                        if (FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(ve.text).matches()) {
                            ve.text = ve.text.toUpperCase();
                            ve.doit = true;
                        } else {
                            ve.doit = false;
                        }
                    } else if (!anField && !FormattedPage.this.isValidChars(ve.text)) {
                        ve.doit = false;
                        return;
                    }
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){
            private TableItem gainedRow;
            private int gainedCol;

            public void focusGained(FocusEvent e) {
                this.gainedRow = cursor.getRow();
                this.gainedCol = cursor.getColumn();
            }

            public void focusLost(FocusEvent e) {
                String value = text2.getText();
                this.processVLTRBidiText(text2, value);
                FormattedPage.this.setModifiedValue((DisplayLine)this.gainedRow.getData(), this.gainedCol + FormattedPage.this.showFromColumnIndex, PDBiDiHelpers.updateFieldValue((IZRL)FormattedPage.this.editor.getResource(), FormattedPage.this.visualFld, (String)text2.getText()), tableViewer);
                text2.dispose();
                tableViewer.refresh();
            }

            private void processVLTRBidiText(Text text22, String value) {
                if (PDBiDiHelpers.isBidiVisualSupportRequired((IZRL)FormattedPage.this.editor.getResource()) && !PDBiDiHelpers.isRTLRequired((IZRL)FormattedPage.this.editor.getResource()) && text22.getTextDirection() == 0x4000000) {
                    value = BidiUtils.bidiTransform((String)value, (String)LTR_INPUT, (String)LTR_OUTPUT);
                    text22.setText(value);
                }
            }
        });
        text2.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FormattedPage.this.editor.updateCursorLocation("" + text2.getCaretPosition());
            }
        });
    }

    private boolean isValidChar(char c) {
        switch (c) {
            case '<': {
                return false;
            }
            case '>': {
                return false;
            }
            case '\"': {
                return false;
            }
            case '\'': {
                return false;
            }
            case '\\': {
                return false;
            }
            case '&': {
                return false;
            }
        }
        return true;
    }

    private boolean isValidChars(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!this.isValidChar(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void setModifiedValue(DisplayLine dl, int tableColumnIndex, String newValue, TableViewer tableViewer) {
        if (!this.editor.isEditSession()) {
            return;
        }
        if (dl instanceof ShadowLine | dl instanceof ShadowGroup) {
            logger.debug((Object)"Cannot update shadowline!");
            return;
        }
        int fieldIndex = tableColumnIndex;
        fieldIndex = tableViewer == this.otherColumnTableViewer && this.heldColumnTableViewer != null ? (fieldIndex += this.heldColumns.size() + 1) : tableColumnIndex - 1;
        FieldType aField = FormattedPageUtility.getField(dl.getRecord(), fieldIndex);
        if (aField == null) {
            logger.debug((Object)"No field to update..");
            return;
        }
        HdrType headers = this.editor.getCurrentTableHeader(dl.getRecord().getId());
        HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex - 1);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(dl.getRecord(), aHeader, this.editor.getCurrentTemplate());
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        int minFieldLen = FormattedPageUtility.getFieldMinLength(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        if (maxFieldLen == -1) {
            return;
        }
        logger.debug((Object)("Current column is at " + fieldIndex + ". start=" + (aHeader.isSetStart() ? aHeader.getStart() : aSymbol.getStart()) + " length=" + (aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen()) + " type=" + aSymbol.getType().getName()));
        if (aSymbol.getCreate() == CreateType.NA) {
            return;
        }
        if (dl instanceof HexRecordWrapper) {
            if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValueVC(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    FormattedPageUtility.setHexHighOrLowValueVC(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.editor.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            } else {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValue(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    if (hexValue.length() < minFieldLen) {
                        hexValue = FormattedEditorUtility.addPaddingForString(hexValue, minFieldLen, '0');
                    }
                    FormattedPageUtility.setHexHighOrLowValue(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.editor.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            }
        } else {
            String textValue = newValue;
            if (FormattedPageUtility.isDb2NullableField(this.editor, aSymbol)) {
                FormattedPageUtility.updateDb2NullableFieldIfRequired(this.editor, textValue, aSymbol, dl.getRecord(), aField, aHeader, true);
            } else if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getANValue(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, false, this.editor.getResource(), this.editor.getSessionIdentifier().getEditorOffset());
                if (PDBiDiHelpers.isBidiVisualSupportRequired((IZRL)this.editor.getResource())) {
                    oldTexValue = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)oldTexValue, (boolean)true);
                }
                if (!textValue.equals(oldTexValue)) {
                    String errMsg;
                    String newTextValue = textValue;
                    if (BidiCharsetUtils.doesTextContainBidiCharacters((String)newTextValue)) {
                        newTextValue = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)newTextValue, (boolean)true);
                    }
                    if ((errMsg = FormattedPageUtility.updateHexValue(this.editor.getSessionProperties(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), newTextValue, this.editor.getResource(), aSymbol)) != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (FormattedPageUtility.performAnVcStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getPliVCValue(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, this.editor.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.editor.getSessionProperties(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), textValue, this.editor.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String oldTexValue = FormattedPageUtility.getVCValue(this.editor.getSessionProperties(), this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aSymbol, aField, aHeader, this.editor.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateVCHexValue(this.editor.getSessionProperties(), this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), textValue, aSymbol, this.editor.getResource());
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (!textValue.equals(aField.getValue())) {
                aField.setValue(textValue);
                dl.getRecord().setChg(true);
                dl.getRecord().updateOnHostRequired(true);
                this.editor.setDirty(true);
                aField.setFieldUpdatedLocally(true, false);
            }
        }
        SingleView.displayCurrentRecord(this.editor, dl);
    }

    private void addTableCursor() {
        if (this.heldColumnTableViewer != null) {
            this.prepareTableCursor(this.heldColumnTableViewer);
            this.prepareTableCursor(this.otherColumnTableViewer);
        } else {
            this.prepareTableCursor(this.otherColumnTableViewer);
        }
    }

    private void addSelectionListeners() {
        if (this.heldColumnTableViewer != null) {
            this.heldColumnTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormattedPage.this.editor.updateLocationInformation(-1);
                    FormattedPage.this.otherColumnTableViewer.getTable().setSelection(FormattedPage.this.heldColumnTableViewer.getTable().getSelectionIndices());
                    int index = FormattedPage.this.heldColumnTableViewer.getTable().getSelectionIndex();
                    columnCount = FormattedPage.this.heldColumnTableViewer.getTable().getColumnCount();
                    FormattedPage.this.viewer = FormattedPage.this.heldColumnTableViewer;
                    if (index != -1) {
                        DisplayLine dl = FormattedPage.this.editor.getCurrentEditorContents().get(index);
                        SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                    }
                }
            });
            this.otherColumnTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormattedPage.this.editor.updateLocationInformation(-1);
                    FormattedPage.this.heldColumnTableViewer.getTable().setSelection(FormattedPage.this.otherColumnTableViewer.getTable().getSelectionIndices());
                    int index = FormattedPage.this.otherColumnTableViewer.getTable().getSelectionIndex();
                    columnCount = FormattedPage.this.otherColumnTableViewer.getTable().getColumnCount();
                    FormattedPage.this.viewer = FormattedPage.this.heldColumnTableViewer;
                    if (index != -1) {
                        DisplayLine dl = FormattedPage.this.editor.getCurrentEditorContents().get(index);
                        SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                    }
                }
            });
        } else {
            this.otherColumnTableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    FormattedPage.this.editor.updateLocationInformation(-1);
                    int index = FormattedPage.this.otherColumnTableViewer.getTable().getSelectionIndex();
                    columnCount = FormattedPage.this.otherColumnTableViewer.getTable().getColumnCount();
                    FormattedPage.this.viewer = FormattedPage.this.otherColumnTableViewer;
                    if (index != -1) {
                        DisplayLine dl = FormattedPage.this.editor.getCurrentEditorContents().get(index);
                        SingleView.displayCurrentRecord(FormattedPage.this.editor, dl);
                    }
                }
            });
        }
    }

    public void performSelectAll() {
        if (this.viewer != null) {
            this.viewer.getTable().selectAll();
        }
    }

    private void addScrollBarListeners() {
        if (this.heldColumnTableViewer != null) {
            final ScrollBar heldColumnScrollBar = this.heldColumnTableViewer.getTable().getVerticalBar();
            final ScrollBar otherColmnScrollBar = this.otherColumnTableViewer.getTable().getVerticalBar();
            heldColumnScrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FormattedPage.this.otherColumntablCursor.setVisible(false);
                    FormattedPage.this.otherColumnTableViewer.getTable().setTopIndex(FormattedPage.this.heldColumnTableViewer.getTable().getTopIndex());
                    ScrollSupportStrategy.handleScrollAction(FormattedPage.this.editor, heldColumnScrollBar, event);
                    FormattedPage.this.otherColumntablCursor.setVisible(true);
                }
            });
            this.heldColumnTableViewer.getTable().addMouseWheelListener(ScrollSupportStrategy.prepareMouseWheelListener(this.editor, heldColumnScrollBar));
            otherColmnScrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FormattedPage.this.heldColumnTableCursor.setVisible(false);
                    FormattedPage.this.heldColumnTableViewer.getTable().setTopIndex(FormattedPage.this.otherColumnTableViewer.getTable().getTopIndex());
                    ScrollSupportStrategy.handleScrollAction(FormattedPage.this.editor, otherColmnScrollBar, event);
                    FormattedPage.this.heldColumnTableCursor.setVisible(true);
                }
            });
            this.otherColumnTableViewer.getTable().addMouseWheelListener(ScrollSupportStrategy.prepareMouseWheelListener(this.editor, otherColmnScrollBar));
        } else {
            final ScrollBar otherColmnScrollBar = this.otherColumnTableViewer.getTable().getVerticalBar();
            otherColmnScrollBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ScrollSupportStrategy.handleScrollAction(FormattedPage.this.editor, otherColmnScrollBar, event);
                }
            });
            this.otherColumnTableViewer.getTable().addMouseWheelListener(ScrollSupportStrategy.prepareMouseWheelListener(this.editor, otherColmnScrollBar));
        }
    }

    private void prepareHeaders(EList<HdrfldType> headers, ArrayList<HdrfldType> heldColumnsTemp, ArrayList<HdrfldType> otherColumnsTemp, Layouttype aLayout) {
        int i = 0;
        while (i < headers.size()) {
            HdrfldType aHeader = (HdrfldType)headers.get(i);
            if (this.isHeldColumn(aHeader, aLayout)) {
                heldColumnsTemp.add(aHeader);
            } else {
                otherColumnsTemp.add(aHeader);
            }
            ++i;
        }
    }

    private boolean isHeldColumn(HdrfldType aHeader, Layouttype aLayout) {
        Symboltype currentSymbol = this.getSymbol(aLayout, aHeader.getSym());
        if (currentSymbol == null) {
            return false;
        }
        return currentSymbol.isSetHold();
    }

    private Symboltype getSymbol(Layouttype aLayout, int symID) {
        int levelInd = 0;
        String[] names = new String[50];
        EList symbols = aLayout.getSymbol();
        int i = 0;
        while (i < symbols.size()) {
            Symboltype aSymbol = (Symboltype)symbols.get(i);
            levelInd = aSymbol.getLvl() - 1;
            if (levelInd >= 0) {
                names[levelInd] = aSymbol.getName();
            }
            if (aSymbol.getRef() == symID) {
                if (levelInd >= 0 && aSymbol.getLongname() == null) {
                    String longName = names[0];
                    int j = 1;
                    while (j <= levelInd) {
                        longName = longName.concat("." + names[j]);
                        ++j;
                    }
                    aSymbol.setLongname(longName);
                }
                return aSymbol;
            }
            ++i;
        }
        return null;
    }

    private void createAColumn(TableViewer viewer, Symboltype aSymbol, HdrType aHeader, HdrfldType aHdrField, String columnName, int columnWidth, int fieldIndex, int alignment) {
        TableViewerColumn column = FormattedEditorUtility.createTableViewerColumn(columnName, columnWidth, viewer, alignment);
        FormattedPageCellLabelProvider cellLabelProvider = new FormattedPageCellLabelProvider(this.editor, aHdrField, fieldIndex);
        column.setLabelProvider((CellLabelProvider)cellLabelProvider);
        TableColumn aColumn = column.getColumn();
        Object tooltipText = "";
        if (this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            tooltipText = MessageFormat.format(Messages.FormattedPage_DB2_TYPE_TOOLTIP, aSymbol.getDb2typ(), aSymbol.getDb2col(), Db2SingleDisplay.keyStatusValue(aSymbol));
        } else {
            tooltipText = MessageFormat.format(Messages.FormattedPage_TYPE_TOOLTIP, aSymbol.getType().toString(), aHdrField.getStart(), aSymbol.isSetLength() ? aSymbol.getLength() : aHdrField.getLen(), aHdrField.getSym() - aHeader.getId() + 1);
            if (aSymbol.getLongname() != null && aSymbol.getLongname().length() > 0) {
                tooltipText = (String)tooltipText + "\n" + StringUtils.translate((String)aSymbol.getLongname(), (IPDHost)this.editor.getSystem());
            }
        }
        aColumn.setToolTipText((String)tooltipText);
        aColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (FormattedPage.this.editor.getSessionProperties().isAllRecdsLoaded()) {
                    SortRecords sortAction = new SortRecords();
                    sortAction.run(FormattedPage.this.editor);
                }
            }
        });
    }

    private void createDummyColumn(TableViewer viewer) {
        TableViewerColumn column = FormattedEditorUtility.createTableViewerColumn("", 100, viewer, 16384);
        DummyFormattedPageCellLabelProvider dummyCellLabelProvider = new DummyFormattedPageCellLabelProvider();
        column.setLabelProvider((CellLabelProvider)dummyCellLabelProvider);
    }

    private void createStatusColumn(Composite parent, TableViewer viewer) {
        TableViewerColumn column = FormattedEditorUtility.createTableViewerColumn("", 100, viewer, 131072);
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!(cell.getElement() instanceof DisplayLine)) {
                    return;
                }
                DisplayLine dl = (DisplayLine)cell.getElement();
                if (dl instanceof HexRecordWrapper) {
                    return;
                }
                RecType aRec = dl.getRecord();
                boolean sqlError = false;
                if (FormattedPage.this.editor.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2 && aRec.getSqlcode() != null && aRec.getSqlcode().trim().length() > 0) {
                    sqlError = true;
                }
                if (dl.getErrorList() != null || aRec.isSetDataError() || aRec.isSetLenError() || aRec.getSqlcode() != null && aRec.getSqlcode().trim().length() > 0) {
                    cell.setImage(ERROR_IMAGE);
                }
                if (aRec.isSetLenError()) {
                    cell.setText(aRec.getRecno() + " =LGTH");
                    cell.setForeground(FormattedEditorPreferencePage.getLenErrTextForegroundColor());
                    cell.setBackground(FormattedEditorPreferencePage.getLenErrTextBackgroundColor());
                } else if (aRec.isSetDataError()) {
                    cell.setText(aRec.getRecno() + " =DATA");
                } else if (sqlError) {
                    cell.setText(aRec.getRecno() + " " + MessageFormat.format(FormattedPage.SQL_ERROR, aRec.getSqlcode()));
                } else if (!(dl instanceof HexRecordWrapper)) {
                    cell.setText("" + aRec.getRecno());
                }
                if (dl instanceof NotSelectedRecordShadowLine) {
                    NotSelectedRecordShadowLine notSelLine = (NotSelectedRecordShadowLine)dl;
                    cell.setText(FormattedEditorUtility.getDescription(notSelLine, FormattedPage.this.editor));
                    if (aRec.isChg()) {
                        cell.setImage(CHANGED_RECORD_IMAGE);
                    } else {
                        cell.setImage(NOT_SELECTED_IMAGE);
                    }
                } else if (dl instanceof NotSelectedRecordsGroup) {
                    NotSelectedRecordsGroup notSelGroup = (NotSelectedRecordsGroup)dl;
                    cell.setText(notSelGroup.getMessage());
                    cell.setImage(NOT_SELECTED_IMAGE);
                } else if (dl instanceof ExcludedRecordsShadowGroup) {
                    cell.setText(((ExcludedRecordsShadowGroup)dl).getMessage());
                    cell.setImage(EXCLUDED_IMAGE);
                } else if (dl instanceof EmptyRecordsShadowGroup) {
                    cell.setText(((EmptyRecordsShadowGroup)dl).getMessage());
                    cell.setImage(EMPTY_RECORD_IMAGE);
                } else if (dl instanceof SuppressedRecordShadowLine) {
                    SuppressedRecordShadowLine suppLine = (SuppressedRecordShadowLine)dl;
                    cell.setText(FormattedEditorUtility.getDescription(suppLine, FormattedPage.this.editor));
                    if (aRec.isChg()) {
                        cell.setImage(CHANGED_RECORD_IMAGE);
                    } else {
                        cell.setImage(SUPPRESSED_IMAGE);
                    }
                } else if (dl instanceof SuppressedRecordsShadowGroup) {
                    SuppressedRecordsShadowGroup suppGroup = (SuppressedRecordsShadowGroup)dl;
                    cell.setText(FormattedEditorUtility.getDescription(suppGroup, FormattedPage.this.editor));
                    cell.setImage(SUPPRESSED_IMAGE);
                } else {
                    if (!aRec.isSetDataError() && aRec.isNew() && !sqlError) {
                        cell.setImage(NEW_RECORD_IMAGE);
                    } else if (!aRec.isSetDataError() && aRec.isChg() && !sqlError) {
                        cell.setImage(CHANGED_RECORD_IMAGE);
                    }
                    if (dl instanceof HexRecordWrapper) {
                        cell.setForeground(FormattedEditorPreferencePage.getHexForegroundColor());
                    }
                }
            }
        });
    }

    private void createRecordLengthColumn(Composite parent, TableViewer viewer) {
        TableViewerColumn column = FormattedEditorUtility.createTableViewerColumn(RECLEN_COL, 100, viewer, 131072);
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (!(cell.getElement() instanceof DisplayLine)) {
                    return;
                }
                DisplayLine dl = (DisplayLine)cell.getElement();
                RecType aRec = dl.getRecord();
                cell.setText("" + aRec.getLen());
            }
        });
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)true);
        this.hideShowRecLenCol();
    }

    @Override
    public void hideShowRecLenCol() {
        TableColumn[] columns = this.hideOrOtherForRecLenViewer.getTable().getColumns();
        TableColumn rulerCol = null;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.getText().equals(RECLEN_COL)) {
                rulerCol = column;
                break;
            }
            ++n2;
        }
        if (rulerCol != null) {
            boolean toggleState = (Boolean)this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").getValue();
            if (!toggleState) {
                rulerCol.setWidth(100);
                rulerCol.setResizable(true);
                this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)true);
            } else {
                rulerCol.setWidth(0);
                rulerCol.setResizable(false);
                this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)false);
            }
        }
    }

    public void resetToggleState() {
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)false);
    }

    private State getToggleState(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command toggleCommand = commandService.getCommand(commandId);
        State toggleState = toggleCommand.getState("org.eclipse.ui.commands.toggleState");
        return toggleState;
    }

    private ArrayList<RecType> getModifiedRecords() {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        ArrayList<RecType> recordsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && aLine.getRecord().isUpdateOnHostRequired()) {
                recordsToUpdate.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsToUpdate;
    }

    private ArrayList<RecType> getRecordsWithError() {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        ArrayList<RecType> recordsWithErrors = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            RecType aRec;
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && (aRec = aLine.getRecord()).isUpdateOnHostRequired() && (aRec.isSetDataError() || aRec.isDataError() || aRec.isSetLenError() || aRec.isLenError())) {
                recordsWithErrors.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsWithErrors;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 2049) {
            DisplayLine currentLine;
            int newIndexForSelection = -1;
            int[] selectedLines = this.getSelectedLines();
            if (selectedLines != null && selectedLines.length > 0) {
                int firstLine = selectedLines[0];
                newIndexForSelection = this.editor.isHexMode() ? firstLine * 3 : firstLine / 3;
            }
            this.setTableContents();
            if (newIndexForSelection != -1) {
                this.setSelectedLines(new int[]{newIndexForSelection});
            }
            if ((currentLine = this.editor.getCurrentLine()) != null) {
                SingleView.displayCurrentRecord(this.editor, currentLine);
            }
        } else if (propId == 2048) {
            this.setTableContents();
            DisplayLine currentLine = this.editor.getCurrentLine();
            if (currentLine != null) {
                SingleView.displayCurrentRecord(this.editor, currentLine);
            }
        }
        if (this.editor.getCurrentEditorContents().size() > 0) {
            if (this.heldColumnTableCursor != null && !this.heldColumnTableCursor.isDisposed() && !this.heldColumnTableCursor.isVisible()) {
                this.heldColumnTableCursor.setVisible(true);
            }
            if (this.otherColumntablCursor != null && !this.otherColumntablCursor.isDisposed() && !this.otherColumntablCursor.isVisible()) {
                this.otherColumntablCursor.setVisible(true);
            }
        }
    }

    @Override
    public boolean updateHostEditorChain() {
        ArrayList<RecType> modified = this.getModifiedRecords();
        ArrayList<RecType> recsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < modified.size()) {
            recsToUpdate.add(this.createRecToUpdate(modified.get(i)));
            ++i;
        }
        try {
            return UpdateHostEditorChainInHexOperation.execute(this.editor, recsToUpdate, this.editor.getTopRecord(), 1);
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.editor.disableEditorActions();
            return false;
        }
    }

    public RecType createRecToUpdate(RecType oldRec) {
        RecType recToUpdate = FMNXEDITFactory.eINSTANCE.createRecType();
        recToUpdate.setToken(oldRec.getToken());
        if (oldRec.isSetSeq()) {
            recToUpdate.setSeq(oldRec.getSeq());
        }
        if (oldRec.isSetSeg()) {
            recToUpdate.setSeg(oldRec.getSeg());
        }
        recToUpdate.setHex(oldRec.getHex());
        recToUpdate.setChg(true);
        recToUpdate.setRecno(oldRec.getRecno());
        return recToUpdate;
    }

    @Override
    public String[] validateContents() throws InterruptedException {
        ArrayList<RecType> recsToUpdate = this.getModifiedRecords();
        if (recsToUpdate.size() > 0) {
            ValidateFormattedValuesdOperation.execute(this.editor, recsToUpdate);
            ArrayList<RecType> recordsWithErrors = this.getRecordsWithError();
            if (recordsWithErrors.isEmpty()) {
                return null;
            }
            String errMsg = MessageFormat.format(Messages.FormattedPage_ERR_FIELDS_EXISTS, recordsWithErrors.size());
            return new String[]{errMsg, errMsg};
        }
        return null;
    }

    @Override
    public ArrayList<RecType> getSelectedNonShadowLines() {
        ArrayList<RecType> list;
        block2: {
            block3: {
                list = new ArrayList<RecType>();
                TableViewer aViewer = this.otherColumnTableViewer;
                if (!(aViewer.getSelection() instanceof IStructuredSelection)) break block2;
                IStructuredSelection selection = (IStructuredSelection)aViewer.getSelection();
                if (selection.size() <= 0) break block3;
                for (Object item : selection) {
                    if (!(item instanceof DisplayLine) || item instanceof ShadowGroup) continue;
                    DisplayLine dl = (DisplayLine)item;
                    FormattedPage.addIfNew(list, dl);
                }
                break block2;
            }
            ArrayList<DisplayLine> contents = this.editor.getCurrentEditorContents();
            if (contents.size() <= 0) break block2;
            int[] selectedRows = this.otherColumnTableViewer.getTable().getSelectionIndices();
            int i = 0;
            while (i < selectedRows.length) {
                FormattedPage.addIfNew(list, contents.get(selectedRows[i]));
                ++i;
            }
        }
        return list;
    }

    @Override
    public void setCursor(NavigationSpecification navSpec) {
        TableItem tableItem;
        logger.trace((Object)("Moving to: " + navSpec.toString()));
        if (this.editor.getCurrentEditorContents().isEmpty()) {
            return;
        }
        if (this.heldColumnTableViewer != null) {
            this.heldColumnTableCursor.setVisible(true);
        }
        if (this.otherColumntablCursor != null) {
            this.otherColumntablCursor.setVisible(true);
        }
        if (navSpec.getLocationType() == NavigationSpecification.LocationType.TOP) {
            if (this.heldColumnTableViewer != null) {
                this.heldColumnTableViewer.getTable().setFocus();
                this.heldColumnTableViewer.getTable().select(0);
                this.heldColumnTableViewer.getTable().showItem(this.heldColumnTableViewer.getTable().getItem(0));
                this.heldColumnTableCursor.setSelection(0, 1);
            }
            this.otherColumnTableViewer.getTable().setFocus();
            this.otherColumnTableViewer.getTable().select(0);
            this.otherColumnTableViewer.getTable().showItem(this.otherColumnTableViewer.getTable().getItem(0));
            this.otherColumntablCursor.setSelection(0, 1);
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.BOTTOM) {
            if (this.heldColumnTableViewer != null) {
                this.heldColumnTableViewer.getTable().setFocus();
                this.heldColumnTableViewer.getTable().select(this.heldColumnTableViewer.getTable().getItemCount() - 1);
                this.heldColumnTableViewer.getTable().showItem(this.heldColumnTableViewer.getTable().getItem(this.heldColumnTableViewer.getTable().getItemCount() - 1));
                this.heldColumnTableCursor.setSelection(this.heldColumnTableViewer.getTable().getItemCount() - 1, 0);
            }
            this.otherColumnTableViewer.getTable().setFocus();
            this.otherColumnTableViewer.getTable().select(this.otherColumnTableViewer.getTable().getItemCount() - 1);
            this.otherColumnTableViewer.getTable().showItem(this.otherColumnTableViewer.getTable().getItem(this.otherColumnTableViewer.getTable().getItemCount() - 1));
            this.otherColumntablCursor.setSelection(this.otherColumnTableViewer.getTable().getItemCount() - 1, 0);
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_NUMBER) {
            index = this.editor.getIndexOf(navSpec.getRecordToken());
            if (index == -1) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedPage_NO_RECFOUND, navSpec.getRecordToken()));
                return;
            }
            if (this.heldColumnTableViewer != null) {
                this.heldColumnTableViewer.getTable().setFocus();
                this.heldColumnTableViewer.getTable().select(index);
                this.heldColumnTableViewer.getTable().showItem(this.heldColumnTableViewer.getTable().getItem(index));
                this.heldColumnTableCursor.setSelection(index, 0);
            }
            this.otherColumnTableViewer.getTable().setFocus();
            this.otherColumnTableViewer.getTable().select(index);
            this.otherColumnTableViewer.getTable().showItem(this.otherColumnTableViewer.getTable().getItem(index));
            this.otherColumntablCursor.setSelection(index, 0);
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.COLUMN_NUMBER) {
            if (navSpec.getRecordToken() != null) {
                index = this.editor.getIndexOf(navSpec.getRecordToken());
                if (index == -1) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedPage_NO_RECFOUND, navSpec.getRecordToken()));
                    return;
                }
                int columnIndex = navSpec.getColumnNumber();
                if (this.heldColumnTableViewer != null) {
                    this.heldColumnTableViewer.getTable().setSelection(index);
                    this.heldColumnTableViewer.getTable().showItem(this.heldColumnTableViewer.getTable().getItem(index));
                    if (columnIndex <= this.heldColumns.size()) {
                        this.heldColumnTableViewer.getTable().showColumn(this.heldColumnTableViewer.getTable().getColumn(columnIndex));
                        this.heldColumnTableCursor.setSelection(index, columnIndex + 1);
                        this.heldColumnTableViewer.getTable().setSelection(index);
                        this.otherColumnTableViewer.getTable().setSelection(index);
                        this.heldColumnTableViewer.getTable().setFocus();
                        this.otherColumntablCursor.setVisible(false);
                        this.heldColumnTableCursor.setFocus();
                        return;
                    }
                    this.otherColumnTableViewer.getTable().showColumn(this.otherColumnTableViewer.getTable().getColumn(columnIndex - this.heldColumns.size() - 1));
                    this.heldColumnTableViewer.getTable().setSelection(index);
                    this.otherColumnTableViewer.getTable().setSelection(index);
                    this.otherColumntablCursor.setSelection(index, columnIndex - this.heldColumns.size() - 1);
                    this.otherColumnTableViewer.getTable().setFocus();
                    this.heldColumnTableCursor.setVisible(false);
                    this.otherColumntablCursor.setFocus();
                    return;
                }
                this.otherColumnTableViewer.getTable().setFocus();
                this.otherColumnTableViewer.getTable().showItem(this.otherColumnTableViewer.getTable().getItem(index));
                this.otherColumnTableViewer.getTable().showColumn(this.otherColumnTableViewer.getTable().getColumn(columnIndex));
                this.otherColumntablCursor.setSelection(index, columnIndex + 1);
                this.setSelectedLines(new int[]{index});
            } else {
                int columnIndex = navSpec.getColumnNumber();
                if (this.heldColumnTableViewer != null) {
                    if (columnIndex <= this.showFromColumnIndex || columnIndex > this.showFromColumnIndex + this.maxShowColumns) {
                        this.editor.startFromColumn(columnIndex - 1);
                    }
                    if (columnIndex <= this.heldColumns.size()) {
                        int adjustedColumn = this.getHeldColumnSize() >= this.maxShowColumns && this.showFromColumnIndex > this.getHeldColumnSize() - this.maxShowColumns ? this.maxShowColumns - (columnIndex - this.showFromColumnIndex) : columnIndex - this.showFromColumnIndex;
                        this.heldColumnTableViewer.getTable().showColumn(this.heldColumnTableViewer.getTable().getColumn(adjustedColumn));
                        this.heldColumnTableCursor.setSelection(0, adjustedColumn);
                        this.otherColumnTableViewer.getTable().setSelection(0);
                        this.heldColumnTableViewer.getTable().setSelection(0);
                        this.heldColumnTableViewer.getTable().setFocus();
                        this.otherColumntablCursor.setVisible(false);
                        this.heldColumnTableCursor.setFocus();
                        return;
                    }
                    int adjustedColumn = this.showFromColumnIndex < this.heldColumns.size() ? columnIndex - this.heldColumns.size() - 1 : columnIndex - this.showFromColumnIndex - 1;
                    this.otherColumnTableViewer.getTable().showColumn(this.otherColumnTableViewer.getTable().getColumn(adjustedColumn));
                    this.heldColumnTableViewer.getTable().setSelection(0);
                    this.otherColumnTableViewer.getTable().setSelection(0);
                    this.otherColumntablCursor.setSelection(0, adjustedColumn);
                    this.otherColumnTableViewer.getTable().setFocus();
                    this.heldColumnTableCursor.setVisible(false);
                    this.otherColumntablCursor.setFocus();
                    return;
                }
                if (columnIndex <= this.showFromColumnIndex || columnIndex > this.showFromColumnIndex + this.maxShowColumns) {
                    this.editor.startFromColumn(columnIndex - 1);
                }
                this.otherColumnTableViewer.getTable().setFocus();
                this.otherColumnTableViewer.getTable().showColumn(this.otherColumnTableViewer.getTable().getColumn(columnIndex - this.showFromColumnIndex));
                this.otherColumntablCursor.setSelection(0, columnIndex - this.showFromColumnIndex);
            }
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.JUST_FOCUS) {
            if (this.heldColumnTableViewer != null) {
                this.heldColumnTableViewer.getTable().setFocus();
            } else {
                this.otherColumnTableViewer.getTable().setFocus();
            }
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.COLUMN_CURSOR_OFFSET) {
            int columnNumber = navSpec.getColumnNumber();
            int cursorLocation = navSpec.getOffset();
            if (this.heldColumnTableViewer != null) {
                if (columnNumber <= this.heldColumns.size()) {
                    TableItem row = this.heldColumnTableCursor.getRow();
                    int column = this.heldColumnTableCursor.getColumn();
                    Text text2 = this.getTextEditor((DisplayLine)row.getData(), column, this.heldColumnTableViewer, this.heldColumnTableCursor);
                    if (text2 != null) {
                        text2.setText(row.getText(column));
                        cursorLocation = cursorLocation > row.getText(column).length() ? row.getText(column).length() : cursorLocation;
                        this.editor.updateCursorLocation("" + cursorLocation);
                        this.heldColumnTableControlEditor.setEditor((Control)text2);
                        text2.setSelection(cursorLocation);
                        this.heldColumnTableViewer.getTable().setFocus();
                        return;
                    }
                } else {
                    TableItem row = this.otherColumntablCursor.getRow();
                    int column = this.otherColumntablCursor.getColumn();
                    Text text3 = this.getTextEditor((DisplayLine)row.getData(), column, this.otherColumnTableViewer, this.otherColumntablCursor);
                    if (text3 != null) {
                        text3.setText(row.getText(column));
                        cursorLocation = cursorLocation > row.getText(column).length() ? row.getText(column).length() : cursorLocation;
                        this.editor.updateCursorLocation("" + cursorLocation);
                        this.otherColumnTableControlEditor.setEditor((Control)text3);
                        text3.setSelection(cursorLocation);
                        this.otherColumnTableViewer.getTable().setFocus();
                        return;
                    }
                }
            } else if (this.otherColumntablCursor != null && !this.otherColumntablCursor.isDisposed() && this.otherColumntablCursor.isVisible()) {
                TableItem row = this.otherColumntablCursor.getRow();
                int column = this.otherColumntablCursor.getColumn();
                Text text4 = this.getTextEditor((DisplayLine)row.getData(), column, this.otherColumnTableViewer, this.otherColumntablCursor);
                if (text4 != null) {
                    text4.setText(row.getText(column));
                    cursorLocation = cursorLocation > row.getText(column).length() ? row.getText(column).length() : cursorLocation;
                    this.editor.updateCursorLocation("" + cursorLocation);
                    this.otherColumnTableControlEditor.setEditor((Control)text4);
                    text4.setSelection(cursorLocation);
                }
            }
        } else {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_UNSUPPORTED_NAV_SPEC, new Object[]{navSpec.getLocationType()}));
        }
        if (this.heldColumnTableViewer != null) {
            this.heldColumnTableViewer.getTable().setFocus();
            this.heldColumnTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.heldColumnTableViewer.getTable().getSelection()));
            this.setCursorSelectionOnFoundField(this.heldColumnTableCursor, this.heldColumnTableViewer);
        }
        if (this.otherColumnTableViewer != null) {
            this.otherColumnTableViewer.getTable().setFocus();
            this.otherColumnTableViewer.setSelection((ISelection)new StructuredSelection((Object[])this.otherColumnTableViewer.getTable().getSelection()));
            this.setCursorSelectionOnFoundField(this.otherColumntablCursor, this.otherColumnTableViewer);
        }
        if (this.heldColumnTableCursor != null && (tableItem = this.heldColumnTableCursor.getRow()) != null) {
            this.heldColumnTableCursor.setBackground(tableItem.getBackground(this.heldColumnTableCursor.getColumn()));
        }
        if (this.otherColumntablCursor.getRow() != null) {
            TableItem tableItem2 = this.otherColumntablCursor.getRow();
            if (tableItem2 != null) {
                this.otherColumntablCursor.setBackground(tableItem2.getBackground(this.otherColumntablCursor.getColumn()));
            }
        } else {
            this.otherColumntablCursor.setVisible(false);
        }
    }

    private void setCursorSelectionOnFoundField(TableCursor cursor, TableViewer viewer) {
        int rowIndex = 0;
        DisplayLine dl = this.editor.getCurrentEditorContents().get(rowIndex);
        int i = 0;
        while (i < viewer.getTable().getColumnCount()) {
            FieldType aField = FormattedPageUtility.getField(dl.getRecord(), i);
            if (aField != null && aField.isSetFindhit() && aField.getFindhit() > 0) {
                cursor.setSelection(rowIndex, i);
                break;
            }
            ++i;
        }
    }

    private void setTableContents() {
        int[] selectedLines = this.getSelectedLines();
        if (selectedLines.length == 0 && this.editor.getCurrentEditorContents().size() > 0) {
            selectedLines = new int[1];
        }
        if (this.heldColumnTableViewer != null) {
            if (this.heldColumnTableCursor != null) {
                this.heldColumnTableCursor.setVisible(false);
            }
            this.heldColumnTableViewer.setInput(this.editor.getCurrentEditorContents());
            this.heldColumnTableViewer.refresh();
        }
        if (this.otherColumnTableViewer != null) {
            if (this.otherColumntablCursor != null) {
                this.otherColumntablCursor.setVisible(false);
            }
            this.otherColumnTableViewer.setInput(this.editor.getCurrentEditorContents());
            this.otherColumnTableViewer.refresh();
        }
        this.setSelectedLines(selectedLines);
        this.editor.updateLocationInformation(-1);
    }

    @Override
    public int[] getSelectedLines() {
        if (this.otherColumnTableViewer != null && !this.otherColumnTableViewer.getTable().isDisposed()) {
            if (this.otherColumnTableViewer.getTable().getSelectionIndex() != -1) {
                return this.otherColumnTableViewer.getTable().getSelectionIndices();
            }
            if (this.otherColumntablCursor.isVisible() && this.otherColumntablCursor.getRow() != null) {
                int rowIndex = this.otherColumnTableViewer.getTable().indexOf(this.otherColumntablCursor.getRow());
                return new int[]{rowIndex};
            }
            return new int[0];
        }
        return new int[0];
    }

    @Override
    public boolean setSelectedLines(int[] selectedRows) {
        int i;
        if (selectedRows == null || selectedRows.length == 0) {
            return false;
        }
        if (this.otherColumnTableViewer.getTable().getItemCount() == 0) {
            return false;
        }
        ArrayList<Integer> validSelection = this.validateSelection(selectedRows);
        if (validSelection.isEmpty()) {
            return false;
        }
        TableItem[] tableItems = new TableItem[validSelection.size()];
        if (this.heldColumnTableViewer != null) {
            i = 0;
            while (i < tableItems.length) {
                tableItems[i] = this.heldColumnTableViewer.getTable().getItem(validSelection.get(i).intValue());
                ++i;
            }
            this.heldColumnTableViewer.getTable().setSelection(tableItems);
        }
        i = 0;
        while (i < tableItems.length) {
            tableItems[i] = this.otherColumnTableViewer.getTable().getItem(validSelection.get(i).intValue());
            ++i;
        }
        this.otherColumnTableViewer.getTable().setSelection(tableItems);
        this.editor.updateLocationInformation(-1);
        return true;
    }

    private ArrayList<Integer> validateSelection(int[] selection) {
        ArrayList<Integer> validSelection = new ArrayList<Integer>();
        int itemCount = this.otherColumnTableViewer.getTable().getItemCount();
        int i = 0;
        while (i < selection.length) {
            if (selection[i] < itemCount) {
                validSelection.add(selection[i]);
            }
            ++i;
        }
        return validSelection;
    }

    @Override
    public int getCursorIndexOnSelectedLine() {
        if (this.heldColumnTableViewer == null) {
            if (this.otherColumnTableViewer == null || this.otherColumnTableViewer.getTable().isDisposed()) {
                return 0;
            }
            if (this.otherColumntablCursor.isVisible()) {
                return this.otherColumntablCursor.getColumn();
            }
            return 0;
        }
        if (this.heldColumnTableCursor.isFocusControl()) {
            return this.heldColumnTableCursor.getColumn();
        }
        return 1 + this.heldColumns.size() + this.otherColumntablCursor.getColumn();
    }

    public int getColumnLocationFromCursor() {
        if (this.heldColumnTableViewer == null) {
            if (this.otherColumnTableViewer == null || this.otherColumnTableViewer.getTable().isDisposed()) {
                return 1;
            }
            return this.otherColumntablCursor.getColumn();
        }
        if (this.heldColumnTableCursor.isFocusControl()) {
            return this.heldColumnTableCursor.getColumn();
        }
        return 1;
    }

    public int refreshContent(int showFromColumnIndexTemp, int maxShowColumnsTemp) {
        if (this.heldColumnTableViewer != null && this.getHeldColumnSize() > 0) {
            this.showFromColumnIndex = showFromColumnIndexTemp;
            this.maxShowColumns = maxShowColumnsTemp;
            this.addColumnsToHeldColumnTable(true);
            this.heldColumnTableViewer.refresh();
        }
        if (this.otherColumnTableViewer != null) {
            this.showFromColumnIndex = showFromColumnIndexTemp;
            this.maxShowColumns = maxShowColumnsTemp;
            this.addColumnsToOtherColumnTable(true);
            this.otherColumnTableViewer.refresh();
        }
        if (this.showFromHeldColumnIndexCur != -1) {
            return this.showFromHeldColumnIndexCur;
        }
        if (this.showFromOtherColumnIndexCur != -1) {
            return this.showFromOtherColumnIndexCur;
        }
        return showFromColumnIndexTemp;
    }

    public int getHeldColumnSize() {
        return this.heldColumns == null ? 0 : this.heldColumns.size();
    }

    public int getCurrentShowFromOtherColumnIndex() {
        return this.showFromOtherColumnIndexCur;
    }

    public int getCurrentShowFromHeldColumnIndex() {
        return this.showFromHeldColumnIndexCur;
    }

    @Override
    public String getSelectedText() {
        TableItem row;
        if (this.heldColumnTableViewer != null && this.heldColumnTableCursor != null && this.heldColumnTableViewer.getTable().isFocusControl()) {
            TableItem row2 = this.heldColumnTableCursor.getRow();
            if (row2 != null) {
                return row2.getText(this.heldColumnTableCursor.getColumn());
            }
        } else if (this.otherColumnTableViewer != null && this.otherColumntablCursor != null && this.otherColumnTableViewer.getTable().isFocusControl() && (row = this.otherColumntablCursor.getRow()) != null) {
            return row.getText(this.otherColumntablCursor.getColumn());
        }
        return "";
    }
}

