/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.formatted;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.pages.formatted.EncodedString;
import com.ibm.etools.fm.editor.formatted.pages.formatted.LazyListModelItemContentProvider;
import com.ibm.etools.fm.editor.formatted.pages.formatted.StyledCellLabelProviderExtension;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.BaseTitleAreaDialog;
import com.ibm.pdtools.common.component.core.util.GUI;
import jakarta.xml.bind.DatatypeConverter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormattedCellEditor
extends TitleAreaDialog {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2022. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int MAX_COLS_TO_DISPLAY = 60;
    private static final PDLogger logger = PDLogger.get(FormattedCellEditor.class);
    private final List<EncodedString> ess = new ArrayList<EncodedString>();
    private Text wCursorLocationText;
    private Text wSelectedCharText;
    private Text wSelectedCharTextHex;
    private TableViewer wTableText;

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        try {
            return super.open();
        }
        catch (NullPointerException e) {
            logger.trace((Object)(String.valueOf(e.getCause()) + "=" + e.getMessage()));
            return 1;
        }
    }

    public FormattedCellEditor(EncodedString es) {
        super(Display.getCurrent() != null ? Display.getCurrent().getActiveShell() : Display.getDefault().getActiveShell());
        Objects.requireNonNull(es, "Must provide a non-null es as input.");
        this.setHelpAvailable(false);
        TrayDialog.setDialogHelpAvailable((boolean)false);
        ArrayList<String> list = new ArrayList<String>((es.getEncodedString().length() + 60 - 1) / 60);
        int start = 0;
        while (start < es.getEncodedString().length()) {
            list.add(es.getEncodedString().substring(start, Math.min(es.getEncodedString().length(), start + 60)));
            start += 60;
        }
        for (String part : list) {
            this.ess.add(EncodedString.createFromHexValues(DatatypeConverter.printHexBinary((byte[])part.getBytes(es.getEncoding())), es.getEncoding()));
        }
        logger.trace((Object)MessageFormat.format("input details: length = {0} encoding ={1} rowCount ={2}", es.getEncodedString().length(), es.getEncoding(), this.ess.size()));
    }

    private static Text createLabeledText(Composite composite, String labelText) {
        Objects.requireNonNull(composite, "Must provide a non-null composite");
        Objects.requireNonNull(labelText, "Must provide a non-null labelText");
        Label label2 = new Label(composite, 0x20004000);
        label2.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label2.setText(labelText);
        return GUI.text.fieldReadOnly((Composite)composite, (Object)GridDataFactory.fillDefaults().grab(true, false).create());
    }

    private static TableViewer createTableViewer(Composite composite) {
        Objects.requireNonNull(composite, "Must provide a non-null composite.");
        TableViewer tableViewer = new TableViewer(composite, 0x30000304);
        BaseTitleAreaDialog.createScrolledComposite((Composite)composite, (Composite)tableViewer.getTable());
        tableViewer.getTable().setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).grab(true, true).create());
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setUseHashlookup(true);
        return tableViewer;
    }

    private void createColumns(TableViewer wTableText, int maxColumns) {
        int numCols = 60;
        if (!this.ess.isEmpty()) {
            numCols = this.ess.get(0).getEncodedString().length();
        }
        int i = 0;
        while (i < numCols + 1) {
            final int colNum = i;
            TableViewerColumn c = new TableViewerColumn(wTableText, 0);
            TableColumn column = c.getColumn();
            column.setResizable(true);
            column.setMoveable(false);
            if (colNum == 0) {
                column.setText(Messages.FormattedCellEditor_0);
                c.setLabelProvider((CellLabelProvider)new StyledCellLabelProviderExtension(colNum, this.ess, maxColumns));
            } else {
                column.setText("" + colNum);
                c.setLabelProvider((CellLabelProvider)new StyledCellLabelProviderExtension(colNum, this.ess, maxColumns){

                    public String getToolTipText(Object element) {
                        return FormattedCellEditor.this.getToolTip(colNum - 1, element);
                    }
                });
            }
            column.setAlignment(0x1000000);
            column.pack();
            ++i;
        }
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)wTableText, (int)1);
    }

    protected Control createDialogArea(Composite parent) {
        Objects.requireNonNull(parent, "Must provide a non-null parent composite.");
        this.setTitle(Messages.FormattedCellEditor_1);
        this.setBlockOnOpen(true);
        this.setMessage(Messages.FormattedCellEditor_2);
        this.getShell().setText(Messages.FormattedCellEditor_1);
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        Composite cursorInfo = new Composite(composite, 0x20000000);
        cursorInfo.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(12).create());
        cursorInfo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(2, 1).create());
        this.wCursorLocationText = FormattedCellEditor.createLabeledText(cursorInfo, Messages.FormattedCellEditor_3);
        this.wSelectedCharText = FormattedCellEditor.createLabeledText(cursorInfo, Messages.FormattedCellEditor_4);
        this.wSelectedCharTextHex = FormattedCellEditor.createLabeledText(cursorInfo, Messages.FormattedCellEditor_5);
        this.wTableText = FormattedCellEditor.createTableViewer(composite);
        this.createColumns(this.wTableText, 60);
        this.wTableText.setContentProvider((IContentProvider)new LazyListModelItemContentProvider(this.wTableText));
        this.wTableText.setInput(this.ess);
        this.wTableText.setItemCount(this.ess.size());
        if (this.ess.size() > 0) {
            this.wTableText.setSelection((ISelection)new StructuredSelection((Object)this.ess.get(0)));
        }
        TableCursor cursor = this.createTableCursor();
        cursor.setSelection(0, 1);
        this.updateCursorMasterDetailControl(cursor);
        cursor.setFocus();
        return parent;
    }

    private TableCursor createTableCursor() {
        Objects.requireNonNull(this.wTableText, "Must provide a non-null wTableText");
        final TableCursor cursor = new TableCursor(this.wTableText.getTable(), 0x20000000);
        final ControlEditor editor2 = new ControlEditor((Composite)cursor);
        editor2.grabHorizontal = true;
        editor2.grabVertical = true;
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                Text text2;
                if ((!Character.isISOControl(e.character) || e.character == '\u007f' || e.character == '\b' && cursor.getColumn() > 0) && (text2 = FormattedCellEditor.this.createTextEditor(cursor, editor2)) != null) {
                    text2.setText(Character.toString(e.character));
                    if (e.character == '\u007f' || e.character == '\b') {
                        text2.setText("");
                        FormattedCellEditor.this.saveEdit(cursor, text2, false, cursor.getRow(), cursor.getColumn());
                    } else {
                        FormattedCellEditor.this.saveEdit(cursor, text2, true, cursor.getRow(), cursor.getColumn());
                    }
                }
            }
        });
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (cursor.getColumn() == 0) {
                    cursor.setSelection(cursor.getRow(), 1);
                }
                FormattedCellEditor.this.wTableText.getTable().setSelection(new TableItem[]{cursor.getRow()});
                FormattedCellEditor.this.updateCursorMasterDetailControl(cursor);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FormattedCellEditor.this.createTextEditor(cursor, editor2);
            }
        });
        cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                this.mouseDown(e);
            }

            public void mouseDown(MouseEvent e) {
                FormattedCellEditor.this.createTextEditor(cursor, editor2);
            }
        });
        return cursor;
    }

    private Text createTextEditor(final TableCursor cursor, ControlEditor editor2) {
        Objects.requireNonNull(cursor, "Must provide a non-null cursor");
        Objects.requireNonNull(editor2, "Must provide a non-null editor");
        final Text text2 = new Text((Composite)cursor, 0x20000000);
        text2.setTextLimit(1);
        text2.setSelection(0);
        TableItem row = cursor.getRow();
        int column = cursor.getColumn();
        if (column <= 0) {
            text2.dispose();
            return null;
        }
        text2.setText(Character.toString(((EncodedString)row.getData()).getChar(column - 1)));
        text2.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    FormattedCellEditor.this.saveEdit(cursor, text2, true, cursor.getRow(), cursor.getColumn());
                }
                if (e.character == '\u001b') {
                    text2.dispose();
                }
            }
        });
        text2.addFocusListener((FocusListener)new FocusAdapter(){
            private TableItem gainedRow;
            private int gainedCol;

            public void focusGained(FocusEvent e) {
                this.gainedRow = cursor.getRow();
                this.gainedCol = cursor.getColumn();
            }

            public void focusLost(FocusEvent e) {
                FormattedCellEditor.this.saveEdit(cursor, text2, true, this.gainedRow, this.gainedCol);
            }
        });
        editor2.setEditor((Control)text2);
        text2.setFocus();
        return text2;
    }

    private void saveEdit(TableCursor cursor, Text text2, boolean moveCursorRight, TableItem row, int column) {
        Objects.requireNonNull(cursor, "Must provide a non-null cursor");
        Objects.requireNonNull(text2, "Must provide a non-null text");
        Objects.requireNonNull(row, "Must provide a non-null row");
        if (column < 1) {
            text2.dispose();
            return;
        }
        String text22 = text2.getText();
        if (text22.isEmpty()) {
            text22 = " ";
        }
        row.setText(column, text22);
        EncodedString model = (EncodedString)row.getData();
        model.setChar(column - 1, text22.charAt(0));
        ((Table)cursor.getParent()).setSelection(new TableItem[]{row});
        this.updateCursorMasterDetailControl(cursor);
        text2.dispose();
        this.moveCursorToNewPosition(cursor, moveCursorRight, model.getEncodedString().length(), column, this.ess.indexOf(row.getData()));
    }

    private void moveCursorToNewPosition(TableCursor cursor, boolean moveCursorRight, int rowLength, int currentColumn, int currentRow) {
        Objects.requireNonNull(cursor, "Must provide a non-null cursor.");
        if (rowLength < 0) {
            throw new IllegalArgumentException("rowLength should be positive.");
        }
        if (currentColumn < 0) {
            throw new IllegalArgumentException("Column index must be 0 or more.");
        }
        if (currentRow < 0) {
            throw new IllegalArgumentException("row index must be 0 or more.");
        }
        boolean FIRST_DATA_COLUMN = true;
        int newRow = currentRow;
        int newCol = currentColumn;
        if (moveCursorRight) {
            if (currentColumn < rowLength) {
                newCol = currentColumn + 1;
            } else if (currentColumn == rowLength && currentRow + 1 < this.ess.size()) {
                newRow = currentRow + 1;
                newCol = 1;
            }
        } else if (currentColumn > 1) {
            newCol = currentColumn - 1;
        } else if (currentColumn == 1 && currentRow > 0) {
            newRow = currentRow - 1;
            newCol = rowLength;
        }
        logger.trace((Object)MessageFormat.format("moving cursor from {0},{1} to {2},{3}", currentRow, currentColumn, newRow, newCol));
        cursor.setSelection(newRow, newCol);
        cursor.setFocus();
    }

    public String getHex() {
        StringBuilder sb = new StringBuilder();
        for (EncodedString es : this.ess) {
            sb.append(es.getHex(es.getEncoding()));
        }
        return sb.toString();
    }

    private void updateCursorMasterDetailControl(TableCursor cursor) {
        Objects.requireNonNull(this.wCursorLocationText, "Must provide a non-null wCursorLocationText.");
        Objects.requireNonNull(this.wSelectedCharText, "Must provide a non-null wSelectedCharText.");
        Objects.requireNonNull(this.wSelectedCharTextHex, "Must provide a non-null wSelectedCharTextHex.");
        Objects.requireNonNull(cursor, "Must provide a non-null cursor.");
        int col = cursor.getColumn();
        if (col == 0) {
            ++col;
        }
        this.wCursorLocationText.setText(this.getOffset(col - 1, cursor.getRow().getData()));
        EncodedString encStr = (EncodedString)cursor.getRow().getData();
        String val = "" + encStr.getChar(col - 1);
        this.wSelectedCharText.setText(val);
        this.wSelectedCharTextHex.setText(DatatypeConverter.printHexBinary((byte[])val.getBytes(encStr.getEncoding())));
        cursor.setToolTipText(this.getToolTip(cursor.getColumn() - 1, cursor.getRow().getData()));
    }

    private String getToolTip(int colNum, Object element) {
        Objects.requireNonNull(element, "Must provide a non-null element.");
        if (colNum >= 0 && !this.ess.isEmpty()) {
            String tooltip = MessageFormat.format(Messages.FormattedCellEditor_6, this.getOffset(colNum, element), DatatypeConverter.printHexBinary((byte[])("" + ((EncodedString)element).getChar(colNum)).getBytes(this.ess.get(0).getEncoding())));
            if (Character.isISOControl(((EncodedString)element).getChar(colNum))) {
                tooltip = MessageFormat.format(Messages.FormattedCellEditor_8, tooltip);
            }
            return tooltip;
        }
        return null;
    }

    private String getOffset(int colNum, Object element) {
        Objects.requireNonNull(element, "Must provide a non-null element.");
        return "" + (this.ess.indexOf(element) * 60 + 1 + colNum);
    }
}

