/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.charmode;

import java.util.LinkedList;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.StyledText;

public class UndoManager {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private int limit;
    private boolean performingUndo = false;
    private boolean performingRedo = false;
    private LinkedList<TextChange> undo = new LinkedList();
    private LinkedList<TextChange> redo = new LinkedList();
    private StyledText st;
    private StyledText infoField;
    private TextChange tempChange = new TextChange(-1, -1, "");

    public UndoManager(int limit, StyledText st, StyledText editorPage) {
        this.limit = limit;
        this.st = st;
        this.infoField = editorPage;
    }

    public UndoManager(int limit, StyledText st) {
        this(limit, st, null);
    }

    public void undo() {
        if (this.undo.size() != 0) {
            TextChange change = this.undo.removeFirst();
            this.performingUndo = true;
            this.st.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            this.st.setSelection(change.getStart(), change.getStart());
            this.st.showSelection();
            if (this.infoField != null) {
                int topIndex = this.st.getTopIndex();
                this.infoField.setTopIndex(topIndex);
            }
            this.performingUndo = false;
        }
    }

    public void redo() {
        if (this.redo.size() != 0) {
            this.performingRedo = true;
            TextChange change = this.redo.removeFirst();
            this.st.replaceTextRange(change.getStart(), change.getLength(), change.getReplacedText());
            this.st.setSelection(change.getStart(), change.getStart());
            this.st.showSelection();
            if (this.infoField != null) {
                int topIndex = this.st.getTopIndex();
                this.infoField.setTopIndex(topIndex);
            }
            this.performingRedo = false;
        }
    }

    public void reset() {
        this.undo.clear();
        this.redo.clear();
    }

    public void addChange(ExtendedModifyEvent event) {
        this.addChange(event.start, event.length, event.replacedText);
    }

    private void addChange(int start, int length, String replacedText) {
        this.tempChange.setStart(start);
        this.tempChange.setLength(length);
        this.tempChange.setText(replacedText);
        if (!this.performingUndo) {
            if (this.undo.isEmpty() || !this.undo.peek().merge(this.tempChange)) {
                this.undo.addFirst(new TextChange(start, length, replacedText));
                if (this.undo.size() > this.limit) {
                    this.undo.removeLast();
                }
                if (!this.performingRedo) {
                    this.redo.clear();
                }
            }
        } else if (this.redo.isEmpty() || !this.redo.peek().merge(this.tempChange)) {
            this.redo.addFirst(new TextChange(start, length, replacedText));
            if (this.redo.size() > this.limit) {
                this.redo.removeLast();
            }
        }
    }

    private static class TextChange {
        private int start;
        private int length;
        StringBuffer replacedText;

        public TextChange(int start, int length, String replacedText) {
            this.start = start;
            this.length = length;
            this.replacedText = new StringBuffer(replacedText);
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setText(String text2) {
            this.replacedText.setLength(0);
            this.replacedText.append(text2);
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public String getReplacedText() {
            return this.replacedText.toString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TextChange)) {
                return false;
            }
            TextChange arg = (TextChange)o;
            return this.start == arg.start && this.length == arg.length && this.replacedText.equals(arg.replacedText);
        }

        public int hashCode() {
            return (this.start + 1) * (this.length + 1) * this.replacedText.hashCode();
        }

        public boolean merge(TextChange t) {
            if (this.length == 0 && t.length == 0) {
                int strLen = t.replacedText.length();
                if (t.start < this.start && t.start + strLen == this.start) {
                    this.start = t.start;
                    this.replacedText.insert(0, t.replacedText);
                    this.length = 0;
                    return true;
                }
                if (t.start == this.start) {
                    this.replacedText.append(t.replacedText);
                    return true;
                }
            } else if (this.start + this.length == t.start) {
                this.length += t.length;
                this.replacedText.append(t.getReplacedText());
                return true;
            }
            return false;
        }
    }
}

