/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.charmode;

import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.pages.charmode.CharModePage;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;

public class CharModeSelectionProvider
implements ISelectionProvider,
SelectionListener,
KeyListener,
MouseListener,
CaretListener {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private FormattedEditor editor = null;
    private ArrayList<ISelectionChangedListener> listeners = null;
    private StyledText currentText = null;
    private ArrayList<DisplayLine> currentSelectedLines = null;
    private boolean isDoubleClicked = false;

    public CharModeSelectionProvider(FormattedEditor editor2) {
        this.editor = editor2;
        this.listeners = new ArrayList();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.currentSelectedLines != null) {
            return new StructuredSelection(this.currentSelectedLines);
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public void keyPressed(KeyEvent e) {
        if (!(e.getSource() instanceof StyledText)) {
            return;
        }
        this.currentText = (StyledText)e.getSource();
        if (!e.widget.isDisposed()) {
            this.setupCurrentSelection();
        }
        if (e.keyCode == 0x1000001 || e.keyCode == 0x1000005) {
            int[] selection = this.editor.getSelection();
            if (selection != null && selection.length > 0 && selection[0] == 0) {
                if (this.editor.isNeedScrolling()) {
                    DisplayLine dl = this.editor.getPreviousLine(false);
                    this.editor.setNeedScrolling(false);
                    if (dl != null) {
                        SingleView.displayCurrentRecord(this.editor, dl);
                    }
                } else {
                    this.editor.setNeedScrolling(true);
                }
            } else {
                this.editor.setNeedScrolling(false);
            }
        } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000006) {
            int[] selection = this.editor.getSelection();
            if (selection != null && selection.length > 0 && selection[0] == this.editor.getCurrentEditorContents().size() - 1) {
                if (this.editor.isNeedScrolling()) {
                    DisplayLine dl = this.editor.getNextLine(false);
                    this.editor.setNeedScrolling(false);
                    if (dl != null) {
                        SingleView.displayCurrentRecord(this.editor, dl);
                    }
                } else {
                    this.editor.setNeedScrolling(true);
                }
            } else {
                this.editor.setNeedScrolling(false);
            }
        } else if (e.keyCode == 0x1000007 || e.keyCode == 0x1000008) {
            this.setRulerTextHorizontalIndex();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.getSource() instanceof StyledText)) {
            return;
        }
        this.currentText = (StyledText)e.getSource();
        this.setupCurrentSelection();
        int[] selection = this.editor.getSelection();
        if (selection != null && this.isDoubleClicked) {
            this.getRulerText().setSelection(selection[0]);
            this.isDoubleClicked = false;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!(e.getSource() instanceof StyledText)) {
            return;
        }
        this.currentText = (StyledText)e.getSource();
        this.setRulerTextHorizontalIndex();
        this.isDoubleClicked = true;
    }

    public void mouseDown(MouseEvent e) {
        if (!(e.getSource() instanceof StyledText)) {
            return;
        }
        this.currentText = (StyledText)e.getSource();
        this.setupCurrentSelection();
    }

    public void mouseUp(MouseEvent e) {
    }

    public void caretMoved(CaretEvent e) {
        if (!(e.getSource() instanceof StyledText)) {
            return;
        }
        this.currentText = (StyledText)e.getSource();
        this.currentText.redraw();
    }

    private void setupCurrentSelection() {
        Point selection = this.currentText.getSelection();
        int start = selection.x;
        int end = selection.y;
        int startLine = this.currentText.getLineAtOffset(start);
        int endLine = this.currentText.getLineAtOffset(end);
        this.currentSelectedLines = this.getSelectedLineItems(startLine, endLine);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(this.currentSelectedLines)));
            ++i;
        }
        int lineStartIndex = this.currentText.getOffsetAtLine(startLine);
        int lineCaretPosition = start - lineStartIndex;
        if (this.currentSelectedLines != null && this.currentSelectedLines.size() > 0) {
            SingleView.displayCurrentRecord(this.editor, this.currentSelectedLines.get(0));
            this.editor.updateLocationInformation(lineCaretPosition);
        } else {
            SingleView.displayCurrentRecord(this.editor, null);
            this.editor.updateLocationInformation(-1);
        }
    }

    private ArrayList<DisplayLine> getSelectedLineItems(int startLineNo, int endLineNo) {
        ArrayList<DisplayLine> selectedLines = new ArrayList<DisplayLine>();
        ArrayList<DisplayLine> currentContents = this.editor.getCurrentEditorContents();
        int i = startLineNo;
        while (i < currentContents.size() && i <= endLineNo) {
            selectedLines.add(currentContents.get(i));
            ++i;
        }
        return selectedLines;
    }

    private void setRulerTextHorizontalIndex() {
        StyledText rulerText = this.getRulerText();
        if (rulerText != null) {
            rulerText.setHorizontalIndex(this.currentText.getHorizontalIndex());
            rulerText.layout(true);
        }
    }

    private StyledText getRulerText() {
        StyledText rulerText = ((CharModePage)this.editor.getCurrentPage()).getRulerText();
        return rulerText;
    }
}

