/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.charmode;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.ScrollSupportStrategy;
import com.ibm.etools.fm.editor.formatted.TopNavigationBar;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.EmptyRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.handler.InsertRecords;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.editor.formatted.pages.charmode.CharModeSelectionProvider;
import com.ibm.etools.fm.editor.formatted.pages.charmode.UndoManager;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.FindHitType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.bidi.ui.BidiUI;
import com.ibm.pdtools.common.component.bidi.ui.VisualBidiSegmentListener;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.GUI;
import com.ibm.pdtools.common.component.core.util.PDBiDiHelpers;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class CharModePage
extends IFormattedEditorPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CharModePage.class);
    private FormattedEditor editor = null;
    private UndoManager undoManager = null;
    private StyledText infoField = null;
    private StyledText textField = null;
    private StyledText rulerText = null;
    private StyledText infoText = null;
    private StyledText recLenText = null;
    private StyledText recLenField = null;
    private ModifyListener textFieldModifyListener = null;
    private CharModeLine[] originalLines = null;
    private boolean textDirty = false;
    private boolean segmented = false;
    private int maxLineLen = 0;
    private CharModeSelectionProvider selectionProvider = null;
    private final TopNavigationBar topNavbar;
    private boolean blockSelectionMode = false;
    private boolean rulerMode = false;
    private SashForm composite;
    private VisualBidiSegmentListener listener = null;
    private StyledText styledText;
    public static String DEFAULT_TEXT = "";
    private boolean isFixedLength = false;
    private final int INDEX_INPUT_TEXT = 0;
    private final int INDEX_INPUT_HEX_HIGH = 1;
    private final int INDEX_INPUT_HEX_LOW = 2;
    Menu popup1 = null;
    Menu popup2 = null;
    private String cols;

    public CharModePage(FormattedEditor editor2, Composite parent, TopNavigationBar topNavbar, boolean blockSelectionMode) {
        this.editor = editor2;
        this.topNavbar = topNavbar;
        this.blockSelectionMode = blockSelectionMode;
        this.createControl(parent);
    }

    private void createControl(Composite parent) {
        Font font = FormattedEditorPreferencePage.getFontStyle();
        this.composite = new SashForm(parent, 256);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        this.composite.setLayoutData((Object)data);
        Composite infoComposite = GUI.composite((Composite)this.composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        infoComposite.setBackground(this.composite.getDisplay().getSystemColor(1));
        infoComposite.setFont(font);
        this.infoText = new StyledText(infoComposite, 10);
        this.infoText.setEnabled(false);
        GridData gData = new GridData(768);
        gData.heightHint = 0;
        this.infoText.setLayoutData((Object)gData);
        this.infoField = new StyledText(infoComposite, 2826);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.infoField.setLayoutData((Object)data);
        this.infoField.setFont(font);
        final ScrollBar infoFieldVerticalScrollBar = this.infoField.getVerticalBar();
        infoFieldVerticalScrollBar.setVisible(false);
        this.infoField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                CharModePage.this.alignTopLine(false);
            }
        });
        this.prepareScrollListenersForControl(infoFieldVerticalScrollBar);
        Composite recLenComposite = GUI.composite((Composite)this.composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        recLenComposite.setBackground(this.composite.getDisplay().getSystemColor(1));
        recLenComposite.setFont(font);
        this.recLenText = new StyledText(recLenComposite, 10);
        this.recLenText.setEnabled(false);
        gData = new GridData(768);
        gData.heightHint = 0;
        this.recLenText.setLayoutData((Object)gData);
        this.recLenField = new StyledText(recLenComposite, 2826);
        data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.recLenField.setLayoutData((Object)data);
        this.recLenField.setFont(font);
        ScrollBar reclenScrollBar = this.recLenField.getVerticalBar();
        reclenScrollBar.setVisible(false);
        this.recLenField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                CharModePage.this.alignTopLine(false);
            }
        });
        this.prepareScrollListenersForControl(reclenScrollBar);
        Composite rulerComposite = GUI.composite((Composite)this.composite, (Layout)GUI.grid.l.noMargins((int)1, (boolean)false), (Object)GUI.grid.d.fillAll());
        rulerComposite.setBackground(this.composite.getDisplay().getSystemColor(1));
        rulerComposite.setFont(font);
        this.rulerText = new StyledText(rulerComposite, 522);
        this.rulerText.setEnabled(false);
        GridData gd = new GridData(768);
        gd.heightHint = 0;
        this.rulerText.setLayoutData((Object)gd);
        this.textField = this.editor.isEditSession() ? new StyledText(rulerComposite, 2818) : new StyledText(rulerComposite, 2826);
        gd = new GridData(1808);
        this.textField.setLayoutData((Object)gd);
        this.textField.setBlockSelection(this.blockSelectionMode);
        this.textField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                CharModePage.this.alignTopLine(true);
                if (e.keyCode == 0x1000009) {
                    CharModePage.this.editor.setInsertMode(!CharModePage.this.editor.isInsertMode());
                } else if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    InsertRecords.process(CharModePage.this.editor, false);
                }
            }
        });
        this.textField.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent ve) {
                if (!Character.isISOControl(ve.character) && !CharModePage.this.editor.isInsertMode() && CharModePage.this.textField.getSelectionCount() == 0) {
                    int pos = CharModePage.this.textField.getCaretOffset();
                    if (CharModePage.this.textField.getText().charAt(pos) != '\n' && CharModePage.this.textField.getText().charAt(pos) != '\r') {
                        CharModePage.this.textField.setSelection(pos, pos + 1);
                    }
                }
                if (ve.character == '\r') {
                    ve.doit = false;
                }
            }
        });
        this.textField.setFont(font);
        ScrollBar textFieldVerticalScrollBar = this.textField.getVerticalBar();
        this.prepareScrollListenersForControl(textFieldVerticalScrollBar);
        this.textField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CharModePage.this.styledText = CharModePage.this.textField;
                CharModePage.this.alignTopLine(true);
            }
        });
        this.infoField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CharModePage.this.styledText = CharModePage.this.infoField;
                CharModePage.this.alignTopLine(false);
            }
        });
        int[] nArray = new int[3];
        nArray[0] = 5;
        nArray[2] = 95;
        this.composite.setWeights(nArray);
        this.setNewData();
        this.textField.setSelection(0, 0);
        this.infoField.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                infoFieldVerticalScrollBar.setVisible(false);
            }
        });
        this.undoManager = new UndoManager(300, this.textField, this.infoField);
        this.textField.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                CharModePage.this.undoManager.addChange(event);
            }
        });
        this.setupSelectionProvider();
        this.setupContextMenu();
        State toggleState = this.getToggleState("com.ibm.etools.fm.ui.model.commands.showCols");
        this.rulerMode = (Boolean)toggleState.getValue();
        if (FormattedEditorPreferencePage.showRulerGridForCols()) {
            this.rulerMode = true;
            toggleState.setValue((Object)this.rulerMode);
        }
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)true);
        this.hideShowRecLenCol();
        if (this.rulerMode) {
            this.drawRuler(false);
        }
        this.styledText = this.textField;
    }

    public void performSelectAll() {
        if (this.styledText != null) {
            this.styledText.selectAll();
        }
    }

    public void copyToClipboard() {
        if (!this.infoField.getSelectionText().isEmpty()) {
            this.infoField.copy();
        } else if (!this.textField.getSelectionText().isEmpty()) {
            this.textField.copy();
        }
    }

    private void prepareScrollListenersForControl(final ScrollBar vScrollBar) {
        vScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CharModePage.this.alignTopLine(true);
                ScrollSupportStrategy.handleScrollAction(CharModePage.this.editor, vScrollBar, e);
            }
        });
        vScrollBar.getParent().addMouseWheelListener(ScrollSupportStrategy.prepareMouseWheelListener(this.editor, vScrollBar));
    }

    public void resetToggleState() {
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)false);
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showCols").setValue((Object)false);
    }

    private State getToggleState(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command toggleCommand = commandService.getCommand(commandId);
        State toggleState = toggleCommand.getState("org.eclipse.ui.commands.toggleState");
        return toggleState;
    }

    private void setInfoFieldColorSettings() {
        this.infoField.setBackground(FormattedEditorPreferencePage.getTextBackgroundColor());
        this.infoField.setForeground(FormattedEditorPreferencePage.getTextForegroundColor());
    }

    private boolean contentsModifiedLocally(ArrayList<String> currentLines) {
        if (currentLines.size() != this.originalLines.length) {
            return true;
        }
        int i = 0;
        while (i < this.originalLines.length) {
            if (!this.originalLines[i].getValue().equals(currentLines.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void annotateContents() {
        ArrayList<StyleRange> styleRangeList = new ArrayList<StyleRange>();
        ArrayList<String> lines = CharModePage.getLines(this.textField.getText(), true);
        ArrayList<DisplayLine> displayLines = this.editor.getCurrentEditorContents();
        if (!this.contentsModifiedLocally(lines)) {
            this.annotateContentsWithFindResult();
            return;
        }
        Color textForegroundColor = FormattedEditorPreferencePage.getTextForegroundColor();
        Color textBackgroundColor = FormattedEditorPreferencePage.getTextBackgroundColor();
        Color hexForegroundColor = FormattedEditorPreferencePage.getHexForegroundColor();
        Color lenErrForegroundColor = FormattedEditorPreferencePage.getLenErrTextForegroundColor();
        Color lenErrBackgroundColor = FormattedEditorPreferencePage.getLenErrTextBackgroundColor();
        int position = 0;
        int lineCount = 0;
        int i = 0;
        while (i < lines.size()) {
            String aLine = lines.get(i);
            int maxLen = this.getMaxRecordLength(i);
            if (i < displayLines.size() && displayLines.get(i) instanceof ShadowGroup) {
                StyleRange sr = new StyleRange(position, aLine.length(), textForegroundColor, lenErrBackgroundColor);
                styleRangeList.add(sr);
                position += aLine.length() + 1;
            } else {
                int aLineLength = aLine.length();
                if (FormattedEditorPreferencePage.inlineValidation() && this.isFixedLength) {
                    aLineLength = aLine.stripTrailing().length();
                }
                if (this.editor.isHexMode()) {
                    if (lineCount % 3 == 0) {
                        if (aLineLength <= maxLen) {
                            sr = new StyleRange(position, aLine.length(), textForegroundColor, textBackgroundColor);
                            styleRangeList.add(sr);
                        } else {
                            sr = new StyleRange(position, maxLen, textForegroundColor, textBackgroundColor);
                            styleRangeList.add(sr);
                            sr = new StyleRange(position + maxLen, aLine.length() - maxLen, lenErrForegroundColor, lenErrBackgroundColor);
                            styleRangeList.add(sr);
                        }
                    } else if (aLineLength <= maxLen) {
                        sr = new StyleRange(position, aLine.length(), hexForegroundColor, textBackgroundColor);
                        styleRangeList.add(sr);
                    } else {
                        sr = new StyleRange(position, maxLen, hexForegroundColor, textBackgroundColor);
                        styleRangeList.add(sr);
                        sr = new StyleRange(position + maxLen, aLine.length() - maxLen, lenErrForegroundColor, lenErrBackgroundColor);
                        styleRangeList.add(sr);
                    }
                    position += aLine.length() + 1;
                } else {
                    if (aLineLength <= maxLen) {
                        sr = new StyleRange(position, aLine.length(), textForegroundColor, textBackgroundColor);
                        styleRangeList.add(sr);
                    } else {
                        sr = new StyleRange(position, maxLen, textForegroundColor, textBackgroundColor);
                        styleRangeList.add(sr);
                        sr = new StyleRange(position + maxLen, aLine.length() - maxLen, lenErrForegroundColor, lenErrBackgroundColor);
                        styleRangeList.add(sr);
                    }
                    position += aLine.length() + 1;
                }
                ++lineCount;
            }
            ++i;
        }
        StyleRange[] ranges = new StyleRange[styleRangeList.size()];
        int i2 = 0;
        while (i2 < ranges.length) {
            ranges[i2] = (StyleRange)styleRangeList.get(i2);
            ++i2;
        }
        this.textField.setStyleRanges(ranges);
        this.setInfoFieldColorSettings();
    }

    private void annotateContentsWithFindResult() {
        ArrayList<StyleRange> styleRangeList = new ArrayList<StyleRange>();
        ArrayList<String> lines = CharModePage.getLines(this.textField.getText(), true);
        ArrayList<DisplayLine> displayLines = this.editor.getCurrentEditorContents();
        Color textForegroundColor = FormattedEditorPreferencePage.getTextForegroundColor();
        Color textBackgroundColor = FormattedEditorPreferencePage.getTextBackgroundColor();
        Color hexForegroundColor = FormattedEditorPreferencePage.getHexForegroundColor();
        Color hitBackgroundColor = FormattedEditorPreferencePage.getSearchMatchBackgroundColor();
        Color lenErrBackgroundColor = FormattedEditorPreferencePage.getLenErrTextBackgroundColor();
        int position = 0;
        int lineCount = 0;
        ArrayList<FindHitType> normalisedHitResult = null;
        int i = 0;
        while (i < lines.size()) {
            String aLine = lines.get(i);
            if (this.editor.isHexMode()) {
                normalisedHitResult = lineCount % 3 == 0 ? CharModePage.annotateLineByRecord(displayLines.get(i), aLine, position, styleRangeList, textForegroundColor, textBackgroundColor, hitBackgroundColor, lenErrBackgroundColor, null, position + aLine.length()) : CharModePage.annotateLineByRecord(displayLines.get(i), aLine, position, styleRangeList, hexForegroundColor, textBackgroundColor, hitBackgroundColor, lenErrBackgroundColor, normalisedHitResult, position + aLine.length());
                position += aLine.length() + 1;
            } else {
                normalisedHitResult = CharModePage.annotateLineByRecord(displayLines.get(i), aLine, position, styleRangeList, textForegroundColor, textBackgroundColor, hitBackgroundColor, lenErrBackgroundColor, null, position + aLine.length());
                position += aLine.length() + 1;
            }
            ++lineCount;
            ++i;
        }
        logger.trace((Object)"################## Beginning of normalised hit list ##################");
        if (normalisedHitResult != null) {
            i = 0;
            while (i < normalisedHitResult.size()) {
                FindHitType aHit = (FindHitType)normalisedHitResult.get(i);
                logger.trace((Object)(i + " pos=" + aHit.getPosn() + " len=" + aHit.getLen()));
                ++i;
            }
        } else {
            logger.trace((Object)"Normalised hit list is null.");
        }
        logger.trace((Object)"################## End of normalised hit list ##################");
        logger.trace((Object)"################## Begining of style range ##################");
        i = 0;
        while (i < styleRangeList.size()) {
            StyleRange sr = (StyleRange)styleRangeList.get(i);
            logger.trace((Object)(i + ": start=" + sr.start + " len=" + sr.length));
            ++i;
        }
        logger.trace((Object)"################## End of style range ##################");
        StyleRange[] ranges = new StyleRange[styleRangeList.size()];
        int i2 = 0;
        while (i2 < ranges.length) {
            ranges[i2] = styleRangeList.get(i2);
            ++i2;
        }
        this.textField.setStyleRanges(ranges);
        this.setInfoFieldColorSettings();
    }

    private static ArrayList<FindHitType> annotateLineByRecord(DisplayLine aDispLine, String aLineText, int startPosition, ArrayList<StyleRange> styleRangeList, Color textForegroundColor, Color backgroundColor, Color findHitBackgroundColor, Color lenErrBackgroundColor, ArrayList<FindHitType> normalisedHitList, int endPosition) {
        StyleRange sr;
        if (aDispLine instanceof ShadowGroup) {
            StyleRange sr2 = new StyleRange(startPosition, aLineText.length(), textForegroundColor, lenErrBackgroundColor);
            styleRangeList.add(sr2);
            return normalisedHitList;
        }
        if (normalisedHitList == null) {
            normalisedHitList = CharModePage.getNormalisedHitList(aDispLine.getRecord(), aLineText);
        }
        if (normalisedHitList.isEmpty()) {
            StyleRange sr3 = new StyleRange(startPosition, aLineText.length(), textForegroundColor, backgroundColor);
            styleRangeList.add(sr3);
            return normalisedHitList;
        }
        FindHitType prevHit = null;
        int i = 0;
        while (i < normalisedHitList.size()) {
            FindHitType aHit = normalisedHitList.get(i);
            if (prevHit == null) {
                if (aHit.getPosn() == 0) {
                    sr = new StyleRange(startPosition, aHit.getLen(), textForegroundColor, findHitBackgroundColor);
                    styleRangeList.add(sr);
                    startPosition += aHit.getLen();
                } else {
                    sr = new StyleRange(startPosition, aHit.getPosn(), textForegroundColor, backgroundColor);
                    styleRangeList.add(sr);
                    sr = new StyleRange(startPosition += aHit.getPosn(), aHit.getLen(), textForegroundColor, findHitBackgroundColor);
                    styleRangeList.add(sr);
                    startPosition += aHit.getLen();
                }
            } else if (prevHit.getPosn() + prevHit.getLen() != aHit.getPosn()) {
                sr = new StyleRange(startPosition, aHit.getPosn() - (prevHit.getPosn() + prevHit.getLen()), textForegroundColor, backgroundColor);
                styleRangeList.add(sr);
                sr = new StyleRange(startPosition += aHit.getPosn() - (prevHit.getPosn() + prevHit.getLen()), aHit.getLen(), textForegroundColor, findHitBackgroundColor);
                styleRangeList.add(sr);
                startPosition += aHit.getLen();
            } else {
                sr = new StyleRange(startPosition, aHit.getLen(), textForegroundColor, findHitBackgroundColor);
                styleRangeList.add(sr);
                startPosition += aHit.getLen();
            }
            prevHit = aHit;
            ++i;
        }
        StyleRange lastSR = styleRangeList.get(styleRangeList.size() - 1);
        if (lastSR.start + lastSR.length < endPosition) {
            int start = lastSR.start + lastSR.length;
            sr = new StyleRange(start, endPosition - start, textForegroundColor, backgroundColor);
            styleRangeList.add(sr);
            logger.trace((Object)("Adding defualt coloring between last search hit and the end of line. Start: " + start + " Length: " + (endPosition - start)));
        }
        return normalisedHitList;
    }

    private static ArrayList<FindHitType> getNormalisedHitList(RecType aRec, String aLineText) {
        ArrayList<FindHitType> combinedList = new ArrayList<FindHitType>();
        if (aRec.getFind().isEmpty()) {
            return combinedList;
        }
        ArrayList<FindHitType> hitList = CharModePage.sortByStartPosition((EList<FindHitType>)aRec.getFind());
        int i = 0;
        while (i < hitList.size()) {
            FindHitType aHit = hitList.get(i);
            int maxLen = Math.min(aRec.getLen(), aLineText.length());
            if (aHit.getPosn() + aHit.getLen() - 1 > maxLen) {
                logger.error((Object)("ERROR: Search hit error on record no: " + aRec.getRecno() + " seq: " + aRec.getSeq() + ". MaxLen: " + aRec.getLen() + " hit start: " + aHit.getPosn() + " hit len: " + aHit.getLen()));
            } else if (combinedList.isEmpty()) {
                FindHitType aNew = FMNXEDITFactory.eINSTANCE.createFindHitType();
                aNew.setPosn(aHit.getPosn() - 1);
                aNew.setLen(aHit.getLen());
                combinedList.add(aNew);
            } else {
                FindHitType prevHit = combinedList.get(combinedList.size() - 1);
                if (aHit.getPosn() - 1 <= prevHit.getPosn() + prevHit.getLen() - 1) {
                    prevHit.setLen(aHit.getPosn() + aHit.getLen() - 1 - prevHit.getPosn());
                } else {
                    FindHitType aNew = FMNXEDITFactory.eINSTANCE.createFindHitType();
                    aNew.setPosn(aHit.getPosn() - 1);
                    aNew.setLen(aHit.getLen());
                    combinedList.add(aNew);
                }
            }
            ++i;
        }
        return combinedList;
    }

    private static ArrayList<FindHitType> sortByStartPosition(EList<FindHitType> hitList) {
        ArrayList<FindHitType> sortedList = new ArrayList<FindHitType>();
        int i = 0;
        while (i < hitList.size()) {
            CharModePage.sortInsert(sortedList, (FindHitType)hitList.get(i));
            ++i;
        }
        return sortedList;
    }

    private static void sortInsert(ArrayList<FindHitType> sortedList, FindHitType aHit) {
        if (sortedList.isEmpty()) {
            sortedList.add(aHit);
            return;
        }
        int i = 0;
        while (i < sortedList.size()) {
            FindHitType anItem = sortedList.get(i);
            if (anItem.getPosn() == aHit.getPosn()) {
                return;
            }
            if (anItem.getPosn() > aHit.getPosn()) {
                sortedList.add(i, aHit);
                return;
            }
            ++i;
        }
        sortedList.add(aHit);
    }

    private int getMaxRecordLength(int lineNo) {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        if (lineNo >= lines.size()) {
            if (this.editor.getSessionProperties().isInplaceEdit()) {
                return 0;
            }
            return this.editor.getSessionProperties().getMaxRECL();
        }
        return FormattedPageUtility.getRecordMaxLength(this.editor.getSessionProperties(), lines.get(lineNo).getRecord());
    }

    private void setNewData() {
        int[] selectedLines = this.getSelectedLines();
        if (this.textFieldModifyListener != null) {
            this.textField.removeModifyListener(this.textFieldModifyListener);
            this.textFieldModifyListener = null;
        }
        this.textDirty = false;
        StringBuilder sbForTextField = new StringBuilder();
        StringBuilder sbForInfoField = new StringBuilder();
        StringBuilder sbForRecLen = new StringBuilder();
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        this.originalLines = new CharModeLine[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            this.originalLines[i] = new CharModeLine();
            ++i;
        }
        i = 0;
        while (i < lines.size()) {
            if (i != 0) {
                sbForInfoField.append("\n");
                sbForTextField.append("\n");
                sbForRecLen.append("\n");
            }
            DisplayLine aLine = lines.get(i);
            sbForRecLen.append(aLine.getRecord().getLen());
            this.recLenField.setText(sbForRecLen.toString());
            if (aLine instanceof HexRecordWrapper) {
                HexRecordWrapper hr = (HexRecordWrapper)aLine;
                this.originalLines[i].setValue(hr.getEntireHighOrLowHexString());
                String hex = this.originalLines[i].getShowValue();
                hex = PDBiDiHelpers.reverseIfVisualRTLRequired((IZRL)this.editor.getResource(), (String)hex);
                sbForTextField.append(hex);
            } else if (aLine instanceof EmptyRecordsShadowGroup) {
                this.originalLines[i].setValue(Messages.EmptyRecordsShadowGroup_MSG_LONG);
                sbForTextField.append(this.originalLines[i].getShowValue());
            } else {
                try {
                    byte[] byteValue = DataConversionUtils.getEBCDICData((String)aLine.getRecord().getHex());
                    this.originalLines[i].setValue(new String(byteValue, this.editor.getResource().getPersistentProperty("encoding")).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", "."));
                    if (PDBiDiHelpers.isResourceEncodingBiDi((IZRL)this.editor.getResource())) {
                        this.handleBidiListenerForFindMode(i);
                    }
                    sbForTextField.append(this.originalLines[i].getShowValue());
                }
                catch (UnsupportedEncodingException e) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.CharModePage_CONV_ERR, aLine.getRecord().getRecno()), (Throwable)e);
                    this.originalLines[i].setValue(aLine.getRecord().getHex());
                    sbForTextField.append(this.originalLines[i].getShowValue());
                }
            }
            if (aLine instanceof HexRecordWrapper) {
                sbForInfoField.append("");
            } else {
                Object infoAnnotation = "";
                if (aLine.getRecord().isNew()) {
                    infoAnnotation = (String)infoAnnotation + Messages.FormattedEditor_NEW_REC_FLAG;
                }
                if (aLine.getRecord().isChg()) {
                    infoAnnotation = (String)infoAnnotation + Messages.FormattedEditor_CHANGED_REC_FLAG;
                }
                if (aLine.getRecord().isLenError()) {
                    infoAnnotation = (String)infoAnnotation + Messages.FormattedEditor_LEN_ERR_FLAG;
                }
                String insertNewPrefix = this.editor.getSessionProperties().isInplaceEdit() ? Messages.FormattedEditor_INVALID_INSERT : Messages.FormattedEditor_INSERT_PENDING;
                sbForInfoField.append((String)(aLine.getRecord().isNew() && aLine.getRecord().isUpdateOnHostRequired() ? insertNewPrefix : aLine.getRecord().getRecno() + (String)infoAnnotation));
            }
            ++i;
        }
        this.setSelectionIfEmpty();
        this.infoField.setText(sbForInfoField.toString());
        this.textField.setText(sbForTextField.toString());
        this.checkAndApplyFontPreferences();
        this.setSelectedLines(selectedLines);
        this.editor.updateLocationInformation(-1);
        this.alignTopLine(true);
        this.annotateContents();
        this.isFixedLength = this.editor.getSessionProperties().isFixedLen();
        if (this.isFixedLength) {
            this.textField.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent event) {
                    if (!FormattedEditorPreferencePage.inlineValidation()) {
                        return;
                    }
                    if (event.text.length() <= 0) {
                        return;
                    }
                    int cursorIndex = CharModePage.this.styledText.getCaretOffset();
                    int index = CharModePage.this.styledText.getLineAtOffset(cursorIndex);
                    String currentText = CharModePage.this.styledText.getLine(index).stripTrailing();
                    event.doit = currentText.length() < CharModePage.this.editor.getSessionProperties().getMaxRECL() || CharModePage.this.styledText.getSelectionCount() != 0;
                }
            });
        }
        this.textFieldModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String insertPrefix;
                CharModePage.this.annotateContents();
                CharModePage.this.textDirty = true;
                CharModePage.this.editor.setDirty(true);
                String string = insertPrefix = CharModePage.this.editor.getSessionProperties().isInplaceEdit() ? Messages.FormattedEditor_INVALID_INSERT : Messages.FormattedEditor_INSERT_PENDING;
                if (CharModePage.this.infoField.getLineCount() < CharModePage.this.textField.getLineCount()) {
                    int diff = CharModePage.this.textField.getLineCount() - CharModePage.this.infoField.getLineCount();
                    String prefix = "\n" + insertPrefix;
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < diff) {
                        sb.append(prefix);
                        ++i;
                    }
                    CharModePage.this.infoField.append(sb.toString());
                    CharModePage.this.alignTopLine(true);
                } else if (CharModePage.this.editor.getCurrentEditorContents().isEmpty()) {
                    if (CharModePage.this.infoField.getText().isEmpty()) {
                        String prefix = insertPrefix;
                        CharModePage.this.infoField.setText(prefix);
                    }
                    CharModePage.this.alignTopLine(true);
                }
            }
        };
        this.textField.addModifyListener(this.textFieldModifyListener);
    }

    public void setSelectionIfEmpty() {
        try {
            if (this.textField.getSelectionText().isEmpty()) {
                this.textField.setSelection(0, 1);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("No Text selected due to " + ex.getMessage()));
        }
    }

    private void checkAndApplyFontPreferences() {
        if (!FormattedEditorPreferencePage.getFontStyle().getFontData()[0].getName().equals(DEFAULT_TEXT)) {
            this.infoField.setFont(FormattedEditorPreferencePage.getFontStyle());
            this.textField.setFont(FormattedEditorPreferencePage.getFontStyle());
        } else {
            this.infoField.setFont(JFaceResources.getTextFont());
            this.textField.setFont(JFaceResources.getTextFont());
        }
    }

    private void handleBidiListenerForFindMode(int i) {
        if (!this.editor.isFindModeActive() && PDBiDiHelpers.isBidiVisualSupportRequired((IZRL)this.editor.getResource())) {
            String bidiText = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)this.originalLines[i].getShowValue(), (boolean)true);
            this.originalLines[i].setValue(bidiText);
            if (this.listener != null) {
                this.listener.setActive(false);
            }
        } else if (this.listener != null) {
            this.listener.setActive(true);
        } else {
            this.listener = (VisualBidiSegmentListener)BidiUI.addBidiSegmentListener((StyledText)this.textField, (boolean)PDBiDiHelpers.isBidiVisualSupportRequired((IZRL)this.editor.getResource()), (boolean)PDBiDiHelpers.isRTLRequired((IZRL)this.editor.getResource()));
        }
    }

    private ArrayList<RecType> getModifiedRecords() {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        ArrayList<RecType> recordsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && aLine.getRecord().isUpdateOnHostRequired()) {
                if (aLine.getRecord().isLenError()) {
                    String validHex = FormattedEditorUtility.checkRecordLength(aLine.getRecord().getHex(), this.editor.getSessionProperties(), aLine.getRecord(), true, FormattedEditorUtility.getSpaceHexValue(this.editor.getResource().getPersistentProperty("encoding")));
                    aLine.getRecord().setHex(validHex);
                    aLine.getRecord().setLenError(false);
                    recordsToUpdate.add(CharModePage.createRecToUpdate(aLine.getRecord()));
                } else {
                    recordsToUpdate.add(CharModePage.createRecToUpdate(aLine.getRecord()));
                }
            }
            ++i;
        }
        return recordsToUpdate;
    }

    private static RecType createRecToUpdate(RecType oldRec) {
        RecType recToUpdate = FMNXEDITFactory.eINSTANCE.createRecType();
        recToUpdate.setToken(oldRec.getToken());
        if (oldRec.isSetSeq()) {
            recToUpdate.setSeq(oldRec.getSeq());
        }
        if (oldRec.isSetSeg()) {
            recToUpdate.setSeg(oldRec.getSeg());
        }
        recToUpdate.setHex(oldRec.getHex());
        if (oldRec.isSetInsert()) {
            recToUpdate.setInsert(true);
        } else {
            recToUpdate.setChg(true);
        }
        recToUpdate.setRecno(oldRec.getRecno());
        return recToUpdate;
    }

    private StringBuffer validateCurrentEditorContents() {
        if (!this.textDirty) {
            return new StringBuffer();
        }
        String encoding = this.editor.getResource().getPersistentProperty("encoding");
        StringBuffer errorMessages = new StringBuffer();
        ArrayList<DisplayLine> editorInputLines = this.editor.getCurrentEditorContents();
        ArrayList<String> currentGUILines = CharModePage.getLines(this.textField.getText(), false);
        FormattedEditorUtility.dumpCurrentEditorContents(currentGUILines);
        if (this.originalLines.length < editorInputLines.size()) {
            while (this.originalLines.length < editorInputLines.size()) {
                editorInputLines.remove(editorInputLines.size() - 1);
            }
        }
        DisplayLine[] currentLine = new DisplayLine[3];
        String[] inputLine = new String[3];
        String[] originalLine = new String[3];
        int currentLineIndex = 0;
        while (currentLineIndex < this.originalLines.length) {
            if (this.editor.isHexMode()) {
                int i = currentLineIndex;
                currentLine[0] = editorInputLines.get(i);
                currentLine[1] = editorInputLines.get(i + 1);
                currentLine[2] = editorInputLines.get(i + 2);
                inputLine[0] = CharModePage.getLine(currentGUILines, i);
                inputLine[1] = CharModePage.getLine(currentGUILines, i + 1);
                inputLine[2] = CharModePage.getLine(currentGUILines, i + 2);
                originalLine[0] = this.originalLines[i].getValue();
                originalLine[1] = this.originalLines[i + 1].getValue();
                originalLine[2] = this.originalLines[i + 2].getValue();
                currentLineIndex += 3;
            } else {
                currentLine[0] = editorInputLines.get(currentLineIndex);
                currentLine[1] = null;
                currentLine[2] = null;
                inputLine[0] = CharModePage.getLine(currentGUILines, currentLineIndex);
                inputLine[1] = null;
                inputLine[2] = null;
                originalLine[0] = this.originalLines[currentLineIndex].getValue();
                originalLine[1] = null;
                originalLine[2] = null;
                ++currentLineIndex;
            }
            this.validateCurrentLine(currentLine, inputLine, originalLine, this.editor.isHexMode(), errorMessages, encoding);
        }
        CharModePage.removeTailingBlankLines(currentGUILines, editorInputLines.size());
        if (currentGUILines.size() <= editorInputLines.size()) {
            return errorMessages;
        }
        if (this.editor.getSessionProperties().isInplaceEdit() || this.editor.getSessionProperties().isNoAppend()) {
            errorMessages.append("\n");
            errorMessages.append(Messages.CharModePage_NO_INSERT_WARN);
            errorMessages.append("\n");
            errorMessages.append(MessageFormat.format(Messages.CharModePage_NO_INSERT, currentGUILines.size() - editorInputLines.size()));
            errorMessages.append("\n");
            return errorMessages;
        }
        this.prepareNewRecords(currentGUILines, editorInputLines.size(), editorInputLines, encoding, errorMessages);
        return errorMessages;
    }

    private static void removeTailingBlankLines(ArrayList<String> currentGUILines, int newLineStartIndex) {
        if (currentGUILines.size() == newLineStartIndex) {
            logger.debug((Object)"No line to delete.");
            return;
        }
        int editorInputSize = currentGUILines.size();
        int i = currentGUILines.size() - 1;
        while (i >= newLineStartIndex) {
            String aLine = currentGUILines.get(i).trim();
            if (aLine.isEmpty()) {
                currentGUILines.remove(i);
                i = currentGUILines.size() - 1;
                continue;
            }
            logger.debug((Object)("1. Before removal: " + editorInputSize + " After removal: " + currentGUILines.size()));
            return;
        }
        logger.debug((Object)("2. Before removal: " + editorInputSize + " After removal: " + currentGUILines.size()));
    }

    private void validateCurrentLine(DisplayLine[] currentDispLine, String[] currentInputLine, String[] originalLine, boolean withHexLine, StringBuffer errorMessages, String encoding) {
        if (currentDispLine[0] instanceof ShadowGroup) {
            if (withHexLine) {
                if (currentInputLine[0].equals(originalLine[0]) && currentInputLine[1].equals(originalLine[1]) && currentInputLine[2].equals(originalLine[2])) {
                    return;
                }
                errorMessages.append(Messages.CharModePage_SHADOW_OVERWRITTEN + "\n");
                return;
            }
            if (currentInputLine[0].equals(originalLine[0])) {
                return;
            }
            errorMessages.append(Messages.CharModePage_SHADOW_OVERWRITTEN + "\n");
            return;
        }
        if (withHexLine) {
            if (currentInputLine[0].equals(originalLine[0]) && currentInputLine[1].equals(originalLine[1]) && currentInputLine[2].equals(originalLine[2]) && !currentDispLine[0].getRecord().isUpdateOnHostRequired()) {
                return;
            }
            if (currentInputLine[1].isEmpty() && currentInputLine[2].isEmpty()) {
                this.validateByText(currentDispLine, currentInputLine, errorMessages, encoding);
                return;
            }
            if (!FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(currentInputLine[1]).matches() || !FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(currentInputLine[2]).matches()) {
                errorMessages.append(MessageFormat.format(Messages.CharModePage_VERIFY_INVALID_HEX_VALUE, currentDispLine[0].getRecord().getRecno(), currentInputLine[1], currentInputLine[2]) + "\n");
                this.validateByText(currentDispLine, currentInputLine, errorMessages, encoding);
                return;
            }
            if (!currentInputLine[1].equals(originalLine[1]) || !currentInputLine[2].equals(originalLine[2])) {
                this.validateByHex(currentDispLine[0], currentInputLine[1], currentInputLine[2], errorMessages);
                return;
            }
            this.validateByText(currentDispLine, currentInputLine, errorMessages, encoding);
            return;
        }
        if (currentInputLine[0].equals(originalLine[0]) && !currentDispLine[0].getRecord().isUpdateOnHostRequired()) {
            return;
        }
        this.validateByText(currentDispLine, currentInputLine, errorMessages, encoding);
    }

    private void validateByText(DisplayLine[] currentDispLine, String[] currentInputLine, StringBuffer errorMessages, String encoding) {
        try {
            String hexString = null;
            if (this.editor.getTemplateResource() == null && FormattedEditorPreferencePage.assumeTextOnlyForChar()) {
                byte[] aNewLineBytes = currentInputLine[0].getBytes(encoding);
                hexString = DataConversionUtils.getHexString((byte[])aNewLineBytes);
            } else {
                hexString = this.constructHexString(currentDispLine, currentInputLine, encoding);
            }
            String verifiedHexString = FormattedEditorUtility.checkRecordLength(hexString, this.editor.getSessionProperties(), currentDispLine[0].getRecord(), false, FormattedEditorUtility.getSpaceHexValue(this.editor.getResource().getPersistentProperty("encoding")));
            if (verifiedHexString != null) {
                currentDispLine[0].getRecord().setHex(verifiedHexString);
                currentDispLine[0].getRecord().setLenError(false);
            } else {
                currentDispLine[0].getRecord().setHex(hexString);
                currentDispLine[0].getRecord().setLenError(true);
                errorMessages.append(MessageFormat.format(Messages.CharModePage_TEXT_LEN_ERR, currentDispLine[0].getRecord().getRecno(), currentInputLine[0].length(), this.editor.getSessionProperties().isInplaceEdit() ? currentDispLine[0].getRecord().getLen() : this.editor.getSessionProperties().getMaxRECL()) + "\n");
            }
            currentDispLine[0].getRecord().setChg(true);
            currentDispLine[0].getRecord().updateOnHostRequired(true);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.CharModePage_VERIFY_CONV_ERR, currentDispLine[0].getRecord().getRecno(), encoding, currentInputLine[0]);
            logger.error((Object)errMsg, (Throwable)e);
            errorMessages.append(errMsg + "\n");
        }
    }

    private String constructHexString(DisplayLine[] currentDispLine, String[] currentInputLine, String encoding) throws Exception {
        StringBuilder newHexString = new StringBuilder();
        currentInputLine[0] = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)currentInputLine[0], (boolean)true);
        if (FormattedEditorPreferencePage.inlineValidation() && this.isFixedLength) {
            currentInputLine[0] = PDBiDiHelpers.translateIfBidiRequired((IZRL)this.editor.getResource(), (String)currentInputLine[0], (boolean)true).stripTrailing();
        }
        byte[] currentLineBytes = currentInputLine[0].getBytes(encoding);
        String currentHexString = DataConversionUtils.getHexString((byte[])currentLineBytes);
        String currentText = currentInputLine[0];
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)currentDispLine[0].getRecord().getHex());
        String originalText = new String(byteValue, this.editor.getResource().getPersistentProperty("encoding")).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", ".");
        String originalHexString = currentDispLine[0].getRecord().getHex();
        int max = currentText.length() < originalText.length() ? currentText.length() : originalText.length();
        int i = 0;
        while (i < max) {
            if (currentText.charAt(i) == originalText.charAt(i)) {
                newHexString.append(originalHexString.charAt(i * 2));
                newHexString.append(originalHexString.charAt(i * 2 + 1));
            } else {
                newHexString.append(currentHexString.charAt(i * 2));
                newHexString.append(currentHexString.charAt(i * 2 + 1));
            }
            ++i;
        }
        if (currentText.length() > originalText.length()) {
            newHexString.append(currentHexString.substring(originalText.length() * 2));
        }
        return newHexString.toString();
    }

    private void validateByHex(DisplayLine aLine, String hexLineHigh, String hexLineLow, StringBuffer errors) {
        HexRecordWrapper hexWrap = aLine.getHexWrappers().get(0);
        if (hexLineHigh.length() < hexLineLow.length()) {
            errors.append(MessageFormat.format(Messages.CharModePage_VERIFY_UNMATCHED_HEX, hexWrap.getRecord().getRecno(), hexLineHigh.length(), hexLineLow.length()) + "\n");
            hexLineLow = hexLineLow.substring(0, hexLineHigh.length());
        } else if (hexLineHigh.length() > hexLineLow.length()) {
            errors.append(MessageFormat.format(Messages.CharModePage_VERIFY_UNMATCHED_HEX, hexWrap.getRecord().getRecno(), hexLineHigh.length(), hexLineLow.length()) + "\n");
            hexLineHigh = hexLineHigh.substring(0, hexLineLow.length());
        }
        String space = FormattedEditorUtility.getSpaceHexValue(this.editor.getResource().getPersistentProperty("encoding"));
        String verifiedNewLine = FormattedEditorUtility.checkRecordLengthOfString(hexLineHigh, this.editor.getSessionProperties(), aLine.getRecord(), space.charAt(0), false);
        String verifiedNextLine = FormattedEditorUtility.checkRecordLengthOfString(hexLineLow, this.editor.getSessionProperties(), aLine.getRecord(), space.charAt(1), false);
        if (verifiedNewLine == null || verifiedNextLine == null) {
            hexWrap.setHighAndLowHexValues(hexLineHigh, hexLineLow);
            hexWrap.getRecord().setLenError(true);
            hexWrap.getRecord().setChg(true);
            errors.append(MessageFormat.format(Messages.CharModePage_HEX_LEN_ERR, aLine.getRecord().getRecno(), hexLineHigh.length(), hexLineLow.length(), this.editor.getSessionProperties().isInplaceEdit() ? aLine.getRecord().getLen() : this.editor.getSessionProperties().getMaxRECL()) + "\n");
        } else {
            hexWrap.setHighAndLowHexValues(verifiedNewLine, verifiedNextLine);
            hexWrap.getRecord().setLenError(false);
            hexWrap.getRecord().setChg(true);
        }
        hexWrap.getRecord().updateOnHostRequired(true);
    }

    private static String getLine(ArrayList<String> currentGUILines, int lineIndex) {
        if (lineIndex < currentGUILines.size()) {
            return currentGUILines.get(lineIndex);
        }
        return "";
    }

    private static ArrayList<String> getLines(String inputText, boolean ignoreReturn) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < inputText.length()) {
            char currentChar = inputText.charAt(i);
            if (ignoreReturn || currentChar != '\r') {
                if (currentChar == '\n') {
                    lines.add(sb.toString());
                    sb = new StringBuilder();
                } else {
                    sb.append(currentChar);
                }
            }
            ++i;
        }
        lines.add(sb.toString());
        return lines;
    }

    private void prepareNewRecords(ArrayList<String> currentGUILines, int newStartIndex, ArrayList<DisplayLine> editorInputLines, String encoding, StringBuffer errorMessages) {
        RecType anchorRec = null;
        if (editorInputLines.isEmpty()) {
            anchorRec = FMNXEDITFactory.eINSTANCE.createRecType();
            anchorRec.setToken("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            anchorRec.setSeq(0);
        } else {
            anchorRec = editorInputLines.get(editorInputLines.size() - 1).getRecord();
        }
        if (this.editor.isHexMode()) {
            this.prepareNewRecordsWithHex(currentGUILines, newStartIndex, editorInputLines, anchorRec, encoding, errorMessages);
        } else {
            this.prepareNewRecordsNoHex(currentGUILines, newStartIndex, editorInputLines, anchorRec, encoding, errorMessages);
        }
    }

    private void prepareNewRecordsNoHex(ArrayList<String> currentGUILines, int newStartIndex, ArrayList<DisplayLine> editorInputLines, RecType anchorRec, String encoding, StringBuffer errorMessages) {
        int newRecIndex = 1;
        int i = newStartIndex;
        while (i < currentGUILines.size()) {
            this.insertNewRecByTextValue(currentGUILines.get(i), editorInputLines, anchorRec, newRecIndex++, encoding, errorMessages);
            ++i;
        }
    }

    private void prepareNewRecordsWithHex(ArrayList<String> currentGUILines, int newStartIndex, ArrayList<DisplayLine> editorInputLines, RecType anchorRec, String encoding, StringBuffer errorMessages) {
        int newRecIndex = 1;
        int i = newStartIndex;
        while (i < currentGUILines.size()) {
            String textLine = CharModePage.getLine(currentGUILines, i);
            String hexHighLine = CharModePage.getLine(currentGUILines, i + 1);
            String hexLowLine = CharModePage.getLine(currentGUILines, i + 2);
            if (hexHighLine.isEmpty() && hexLowLine.isEmpty()) {
                this.insertNewRecByTextValue(textLine, editorInputLines, anchorRec, newRecIndex++, encoding, errorMessages);
            } else if (!FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(hexHighLine).matches() || !FormattedEditorUtility.HEX_CHARACTERS_REGEXP.matcher(hexLowLine).matches()) {
                errorMessages.append(MessageFormat.format(Messages.CharModePage_NEW_REC_INVALID_HEX, newRecIndex, hexHighLine, hexLowLine) + "\n");
                this.insertNewRecByTextValue(textLine, editorInputLines, anchorRec, newRecIndex++, encoding, errorMessages);
            } else {
                this.insertNewRecByHexValue(hexHighLine, hexLowLine, editorInputLines, anchorRec, newRecIndex++, errorMessages);
            }
            i += 3;
        }
    }

    private void insertNewRecByTextValue(String textValue, ArrayList<DisplayLine> editorInputLines, RecType anchorRec, int sequenceNo, String encoding, StringBuffer errorMessages) {
        try {
            RecType aNewRec = FMNXEDITFactory.eINSTANCE.createRecType();
            aNewRec.setInsert(true);
            byte[] aNewLineBytes = textValue.getBytes(encoding);
            String hexString = DataConversionUtils.getHexString((byte[])aNewLineBytes);
            String verifiedHexString = FormattedEditorUtility.checkRecordLength(hexString, this.editor.getSessionProperties(), anchorRec, false, FormattedEditorUtility.getSpaceHexValue(this.editor.getResource().getPersistentProperty("encoding")));
            if (verifiedHexString != null) {
                aNewRec.setHex(verifiedHexString);
                aNewRec.setLenError(false);
            } else {
                aNewRec.setHex(hexString);
                aNewRec.setLenError(true);
                errorMessages.append(MessageFormat.format(Messages.CharModePage_NEW_TEXT_LEN_ERR, sequenceNo, textValue) + "\n");
            }
            aNewRec.setToken(anchorRec.getToken());
            aNewRec.setSeq(anchorRec.getSeq() + sequenceNo);
            aNewRec.setRecno(anchorRec.getRecno());
            aNewRec.updateOnHostRequired(true);
            DisplayLine newLine = new DisplayLine(this.editor.getResource(), aNewRec);
            editorInputLines.add(newLine);
            if (this.editor.isHexMode()) {
                HexRecordWrapper hexWrapper = new HexRecordWrapper(this.editor.getResource(), newLine, true);
                newLine.addHexRecordWrapper(hexWrapper);
                editorInputLines.add(hexWrapper);
                hexWrapper = new HexRecordWrapper(this.editor.getResource(), newLine, false);
                newLine.addHexRecordWrapper(hexWrapper);
                editorInputLines.add(hexWrapper);
            }
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.CharModePage_NEW_REC_EX, textValue);
            logger.error((Object)errMsg, (Throwable)e);
            errorMessages.append(errMsg + "\n");
        }
    }

    private void insertNewRecByHexValue(String hexHigh, String hexLow, ArrayList<DisplayLine> editorInputLines, RecType anchorRec, int sequenceNo, StringBuffer errorMessages) {
        RecType aNewRec = FMNXEDITFactory.eINSTANCE.createRecType();
        aNewRec.setInsert(true);
        String hexString = CharModePage.prepareHexValue(hexHigh, hexLow, sequenceNo, errorMessages);
        String verifiedHexString = FormattedEditorUtility.checkRecordLength(hexString, this.editor.getSessionProperties(), anchorRec, false, FormattedEditorUtility.getSpaceHexValue(this.editor.getResource().getPersistentProperty("encoding")));
        if (verifiedHexString != null) {
            aNewRec.setHex(verifiedHexString);
            aNewRec.setLenError(false);
        } else {
            aNewRec.setHex(hexString);
            aNewRec.setLenError(true);
            errorMessages.append(MessageFormat.format(Messages.CharModePage_NEW_HEX_LEN_ERR, sequenceNo, hexHigh, hexLow) + "\n");
        }
        aNewRec.setToken(anchorRec.getToken());
        aNewRec.setSeq(anchorRec.getSeq() + sequenceNo);
        aNewRec.setRecno(anchorRec.getRecno());
        aNewRec.updateOnHostRequired(true);
        DisplayLine newLine = new DisplayLine(this.editor.getResource(), aNewRec);
        editorInputLines.add(newLine);
        if (this.editor.isHexMode()) {
            HexRecordWrapper hexWrapper = new HexRecordWrapper(this.editor.getResource(), newLine, true);
            newLine.addHexRecordWrapper(hexWrapper);
            editorInputLines.add(hexWrapper);
            hexWrapper = new HexRecordWrapper(this.editor.getResource(), newLine, false);
            newLine.addHexRecordWrapper(hexWrapper);
            editorInputLines.add(hexWrapper);
        }
    }

    private static String prepareHexValue(String hexHigh, String hexLow, int sequenceNo, StringBuffer errorMessages) {
        if (hexHigh.length() < hexLow.length()) {
            errorMessages.append(MessageFormat.format(Messages.CharModePage_VERIFY_UNMATCHED_HEX_NEW_REC, sequenceNo, hexHigh, hexLow) + "\n");
            hexLow = hexLow.substring(0, hexHigh.length());
        } else if (hexHigh.length() > hexLow.length()) {
            errorMessages.append(MessageFormat.format(Messages.CharModePage_VERIFY_UNMATCHED_HEX_NEW_REC, sequenceNo, hexHigh, hexLow) + "\n");
            hexHigh = hexHigh.substring(0, hexLow.length());
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < hexHigh.length()) {
            sb.append(hexHigh.charAt(i));
            sb.append(hexLow.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 2049) {
            DisplayLine currentLine;
            int newIndexForSelection = -1;
            int currentOffset = this.textField.getCaretOffset();
            int lineNo = 0;
            if (currentOffset != -1) {
                lineNo = this.textField.getLineAtOffset(currentOffset);
                newIndexForSelection = this.editor.isHexMode() ? lineNo * 3 : lineNo / 3;
            }
            this.setNewData();
            if (newIndexForSelection != -1) {
                this.setSelectedLines(new int[]{newIndexForSelection});
            }
            if ((currentLine = this.editor.getCurrentLine()) != null) {
                SingleView.displayCurrentRecord(this.editor, currentLine);
            }
        } else if (propId == 2048) {
            this.setNewData();
        }
    }

    @Override
    public boolean updateHostEditorChain() {
        ArrayList<RecType> recsToUpdate = this.getModifiedRecords();
        int newRecCount = CharModePage.countNewRecords(recsToUpdate);
        try {
            if (UpdateHostEditorChainInHexOperation.execute(this.editor, recsToUpdate, this.editor.getTopRecord(), 1)) {
                this.editor.getSessionProperties().updateTotalNumRecords(newRecCount, true);
                this.editor.updateLocationInformation(-1);
                return true;
            }
            return false;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.editor.disableEditorActions();
            return false;
        }
    }

    private static int countNewRecords(ArrayList<RecType> recsToUpdate) {
        int newRecCount = 0;
        int i = 0;
        while (i < recsToUpdate.size()) {
            if (recsToUpdate.get(i).isInsert()) {
                ++newRecCount;
            }
            ++i;
        }
        return newRecCount;
    }

    @Override
    public String[] validateContents() {
        FormattedEditorUtility.dumpCurrentEditorContents(this.editor);
        StringBuffer errors = this.validateCurrentEditorContents();
        if (errors.length() == 0) {
            return null;
        }
        String errMsg = Messages.CharModePage_SOME_ERR;
        return new String[]{errMsg, errors.toString()};
    }

    @Override
    public ArrayList<RecType> getSelectedNonShadowLines() {
        ArrayList<RecType> list;
        block3: {
            ISelection sel;
            block2: {
                list = new ArrayList<RecType>();
                sel = this.selectionProvider.getSelection();
                if (sel != null) break block2;
                ArrayList<DisplayLine> currentContents = this.editor.getCurrentEditorContents();
                if (currentContents.size() <= 0) break block3;
                int[] selectedLines = this.getSelectedLines();
                int i = 0;
                while (i < selectedLines.length) {
                    CharModePage.addIfNew(list, currentContents.get(selectedLines[i]));
                    ++i;
                }
                break block3;
            }
            IStructuredSelection selection = (IStructuredSelection)sel;
            for (Object item : selection) {
                if (!(item instanceof DisplayLine) || item instanceof ShadowGroup) continue;
                DisplayLine dl = (DisplayLine)item;
                CharModePage.addIfNew(list, dl);
            }
        }
        return list;
    }

    @Override
    public void setCursor(NavigationSpecification navSpec) {
        logger.trace((Object)("moving to: " + navSpec.toString()));
        if (this.textField.isDisposed()) {
            logger.trace((Object)"the text control is disposed. Returning.");
            return;
        }
        if (navSpec.getLocationType() == NavigationSpecification.LocationType.TOP) {
            this.infoField.setSelection(0, 0);
            this.textField.setFocus();
            this.textField.setSelection(0, 0);
            this.textField.setCaretOffset(0);
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.BOTTOM) {
            int infoFieldLastStartOffset = this.infoField.getOffsetAtLine(this.infoField.getLineCount() - 1);
            this.infoField.setSelection(infoFieldLastStartOffset, infoFieldLastStartOffset);
            int textFieldLastLineStartOffset = this.textField.getOffsetAtLine(this.textField.getLineCount() - 1);
            this.textField.setSelection(textFieldLastLineStartOffset, textFieldLastLineStartOffset);
            this.textField.setCaretOffset(textFieldLastLineStartOffset);
            this.textField.setFocus();
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_NUMBER) {
            int index = this.editor.getIndexOf(navSpec.getRecordToken());
            if (index == -1) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CharModePage_NO_RECFOUND, navSpec.getRecordToken()));
                return;
            }
            int infoFieldLastStartOffset = this.infoField.getOffsetAtLine(index);
            this.infoField.setSelection(infoFieldLastStartOffset, infoFieldLastStartOffset);
            int textFieldLastLineStartOffset = this.textField.getOffsetAtLine(index);
            this.textField.setFocus();
            this.textField.setSelection(textFieldLastLineStartOffset, textFieldLastLineStartOffset);
            this.textField.setCaretOffset(textFieldLastLineStartOffset);
            this.editor.setFocus();
            this.textField.setFocus();
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.RECORD_OFFSET) {
            int index = 0;
            if (navSpec.getRecordToken() != null && (index = this.editor.getIndexOf(navSpec.getRecordToken())) == -1) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.CharModePage_NO_RECFOUND, navSpec.getRecordToken()));
                return;
            }
            int infoFieldLastStartOffset = this.infoField.getOffsetAtLine(index);
            this.infoField.setSelection(infoFieldLastStartOffset, infoFieldLastStartOffset);
            int offset = navSpec.getOffset();
            DisplayLine aLine = this.editor.getCurrentEditorContents().get(index);
            if (offset >= aLine.getRecord().getLen()) {
                offset = aLine.getRecord().getLen();
            }
            int textFieldLastLineStartOffset = this.textField.getOffsetAtLine(index);
            this.textField.setSelection(textFieldLastLineStartOffset + offset, textFieldLastLineStartOffset + offset);
            this.textField.setCaretOffset(textFieldLastLineStartOffset + offset);
            this.textField.setFocus();
            this.rulerText.setSelection(textFieldLastLineStartOffset + offset, textFieldLastLineStartOffset + offset);
            this.rulerText.setCaretOffset(textFieldLastLineStartOffset + offset);
            this.editor.updateLocationInformation(offset);
        } else if (navSpec.getLocationType() == NavigationSpecification.LocationType.JUST_FOCUS) {
            this.textField.setFocus();
        } else {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.FormattedEditor_UNSUPPORTED_NAV_SPEC, new Object[]{navSpec.getLocationType()}));
        }
    }

    private void setupSelectionProvider() {
        this.selectionProvider = new CharModeSelectionProvider(this.editor);
        this.editor.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.infoField.addMouseListener((MouseListener)this.selectionProvider);
        this.textField.addMouseListener((MouseListener)this.selectionProvider);
        this.infoField.addKeyListener((KeyListener)this.selectionProvider);
        this.textField.addKeyListener((KeyListener)this.selectionProvider);
        this.infoField.addSelectionListener((SelectionListener)this.selectionProvider);
        this.textField.addSelectionListener((SelectionListener)this.selectionProvider);
        this.textField.addCaretListener((CaretListener)this.selectionProvider);
    }

    private void setupContextMenu() {
        MenuManager popupMenu1 = this.editor.getActionManager().getPopupMenu();
        if (this.popup1 == null) {
            this.popup1 = popupMenu1.createContextMenu((Control)this.infoField);
        }
        if (this.popup2 == null) {
            this.popup2 = popupMenu1.createContextMenu((Control)this.textField);
        }
        this.infoField.setMenu(this.popup1);
        this.textField.setMenu(this.popup2);
        this.editor.getSite().registerContextMenu(popupMenu1, (ISelectionProvider)this.selectionProvider);
    }

    private void alignTopLine(boolean alignByContentText) {
        int topLineIndex = 0;
        topLineIndex = alignByContentText ? this.textField.getTopIndex() : this.infoField.getTopIndex();
        this.infoField.setTopIndex(topLineIndex);
        this.textField.setTopIndex(topLineIndex);
        this.recLenField.setTopIndex(topLineIndex);
    }

    @Override
    public int[] getSelectedLines() {
        if (this.textField.isDisposed()) {
            return null;
        }
        Point selection = this.textField.getSelection();
        int start = selection.x;
        int end = selection.y;
        int startLine = this.textField.getLineAtOffset(start);
        int endLine = this.textField.getLineAtOffset(end);
        if (startLine == -1 || endLine == -1) {
            return new int[0];
        }
        int[] sel = new int[endLine - startLine + 1];
        int i = 0;
        while (startLine + i <= endLine) {
            sel[i] = startLine + i;
            ++i;
        }
        return sel;
    }

    @Override
    public boolean setSelectedLines(int[] selection) {
        if (this.textField.isDisposed()) {
            return false;
        }
        if (selection == null || selection.length == 0) {
            return false;
        }
        if (selection[0] >= this.editor.getCurrentEditorContents().size()) {
            return false;
        }
        int startLine = selection[0];
        int endLine = selection[selection.length - 1];
        if (endLine >= this.textField.getLineCount()) {
            endLine = this.textField.getLineCount() - 1;
        }
        int startCaretLoc = this.textField.getOffsetAtLine(startLine);
        int endCaretLoc = this.findEndOfLineCaretLocation(this.textField.getOffsetAtLine(endLine));
        this.textField.setSelection(startCaretLoc, endCaretLoc);
        this.textField.setHorizontalIndex(0);
        this.alignTopLine(true);
        this.editor.updateLocationInformation(-1);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int findEndOfLineCaretLocation(int start) {
        text = this.textField.getText();
        if (start < text.length()) ** GOTO lbl5
        return start;
lbl-1000:
        // 1 sources

        {
            ++start;
lbl5:
            // 2 sources

            ** while (start < text.length() && text.charAt((int)start) != '\n')
        }
lbl6:
        // 1 sources

        return start;
    }

    public void undo() {
        this.undoManager.undo();
    }

    public void redo() {
        this.undoManager.redo();
    }

    public void clearUndoManager() {
        this.undoManager.reset();
    }

    public void toggleBlockSelection() {
        if (this.textField != null && !this.textField.isDisposed()) {
            this.blockSelectionMode = !this.blockSelectionMode;
            this.textField.setBlockSelection(this.blockSelectionMode);
        }
    }

    public boolean getBlockSelection() {
        return this.blockSelectionMode;
    }

    @Override
    public int getCursorIndexOnSelectedLine() {
        if (this.textField != null && !this.textField.isDisposed()) {
            int caretOffset = this.textField.getCaretOffset();
            int lineNo = this.textField.getLineAtOffset(caretOffset);
            int offsetAtLine = this.textField.getOffsetAtLine(lineNo);
            return caretOffset - offsetAtLine;
        }
        return 0;
    }

    public boolean isTextDirty() {
        return this.textDirty;
    }

    public int refreshContent(int showFromColumnIndex) {
        if (showFromColumnIndex > this.maxLineLen) {
            showFromColumnIndex = this.maxLineLen - 1;
        }
        this.setNewData();
        if (this.rulerMode) {
            if (this.editor.getShowFromColumnIndex() > this.maxLineLen) {
                this.rulerText.setText(DEFAULT_TEXT);
            } else if (this.editor.getShowFromColumnIndex() + FormattedEditorPreferencePage.getMaxCharacterNo() > this.maxLineLen) {
                this.setRulerMarker(this.editor.getShowFromColumnIndex(), this.maxLineLen);
            } else {
                this.setRulerMarker(this.editor.getShowFromColumnIndex(), this.editor.getShowFromColumnIndex() + FormattedEditorPreferencePage.getMaxCharacterNo());
            }
            Font font = FormattedEditorPreferencePage.getFontStyle();
            this.rulerText.setFont(font);
            this.rulerText.setBackground(Display.getDefault().getSystemColor(15));
        }
        return showFromColumnIndex;
    }

    private void setRulerMarker(int columnIndex, int maxCharLength) {
        String substring = this.cols.substring(columnIndex, maxCharLength);
        StringBuilder string = new StringBuilder(substring);
        int i = 1;
        while (i < substring.length()) {
            if (Character.isDigit(substring.charAt(i)) && substring.charAt(i) != '0' && substring.charAt(i + 1) == '-') {
                String string2 = Integer.toString(columnIndex + i + 1);
                string.replace(i, i + string2.length(), string2);
                break;
            }
            ++i;
        }
        this.rulerText.setText(string.toString());
    }

    @Override
    public String getSelectedText() {
        String selectionText;
        if (this.infoField != null && this.infoField.isFocusControl()) {
            String selectionText2 = this.infoField.getSelectionText();
            if (selectionText2 != null) {
                return selectionText2;
            }
        } else if (this.textField != null && this.textField.isFocusControl() && (selectionText = this.textField.getSelectionText()) != null) {
            return selectionText;
        }
        return "";
    }

    public void drawRuler(boolean promptCheck) {
        if (this.editor.isDirty() && promptCheck) {
            boolean response = PDDialogs.openQuestion((String)Messages.CharModePage_RULER_WARNING);
            if (response) {
                this.renderRulerContent();
            }
            return;
        }
        this.renderRulerContent();
    }

    public void renderRulerContent() {
        Listener[] listeners = this.textField.getListeners(9);
        boolean isPaintListeneradded = false;
        Listener paintListner = null;
        Listener[] listenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listner = listenerArray[n2];
            if (listner instanceof TypedListener) {
                isPaintListeneradded = true;
                paintListner = listner;
            }
            ++n2;
        }
        this.cols = DEFAULT_TEXT;
        String initialText = "----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8";
        String concatenatedText = "----+----0----+----1----+----2----+----3----+----4----+----5----+----6----+----7----+----8----+----9";
        GridData infoGrid = (GridData)this.infoText.getLayoutData();
        GridData rulerGrid = (GridData)this.rulerText.getLayoutData();
        GridData recLenGrid = (GridData)this.recLenText.getLayoutData();
        Composite rulerComposite = this.rulerText.getParent();
        Composite inforComposite = this.infoText.getParent();
        Composite recLenComposite = this.recLenField.getParent();
        if (isPaintListeneradded) {
            Listener[] scrollListeners = this.textField.getHorizontalBar().getListeners(13);
            this.textField.removeListener(9, paintListner);
            Listener[] listenerArray2 = scrollListeners;
            int n3 = scrollListeners.length;
            int n4 = 0;
            while (n4 < n3) {
                Listener scrollListener = listenerArray2[n4];
                if (scrollListener instanceof TypedListener) {
                    this.textField.getHorizontalBar().removeListener(13, scrollListener);
                }
                ++n4;
            }
            this.rulerText.setText(initialText);
            this.rulerText.setBackground(Display.getDefault().getSystemColor(1));
            this.infoText.setBackground(Display.getDefault().getSystemColor(1));
            this.recLenText.setBackground(Display.getDefault().getSystemColor(1));
            infoGrid.heightHint = 0;
            rulerGrid.heightHint = 0;
            recLenGrid.heightHint = 0;
            this.rulerMode = false;
        } else {
            this.rulerMode = true;
            String[] lines = this.textField.getText().split("\\r?\\n");
            int largestLinelength = 0;
            String[] stringArray = lines;
            int n5 = lines.length;
            int n6 = 0;
            while (n6 < n5) {
                String line = stringArray[n6];
                int length = line.stripTrailing().length();
                if (length > largestLinelength) {
                    largestLinelength = length;
                }
                ++n6;
            }
            int maxLength = 0;
            this.cols = String.valueOf(this.cols) + initialText;
            if (this.maxLineLen > 80) {
                this.cols = String.valueOf(this.cols) + "----+----9";
                maxLength = this.maxLineLen - 90;
                int rem = maxLength / 100;
                int i = 0;
                while (i <= rem) {
                    this.cols = String.valueOf(this.cols) + concatenatedText;
                    ++i;
                }
            }
            int j = 100;
            StringBuilder string = new StringBuilder(this.cols);
            while (j < this.cols.length()) {
                string.replace(j - 1, j + Integer.toString(j).length() - 1, Integer.toString(j));
                j += 100;
            }
            this.cols = DEFAULT_TEXT;
            this.cols = string.toString();
            this.rulerText.setText(this.cols.substring(this.editor.getShowFromColumnIndex(), this.editor.getShowFromColumnIndex() + largestLinelength));
            Font font = FormattedEditorPreferencePage.getFontStyle();
            this.rulerText.setFont(font);
            this.rulerText.setBackground(Display.getDefault().getSystemColor(15));
            this.infoText.setBackground(Display.getDefault().getSystemColor(15));
            this.recLenText.setBackground(Display.getDefault().getSystemColor(15));
            infoGrid.heightHint = 20;
            rulerGrid.heightHint = 20;
            recLenGrid.heightHint = 20;
            this.textField.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (CharModePage.this.textField != null) {
                        int x = CharModePage.this.textField.getCaret().getLocation().x;
                        int y = CharModePage.this.textField.getCaret().getLocation().y - CharModePage.this.textField.getLocationAtOffset((int)CharModePage.this.textField.getCaretOffset()).y;
                        if (x >= 0) {
                            Rectangle area = CharModePage.this.textField.getClientArea();
                            e.gc.setForeground(Display.getDefault().getSystemColor(15));
                            e.gc.setLineStyle(1);
                            e.gc.setLineWidth(2);
                            e.gc.drawLine(x, y, x, area.height);
                        }
                    }
                }
            });
            this.textField.getHorizontalBar().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    CharModePage.this.rulerText.setHorizontalIndex(CharModePage.this.textField.getHorizontalIndex());
                    CharModePage.this.rulerText.layout(true);
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        rulerComposite.layout();
        inforComposite.layout();
        recLenComposite.layout();
        this.editor.refresh();
    }

    public boolean isRulerMode() {
        return this.rulerMode;
    }

    public StyledText getRulerText() {
        return this.rulerText;
    }

    @Override
    public void hideShowRecLenCol() {
        boolean toggleState = (Boolean)this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").getValue();
        if (!toggleState) {
            this.composite.setWeights(new int[]{5, 5, 90});
            this.editor.refresh();
            this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)true);
        } else {
            int[] nArray = new int[3];
            nArray[0] = 5;
            nArray[2] = 95;
            this.composite.setWeights(nArray);
            this.editor.refresh();
            this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)false);
        }
    }

    private class CharModeLine {
        String value = new String("");

        public void setValue(String value) {
            int valueLen = value.length();
            this.value = value;
            if (!CharModePage.this.segmented && valueLen > FormattedEditorPreferencePage.getMaxCharacterNo()) {
                CharModePage.this.segmented = true;
                CharModePage.this.editor.setSegmentedStatus(true);
                if (CharModePage.this.editor.getEditorInput() != null && CharModePage.this.editor.getEditorInput().isEditSession()) {
                    CharModePage.this.topNavbar.setEditType(BaseEditorOptions.EditType.VIEW);
                    PDDialogs.openWarningThreadSafe((String)Messages.Warning, (String)MessageFormat.format(Messages.CharModePage_WarningWhenRecordLengthGreaterThanMaxSegmentWidth, valueLen, FormattedEditorPreferencePage.getMaxCharacterNo()));
                }
                CharModePage.this.editor.getEditorInput().setEditSession(false);
                CharModePage.this.textField.setEditable(false);
            }
            if (valueLen > CharModePage.this.maxLineLen) {
                CharModePage.this.maxLineLen = valueLen;
            }
        }

        public String getShowValue() {
            if (CharModePage.this.segmented) {
                int startInd = CharModePage.this.editor.getShowFromColumnIndex();
                int endInd = startInd + FormattedEditorPreferencePage.getMaxCharacterNo();
                if (startInd >= this.value.length()) {
                    return "";
                }
                if (endInd >= this.value.length()) {
                    return this.value.substring(startInd);
                }
                return this.value.substring(startInd, endInd);
            }
            return this.value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

