/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.pages.advanced;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFormattedEditorPage;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.HexRecordWrapper;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.contents.ShadowLine;
import com.ibm.etools.fm.editor.formatted.nattable.NatTableWrapper;
import com.ibm.etools.fm.editor.formatted.nattable.provider.SymbolDataProvider;
import com.ibm.etools.fm.editor.formatted.nattable.util.Utils;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.editor.formatted.operations.ValidateFormattedValuesdOperation;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.editor.formatted.pages.single.SingleView;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.HdrType;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.CreateType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TemplateType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class AdvancedModePage
extends IFormattedEditorPage {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2025. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(AdvancedModePage.class);
    private FormattedEditor editor = null;
    private int maxShowColumns = 50;
    private int showFromColumnIndex;
    private SashForm composite;
    private NatTableWrapper table;

    public AdvancedModePage(FormattedEditor editor2, Composite parent, int showFromColumnIndex, int maxShowColumns) {
        this.editor = editor2;
        this.showFromColumnIndex = showFromColumnIndex;
        this.maxShowColumns = maxShowColumns;
        this.createControl(parent);
    }

    private void createControl(Composite p) {
        SashForm editorComposite = new SashForm(p, 256);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        editorComposite.setLayoutData((Object)data);
        if (this.editor.getTemplateResource() == null || this.editor.getCurrentTemplate() == null) {
            return;
        }
        TemplateType template = this.editor.getCurrentTemplate();
        EList layouts = template.getLayout();
        Layouttype currentLayout = null;
        int i = 0;
        while (i < layouts.size()) {
            Layouttype aLayout = (Layouttype)layouts.get(i);
            if (aLayout.getId() == this.editor.getActiveLayoutID()) {
                currentLayout = aLayout;
                break;
            }
            if (currentLayout == null && aLayout.isSel()) {
                currentLayout = aLayout;
            }
            ++i;
        }
        this.createTables((Composite)editorComposite, currentLayout);
    }

    private Control createTables(Composite parent, Layouttype aLayout) {
        HdrType header = this.editor.getCurrentTableHeader(aLayout.getId());
        if (header == null) {
            return null;
        }
        EList headers = header.getHdrfld();
        this.table = new NatTableWrapper(aLayout, this.editor, parent);
        this.table.setFocus();
        return parent;
    }

    public void resetToggleState() {
        this.getToggleState("com.ibm.etools.fm.ui.model.commands.showRecLen").setValue((Object)false);
    }

    private State getToggleState(String commandId) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command toggleCommand = commandService.getCommand(commandId);
        State toggleState = toggleCommand.getState("org.eclipse.ui.commands.toggleState");
        return toggleState;
    }

    private ArrayList<RecType> getRecordsWithError() {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        ArrayList<RecType> recordsWithErrors = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            RecType aRec;
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && (aRec = aLine.getRecord()).isUpdateOnHostRequired() && (aRec.isSetDataError() || aRec.isDataError() || aRec.isSetLenError() || aRec.isLenError())) {
                recordsWithErrors.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsWithErrors;
    }

    public void propertyChanged(Object arg0, int arg1) {
    }

    @Override
    public String[] validateContents() throws InterruptedException {
        ArrayList<RecType> recsToUpdate = this.getModifiedRecords();
        if (recsToUpdate.size() > 0) {
            ValidateFormattedValuesdOperation.execute(this.editor, recsToUpdate);
            ArrayList<RecType> recordsWithErrors = this.getRecordsWithError();
            if (recordsWithErrors.isEmpty()) {
                return null;
            }
            String errMsg = MessageFormat.format(Messages.FormattedPage_ERR_FIELDS_EXISTS, recordsWithErrors.size());
            return new String[]{errMsg, errMsg};
        }
        return null;
    }

    @Override
    public boolean updateHostEditorChain() {
        ArrayList<RecType> modified = this.getModifiedRecords();
        ArrayList<RecType> recsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < modified.size()) {
            recsToUpdate.add(this.createRecToUpdate(modified.get(i)));
            ++i;
        }
        try {
            return UpdateHostEditorChainInHexOperation.execute(this.editor, recsToUpdate, this.editor.getTopRecord(), 1);
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            this.editor.disableEditorActions();
            return false;
        }
    }

    private ArrayList<RecType> getModifiedRecords() {
        ArrayList<DisplayLine> lines = this.editor.getCurrentEditorContents();
        ArrayList<RecType> recordsToUpdate = new ArrayList<RecType>();
        int i = 0;
        while (i < lines.size()) {
            DisplayLine aLine = lines.get(i);
            if (!(aLine instanceof ShadowGroup) && !(aLine instanceof HexRecordWrapper) && aLine.getRecord().isUpdateOnHostRequired()) {
                recordsToUpdate.add(aLine.getRecord());
            }
            ++i;
        }
        return recordsToUpdate;
    }

    public RecType createRecToUpdate(RecType oldRec) {
        RecType recToUpdate = FMNXEDITFactory.eINSTANCE.createRecType();
        recToUpdate.setToken(oldRec.getToken());
        if (oldRec.isSetSeq()) {
            recToUpdate.setSeq(oldRec.getSeq());
        }
        if (oldRec.isSetSeg()) {
            recToUpdate.setSeg(oldRec.getSeg());
        }
        recToUpdate.setHex(oldRec.getHex());
        recToUpdate.setChg(true);
        recToUpdate.setRecno(oldRec.getRecno());
        return recToUpdate;
    }

    public Object[] setSize(Object[] arr, int size) {
        arr = new Object[size];
        return arr;
    }

    public Object[][] getSelectedNonShadowLines2() {
        SelectionLayer selection = this.table.getSelectionLayer();
        PositionCoordinate[] coordinates = selection.getSelectedCellPositions();
        List<Integer> rowArr = Utils.getRowPositions(coordinates);
        Collections.sort(rowArr);
        Object[][] data = new Object[Utils.getRowPositions(coordinates).size()][Utils.getColPositions(coordinates).size()];
        int i = 0;
        while (i < rowArr.size()) {
            List<Integer> colArr = Utils.getColPoistionsByRow(coordinates, rowArr.get(i));
            int diff = data[i].length - colArr.size();
            if (diff > 0) {
                data[i] = this.setSize(data[i], colArr.size());
            }
            int j = 0;
            while (j < colArr.size()) {
                data[i][j] = selection.getDataValueByPosition(colArr.get(j).intValue(), rowArr.get(i).intValue());
                ++j;
            }
            ++i;
        }
        return data;
    }

    @Override
    public ArrayList<RecType> getSelectedNonShadowLines() {
        ArrayList<RecType> list = new ArrayList<RecType>();
        SelectionLayer selection = this.table.getSelectionLayer();
        SymbolDataProvider dataProvider = this.table.getDataProvider();
        PositionCoordinate[] coordinates = selection.getSelectedCellPositions();
        int i = 0;
        while (i < coordinates.length) {
            DisplayLine rowSelection = dataProvider.getRecordValue(coordinates[i].rowPosition);
            if (rowSelection instanceof DisplayLine && !(rowSelection instanceof ShadowGroup)) {
                DisplayLine dl = rowSelection;
                AdvancedModePage.addIfNew(list, dl);
            }
            ++i;
        }
        return list;
    }

    public int[][] getSelection() {
        PositionCoordinate[] coordinates = this.table.getSelectionLayer().getSelectedCellPositions();
        if (coordinates.length > 0) {
            return new int[][]{{coordinates[0].rowPosition, coordinates[0].columnPosition}};
        }
        return new int[][]{new int[2]};
    }

    @Override
    public int[] getSelectedLines() {
        return null;
    }

    @Override
    public void hideShowRecLenCol() {
    }

    @Override
    public boolean setSelectedLines(int[] selection) {
        return false;
    }

    @Override
    public void setCursor(NavigationSpecification navSpec) {
    }

    @Override
    public int getCursorIndexOnSelectedLine() {
        return 0;
    }

    @Override
    protected String getSelectedText() {
        return null;
    }

    private void setModifiedValue(DisplayLine dl, int tableColumnIndex, String newValue, NatTableWrapper table) {
        if (!this.editor.isEditSession()) {
            return;
        }
        if (dl instanceof ShadowLine | dl instanceof ShadowGroup) {
            logger.debug((Object)"Cannot update shadowline!");
            return;
        }
        int fieldIndex = tableColumnIndex - 1;
        FieldType aField = FormattedPageUtility.getField(dl.getRecord(), fieldIndex);
        if (aField == null) {
            logger.debug((Object)"No field to update..");
            return;
        }
        HdrType headers = this.editor.getCurrentTableHeader(dl.getRecord().getId());
        HdrfldType aHeader = (HdrfldType)headers.getHdrfld().get(fieldIndex - 1);
        Symboltype aSymbol = FormattedPageUtility.getSymbol(dl.getRecord(), aHeader, this.editor.getCurrentTemplate());
        int maxFieldLen = FormattedPageUtility.getFieldMaxLen(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        int minFieldLen = FormattedPageUtility.getFieldMinLength(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aHeader);
        if (maxFieldLen == -1) {
            return;
        }
        logger.debug((Object)("Current column is at " + fieldIndex + ". start=" + (aHeader.isSetStart() ? aHeader.getStart() : aSymbol.getStart()) + " length=" + (aSymbol.isSetLength() ? aSymbol.getLength() : aHeader.getLen()) + " type=" + aSymbol.getType().getName()));
        if (aSymbol.getCreate() == CreateType.NA) {
            return;
        }
        if (dl instanceof HexRecordWrapper) {
            if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValueVC(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    FormattedPageUtility.setHexHighOrLowValueVC(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.editor.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            } else {
                String hexValue = newValue;
                HexRecordWrapper hrw = (HexRecordWrapper)dl;
                String oldHexValue = FormattedPageUtility.getHexHighOrLowValue(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader);
                if (!oldHexValue.equals(hexValue)) {
                    if (hexValue.length() < minFieldLen) {
                        hexValue = FormattedEditorUtility.addPaddingForString(hexValue, minFieldLen, '0');
                    }
                    FormattedPageUtility.setHexHighOrLowValue(this.editor.getSessionProperties(), hrw, aSymbol, aField, aHeader, hexValue);
                    dl.getRecord().updateOnHostRequired(true);
                    this.editor.setDirty(true);
                    aField.setFieldUpdatedLocally(true, true);
                }
            }
        } else {
            String textValue = newValue;
            if (FormattedPageUtility.isDb2NullableField(this.editor, aSymbol)) {
                FormattedPageUtility.updateDb2NullableFieldIfRequired(this.editor, textValue, aSymbol, dl.getRecord(), aField, aHeader, true);
            } else if (FormattedPageUtility.performLocalStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getANValue(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, false, this.editor.getResource(), this.editor.getSessionIdentifier().getEditorOffset());
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.editor.getSessionProperties(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), textValue, this.editor.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (FormattedPageUtility.performAnVcStrProc(aSymbol)) {
                String oldTexValue = FormattedPageUtility.getPliVCValue(this.editor.getSessionProperties(), dl.getRecord(), aSymbol, aField, aHeader, this.editor.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateHexValue(this.editor.getSessionProperties(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), textValue, this.editor.getResource(), aSymbol);
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (aSymbol.getCreate().equals((Object)CreateType.VC)) {
                String oldTexValue = FormattedPageUtility.getVCValue(this.editor.getSessionProperties(), this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aSymbol, aField, aHeader, this.editor.getResource(), true);
                if (!textValue.equals(oldTexValue)) {
                    String errMsg = FormattedPageUtility.updateVCHexValue(this.editor.getSessionProperties(), this.editor.getSessionIdentifier().getDb2EditOptions().getEditorOptions(), dl.getRecord(), aField, aHeader, this.editor.getCurrentTemplate(), textValue, aSymbol, this.editor.getResource());
                    if (errMsg != null) {
                        PDDialogs.openErrorThreadSafe((String)errMsg);
                    } else {
                        dl.getRecord().setChg(true);
                        dl.getRecord().updateOnHostRequired(true);
                        this.editor.setDirty(true);
                        aField.setFieldUpdatedLocally(true, false);
                    }
                }
            } else if (!textValue.equals(aField.getValue())) {
                aField.setValue(textValue);
                dl.getRecord().setChg(true);
                dl.getRecord().updateOnHostRequired(true);
                this.editor.setDirty(true);
                aField.setFieldUpdatedLocally(true, false);
            }
        }
        SingleView.displayCurrentRecord(this.editor, dl);
    }

    class BlockSelection {
        private Map<String, String> values;
        private Set<Range> range;

        public BlockSelection(Map<String, String> values, Set<Range> range) {
            this.values = values;
            this.range = range;
        }
    }
}

