/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class ValidateFormattedValuesdOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(ValidateFormattedValuesdOperation.class);

    public static boolean execute(final IFMEditor editor2, ArrayList<RecType> recsForValidation) throws InterruptedException {
        if (recsForValidation == null || recsForValidation.isEmpty()) {
            return true;
        }
        final List<RecType> recsToValidate = ValidateFormattedValuesdOperation.prepareRecordsForVerification(recsForValidation);
        EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
        contents.getRec().addAll(recsToValidate);
        final StringBuffer strRecToUpdate = new StringBuffer();
        try {
            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ValidateFormattedValuesdOperation_CONV_ERR, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int noOfRecs = recsToValidate.size();
                    monitor.beginTask(MessageFormat.format(Messages.ValidateFormattedValuesdOperation_DESC, noOfRecs, editor2.getResource().getFormattedName()), 1);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result r = editor2.getSessionIdentifier().checkFormattedRecordsEditSession(strRecToUpdate, noOfRecs, howIsGoing);
                    result.copy(r);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            String errMsg = MessageFormat.format(Messages.ValidateFormattedValuesdOperation_EX, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        logger.debug((Object)("Editor update command RC=" + result.getRC()));
        logger.debug(result.getOutput());
        try {
            logger.debug((Object)("Trtying to parse [" + ((StringBuffer)result.getOutput()).toString() + "]"));
            EditType verifiedResult = EditorDataSerializeUtils.load((StringBuffer)((StringBuffer)result.getOutput()), (IZRL)editor2.getResource());
            EList verifiedRecs = verifiedResult.getRec();
            if (verifiedRecs.size() != recsToValidate.size()) {
                logger.error((Object)("Why number is different? verified=" + verifiedRecs.size() + " original=" + recsToValidate.size()));
            }
            for (RecType aRec : verifiedRecs) {
                ValidateFormattedValuesdOperation.updateFieldsAndErrors(aRec, recsForValidation);
            }
            editor2.refresh();
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.ValidateFormattedValuesdOperation_EX, editor2.getResource().getFormattedName());
            result.add(errMsg);
            result.add((Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        return true;
    }

    private static void updateFieldsAndErrors(RecType verifiedRec, List<RecType> toBeVerified) {
        for (RecType originalRec : toBeVerified) {
            if (!verifiedRec.getToken().equals(originalRec.getToken())) continue;
            if (originalRec.isSetSeq() && originalRec.isSetSeg()) {
                if (!verifiedRec.isSetSeq() || !verifiedRec.isSetSeg() || originalRec.getSeq() != verifiedRec.getSeq() || originalRec.getSeg() != verifiedRec.getSeg()) continue;
                ValidateFormattedValuesdOperation.updateFieldsAndErrors(verifiedRec, originalRec);
                return;
            }
            if (!originalRec.isSetSeq() && originalRec.isSetSeg()) {
                if (verifiedRec.isSetSeq() || !verifiedRec.isSetSeg() || originalRec.getSeg() != verifiedRec.getSeg()) continue;
                ValidateFormattedValuesdOperation.updateFieldsAndErrors(verifiedRec, originalRec);
                return;
            }
            if (originalRec.isSetSeq() && !originalRec.isSetSeg()) {
                if (!verifiedRec.isSetSeq() || verifiedRec.isSetSeg() || originalRec.getSeq() != verifiedRec.getSeq()) continue;
                ValidateFormattedValuesdOperation.updateFieldsAndErrors(verifiedRec, originalRec);
                return;
            }
            ValidateFormattedValuesdOperation.updateFieldsAndErrors(verifiedRec, originalRec);
            return;
        }
        logger.error((Object)("Did not find record " + verifiedRec.getRecno() + " [" + verifiedRec.toString() + "]"));
    }

    private static void updateFieldsAndErrors(RecType verifiedRec, RecType originalRec) {
        originalRec.setHex(verifiedRec.getHex());
        if (verifiedRec.isSetDataError() || verifiedRec.isDataError()) {
            originalRec.setDataError(true);
        } else {
            originalRec.unsetDataError();
        }
        if (verifiedRec.isSetLenError() || verifiedRec.isLenError()) {
            originalRec.setLenError(true);
        } else {
            originalRec.unsetLenError();
        }
        int errors = ValidateFormattedValuesdOperation.updateFields(verifiedRec, originalRec);
        if (errors > 0) {
            originalRec.setDataError(true);
        } else {
            originalRec.unsetDataError();
        }
    }

    private static int updateFields(RecType verifiedRec, RecType originalRec) {
        int errorCount = 0;
        originalRec.getField().clear();
        originalRec.getField().addAll((Collection)verifiedRec.getField());
        for (FieldType aField : originalRec.getField()) {
            if (aField.isSetInerror() || aField.isInerror()) {
                ++errorCount;
            }
            aField.setFieldUpdatedLocally(true, false);
        }
        originalRec.updateOnHostRequired(true);
        return errorCount;
    }

    private static List<RecType> prepareRecordsForVerification(List<RecType> recsToValidate) {
        ArrayList<RecType> verifyList = new ArrayList<RecType>();
        for (RecType r : recsToValidate) {
            verifyList.add(ValidateFormattedValuesdOperation.createCopy(r));
        }
        return verifyList;
    }

    private static RecType createCopy(RecType aRec) {
        RecType aCopy = FMNXEDITFactory.eINSTANCE.createRecType();
        aCopy.setToken(aRec.getToken());
        aCopy.setHex(aRec.getHex());
        aCopy.setId(aRec.getId());
        if (aRec.isSetSeq()) {
            aCopy.setSeq(aRec.getSeq());
        }
        if (aRec.isSetSeg()) {
            aCopy.setSeg(aRec.getSeg());
        }
        if (aRec.isSetNew()) {
            aCopy.setNew(true);
        }
        if (aRec.isSetInsert()) {
            aCopy.setInsert(true);
        }
        if (aRec.isSetChg()) {
            aCopy.setChg(true);
        }
        for (FieldType aField : aRec.getField()) {
            if (!aField.isFieldUpdatedLocally() || aField.getValue() == null || aField.getValue().trim().isEmpty() || aField.isFieldUpdatedByHex()) continue;
            aCopy.getField().add((Object)ValidateFormattedValuesdOperation.createCopy(aField));
        }
        return aCopy;
    }

    private static FieldType createCopy(FieldType aField) {
        FieldType aCopy = FMNXEDITFactory.eINSTANCE.createFieldType();
        aCopy.setSeq(aField.getSeq());
        aCopy.setSym(aField.getSym());
        aCopy.setStart(aField.getStart());
        aCopy.setLen(aField.getLen());
        if (aField.getValue() != null) {
            aCopy.setValue(aField.getValue());
        }
        return aCopy;
    }
}

