/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class UpdateHostEditorChainInHexOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(UpdateHostEditorChainInHexOperation.class);

    public static boolean execute(final IFMEditor editor2, final List<RecType> recsToUpdate, final RecType topRecord, final int repeatCount) throws InterruptedException {
        Objects.requireNonNull(editor2, "Must specify a non-null editor.");
        logger.debug((Object)("Updating " + String.valueOf(recsToUpdate != null ? Integer.valueOf(recsToUpdate.size()) : null) + " records. Repeat count is " + repeatCount + ". Resource=" + editor2.getResource().getFormattedName()));
        if (recsToUpdate == null || recsToUpdate.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
            return true;
        }
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int noOfRecs = recsToUpdate.size();
                    monitor.beginTask(MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_DESC, noOfRecs, editor2.getResource().getFormattedName(), repeatCount), repeatCount + 1);
                    logger.debug((Object)("each update contains " + noOfRecs + " records."));
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    int repeatIndex = 0;
                    while (repeatIndex < repeatCount) {
                        monitor.subTask(MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_REPEAT_STATUS, repeatIndex, repeatCount));
                        logger.debug((Object)("Updating: " + repeatIndex + ":" + repeatCount));
                        Result updateHexResult = new Result((Object)new StringBuffer());
                        EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
                        UpdateHostEditorChainInHexOperation.updateSequenceNumber(repeatIndex, recsToUpdate);
                        contents.getRec().addAll((Collection)recsToUpdate);
                        StringBuffer strRecToUpdate = new StringBuffer();
                        try {
                            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
                        }
                        catch (Exception e) {
                            String errMsg = MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_CONV_ERR, editor2.getResource().getFormattedName());
                            result.add(errMsg);
                            result.setRC(8);
                            throw new InvocationTargetException(e);
                        }
                        editor2.getSessionIdentifier().updateRecordsInHexInEditSession(strRecToUpdate, noOfRecs, howIsGoing, updateHexResult);
                        result.addSubResult(updateHexResult);
                        monitor.worked(1);
                        if (!updateHexResult.isSuccessfulWithoutWarnings()) {
                            logger.debug((Object)("Error occurred while updating records. " + repeatIndex + ":" + repeatCount));
                            return;
                        }
                        ++repeatIndex;
                    }
                    editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, topRecord);
                    monitor.worked(1);
                    monitor.done();
                    logger.debug((Object)("Finished updating " + noOfRecs + " records. Repeat=" + repeatCount));
                }
            });
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_EX, editor2.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        logger.debug((Object)("Editor update command RC=" + result.getRC()));
        logger.debug(result.getOutput());
        if (result.isSuccessfulWithoutWarnings()) {
            return true;
        }
        if (result.getRC() == 4) {
            PDDialogs.openInfoThreadSafe((String)Messages.UpdateHostEditorChainInHexOperation_WARNING, (String)((StringBuffer)result.getOutput()).toString());
            return true;
        }
        PDDialogs.openErrorThreadSafe((String)Messages.UpdateHostEditorChainInHexOperation_ERROR, (String)result.dumpOutputAndMessages(true));
        return false;
    }

    private static void updateSequenceNumber(int loopIndex, List<RecType> recsToUpdate) {
        if (loopIndex == 0) {
            return;
        }
        int setSize = recsToUpdate.size();
        int i = 0;
        while (i < recsToUpdate.size()) {
            RecType aRec = recsToUpdate.get(i);
            aRec.setSeq(aRec.getSeq() + loopIndex * setSize);
            ++i;
        }
    }
}

