/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class UpdateHostEditorChainInHexForImsOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(UpdateHostEditorChainInHexForImsOperation.class);

    public static boolean execute(final IFMEditor editor2, final ArrayList<RecType> recsToUpdate, final RecType topRecord) throws InterruptedException {
        if (recsToUpdate == null || recsToUpdate.isEmpty()) {
            logger.debug((Object)"No records specified to update.");
            return true;
        }
        logger.debug((Object)("Updating " + recsToUpdate.size() + " records in resource=" + editor2.getResource().getFormattedName()));
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int noOfRecs = recsToUpdate.size();
                    monitor.beginTask(Messages.UpdateHostEditorChainInHexForImsOperation_1, noOfRecs);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    int i = 0;
                    while (i < noOfRecs) {
                        monitor.subTask(MessageFormat.format(Messages.UpdateHostEditorChainInHexForImsOperation_2, i + 1, noOfRecs));
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        try {
                            EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
                            ArrayList<RecType> recList = new ArrayList<RecType>();
                            RecType aRecord = (RecType)recsToUpdate.get(i);
                            recList.add(aRecord);
                            contents.getRec().addAll(recList);
                            StringBuffer strRecToUpdate = new StringBuffer();
                            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
                            Result updateResult = new Result();
                            editor2.getSessionIdentifier().updateRecordsInHexInEditSession(strRecToUpdate, 1, howIsGoing, updateResult);
                            if (!updateResult.isSuccessfulWithoutWarnings() && !PDDialogs.openQuestionThreadSafe((String)Messages.UpdateHostEditorChainInHexForImsOperation_3, (String)Messages.UpdateHostEditorChainInHexForImsOperation_4, (String)updateResult.getMessagesCombined().toString())) {
                                return;
                            }
                        }
                        catch (Exception e) {
                            result.add(MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_CONV_ERR, editor2.getResource().getFormattedName()));
                            result.setRC(8);
                            throw new InvocationTargetException(e);
                        }
                        ++i;
                    }
                    editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, topRecord);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.UpdateHostEditorChainInHexOperation_EX, editor2.getResource().getFormattedName()), (Throwable)e);
            return false;
        }
        return true;
    }
}

