/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.OpenFormattedEditorJob;
import com.ibm.etools.fm.ui.dialog.ImsDatabaseDataSetDialog;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.Objects;

public class StartImsEditSessionOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(StartImsEditSessionOperation.class);

    public static AbstractSessionFormatted execute(ImsEditorOptions imsOptions, FMEditSessionProperties props, Result<StringBuffer> overallResult, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(imsOptions, "Must specify a non-null imsOptions.");
        monitor.beginTask(MessageFormat.format(Messages.OpenFormattedEditorJob_NAME, imsOptions.getImsResource().getFormattedName()), 2);
        AbstractSessionFormatted session = AbstractSessionFormatted.createFormattedEditSession((ImsEditorOptions)imsOptions, (FMEditSessionProperties)props);
        Result result = session.createIMSEditSession(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            String errMsg = Messages.StartImsEditSessionOperation_0;
            PDDialogs.openErrorThreadSafe((String)errMsg, (String)result.getMessagesCombined().toString());
            overallResult.setRC(8);
            overallResult.add(errMsg);
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.StartImsEditSessionOperation_3, imsOptions.getImsResource().getName()), (String)overallResult.dumpOutputAndMessages(true));
            return null;
        }
        if (imsOptions.getRegionType() == ImsRegionType.DLI && !imsOptions.getSubsystem().getCanonicalConfig().getDliConfig().getDynamicAllocationUsedForDDs() && imsOptions.getDatabase() != null) {
            try {
                Result<StringBuffer> allocResult = ImsDatabaseDataSetDialog.allocateDatabaseDataSets(session.getConnection(), imsOptions.getDatabase(), imsOptions.editDliDatabaseDataSets(), imsOptions.getAccessMode(), monitor);
                if (allocResult != null) {
                    overallResult.addSubResult(allocResult);
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.StartImsEditSessionOperation_4, imsOptions.getImsResource().getName()), (String)overallResult.dumpOutputAndMessages2(true));
                    return null;
                }
            }
            catch (CommunicationException e) {
                String errMsg = Messages.StartImsEditSessionOperation_1;
                logger.error((Object)errMsg, (Throwable)e);
                overallResult.setRC(8);
                PDDialogs.openErrorThreadSafe((String)errMsg);
                return null;
            }
        }
        if (!(result = session.startIMSEditSession(monitor)).isSuccessfulWithoutWarnings()) {
            String errMsg = "";
            errMsg = imsOptions.isEditSession() ? MessageFormat.format(Messages.OpenAsFormatted_EDIT_XML_ERROR, imsOptions.getImsResource().getFormattedName(), imsOptions.getTemplate() != null ? imsOptions.getTemplate().getFormattedName() : Messages.NONE) : MessageFormat.format(Messages.OpenAsFormatted_BROWSE_XML_ERROR, imsOptions.getImsResource().getFormattedName(), imsOptions.getTemplate() != null ? imsOptions.getTemplate().getFormattedName() : Messages.NONE);
            StringBuilder msgCombined = result.getMessagesCombined();
            errMsg = OpenFormattedEditorJob.inUse(msgCombined).concat(errMsg);
            PDDialogs.openErrorThreadSafe((String)errMsg, (String)msgCombined.toString());
            overallResult.setRC(8);
            overallResult.add(errMsg);
            return null;
        }
        return session;
    }

    public static Result<StringBuffer> retrieveImsKeyPosition(AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(session, "Must specify a non-null session.");
        Result result = session.getImsKeyPosition(monitor);
        if (!result.isSuccessfulWithoutWarnings()) {
            String errMsg = Messages.StartImsEditSessionOperation_2;
            PDDialogs.openErrorThreadSafe((String)errMsg, (String)result.getMessagesCombined().toString());
            result.setRC(8);
            result.add(errMsg);
            return result;
        }
        return result;
    }
}

