/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;

public class SendShowCommandOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SendShowCommandOperation.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sendCommand(ArrayList<String> commands, AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(commands, "Must provide a non-null commands");
        Objects.requireNonNull(session, "Must provide a non-null session");
        try {
            Result result = null;
            int i = 0;
            while (true) {
                if (i >= commands.size()) {
                    return true;
                }
                String aCmd = commands.get(i);
                result = session.sendCommand(aCmd, null, monitor);
                if (result.getRC() >= 8) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_EDITOR_CMD_ERR, aCmd));
                    return false;
                }
                ++i;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.SendShowCommandOperation_EXE;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
    }

    public static boolean sendDefaults(AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(session, "Must provide a non-null session");
        ArrayList<String> commands = new ArrayList<String>();
        if (FormattedEditorPreferencePage.showNotSelectedRecords()) {
            commands.add("SHOW NOT ON");
        } else {
            commands.add("SHOW NOT OFF");
        }
        if (FormattedEditorPreferencePage.showSuppressedRecords()) {
            commands.add("SHOW SUP ON");
        } else {
            commands.add("SHOW SUP OFF");
        }
        if (FormattedEditorPreferencePage.displayShadowLinesForEx()) {
            commands.add("SHADOW EX ON");
        } else {
            commands.add("SHADOW EX OFF");
        }
        if (FormattedEditorPreferencePage.displayShadowLinesForNot()) {
            commands.add("SHADOW NOT ON");
        } else {
            commands.add("SHADOW NOT OFF");
        }
        if (FormattedEditorPreferencePage.displayShadowLinesForSup()) {
            commands.add("SHADOW SUP ON");
        } else {
            commands.add("SHADOW SUP OFF");
        }
        return SendShowCommandOperation.sendCommand(commands, session, monitor);
    }

    public static boolean sendExportDefaults(AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(session, "Must provide a non-null session");
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("SHOW NOT OFF");
        commands.add("SHOW SUP ON");
        commands.add("SHADOW EX OFF");
        commands.add("SHADOW NOT OFF");
        commands.add("SHADOW SUP OFF");
        return SendShowCommandOperation.sendCommand(commands, session, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sendDb2Defaults(AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(session, "Must provide a non-null session");
        try {
            Result result = null;
            ArrayList<String> commands = new ArrayList<String>();
            if (FormattedEditorPreferencePage.displayShadowLinesForEx()) {
                commands.add("SHADOW EX ON");
            } else {
                commands.add("SHADOW EX OFF");
            }
            int i = 0;
            while (true) {
                if (i >= commands.size()) {
                    return true;
                }
                String aCmd = (String)commands.get(i);
                result = session.sendCommand(aCmd, null, monitor);
                if (result.getRC() >= 8) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_EDITOR_CMD_ERR, aCmd));
                    return false;
                }
                ++i;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.SendShowCommandOperation_EXE;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sendImsDefaults(AbstractSessionFormatted session, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(session, "Must provide a non-null session");
        try {
            Result result = null;
            ArrayList<String> commands = new ArrayList<String>();
            if (FormattedEditorPreferencePage.showSuppressedRecords()) {
                commands.add("SHOW SUP ON");
            } else {
                commands.add("SHOW SUP OFF");
            }
            int i = 0;
            while (true) {
                if (i >= commands.size()) {
                    return true;
                }
                String aCmd = (String)commands.get(i);
                result = session.sendCommand(aCmd, null, monitor);
                if (result.getRC() >= 8) {
                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FMIFormattedDataEditor_EDITOR_CMD_ERR, aCmd), (String)result.dumpOutputAndMessages(true));
                    return false;
                }
                ++i;
            }
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.SendShowCommandOperation_EXE;
            logger.error((Object)errMsg, (Throwable)e);
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
    }
}

