/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.operations;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.ims.ImsKeyField;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsInsertDialog;
import com.ibm.etools.fm.model.formatted.EditType;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.util.EditorDataSerializeUtils;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InsertNewFormattedRecordsOperation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(InsertNewFormattedRecordsOperation.class);
    public static final int NO_TEMPLATE_USE_LAYOUT_ID = -1;

    public static boolean execute(final IFMEditor editor2, final RecType anchorRecord, final int numberOfNewRecords, final RecType topRecord, int layoutID) throws InterruptedException {
        Objects.requireNonNull(anchorRecord, "Must provide a non-null anchorRecord.");
        logger.debug((Object)("Inserting " + numberOfNewRecords + " formatted records into the current edit session. Inserting after recno=" + anchorRecord.getRecno() + " seq=" + anchorRecord.getSeq() + " token: " + anchorRecord.getToken()));
        if (numberOfNewRecords == 0) {
            return true;
        }
        final List<RecType> newRecList = InsertNewFormattedRecordsOperation.prepareRecordsToInsert(anchorRecord, Math.min(numberOfNewRecords, FormattedEditorPreferencePage.getRecordCacheSize()), layoutID);
        EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
        contents.getRec().addAll(newRecList);
        final StringBuffer strRecToUpdate = new StringBuffer();
        try {
            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_CONV_ERR, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        final Result finalResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    int noOfRecs = newRecList.size();
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    monitor.beginTask(MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_DESC, numberOfNewRecords, editor2.getResource().getFormattedName()), numberOfNewRecords + 1);
                    Result result = editor2.getSessionIdentifier().prepareNewFormattedRecordsInEditSession(strRecToUpdate, noOfRecs, howIsGoing);
                    finalResult.copy(result);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        monitor.done();
                        return;
                    }
                    monitor.worked(1);
                    List<RecType> recsForUpdate = InsertNewFormattedRecordsOperation.prepareNewRecordsForUpdate((StringBuffer)result.getOutput(), editor2, anchorRecord);
                    StringBuffer strRecsForUpdate = InsertNewFormattedRecordsOperation.prepareNewRecordsForUpdate(recsForUpdate, noOfRecs, editor2);
                    logger.debug((Object)("block insert size is " + recsForUpdate.size()));
                    int repeatCount = 0;
                    while (repeatCount < numberOfNewRecords) {
                        monitor.subTask(MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_INSERT_STATUS, repeatCount + 1, numberOfNewRecords));
                        Result updateHexResult = new Result((Object)new StringBuffer());
                        int insertSize = noOfRecs;
                        if (repeatCount + noOfRecs > numberOfNewRecords) {
                            insertSize = numberOfNewRecords - repeatCount;
                            strRecsForUpdate = InsertNewFormattedRecordsOperation.prepareNewRecordsForUpdate(recsForUpdate, insertSize, editor2);
                            logger.debug((Object)("block insert is too large. Just inserting " + insertSize));
                        } else {
                            logger.debug((Object)("just about to do a block insert of size " + recsForUpdate.size()));
                        }
                        editor2.getSessionIdentifier().updateRecordsInHexInEditSession(strRecsForUpdate, insertSize, howIsGoing, updateHexResult);
                        finalResult.addSubResult(updateHexResult);
                        if (!updateHexResult.isSuccessfulWithoutWarnings()) {
                            logger.debug((Object)("error occurred while inserting new record. repeatCount=" + repeatCount + " numberOfNewRecords=" + numberOfNewRecords));
                            return;
                        }
                        monitor.worked(insertSize);
                        repeatCount += noOfRecs;
                    }
                    logger.debug((Object)("finished inserting " + numberOfNewRecords + " records."));
                    if (finalResult.getRC() <= 4) {
                        if ("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".equals(anchorRecord.getToken())) {
                            editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, anchorRecord);
                        } else {
                            editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, topRecord);
                        }
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_EX, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        logger.debug((Object)("Editor update command RC=" + finalResult.getRC()));
        logger.debug(finalResult.getOutput());
        if (finalResult.isSuccessfulWithoutWarnings()) {
            return true;
        }
        if (finalResult.getRC() == 4) {
            PDDialogWithText.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FMPlugin_INFO_TITLE, (String)Messages.InsertNewFormattedRecordsOperation_WARNING, (String)((StringBuffer)finalResult.getOutput()).toString());
            return true;
        }
        String errMsg = finalResult.getMessagesCombined().toString().trim();
        if (!errMsg.isEmpty()) {
            PDDialogs.openErrorThreadSafe((String)Messages.InsertNewFormattedRecordsOperation_ERROR, (String)errMsg);
        } else {
            PDDialogs.openErrorThreadSafe((String)Messages.InsertNewFormattedRecordsOperation_ERROR);
        }
        return false;
    }

    public static boolean execute1(final IFMEditor editor2, final RecType anchorRecord, final RecType topRecord, int layoutID, final String hexKeyValue, final ImsSegment segInfo) throws InterruptedException {
        logger.debug((Object)"Inserting a new record (segment)");
        List<RecType> newRecList = InsertNewFormattedRecordsOperation.prepareRecordsToInsert(anchorRecord, 1, layoutID);
        EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
        contents.getRec().addAll(newRecList);
        final StringBuffer strRecToUpdate = new StringBuffer();
        try {
            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
        }
        catch (IOException e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_CONV_ERR, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        final Result finalResult = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_0, editor2.getResource()), 3);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = editor2.getSessionIdentifier().prepareNewFormattedRecordsInEditSession(strRecToUpdate, 1, howIsGoing);
                    finalResult.copy(result);
                    if (!result.isSuccessfulWithoutWarnings()) {
                        monitor.done();
                        return;
                    }
                    monitor.worked(1);
                    List<RecType> recsForUpdate = InsertNewFormattedRecordsOperation.prepareNewRecordsForUpdate((StringBuffer)result.getOutput(), editor2, anchorRecord);
                    Result<StringBuffer> insertResult = InsertNewFormattedRecordsOperation.insertNewRecord(howIsGoing, recsForUpdate, hexKeyValue, segInfo, editor2);
                    finalResult.addSubResult(insertResult);
                    monitor.worked(1);
                    logger.debug((Object)"finished inserting new records.");
                    if (finalResult.getRC() <= 4) {
                        if ("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF".equals(anchorRecord.getToken())) {
                            editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, anchorRecord);
                        } else {
                            editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, topRecord);
                        }
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_EX, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return false;
        }
        return true;
    }

    private static Result<StringBuffer> insertNewRecord(IHowIsGoing monitor, List<RecType> recsForUpdate, final String hexKeyValue, final ImsSegment segInfo, final IFMEditor editor2) throws InterruptedException {
        if (segInfo.getKeyFields().size() > 0 && ((ImsKeyField)segInfo.getKeyFields().get(0)).getLength() > 0) {
            ImsKeyField aKeyField = (ImsKeyField)segInfo.getKeyFields().get(0);
            int keyStartPos = Integer.parseInt(aKeyField.getPos()) - 1;
            int keyLength = aKeyField.getLength();
            RecType aRec = recsForUpdate.get(0);
            Object hexStr = aRec.getHex();
            String header = ((String)hexStr).substring(0, keyStartPos * 2);
            String tailer = ((String)hexStr).substring(keyStartPos * 2 + keyLength * 2);
            hexStr = header + hexKeyValue + tailer;
            aRec.setHex((String)hexStr);
        }
        StringBuffer strRecsForUpdate = InsertNewFormattedRecordsOperation.prepareNewRecordsForUpdate(recsForUpdate, 1, editor2);
        Result updateHexResult = new Result((Object)new StringBuffer());
        editor2.getSessionIdentifier().updateRecordsInHexInEditSession(strRecsForUpdate, 1, monitor, updateHexResult);
        if (updateHexResult.isSuccessfulWithoutWarnings()) {
            return updateHexResult;
        }
        if (PDDialogs.openQuestionThreadSafe((String)Messages.InsertNewFormattedRecordsOperation_1, (String)Messages.InsertNewFormattedRecordsOperation_2, (String)updateHexResult.getMessagesCombined().toString())) {
            final AtomicBoolean finishedSuccess = new AtomicBoolean(true);
            final StringBuffer newKeyValueBuffer = new StringBuffer();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ImsInsertDialog dialog = new ImsInsertDialog(editor2, segInfo, hexKeyValue);
                    if (dialog.open() != 0) {
                        finishedSuccess.set(false);
                    } else {
                        finishedSuccess.set(true);
                        newKeyValueBuffer.append(dialog.getEnteredKeyValueInHex());
                    }
                }
            });
            if (finishedSuccess.get()) {
                return InsertNewFormattedRecordsOperation.insertNewRecord(monitor, recsForUpdate, newKeyValueBuffer.toString(), segInfo, editor2);
            }
            return updateHexResult;
        }
        return updateHexResult;
    }

    private static List<RecType> prepareRecordsToInsert(RecType anchorRec, int numberOfNewRecs, int layoutID) {
        ArrayList<RecType> recsToInsert = new ArrayList<RecType>();
        int i = 0;
        while (i < numberOfNewRecs) {
            RecType aRecToInsert = FMNXEDITFactory.eINSTANCE.createRecType();
            aRecToInsert.setInsert(true);
            aRecToInsert.setToken(anchorRec.getToken());
            if (anchorRec.isSetSeq()) {
                aRecToInsert.setSeq(anchorRec.getSeq() + i + 1);
            } else {
                aRecToInsert.setSeq(i + 1);
            }
            if (layoutID != -1) {
                aRecToInsert.setId(layoutID);
            }
            recsToInsert.add(aRecToInsert);
            ++i;
        }
        return recsToInsert;
    }

    private static List<RecType> prepareNewRecordsForUpdate(StringBuffer input, IFMEditor editor2, RecType anchorRec) {
        Objects.requireNonNull(editor2, "Must specify a non-null editor");
        try {
            ArrayList<RecType> recsForUpdate = new ArrayList<RecType>();
            EditType newFormattedRecs = EditorDataSerializeUtils.load((StringBuffer)input, (IZRL)editor2.getResource());
            EList recs = newFormattedRecs.getRec();
            int i = 0;
            while (i < recs.size()) {
                RecType aRec = (RecType)recs.get(i);
                recsForUpdate.add(InsertNewFormattedRecordsOperation.createRecToUpdate(aRec, editor2, anchorRec, i + 1));
                ++i;
            }
            return recsForUpdate;
        }
        catch (CoreException e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_CONV_ERR, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return null;
        }
    }

    private static StringBuffer prepareNewRecordsForUpdate(List<RecType> recsForUpdate, int max, IFMEditor editor2) {
        Objects.requireNonNull(recsForUpdate, "Must specify a non-null recsForUpdate");
        try {
            EditType contents = FMNXEDITFactory.eINSTANCE.createEditType();
            int i = 0;
            while (i < max) {
                contents.getRec().add((Object)recsForUpdate.get(i));
                ++i;
            }
            StringBuffer strRecToUpdate = new StringBuffer();
            strRecToUpdate.append(EditorDataSerializeUtils.editToString((EditType)contents, (IZRL)editor2.getResource()));
            return strRecToUpdate;
        }
        catch (IOException e) {
            String errMsg = MessageFormat.format(Messages.InsertNewFormattedRecordsOperation_CONV_ERR, editor2.getResource().getFormattedName());
            PDDialogs.openErrorThreadSafe((String)errMsg);
            return null;
        }
    }

    public static RecType createRecToUpdate(RecType oldRec, IFMEditor editor2, RecType anchorRec, int seqNo) {
        Objects.requireNonNull(anchorRec, "Must specify a non-null anchorRec");
        RecType recToUpdate = FMNXEDITFactory.eINSTANCE.createRecType();
        recToUpdate.setToken(anchorRec.getToken());
        recToUpdate.setSeq(anchorRec.getSeq() + seqNo);
        recToUpdate.setHex(FormattedEditorUtility.checkRecordLength(oldRec.getHex(), editor2.getSessionProperties(), oldRec, true, "00"));
        recToUpdate.setInsert(true);
        recToUpdate.setRecno(anchorRec.getRecno());
        return recToUpdate;
    }
}

