/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.nattable.provider;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ExcludedRecordsShadowGroup;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPageUtility;
import com.ibm.etools.fm.model.formatted.FieldType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import com.ibm.etools.fm.model.template.TypeType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class SymbolDataProvider
implements IDataProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String DBCS_ENCODING = "DBCS";
    private final Layouttype aLayout;
    private FormattedEditor editor;
    private ArrayList<DisplayLine> currentContents;

    public SymbolDataProvider(FormattedEditor editor2, Layouttype aLayout) {
        this.aLayout = aLayout;
        this.editor = editor2;
        this.currentContents = editor2.getCurrentEditorContents();
    }

    private void prepareContents() {
        this.currentContents = this.editor.getCurrentEditorContents();
        int i = 0;
        while (i < this.currentContents.size()) {
            EList columns = this.currentContents.get(i).getRecord().getField();
            ((FieldType)columns.get(0)).getSeq();
            ++i;
        }
    }

    public Symboltype getSymbolValue(int rowIndex) {
        return (Symboltype)this.aLayout.getSymbol().get(rowIndex);
    }

    public DisplayLine getRecordValue(int rowIndex) {
        if (rowIndex <= this.currentContents.size() - 1) {
            return this.currentContents.get(rowIndex);
        }
        return null;
    }

    public int getIndexOf(DisplayLine dl) {
        return this.currentContents.indexOf(dl);
    }

    public int getColumnCount() {
        return 0;
    }

    private int getFieldMaxLen(Symboltype aSymbol, RecType aRecord) {
        int start = aSymbol.getStart();
        int length = aSymbol.getLength();
        int recMax = aRecord.getLen();
        if (start > recMax) {
            return -1;
        }
        if (start - 1 + length <= recMax) {
            return length;
        }
        return recMax - start;
    }

    private String getANValue(String encoding, RecType aRecord, Symboltype aSymbol, FieldType aField) {
        int fieldMaxLen = this.getFieldMaxLen(aSymbol, aRecord);
        Object hexValue = aRecord.getHex();
        int offset = 0;
        int start = ((aField.isSetStart() ? aField.getStart() + offset : aSymbol.getStart() + offset) - 1) * 2;
        int end = start + fieldMaxLen * 2;
        if (start < 0) {
            start = 0;
        }
        hexValue = start < ((String)hexValue).length() ? (end < ((String)hexValue).length() ? ((String)hexValue).substring(start, end) : ((String)hexValue).substring(start)) : "";
        if (DBCS_ENCODING.equalsIgnoreCase(aSymbol.getEncoding())) {
            hexValue = "0E" + (String)hexValue + "0F";
        } else if (TypeType.G.equals((Object)aSymbol.getType())) {
            hexValue = "0E" + (String)hexValue + "0F";
        }
        byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexValue);
        try {
            return new String(byteValue, encoding).replaceAll("[\\u0000-\\u001F\\u007F-\\u009F\\r\\n]", "\uff0e");
        }
        catch (UnsupportedEncodingException e) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.FormattedPageUtility_CONV_ERR2, aRecord.getRecno(), aField.getSeq(), encoding, hexValue), (Throwable)e);
            aField.setError(true);
            aRecord.setDataError(true);
            return "";
        }
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        RecType aRecord = this.currentContents.get(rowIndex).getRecord();
        if (!aRecord.isSetExc() || !aRecord.isExc()) {
            FieldType aField = (FieldType)aRecord.getField().get(columnIndex);
            Symboltype aSymbol = (Symboltype)this.aLayout.getSymbol().get(columnIndex);
            String encoding = FormattedPageUtility.getEncodingForField(aSymbol, this.editor.getResource());
            String hexValue = this.currentContents.get(rowIndex).getRecord().getHex();
            if (((FieldType)this.currentContents.get(rowIndex).getRecord().getField().get(columnIndex)).getValue().isEmpty()) {
                return this.getANValue(encoding, aRecord, aSymbol, aField);
            }
            return ((FieldType)this.currentContents.get(rowIndex).getRecord().getField().get(columnIndex)).getValue();
        }
        if (columnIndex == 0) {
            return ((ExcludedRecordsShadowGroup)this.currentContents.get(rowIndex)).getMessage();
        }
        return null;
    }

    public int getRowCount() {
        return this.currentContents.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Symboltype symbol = this.getSymbolValue(rowIndex);
        Objects.requireNonNull(symbol, "Symbol not found!");
    }
}

