/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.nattable.provider;

import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;

public class ColumnDataProvider
implements IDataProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int SEQUENCE_COLUMN_ID = 0;
    public static final int HOLD_COLUMN_ID = 1;
    public static final int SELECTED_COLUMN_ID = 2;
    public static final int LEVEL_COLUMN_ID = 3;
    public static final int NAME_COLUMN_ID = 4;
    public static final int CLAUSE_COLUMN_ID = 5;
    public static final int PICTURE_COLUMN_ID = 6;
    public static final int TYPE_COLUMN_ID = 7;
    public static final int START_COLUMN_ID = 8;
    public static final int LENGTH_COLUMN_ID = 9;
    public static final int REDEFINES_CRITERIA_ID = 10;
    public static final int CCSID_COLUMN_ID = 11;
    private EList<HdrfldType> headers;
    private Layouttype aLayout;
    private HdrfldType header;
    private ArrayList<HdrfldType> heldColumns;
    private ArrayList<HdrfldType> otherColumns;
    private String[] COLUMN_NAMES;

    public ColumnDataProvider(EList<HdrfldType> headers, Layouttype aLayout) {
        this.headers = headers;
        this.aLayout = aLayout;
        this.prepareHeaders();
    }

    private void prepareHeaders() {
        this.COLUMN_NAMES = new String[this.headers.size()];
        int i = 0;
        while (i < this.headers.size()) {
            String columnName;
            Symboltype currentSymbol = this.getSymbol(this.aLayout, ((HdrfldType)this.headers.get(i)).getSym());
            this.COLUMN_NAMES[i] = columnName = currentSymbol.getHeading() != null && currentSymbol.getHeading().length() > 0 ? currentSymbol.getHeading() : currentSymbol.getName();
            ++i;
        }
    }

    private Symboltype getSymbol(Layouttype aLayout, int symID) {
        int levelInd = 0;
        EList symbols = aLayout.getSymbol();
        int i = 0;
        while (i < symbols.size()) {
            Symboltype aSymbol = (Symboltype)symbols.get(i);
            levelInd = aSymbol.getLvl() - 1;
            if (levelInd >= 0) {
                this.COLUMN_NAMES[levelInd] = aSymbol.getName();
            }
            if (aSymbol.getRef() == symID) {
                if (levelInd >= 0 && aSymbol.getLongname() == null) {
                    String longName = this.COLUMN_NAMES[0];
                    int j = 1;
                    while (j <= levelInd) {
                        longName = longName.concat("." + this.COLUMN_NAMES[j]);
                        ++j;
                    }
                    aSymbol.setLongname(longName);
                }
                return aSymbol;
            }
            ++i;
        }
        return null;
    }

    public String[] getColNames() {
        return this.COLUMN_NAMES;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        if (columnIndex >= 0 && columnIndex < this.COLUMN_NAMES.length) {
            return this.COLUMN_NAMES[columnIndex];
        }
        return null;
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        throw new UnsupportedOperationException();
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public int getRowCount() {
        return 1;
    }
}

