/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.nattable;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.nattable.accumulator.FormattedLabelAccumulator;
import com.ibm.etools.fm.editor.formatted.nattable.config.FilterRowConfiguration;
import com.ibm.etools.fm.editor.formatted.nattable.config.FormattedStyleConfiguration;
import com.ibm.etools.fm.editor.formatted.nattable.provider.ColumnDataProvider;
import com.ibm.etools.fm.editor.formatted.nattable.provider.SymbolDataProvider;
import com.ibm.etools.fm.model.formatted.HdrfldType;
import com.ibm.etools.fm.model.template.Layouttype;
import com.ibm.etools.fm.model.template.Symboltype;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.NatGridLayerPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.reorder.config.DefaultColumnReorderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultRowSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class NatTableWrapper {
    private NatTable table;
    private ConfigRegistry registry = new ConfigRegistry();
    private Layouttype aLayout;
    private DefaultColumnHeaderDataProvider columnHeaderDataProvider;
    private final SymbolDataProvider dataProvider;
    private final ColumnDataProvider headerProvider;
    private int fromPosition;
    private int toPosition;
    private GridLayer gridLayer;
    final DataLayer bodyDataLayer;
    private BodyLayerStack<Symboltype> bodyLayerStack;
    private FormattedEditor editor;

    public NatTableWrapper(Layouttype aLayout, FormattedEditor editor2, Composite parent) {
        this.aLayout = aLayout;
        this.editor = editor2;
        this.dataProvider = new SymbolDataProvider(editor2, aLayout);
        this.bodyDataLayer = new DataLayer((IDataProvider)this.dataProvider);
        this.headerProvider = new ColumnDataProvider((EList<HdrfldType>)editor2.getCurrentTableHeader(aLayout.getId()).getHdrfld(), aLayout);
        final List<String> colNames = Arrays.asList(this.headerProvider.getColNames());
        this.columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(this.headerProvider.getColNames());
        IColumnPropertyAccessor<DisplayLine> columnPropertyAccessor = new IColumnPropertyAccessor<DisplayLine>(){

            public int getColumnCount() {
                return colNames.size();
            }

            public Object getDataValue(DisplayLine rowObject, int columnIndex) {
                return NatTableWrapper.this.dataProvider.getDataValue(columnIndex, NatTableWrapper.this.dataProvider.getIndexOf(rowObject));
            }

            public void setDataValue(DisplayLine rowObject, int columnIndex, Object newValue) {
            }

            public int getColumnIndex(String propertyName) {
                return colNames.indexOf(propertyName);
            }

            public String getColumnProperty(int arg0) {
                return null;
            }
        };
        ArrayList<DisplayLine> values = new ArrayList<DisplayLine>();
        int i = 0;
        while (i < this.dataProvider.getRowCount()) {
            values.add(this.dataProvider.getRecordValue(i));
            ++i;
        }
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.bodyDataLayer);
        selectionLayer.addConfiguration((IConfiguration)new DefaultRowSelectionLayerConfiguration());
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        FormattedLabelAccumulator formattedLabelAccumulator = new FormattedLabelAccumulator(this.dataProvider, aLayout);
        this.bodyLayerStack = new BodyLayerStack(values, columnPropertyAccessor, formattedLabelAccumulator);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)this.headerProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        DefaultGlazedListsStaticFilterStrategy filterStrategy = new DefaultGlazedListsStaticFilterStrategy(this.bodyLayerStack.getFilterList(), (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)this.registry);
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)filterStrategy, (ILayer)columnHeaderLayer, columnHeaderDataLayer.getDataProvider(), (IConfigRegistry)this.registry);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, this.bodyLayerStack, this.bodyLayerStack.getSelectionLayer());
        rowHeaderLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPos, int rowPos) {
                if (NatTableWrapper.this.dataProvider.getRecordValue(rowPos) != null && NatTableWrapper.this.dataProvider.getRecordValue(rowPos).getRecord().isChg()) {
                    configLabels.addLabel("HAS_CHG");
                }
            }
        });
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.headerProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        this.gridLayer = new GridLayer(this.bodyLayerStack, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        this.table = new NatTable(parent, (ILayer)this.gridLayer, false);
        NatGridLayerPainter layerPainter = new NatGridLayerPainter(this.table, 20);
        this.table.setLayerPainter((ILayerPainter)layerPainter);
        this.configureTable((DefaultGlazedListsStaticFilterStrategy<DisplayLine>)filterStrategy);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.resizeTableOnLoad(parent);
    }

    private void configRegistry(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.getColor((int)0, (int)100, (int)0));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle);
    }

    private void configureTable(DefaultGlazedListsStaticFilterStrategy<DisplayLine> filterStrategy) {
        this.table.setConfigRegistry((IConfigRegistry)this.registry);
        this.table.addConfiguration((IConfiguration)new DefaultColumnReorderLayerConfiguration());
        this.attachDragReordering();
        this.table.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        this.table.addConfiguration((IConfiguration)new FormattedStyleConfiguration());
        this.table.addConfiguration((IConfiguration)new FilterRowConfiguration());
        this.table.setBackground(new Color((Device)Display.getDefault(), 255, 255, 255));
        this.table.configure();
        new DefaultToolTip((Control)this.table, 2, false){

            protected Object getToolTipArea(Event event) {
                int x = NatTableWrapper.this.table.getColumnPositionByX(event.x);
                int y = NatTableWrapper.this.table.getRowPositionByY(event.y);
                return new Point(x, y);
            }

            protected String getText(Event event) {
                int y;
                int x = NatTableWrapper.this.table.getColumnPositionByX(event.x);
                ILayerCell cell = NatTableWrapper.this.table.getCellByPosition(x, y = NatTableWrapper.this.table.getRowPositionByY(event.y));
                if (cell == null) {
                    return null;
                }
                int col = cell.getColumnIndex();
                String tooltip = null;
                switch (col) {
                    case 1: {
                        tooltip = Messages.NatTableWrapperHoldTooltip;
                        break;
                    }
                    case 2: {
                        tooltip = Messages.NatTableWrapperSelectedTooltip;
                        break;
                    }
                }
                return tooltip;
            }

            protected boolean shouldCreateToolTip(Event event) {
                if (this.getText(event) != null) {
                    return super.shouldCreateToolTip(event);
                }
                return false;
            }
        };
    }

    private void resizeTableOnLoad(final Composite parent) {
        this.table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                int i = 0;
                while (i < NatTableWrapper.this.table.getColumnCount()) {
                    InitializeAutoResizeColumnsCommand columnCommand = new InitializeAutoResizeColumnsCommand((ILayer)NatTableWrapper.this.table, i, NatTableWrapper.this.table.getConfigRegistry(), new GCFactory((Drawable)NatTableWrapper.this.table));
                    NatTableWrapper.this.table.doCommand((ILayerCommand)columnCommand);
                    ++i;
                }
                i = 0;
                while (i < NatTableWrapper.this.table.getRowCount()) {
                    InitializeAutoResizeRowsCommand rowCommand = new InitializeAutoResizeRowsCommand((ILayer)NatTableWrapper.this.table, i, NatTableWrapper.this.table.getConfigRegistry(), new GCFactory((Drawable)NatTableWrapper.this.table));
                    NatTableWrapper.this.table.doCommand((ILayerCommand)rowCommand);
                    ++i;
                }
                NatTableWrapper.this.table.removeListener(9, (Listener)this);
                Composite p1 = parent.getParent();
                Monitor primary = p1.getMonitor();
                NatTableWrapper.this.table.layout(true, true);
                while (p1 != null && !(p1 instanceof CTabFolder)) {
                    p1.layout(true, true);
                    if (p1 instanceof Shell) {
                        Shell shell = (Shell)p1;
                        shell.layout(true, true);
                        Rectangle bounds = primary.getBounds();
                        Rectangle rect = shell.getBounds();
                        Point newSize = shell.computeSize(NatTableWrapper.this.table.getPreferredWidth(), -1, true);
                        newSize.x = NatTableWrapper.this.table.getPreferredWidth() + 1000;
                        newSize.y += NatTableWrapper.this.table.getPreferredHeight() - NatTableWrapper.this.table.getHeight();
                        if (newSize.y > bounds.height + 20) {
                            newSize.y = bounds.height + 20;
                        }
                        shell.setSize(newSize);
                        rect = shell.getBounds();
                        int x = bounds.x + (bounds.width - rect.width) / 2;
                        int y = bounds.y + (bounds.height - rect.height) / 2;
                        shell.setLocation(x, y);
                        break;
                    }
                    p1 = p1.getParent();
                }
            }
        });
    }

    public SelectionLayer getSelectionLayer() {
        return this.bodyLayerStack.getSelectionLayer();
    }

    public SymbolDataProvider getDataProvider() {
        return this.dataProvider;
    }

    private void attachDragReordering() {
        this.bodyDataLayer.registerCommandHandler((ILayerCommandHandler)new ILayerCommandHandler<ColumnReorderStartCommand>(){

            public Class<ColumnReorderStartCommand> getCommandClass() {
                return ColumnReorderStartCommand.class;
            }

            public boolean doCommand(ILayer targetLayer, ColumnReorderStartCommand command) {
                NatTableWrapper.this.fromPosition = command.getFromColumnPosition() - 1;
                return true;
            }
        });
        this.bodyDataLayer.registerCommandHandler((ILayerCommandHandler)new ILayerCommandHandler<ColumnReorderEndCommand>(){

            public Class<ColumnReorderEndCommand> getCommandClass() {
                return ColumnReorderEndCommand.class;
            }

            public boolean doCommand(ILayer targetLayer, ColumnReorderEndCommand command) {
                NatTableWrapper.this.toPosition = command.getToColumnPosition() - 1;
                NatTableWrapper.this.editor.setDirty(true);
                return true;
            }
        });
    }

    public void setFocus() {
        this.table.setFocus();
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final FilterList<DisplayLine> filterList;
        private final IDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;
        private TransformedList<DisplayLine, DisplayLine> rowObjectsGlazedList = null;

        public BodyLayerStack(List<DisplayLine> values, IColumnPropertyAccessor<DisplayLine> columnPropertyAccessor, FormattedLabelAccumulator formattedLabelAccumulator) {
            EventList eventList = GlazedLists.eventList(values);
            this.rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            SortedList sortedList = new SortedList(this.rowObjectsGlazedList, null);
            this.filterList = new FilterList((EventList)sortedList);
            this.bodyDataProvider = new ListDataProvider(this.filterList, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.getBodyDataProvider());
            bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)formattedLabelAccumulator);
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.filterList);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer);
            ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.getSelectionLayer());
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public FilterList<DisplayLine> getFilterList() {
            return this.filterList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public void updateList(List<DisplayLine> updatedValues) {
            this.rowObjectsGlazedList.clear();
            updatedValues.size();
            int i = 0;
            while (i < updatedValues.size()) {
                this.rowObjectsGlazedList.add((Object)updatedValues.get(i));
                ++i;
            }
        }
    }
}

