/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.model.formatted.KeyeType;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.etools.fm.model.formatted.ReltabType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.etools.fm.ui.views.systems.handlers.OpenFormatted;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.lookup.api.LookupAPI;
import com.ibm.pdtools.common.component.ui.dialog.PDDialogWithText;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ViewSqlError
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(ViewSqlError.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart instanceof FormattedEditor) {
            FormattedEditor editor2 = (FormattedEditor)editorPart;
            if (editor2.isAllActionsDisabled()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            } else if (editor2.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2 || !editor2.isEditSession()) {
                PDDialogs.openInfoThreadSafe((String)Messages.SqlErrorAction_0);
            } else {
                DisplayLine currentSelection = editor2.getCurrentLine();
                if (currentSelection == null) {
                    PDDialogs.openInfoThreadSafe((String)Messages.SqlErrorAction_1);
                } else {
                    RecType aRec = currentSelection.getRecord();
                    String sqlErr = aRec.getSqlcode();
                    if (sqlErr != null && sqlErr.trim().length() > 0) {
                        if (aRec.getReltab() != null) {
                            String msg = MessageFormat.format(Messages.SqlErrorAction_3, sqlErr);
                            StringBuilder longMsg = new StringBuilder();
                            PDDialogWithText.ITextDialogRunnable lookupAction = ViewSqlError.createLookupAction(sqlErr);
                            ReltabType aRelatedTable = aRec.getReltab();
                            Db2Table aTable = ViewSqlError.createDb2Table(editor2, aRelatedTable);
                            Db2EditOptions opts = new Db2EditOptions();
                            opts.setTable(aTable != null ? aTable : (Db2Table)editor2.getResource());
                            PDDialogWithText.ITextDialogRunnable reditAction = ViewSqlError.createRelatedTableEditAction(opts, aRelatedTable.getType().charAt(0), aRelatedTable.getWhere());
                            if (aRelatedTable.getType().equalsIgnoreCase("P")) {
                                longMsg.append(Messages.SqlErrorAction_ParentTableInfo);
                            } else {
                                longMsg.append(Messages.SqlErrorAction_DependentTableInfo);
                            }
                            if (aTable != null) {
                                longMsg.append(MessageFormat.format(Messages.SqlErrorAction_Db2OwnerName, aTable.getOwner(), aTable.getName()));
                            } else {
                                longMsg.append(Messages.SqlErrorAction_RetatedTableRetErr);
                                longMsg.append(MessageFormat.format(Messages.SqlErrorAction_Db2OwnerNameInHex, aRelatedTable.getOwner(), aRelatedTable.getTable()));
                            }
                            EList infoList = aRelatedTable.getKeye();
                            if (infoList != null && infoList.size() > 0) {
                                longMsg.append(Messages.SqlErrorAction_ErrColumns);
                                int i = 0;
                                while (i < infoList.size()) {
                                    longMsg.append(ViewSqlError.createInfoLineForColumnPair((KeyeType)infoList.get(i)));
                                    ++i;
                                }
                            }
                            PDDialogs.openInfoThreadSafe((String)Messages.FMPlugin_INFO_TITLE, (String)msg, (String)longMsg.toString(), (String[])new String[]{Messages.SqlErrorAction_4, "REDIT"}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{lookupAction, reditAction});
                        } else {
                            PDDialogWithText.ITextDialogRunnable lookupAction = ViewSqlError.createLookupAction(sqlErr);
                            String msg = MessageFormat.format(Messages.SqlErrorAction_3, sqlErr);
                            PDDialogs.openInfoThreadSafe((String)Messages.FMPlugin_INFO_TITLE, (String)msg, (String)msg, (String[])new String[]{Messages.SqlErrorAction_4}, (PDDialogWithText.ITextDialogRunnable[])new PDDialogWithText.ITextDialogRunnable[]{lookupAction});
                        }
                    } else {
                        PDDialogs.openInfoThreadSafe((String)Messages.SqlErrorAction_5);
                    }
                }
            }
        }
    }

    private static PDDialogWithText.ITextDialogRunnable createLookupAction(final String sqlErr) {
        return new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText context) {
                Map sqlMessages = new LookupAPI().lookupText(sqlErr);
                if (sqlMessages != null && sqlMessages.get(sqlErr) != null) {
                    PDDialogs.openErrorThreadSafe((String)((String)sqlMessages.get(sqlErr)));
                }
            }
        };
    }

    private static PDDialogWithText.ITextDialogRunnable createRelatedTableEditAction(final Db2EditOptions options, final char relType, final String whereClause) {
        return new PDDialogWithText.ITextDialogRunnable(){

            public void run(PDDialogWithText context) {
                if (FMUIPlugin.getDefault().dsEditSessionExist((IZRL)options.getTable())) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.OpenAsFormatted_DUP_EDIT, options.getTable().getFormattedName()));
                    return;
                }
                OpenFormatted.invokeDb2Editor(options, relType, whereClause);
            }
        };
    }

    private static Db2Table createDb2Table(FormattedEditor editor2, ReltabType relatedTableInfo) {
        String tableOwner = ViewSqlError.convertHexToStr(relatedTableInfo.getOwner(), editor2.getResource().getSystem().getHostType());
        String tableName = ViewSqlError.convertHexToStr(relatedTableInfo.getTable(), editor2.getResource().getSystem().getHostType());
        if (tableOwner == null || tableName == null) {
            return null;
        }
        if (!Db2Table.isValidOwner((IPDHost)editor2.getSessionIdentifier().getDb2EditOptions().getSubsystem().getSystem(), (String)tableOwner)) {
            logger.error((Object)("Invalid table owner: " + tableOwner + " hex[" + relatedTableInfo.getOwner() + "]"));
            return null;
        }
        if (!Db2Table.isValidName((IPDHost)editor2.getSessionIdentifier().getDb2EditOptions().getSubsystem().getSystem(), (String)tableName)) {
            logger.error((Object)("Invalid table name: " + tableName + " hex[" + relatedTableInfo.getTable() + "]"));
            return null;
        }
        return new Db2Table(editor2.getSessionIdentifier().getDb2EditOptions().getSubsystem(), tableName, tableOwner);
    }

    private static String createInfoLineForColumnPair(KeyeType aKeyeType) {
        return MessageFormat.format(Messages.SqlErrorAction_ParentDependentColumnInfo, aKeyeType.getPcol(), aKeyeType.getDcol());
    }

    public static String convertHexToStr(String hexStr, HostType hostType) {
        Objects.requireNonNull(hexStr, "Must provide a non-null hexStr String.");
        try {
            byte[] byteValue = DataConversionUtils.getEBCDICData((String)hexStr);
            return new String(byteValue, hostType.getCommunicationEncoding());
        }
        catch (Exception e) {
            logger.error((Object)"Conversion error occurred.", (Throwable)e);
            return null;
        }
    }
}

