/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.SortDialog;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class SortRecords
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart instanceof FormattedEditor) {
            this.run((FormattedEditor)editorPart);
        }
    }

    public void run(final FormattedEditor editor2) {
        SortDialog dialog;
        if (editor2.isAllActionsDisabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
        } else if (!editor2.getSessionProperties().isAllRecdsLoaded()) {
            PDDialogs.openInfoThreadSafe((String)Messages.SortAction_NO_SORT);
        } else if (editor2.getSessionProperties().isInplaceEdit()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
        } else if (editor2.updateDirtyContents() && (dialog = new SortDialog(editor2)).open() == 0) {
            final String sortCommand = SortDialog.getSortCommandAsString(editor2.getCurrentSortCriteria());
            final Result overallResult = new Result((Object)new StringBuffer());
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(MessageFormat.format(Messages.SortAction_TASK_NAME, sortCommand), 3);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        Result result = editor2.getSessionIdentifier().sendCommand(sortCommand, null, howIsGoing);
                        overallResult.addSubResult(result);
                        if (result.getRC() >= 8) {
                            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.SortAction_CMD_ERR, sortCommand), (String)result.getMessagesCombined().toString());
                            return;
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        result = editor2.getSessionIdentifier().setCursorPositionToTop(howIsGoing);
                        overallResult.addSubResult(result);
                        if (result.getRC() >= 8) {
                            PDDialogs.openErrorThreadSafe((String)Messages.SortAction_CUR_POS_ERR, (String)result.getMessagesCombined().toString());
                            return;
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        if (!editor2.loadRecordsFromHost(howIsGoing)) {
                            PDDialogs.openErrorThreadSafe((String)Messages.SortAction_LOAD_RECS_ERR, (String)result.getMessagesCombined().toString());
                            overallResult.add(Messages.SortAction_LOAD_RECS_ERR);
                            overallResult.setRC(8);
                            return;
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
                if (overallResult.isSuccessfulWithoutWarnings() && editor2.isEditSession()) {
                    editor2.setDirty(true);
                }
            }
            catch (InvocationTargetException e) {
                PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX, (Throwable)e);
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor2.disableEditorActions();
            }
        }
    }
}

