/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.ShowDialog;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class ShowOptions
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(final IFMEditor editor2) {
        ShowDialog dialog;
        if (editor2.updateDirtyContents() && (dialog = new ShowDialog(editor2)).open() == 0) {
            final ArrayList<String> commands = dialog.getShowCommands();
            Job showOptions = new Job(Messages.ShowOptions_UpdatingSessionOptions){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(MessageFormat.format(Messages.ShowAction_SHOW_CMD_NAME, editor2.getResource().getFormattedName()), commands.size() + 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        int i = 0;
                        while (i < commands.size()) {
                            String cmd = (String)commands.get(i);
                            monitor.subTask(MessageFormat.format(Messages.ShowAction_SHOW_CMD_SUB_TASK, i, commands.size(), cmd));
                            editor2.getSessionIdentifier().sendCommand(cmd, null, howIsGoing);
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.subTask(Messages.ShowAction_SHOW_CMD_SUB_TASK_GET_RECS);
                        editor2.loadRecordsFromHost(howIsGoing);
                        monitor.worked(1);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            showOptions.setUser(true);
            showOptions.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().matches(8)) {
                        PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                        editor2.disableEditorActions();
                    } else if (event.getResult().matches(4)) {
                        PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX);
                    }
                }
            });
            showOptions.schedule();
        }
    }
}

