/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class RefreshContents
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(final IFMEditor editor2) {
        if (!editor2.getSessionProperties().isRefreshCommandAvailable()) {
            PDDialogs.openInfoThreadSafe((String)Messages.RefreshAction_NOT_AVAILABLE);
        } else if (editor2.updateDirtyContents()) {
            final Result overallResult = new Result((Object)new StringBuffer());
            Job showOptions = new Job(Messages.RefreshContents_Refreshing){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(Messages.RefreshAction_TASK_NAME, 2);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        Result result = editor2.getSessionIdentifier().sendCommand("REFRESH", null, howIsGoing);
                        overallResult.copy(result);
                        if (result.getRC() < 8) {
                            monitor.worked(1);
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            monitor.worked(1);
                            if (!editor2.loadRecordsFromHost(howIsGoing)) {
                                overallResult.setRC(8);
                                overallResult.add(Messages.RefreshAction_LOAD_ERR);
                                return new Status(4, "com.ibm.etools.fm.ui", Messages.RefreshAction_LOAD_ERR);
                            }
                            monitor.worked(1);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (InterruptedException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            showOptions.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().matches(8)) {
                        PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                        editor2.disableEditorActions();
                    } else if (event.getResult().matches(4) && !overallResult.isSuccessfulWithoutWarnings()) {
                        PDDialogs.openErrorThreadSafe((String)Messages.RefreshAction_OVERALL_ERR_MSG, (String)overallResult.getMessagesCombined().toString());
                    }
                }
            });
            showOptions.setUser(true);
            showOptions.schedule();
        }
    }
}

