/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.util.ReditUtils;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted.pages.formatted.FormattedPage;
import com.ibm.etools.fm.editor.formatted2.dialogs.ReditSelectionDialog;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.redit.ReditType;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class Redit
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp.  2013, 2017. All rights reserved.";
    private String prevSearchCommand = "";

    @Override
    protected void editorCommandHandler(final IFMEditor editor2) {
        if (editor2 instanceof FormattedEditor) {
            Object findCommand = "FIND '=' NEXT CHAR  ";
            FormattedEditor formattedEditor = (FormattedEditor)editor2;
            FormattedPage page = (FormattedPage)formattedEditor.getCurrentPage();
            int index = page.getColumnLocationFromCursor();
            findCommand = (String)findCommand + "#" + index;
            this.doFindAndSetCursor((String)findCommand, formattedEditor);
        }
        if (editor2.getSessionIdentifier().getSessionType() != AbstractSessionFormatted.SessionType.DB2) {
            PDDialogs.openInfoThreadSafe((String)Messages.ReditAction_1);
        } else if (!editor2.getResource().getSystem().supports((PDFeature)FMFeature.DB2_REDIT)) {
            PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.ReditAction_3, ((FMHost)editor2.getResource().getSystem().getFMHostSystem()).getServerVersion()));
        } else if (editor2.updateDirtyContents()) {
            final Result result = new Result();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ReditAction_2, 3);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        result.addSubResult(editor2.getSessionIdentifier().sendCommand("REDIT", null, howIsGoing));
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                });
                if (result.isSuccessfulWithoutWarnings()) {
                    ReditType redit = ReditUtils.load((String)((Result)result.getSubResults().get(0)).getOutput().toString(), (String)editor2.getResource().getSystem().getHostName());
                    new ReditSelectionDialog(editor2.getSessionIdentifier().getDb2EditOptions().getSubsystem(), redit).open();
                } else {
                    PDDialogs.openErrorThreadSafe((String)Messages.ReditAction_4, (String)result.dumpOutputAndMessages(true));
                }
            }
            catch (InvocationTargetException e) {
                PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX, (Throwable)e);
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor2.disableEditorActions();
            }
        }
    }

    private void doFindAndSetCursor(final String command, final IFMEditor editor2) {
        StringBuilder firstHitFormattedInfo = new StringBuilder();
        StringBuilder firstHitCharInfo = new StringBuilder();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String cmdToExecute = command;
                    if (Redit.this.prevSearchCommand.equals(cmdToExecute)) {
                        cmdToExecute = "RFIND";
                    }
                    Redit.this.prevSearchCommand = command;
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = editor2.getSessionIdentifier().sendCommand(cmdToExecute, null, howIsGoing);
                    monitor.worked(1);
                    if (result.getRC() >= 8) {
                        if (!editor2.loadRecordsFromHost(howIsGoing)) {
                            return;
                        }
                        return;
                    }
                    if (!editor2.loadRecordsFromHost(howIsGoing)) {
                        return;
                    }
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.FindReplaceWindow_EXEC_ERR_MSG, (String)MessageFormat.format(Messages.FindReplaceWindow_EXEC_ERR_TITLE, command), (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            editor2.disableEditorActions();
            return;
        }
        if (editor2.getCurrentEditorContents().isEmpty()) {
            return;
        }
        if (editor2 instanceof FormattedEditor) {
            FormattedEditor fEditor = (FormattedEditor)editor2;
            if (fEditor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
                if (firstHitFormattedInfo.length() > 0) {
                    String aLine = firstHitFormattedInfo.toString();
                    String field = aLine.substring(aLine.indexOf("at field"));
                    field = field.substring("at field".length(), field.indexOf(44)).trim();
                    DisplayLine displayLine = editor2.getCurrentEditorContents().get(0);
                }
            } else if (firstHitCharInfo.length() > 0) {
                String aLine = firstHitCharInfo.toString();
                aLine = aLine.substring(aLine.indexOf("at ") + 3);
                DisplayLine recToken = editor2.getCurrentEditorContents().get(0);
                editor2.setCursor(new NavigationSpecification(recToken, Integer.parseInt(aLine) - 1, false));
            }
        } else if (firstHitFormattedInfo.length() > 0) {
            String aLine = firstHitFormattedInfo.toString();
            String field = aLine.substring(aLine.indexOf("at field"));
            field = field.substring("at field".length(), field.indexOf(44)).trim();
            DisplayLine recToken = editor2.getCurrentEditorContents().get(0);
            editor2.setCursor(new NavigationSpecification(recToken, Integer.parseInt(field), true));
        }
    }
}

