/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.PasteDialog;
import com.ibm.etools.fm.editor.formatted.handler.Clipboard;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.List;

public class PasteRecords
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(IFMEditor ifm) {
        if (ifm instanceof FormattedEditor) {
            FormattedEditor editor2 = (FormattedEditor)ifm;
            if (!editor2.isEditSession()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_NON_EDIT_SESSION);
            } else if (editor2.getSessionProperties().isInplaceEdit()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
            } else {
                String[] itemsToPaste = Clipboard.get();
                if (itemsToPaste.length == 0) {
                    PDDialogs.openInfoThreadSafe((String)Messages.PasteAction_NO_ITEM_TO_PASTE);
                    return;
                }
                int[] selection = editor2.getSelection();
                if (editor2.updateDirtyContents()) {
                    PasteDialog dialog;
                    ArrayList<RecType> selectedItems = editor2.getCurrentPage().getSelectedNonShadowLines();
                    boolean startLocationKnown = true;
                    if (selectedItems == null || selectedItems.isEmpty()) {
                        startLocationKnown = false;
                    }
                    if ((dialog = new PasteDialog(startLocationKnown)).open() == 0) {
                        List<RecType> recsToPaste = PasteRecords.prepareRecordsToInsert(editor2, selectedItems, itemsToPaste, dialog.isInsertAtTop());
                        try {
                            if (UpdateHostEditorChainInHexOperation.execute(editor2, recsToPaste, dialog.isInsertAtTop() ? PasteRecords.createTopRecType() : editor2.getTopRecord(), dialog.getRepeatCount())) {
                                editor2.getSessionProperties().updateTotalNumRecords(recsToPaste.size() * dialog.getRepeatCount(), true);
                                editor2.updateLocationInformation(-1);
                                editor2.setSelection(selection);
                            }
                        }
                        catch (InterruptedException e) {
                            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                            editor2.disableEditorActions();
                            return;
                        }
                        editor2.setDirty(true);
                    }
                }
            }
        } else {
            PDDialogs.openInfoThreadSafe((String)Messages.PasteRecords_CopyNotSupportedInCurrentEditor);
        }
    }

    private static List<RecType> prepareRecordsToInsert(FormattedEditor editor2, List<RecType> original, String[] newRecords, boolean insertAtTop) {
        RecType anchorRec = null;
        anchorRec = insertAtTop ? PasteRecords.createTopRecType() : (original == null || original.isEmpty() ? PasteRecords.createTopRecType() : original.get(0));
        ArrayList<RecType> recsToInsert = new ArrayList<RecType>();
        int newItemIndex = 1;
        String[] stringArray = newRecords;
        int n = newRecords.length;
        int n2 = 0;
        while (n2 < n) {
            String newRecHex = stringArray[n2];
            RecType aRecToInsert = FMNXEDITFactory.eINSTANCE.createRecType();
            aRecToInsert.setInsert(true);
            aRecToInsert.setToken(anchorRec.getToken());
            if (anchorRec.isSetSeq()) {
                aRecToInsert.setSeq(anchorRec.getSeq() + newItemIndex);
            } else {
                aRecToInsert.setSeq(newItemIndex);
            }
            ++newItemIndex;
            aRecToInsert.setHex(FormattedEditorUtility.checkRecordLength(newRecHex, editor2.getSessionProperties(), anchorRec, true, FormattedEditorUtility.getSpaceHexValue(editor2.getResource().getPersistentProperty("encoding"))));
            recsToInsert.add(aRecToInsert);
            ++n2;
        }
        return recsToInsert;
    }

    private static RecType createTopRecType() {
        RecType topRec = FMNXEDITFactory.eINSTANCE.createRecType();
        topRec.setToken("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
        topRec.setSeq(0);
        return topRec;
    }
}

