/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PageUp
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart instanceof IFMEditor) {
            this.run((IFMEditor)editorPart);
        }
    }

    public Result<StringBuffer> run(final IFMEditor editor2) {
        if (editor2.isAllActionsDisabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            return null;
        }
        int selectedColumn = editor2.getCursorIndexOnSelectedLine();
        FMEditSessionProperties props = editor2.getSessionProperties();
        if (!editor2.updateDirtyContents()) {
            return null;
        }
        if (props.getCurrentStartPosition() == 1) {
            PageUp.setCursor(editor2, selectedColumn, true);
            return null;
        }
        if (!editor2.isBusyNow()) {
            editor2.setBusyNow(true);
            final Result overallReult = new Result((Object)new StringBuffer());
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.SetpUpAction_DESC, 2);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        String cmd = "UP " + FormattedEditorPreferencePage.getRecordCacheSize();
                        if (monitor.isCanceled()) {
                            editor2.setBusyNow(false);
                            throw new InterruptedException();
                        }
                        Result aResult = editor2.getSessionIdentifier().sendCommand(cmd, null, howIsGoing);
                        if (!aResult.isSuccessfulWithoutWarnings()) {
                            overallReult.copy(aResult);
                            editor2.setBusyNow(false);
                            return;
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            editor2.setBusyNow(false);
                            throw new InterruptedException();
                        }
                        if (!editor2.loadRecordsFromHost(howIsGoing)) {
                            overallReult.setRC(8);
                            editor2.setBusyNow(false);
                            return;
                        }
                        editor2.setBusyNow(false);
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX, (Throwable)e);
                editor2.setBusyNow(false);
                return null;
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor2.disableEditorActions();
                editor2.setBusyNow(false);
                return null;
            }
            if (!overallReult.isSuccessfulWithoutWarnings()) {
                PDDialogs.openErrorThreadSafe((String)Messages.StepUpAction_ERR, (String)overallReult.toString());
                return null;
            }
            PageUp.setCursor(editor2, selectedColumn, false);
            return overallReult;
        }
        return null;
    }

    private static void setCursor(IFMEditor editor2, int cursorPosition, boolean selectTop) {
        DisplayLine recToken = null;
        if (editor2.getCurrentEditorContents().size() > 0) {
            recToken = selectTop ? editor2.getCurrentEditorContents().get(0) : editor2.getCurrentEditorContents().get(editor2.getCurrentEditorContents().size() - 1);
            if (editor2 instanceof FormattedEditor) {
                FormattedEditor fEditor = (FormattedEditor)editor2;
                if (fEditor.getCurrentEditorMode() == IFMEditor.EditorMode.FORMATTED) {
                    editor2.setCursor(new NavigationSpecification(recToken, cursorPosition, true));
                    return;
                }
                editor2.setCursor(new NavigationSpecification(recToken, cursorPosition, false));
                return;
            }
            editor2.setCursor(new NavigationSpecification(recToken, cursorPosition, false));
            return;
        }
        editor2.setCursor(NavigationSpecification.JUST_FOCUS);
    }
}

