/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.editor.formatted.FMEditorInputWithTemplate;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.OpenFormattedEditorJob;
import com.ibm.etools.fm.ui.FMUIPlugin;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.UUID;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewTemplate
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IZRL newTemplate = null;
    private IZRL oldTemplate = null;
    private UUID uniqueKey = null;

    public NewTemplate(IZRL newTemplate, IZRL oldTemplate) {
        this.newTemplate = newTemplate;
        this.oldTemplate = oldTemplate;
    }

    public NewTemplate(IZRL newTemplate, IZRL oldTemplate, UUID uniqueKey) {
        this.newTemplate = newTemplate;
        this.oldTemplate = oldTemplate;
        this.uniqueKey = uniqueKey;
    }

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart.isDirty() && editorPart instanceof FormattedEditor) {
            this.run((FormattedEditor)editorPart);
        }
    }

    public void run(FormattedEditor editor2) {
        FMEditorInputWithTemplate input = editor2.getEditorInput();
        FMUIPlugin.getDefault().removeDSEditSession(input.getResource());
        IZRL aResource = null;
        IZRL aTemplate = null;
        String xmlContents = null;
        if (this.uniqueKey != null) {
            aResource = FMUIPlugin.getDefault().runTempEntryExists(this.uniqueKey).getResource();
            aTemplate = FMUIPlugin.getDefault().runTempEntryExists(this.uniqueKey).getTemplate();
            xmlContents = FMUIPlugin.getDefault().runTempEntryExists(this.uniqueKey).getXMLBuffer();
            editor2.getSessionIdentifier().getBaseEditOptions().setTemplateDirty(false);
        }
        editor2.getSite().getPage().closeEditor((IEditorPart)editor2, false);
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.BASE) {
            BaseEditorOptions options = input.getSessionIdentifer().getBaseEditOptions();
            this.oldTemplate = options.getaTemplate();
            options.setaTemplate(this.newTemplate);
            if (this.uniqueKey != null) {
                new OpenFormattedEditorJob(input.getEditSessionProperties(), options, this.oldTemplate != null ? this.oldTemplate : null, this.uniqueKey).schedule();
                input.getSessionIdentifer().getBaseEditOptions().setRunTempKey(this.uniqueKey);
                FMUIPlugin.getDefault().addRunTempEntry(this.uniqueKey, aResource, aTemplate, xmlContents);
                editor2.getSessionIdentifier().getBaseEditOptions().setTemplateDirty(true);
            } else {
                new OpenFormattedEditorJob(input.getEditSessionProperties(), options, this.oldTemplate != null ? this.oldTemplate : null).schedule();
            }
        } else if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.DB2) {
            Db2EditOptions options = input.getSessionIdentifer().getDb2EditOptions();
            this.oldTemplate = options.getTemplate();
            options.setTemplate(this.newTemplate);
            new OpenFormattedEditorJob(input.getEditSessionProperties(), options, this.oldTemplate, options.getEncoding(), options.getDbcsEncoding(), options.getBidiFormat()).schedule();
        }
    }
}

