/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DataSetType;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.NavigationSpecification;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.ui.prefs.FormattedEditorPreferencePage;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class JumpToRecord
extends SkeletonHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2024. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private String navigateCommand = null;

    public JumpToRecord(String navigateCommand) {
        this.navigateCommand = navigateCommand;
    }

    public void run(final IFMEditor editor2) {
        if (editor2.isAllActionsDisabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            return;
        }
        if (!editor2.updateDirtyContents()) {
            return;
        }
        ArrayList<DisplayLine> contents = editor2.getCurrentEditorContents();
        int offset = 0;
        if (contents.size() > 0) {
            if ("TOP".equals(this.navigateCommand)) {
                if (contents.get(0).getRecord().getRecno() == 1) {
                    editor2.setCursor(NavigationSpecification.TOP);
                    return;
                }
            } else if ("BOT".equals(this.navigateCommand)) {
                int totalSize = editor2.getSessionProperties().getNumRecords();
                if (totalSize > 0 && totalSize == contents.get(contents.size() - 1).getRecord().getRecno()) {
                    editor2.setCursor(NavigationSpecification.BOTTOM);
                    return;
                }
            } else if (this.navigateCommand.startsWith("LOCATE")) {
                int recno;
                int totalRecNum = editor2.getSessionProperties().getNumRecords();
                if (totalRecNum > 0 && (recno = Integer.parseInt(this.navigateCommand.substring("LOCATE".length()).trim())) > totalRecNum) {
                    PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.JumpToRecordAction_LOCATE_INVALID, recno, totalRecNum));
                    return;
                }
            } else if (this.navigateCommand.startsWith("OFFSET") && ((offset = Integer.parseInt(this.navigateCommand.substring("OFFSET".length()).trim())) < -32760 || offset > 32760)) {
                PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.JumpToRecordAction_OFFSET_INVALID, offset));
                return;
            }
        }
        final int finalOffset = offset;
        final Result result = new Result((Object)new StringBuffer());
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    DataSetOrMember zosResource;
                    monitor.beginTask(MessageFormat.format(Messages.JumpToRecordAction_DESC, JumpToRecord.this.navigateCommand), 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    if (JumpToRecord.this.navigateCommand.contains("KEY ") && (zosResource = (DataSetOrMember)editor2.getResource()).asDataSet().getType() != DataSetType.KSDS) {
                        PDDialogs.openInfoThreadSafe((String)MessageFormat.format(Messages.EditorOptionDialog_NO_KEY, zosResource.getFormattedName()));
                        return;
                    }
                    if ("TOP".equals(JumpToRecord.this.navigateCommand)) {
                        rsb = editor2.getSessionIdentifier().setCursorPositionToTop(howIsGoing);
                        result.copy(rsb);
                        if (!rsb.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        monitor.worked(1);
                    } else if ("BOT".equals(JumpToRecord.this.navigateCommand)) {
                        rsb = editor2.getSessionIdentifier().setCursorPositionToBottom(howIsGoing, FormattedEditorPreferencePage.getRecordCacheSize());
                        result.copy(rsb);
                        if (!rsb.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        monitor.worked(1);
                    } else {
                        rsb = editor2.getSessionIdentifier().sendCommand(JumpToRecord.this.navigateCommand, null, howIsGoing);
                        result.copy(rsb);
                        if (rsb.getMessagesCombined().toString().contains("FMNBB603")) {
                            PDDialogs.openInfoThreadSafe((String)rsb.getMessagesCombined().toString());
                            return;
                        }
                        editor2.getSessionIdentifier().setEditorOffset(finalOffset);
                        if (!rsb.isSuccessfulWithoutWarnings()) {
                            return;
                        }
                        monitor.worked(1);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    if (!editor2.loadRecordsFromHost(howIsGoing)) {
                        result.setRC(8);
                        return;
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX, (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            editor2.disableEditorActions();
            return;
        }
        if (!result.isSuccessfulWithoutWarnings()) {
            PDDialogs.openErrorThreadSafe((String)MessageFormat.format(result.getMessagesCombined().toString(), this.navigateCommand));
        }
        if (this.navigateCommand.equalsIgnoreCase("BOT")) {
            editor2.setCursor(NavigationSpecification.BOTTOM);
        }
    }

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart.isDirty() && editorPart instanceof FormattedEditor) {
            this.run((FormattedEditor)editorPart);
        }
    }
}

