/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.InsertDialog;
import com.ibm.etools.fm.editor.formatted.operations.InsertNewFormattedRecordsOperation;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.editor.formatted1.ImsEditor;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsInsertDialog;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import com.ibm.pdtools.common.component.ui.views.systems.handlers.SkeletonHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class InsertRecords
extends SkeletonHandler {
    private static final PDLogger logger = PDLogger.get(InsertRecords.class);
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    protected void handle(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (editorPart instanceof IFMEditor) {
            InsertRecords.process((IFMEditor)editorPart, true);
        }
    }

    public static void process(IFMEditor editor2, boolean askNumberOfRecords) {
        if (editor2 != null) {
            if (editor2.isAllActionsDisabled()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_ALL_DISABLED);
            } else if (!editor2.isEditSession()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_NON_EDIT_SESSION);
            } else if (editor2.getSessionProperties().isInplaceEdit()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
            } else {
                int[] selection = editor2.getSelection();
                if (editor2.updateDirtyContents()) {
                    ArrayList<RecType> selectedItems = editor2.getSelectedNonShadowLines();
                    if ((selectedItems == null || selectedItems.isEmpty()) && !PDDialogs.openQuestion((String)Messages.InsertAction_NO_LOCATION)) {
                        return;
                    }
                    if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
                        InsertRecords.handleInsertForIms(editor2, selection, selectedItems);
                    } else {
                        InsertRecords.handleInsertRecords(editor2, selection, selectedItems, askNumberOfRecords);
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void handleInsertRecords(IFMEditor editor, int[] selection, ArrayList<RecType> selectedItems, boolean askNumberOfRecords) {
        if (askNumberOfRecords) {
            dialog = new InsertDialog();
            if (dialog.open() != 0) {
                return;
            }
            numberOfNewRecs = dialog.getNumberOfRecordsToInsert();
            insertAtTop = dialog.isInsertAtTop();
        } else {
            numberOfNewRecs = 1;
            v0 = insertAtTop = selectedItems == null || selectedItems.isEmpty() != false;
        }
        if (editor.getTemplateResource() == null) {
            recsToInsert = InsertRecords.prepareRecordsToInsert(editor, selectedItems, insertAtTop);
            try {
                if (editor.getResource().getSystem().getHostType() == HostType.ZOS) {
                    if (insertAtTop) {
                        topRec = InsertRecords.getAnchorRecord(null, true);
                        UpdateHostEditorChainInHexOperation.execute(editor, recsToInsert, topRec, numberOfNewRecs);
                    } else {
                        UpdateHostEditorChainInHexOperation.execute(editor, recsToInsert, editor.getTopRecord(), numberOfNewRecs);
                    }
                    editor.getSessionProperties().updateTotalNumRecords(numberOfNewRecs, true);
                    editor.updateLocationInformation(-1);
                    editor.setSelection(selection);
                }
                anAnchor = InsertRecords.getAnchorRecord(selectedItems, insertAtTop);
                if (!InsertNewFormattedRecordsOperation.execute(editor, anAnchor, numberOfNewRecs, editor.getTopRecord(), -1)) ** GOTO lbl49
                editor.getSessionProperties().updateTotalNumRecords(numberOfNewRecs, true);
                editor.updateLocationInformation(-1);
                editor.setSelection(selection);
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor.disableEditorActions();
                return;
            }
        } else {
            anAnchor = InsertRecords.getAnchorRecord(selectedItems, insertAtTop);
            layoutID = editor.getActiveLayoutID();
            if (anAnchor.isSetId()) {
                layoutID = anAnchor.getId();
            }
            try {
                if (InsertNewFormattedRecordsOperation.execute(editor, anAnchor, numberOfNewRecs, editor.getTopRecord(), layoutID)) {
                    editor.getSessionProperties().updateTotalNumRecords(numberOfNewRecs, true);
                    editor.updateLocationInformation(-1);
                    editor.setSelection(selection);
                }
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor.disableEditorActions();
                return;
            }
        }
lbl49:
        // 4 sources

        editor.setDirty(true);
    }

    private static RecType getAnchorRecord(ArrayList<RecType> original, boolean insertAtTop) {
        RecType anchorRec = null;
        if (insertAtTop) {
            anchorRec = FMNXEDITFactory.eINSTANCE.createRecType();
            anchorRec.setToken("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            anchorRec.setSeq(0);
        } else if (original == null || original.isEmpty()) {
            anchorRec = FMNXEDITFactory.eINSTANCE.createRecType();
            anchorRec.setToken("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
            anchorRec.setSeq(0);
        } else {
            anchorRec = original.get(0);
        }
        return anchorRec;
    }

    private static ArrayList<RecType> prepareRecordsToInsert(IFMEditor editor2, ArrayList<RecType> original, boolean insertAtTop) {
        RecType anchorRec = InsertRecords.getAnchorRecord(original, insertAtTop);
        String hexString = FormattedEditorUtility.checkRecordLength("", editor2.getSessionProperties(), anchorRec, true, FormattedEditorUtility.getSpaceHexValue(editor2.getResource().getPersistentProperty("encoding")));
        ArrayList<RecType> recsToInsert = new ArrayList<RecType>();
        RecType aRecToInsert = FMNXEDITFactory.eINSTANCE.createRecType();
        aRecToInsert.setInsert(true);
        aRecToInsert.setToken(anchorRec.getToken());
        if (anchorRec.isSetSeq()) {
            aRecToInsert.setSeq(anchorRec.getSeq() + 1);
        } else {
            aRecToInsert.setSeq(1);
        }
        aRecToInsert.setHex(hexString);
        recsToInsert.add(aRecToInsert);
        return recsToInsert;
    }

    private static void handleInsertForIms(IFMEditor editor2, int[] selection, ArrayList<RecType> selectedItems) {
        ImsEditor imsEditor = (ImsEditor)editor2;
        ImsSegment segInfo = InsertRecords.getSegmentInfo(imsEditor, selectedItems);
        if (segInfo == null) {
            return;
        }
        ImsInsertDialog dialog = new ImsInsertDialog(editor2, segInfo, "");
        if (dialog.open() != 0) {
            return;
        }
        String hexKeyValue = dialog.getEnteredKeyValueInHex();
        RecType anAnchor = InsertRecords.getAnchorRecord(selectedItems, dialog.isInsertAtTop());
        int layoutID = editor2.getActiveLayoutID();
        if (anAnchor.isSetId()) {
            layoutID = anAnchor.getId();
        }
        try {
            if (InsertNewFormattedRecordsOperation.execute1(editor2, anAnchor, editor2.getTopRecord(), layoutID, hexKeyValue, segInfo)) {
                editor2.getSessionProperties().updateTotalNumRecords(1, true);
                editor2.updateLocationInformation(-1);
                editor2.setSelection(selection);
            }
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            editor2.disableEditorActions();
            return;
        }
        editor2.setDirty(true);
    }

    private static ImsSegment getSegmentInfo(ImsEditor imsEditor, ArrayList<RecType> selectedItems) {
        ImsDatabaseInfo dbInfo = imsEditor.getDatabaseInformation();
        List segments = dbInfo.getSegments();
        if (selectedItems.isEmpty()) {
            return (ImsSegment)segments.get(0);
        }
        RecType anchorRecord = selectedItems.get(0);
        for (ImsSegment imsSegment : segments) {
            if (!imsSegment.getName().equals(anchorRecord.getSegname())) continue;
            return imsSegment;
        }
        logger.error((Object)("No such segment exist! Segment: " + anchorRecord.getSegname()));
        throw new IllegalArgumentException("Specified segment does not exist: " + anchorRecord.getSegname());
    }
}

