/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.contents.ShadowGroup;
import com.ibm.etools.fm.editor.formatted.dialogs.ExcludeDialog;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ExcludeRecords
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(IFMEditor ifm) {
        if (ifm instanceof FormattedEditor) {
            ExcludeDialog dialog;
            final FormattedEditor editor2 = (FormattedEditor)ifm;
            if (editor2.updateDirtyContents() && (dialog = new ExcludeDialog(Display.getCurrent().getActiveShell(), editor2)).open() == 0) {
                final String command = dialog.getExcludeCommand();
                RecType startRec = null;
                ArrayList<RecType> selectedItems = editor2.getCurrentPage().getSelectedNonShadowLines();
                if (selectedItems.size() != 0) {
                    startRec = selectedItems.get(0);
                }
                if (startRec == null) {
                    ArrayList<DisplayLine> editorContents = editor2.getCurrentEditorContents();
                    int i = 0;
                    while (i < editorContents.size()) {
                        DisplayLine dl = editorContents.get(i);
                        if (!(dl instanceof ShadowGroup)) {
                            startRec = dl.getRecord();
                            break;
                        }
                        ++i;
                    }
                }
                final RecType excludeStartRec = startRec;
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask(command, 2);
                            IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                            try {
                                Result result;
                                if (excludeStartRec != null && (result = editor2.getSessionIdentifier().setCursorPosition(howIsGoing, excludeStartRec, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF")).getRC() >= 8) {
                                    PDDialogs.openErrorThreadSafe((String)Messages.ExcludeAction_ERR_CURSOR, (String)result.getMessagesCombined().toString());
                                    return;
                                }
                                result = editor2.getSessionIdentifier().sendCommand(command, null, howIsGoing);
                                if (result.getRC() >= 8) {
                                    PDDialogs.openErrorThreadSafe((String)MessageFormat.format(Messages.ExcludeAction_ERR, command), (String)result.getMessagesCombined().toString());
                                    return;
                                }
                                monitor.worked(1);
                                if (dialog.isExcludeAll()) {
                                    if (result.getMessagesCombined().indexOf("FMNBE223") != -1 || result.getMessagesCombined().indexOf("FMNBE222") != -1) {
                                        PDDialogs.openInfoThreadSafe((String)Messages.FMPlugin_INFO_TITLE, (String)MessageFormat.format(Messages.ExcludeAction_NO_MATCH, command), (String)result.getMessagesCombined().toString());
                                    } else if (!editor2.loadRecordsFromHost(howIsGoing)) {
                                        PDDialogs.openErrorThreadSafe((String)Messages.ExcludeRecords_ErrorLoading);
                                        return;
                                    }
                                } else if (result.getMessagesCombined().indexOf("FMNBE223") != -1 || result.getMessagesCombined().indexOf("FMNBE222") != -1) {
                                    PDDialogs.openInfoThreadSafe((String)Messages.FMPlugin_INFO_TITLE, (String)MessageFormat.format(Messages.ExcludeAction_NO_MATCH, command), (String)result.getMessagesCombined().toString());
                                    if (!editor2.loadRecordsFromHostSetLocationFirst(howIsGoing, excludeStartRec)) {
                                        PDDialogs.openErrorThreadSafe((String)Messages.ExcludeRecords_ErrorLoading);
                                        return;
                                    }
                                } else if (!editor2.loadRecordsFromHost(howIsGoing)) {
                                    PDDialogs.openErrorThreadSafe((String)Messages.ExcludeRecords_ErrorLoading);
                                    return;
                                }
                                monitor.worked(1);
                                monitor.done();
                            }
                            catch (InterruptedException e) {
                                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                                editor2.disableEditorActions();
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX, (Throwable)e);
                }
                catch (InterruptedException e) {
                    PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                    editor2.disableEditorActions();
                }
            }
        } else {
            PDDialogs.openInfoThreadSafe((String)Messages.ExcludeRecords_ExcludeNotSupportedInCurrentEditor);
        }
    }
}

