/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.dialogs.DeleteDialog;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexForImsOperation;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.editor.formatted.pages.advanced.AdvancedModePage;
import com.ibm.etools.fm.editor.formatted1.dialogs.ImsDeleteDialog;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class DeleteRecords
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void editorCommandHandler(IFMEditor editor2) {
        if (!editor2.isEditSession()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_NON_EDIT_SESSION);
            return;
        }
        if (editor2.getSessionProperties().isInplaceEdit() && !editor2.getSessionProperties().isPseudoDelEnabled()) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
            return;
        }
        if (!editor2.updateDirtyContents()) return;
        ArrayList<RecType> selectedItems = editor2.getSelectedNonShadowLines();
        if (editor2.getSessionIdentifier().getSessionType() == AbstractSessionFormatted.SessionType.IMS) {
            if (selectedItems == null || selectedItems.isEmpty()) {
                return;
            }
            ImsDeleteDialog dialogIMS = new ImsDeleteDialog(selectedItems.get(0));
            if (dialogIMS.open() != 0) {
                return;
            }
            ArrayList<RecType> recsToDelete = DeleteRecords.prepareDeleteRecords(selectedItems);
            try {
                if (!UpdateHostEditorChainInHexOperation.execute(editor2, recsToDelete, editor2.getTopRecord(), 1)) return;
                editor2.getSessionProperties().updateTotalNumRecords(recsToDelete.size(), false);
                editor2.updateLocationInformation(-1);
                return;
            }
            catch (InterruptedException e) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                editor2.disableEditorActions();
                return;
            }
        }
        FormattedEditor ifm = (FormattedEditor)editor2;
        if (ifm.getCurrentPage() instanceof AdvancedModePage && (selectedItems == null || selectedItems.isEmpty())) {
            PDDialogs.openInfoThreadSafe((String)Messages.DeleteActionItem_NO_ITEM_TO_DELETE);
            return;
        }
        DeleteDialog dialog = new DeleteDialog(selectedItems.size());
        if (dialog.open() != 0) {
            return;
        }
        if (dialog.isDeleteAll()) {
            DeleteRecords.deleteAllRecords(editor2);
            editor2.getSessionProperties().setToZero();
            editor2.updateLocationInformation(-1);
            editor2.setDirty(true);
            return;
        }
        ArrayList<RecType> recsToDelete = DeleteRecords.prepareDeleteRecords(selectedItems);
        try {
            if (UpdateHostEditorChainInHexForImsOperation.execute(editor2, recsToDelete, editor2.getTopRecord())) {
                editor2.getSessionProperties().updateTotalNumRecords(recsToDelete.size(), false);
                editor2.updateLocationInformation(-1);
            }
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            editor2.disableEditorActions();
            return;
        }
        editor2.setDirty(true);
    }

    private static ArrayList<RecType> prepareDeleteRecords(ArrayList<RecType> original) {
        ArrayList<RecType> recsToDelete = new ArrayList<RecType>();
        int i = 0;
        while (i < original.size()) {
            RecType aRec = original.get(i);
            RecType aRecToDel = FMNXEDITFactory.eINSTANCE.createRecType();
            aRecToDel.setDel(true);
            aRecToDel.setToken(aRec.getToken());
            if (aRec.isSetSeq()) {
                aRecToDel.setSeq(aRec.getSeq());
            }
            if (aRec.isSetSeg()) {
                aRecToDel.setSeg(aRec.getSeg());
            }
            aRecToDel.setHex(aRec.getHex());
            aRecToDel.setRecno(aRec.getRecno());
            recsToDelete.add(aRecToDel);
            ++i;
        }
        return recsToDelete;
    }

    private static void deleteAllRecords(final IFMEditor editor2) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.DeleteAction_DEL_ALL, 2);
                    IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                    Result result = editor2.getSessionIdentifier().sendCommand("DELETE ALL", null, howIsGoing);
                    if (result.getRC() < 8) {
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.worked(1);
                        if (!editor2.loadRecordsFromHost(howIsGoing)) {
                            return;
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PDDialogs.openErrorThreadSafe((String)Messages.EditorAction_EX);
        }
        catch (InterruptedException e) {
            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
            editor2.disableEditorActions();
        }
    }
}

