/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted2.dialogs.DReditSelectionDialog;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.logging.PDLoggerJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;

public class DRedit
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2022. All rights reserved. \u00a9 Copyright IBM Corp.  2013, 2017. All rights reserved.";
    private static final PDLoggerJhost logger = PDLoggerJhost.get(DRedit.class);
    private Result<String[][]> result;

    @Override
    protected void editorCommandHandler(IFMEditor editor2) {
        if (editor2 instanceof FormattedEditor) {
            StructuredSelection structuredSel;
            final Db2Table db2Table = (Db2Table)((FormattedEditor)editor2).getEditorInput().getResource();
            Map<String, String> colNoToValsMap = ((FormattedEditor)editor2).getColNoToValuesMap();
            ISelection selection = ((FormattedEditor)editor2).getEditorSite().getSelectionProvider().getSelection();
            DisplayLine dl = null;
            if (selection instanceof StructuredSelection && (structuredSel = (StructuredSelection)selection) != null && !structuredSel.isEmpty()) {
                dl = (DisplayLine)structuredSel.getFirstElement();
            }
            String owner = db2Table.getOwner();
            String tableName = db2Table.getName();
            final StringBuilder sb = DRedit.getSQLQuery(owner, tableName);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Loading Records...", 1);
                        IHowIsGoing howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        Db2SqlQuery query = new Db2SqlQuery(db2Table.getSubsystem(), sb.toString());
                        DRedit.this.result = query.execute(howIsGoing);
                        monitor.worked(1);
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                logger.trace((Throwable)e);
            }
            if (this.result.isSuccessfulWithoutWarnings()) {
                DReditSelectionDialog dialog = new DReditSelectionDialog(db2Table.getSubsystem(), (String[][])this.result.getOutput(), colNoToValsMap, dl, editor2.isEditSession());
                dialog.open();
            }
        }
    }

    private static StringBuilder getSQLQuery(String owner, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT FKY.CREATOR, FKY.TBNAME, FKY.RELNAME, FKY.COLNAME,FKY.COLNO, FKY.COLSEQ, REL.REFTBNAME, REL.REFTBCREATOR, COL.NAME");
        sb.append(" FROM ");
        sb.append("SYSIBM.SYSFOREIGNKEYS FKY, SYSIBM.SYSRELS REL, SYSIBM.SYSCOLUMNS COL");
        sb.append(" WHERE ");
        sb.append("FKY.TBNAME = '");
        sb.append(tableName);
        sb.append("'");
        sb.append(" AND FKY.CREATOR = '");
        sb.append(owner);
        sb.append("'");
        sb.append(" AND REL.TBNAME    = '");
        sb.append(tableName);
        sb.append("'");
        sb.append(" AND REL.CREATOR   = '");
        sb.append(owner);
        sb.append("'");
        sb.append(" AND REL.RELNAME   = FKY.RELNAME");
        sb.append(" AND REL.IXOWNER   = ' '");
        sb.append(" AND  COL.TBNAME    = REL.REFTBNAME AND COL.TBCREATOR = REL.REFTBCREATOR");
        sb.append(" AND COL.KEYSEQ    = FKY.COLSEQ");
        sb.append(" UNION ALL SELECT ");
        sb.append("FKY.CREATOR, FKY.TBNAME, FKY.RELNAME, FKY.COLNAME,  FKY.COLNO, FKY.COLSEQ, REL.REFTBNAME, REL.REFTBCREATOR, COL.NAME");
        sb.append(" FROM ");
        sb.append("SYSIBM.SYSFOREIGNKEYS FKY, SYSIBM.SYSRELS REL, SYSIBM.SYSKEYS K,SYSIBM.SYSCOLUMNS COL");
        sb.append(" WHERE ");
        sb.append("FKY.TBNAME = '");
        sb.append(tableName);
        sb.append("'");
        sb.append(" AND FKY.CREATOR ='");
        sb.append(owner);
        sb.append("'");
        sb.append(" AND REL.CREATOR = '");
        sb.append(owner);
        sb.append("'");
        sb.append(" AND REL.TBNAME = '");
        sb.append(tableName);
        sb.append("'");
        sb.append(" AND REL.CREATOR   = '");
        sb.append(owner);
        sb.append("'");
        sb.append(" AND REL.RELNAME   = FKY.RELNAME AND REL.IXOWNER  <> ' '");
        sb.append(" AND K.IXCREATOR   = REL.IXOWNER AND K.IXNAME = REL.IXNAME");
        sb.append(" AND COL.TBNAME    = REL.REFTBNAME");
        sb.append(" AND COL.TBNAME    = REL.REFTBNAME");
        sb.append(" AND COL.TBCREATOR =  REL.REFTBCREATOR");
        sb.append(" AND COL.COLNO     = K.COLNO");
        sb.append(" ORDER BY 4, 7 FOR FETCH ONLY");
        return sb;
    }
}

