/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.handler.Clipboard;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted.operations.UpdateHostEditorChainInHexOperation;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;

public class CutRecords
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(IFMEditor ifm) {
        if (ifm instanceof FormattedEditor) {
            FormattedEditor editor2 = (FormattedEditor)ifm;
            if (!editor2.isEditSession()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_NON_EDIT_SESSION);
            } else if (editor2.getSessionProperties().isInplaceEdit()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
            } else {
                int[] selection = editor2.getSelection();
                if (editor2.updateDirtyContents()) {
                    ArrayList<RecType> selectedItems = editor2.getCurrentPage().getSelectedNonShadowLines();
                    if (selectedItems == null || selectedItems.isEmpty()) {
                        PDDialogs.openInfoThreadSafe((String)Messages.CutAction_NO_ITEM);
                    } else {
                        Clipboard.add(selectedItems, editor2.getResource());
                        ArrayList<RecType> recsToDelete = CutRecords.prepareDeleteRecords(selectedItems);
                        try {
                            if (UpdateHostEditorChainInHexOperation.execute(editor2, recsToDelete, editor2.getTopRecord(), 1)) {
                                editor2.getSessionProperties().updateTotalNumRecords(recsToDelete.size(), false);
                                editor2.updateLocationInformation(-1);
                            }
                            editor2.setDirty(true);
                            editor2.setSelection(selection);
                        }
                        catch (InterruptedException e) {
                            PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_CACELLED);
                            editor2.disableEditorActions();
                        }
                    }
                }
            }
        } else {
            PDDialogs.openInfoThreadSafe((String)Messages.CutRecords_CutNotSupportedINCurrentEditor);
        }
    }

    private static ArrayList<RecType> prepareDeleteRecords(ArrayList<RecType> original) {
        ArrayList<RecType> recsToDelete = new ArrayList<RecType>();
        int i = 0;
        while (i < original.size()) {
            RecType aRec = original.get(i);
            RecType aRecToDel = FMNXEDITFactory.eINSTANCE.createRecType();
            aRecToDel.setDel(true);
            aRecToDel.setToken(aRec.getToken());
            aRecToDel.setSeq(aRec.getSeq());
            aRecToDel.setHex(aRec.getHex());
            aRecToDel.setRecno(aRec.getRecno());
            recsToDelete.add(aRecToDel);
            ++i;
        }
        return recsToDelete;
    }
}

