/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.editor.formatted.handler;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.editor.formatted.FormattedEditor;
import com.ibm.etools.fm.editor.formatted.FormattedEditorUtility;
import com.ibm.etools.fm.editor.formatted.IFMEditor;
import com.ibm.etools.fm.editor.formatted.contents.DisplayLine;
import com.ibm.etools.fm.editor.formatted.handler.Clipboard;
import com.ibm.etools.fm.editor.formatted.handler.IFMEditorHandler;
import com.ibm.etools.fm.editor.formatted.pages.advanced.AdvancedModePage;
import com.ibm.etools.fm.model.formatted.FMNXEDITFactory;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.ui.util.PDDialogs;
import java.util.ArrayList;
import java.util.List;

public class BlockPaste
extends IFMEditorHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";

    @Override
    protected void editorCommandHandler(IFMEditor ifm) {
        if (ifm instanceof FormattedEditor) {
            FormattedEditor editor2 = (FormattedEditor)ifm;
            if (!editor2.isEditSession()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_NON_EDIT_SESSION);
            } else if (editor2.getSessionProperties().isInplaceEdit()) {
                PDDialogs.openInfoThreadSafe((String)Messages.EditorAction_INVALID_FOR_INPLACE);
            } else {
                List<Object[]> contents = Clipboard.getBlockContents();
                if (contents.size() == 0) {
                    PDDialogs.openInfoThreadSafe((String)Messages.PasteAction_NO_ITEM_TO_PASTE);
                    return;
                }
                int rowIndex = -1;
                int colIndex = -1;
                if (editor2.updateDirtyContents()) {
                    if (editor2.getCurrentPage() instanceof AdvancedModePage) {
                        int[][] position = ((AdvancedModePage)editor2.getCurrentPage()).getSelection();
                        rowIndex = position[0][0];
                        colIndex = position[0][1];
                    }
                    int i = 0;
                    while (i < contents.size()) {
                        Object[] selectionRow = contents.get(i);
                        int currentColIndex = colIndex;
                        int j = 0;
                        while (j < selectionRow.length) {
                            String newValue = (String)selectionRow[j];
                            DisplayLine currentLine = editor2.getCurrentEditorContents().get(rowIndex);
                            editor2.updateFieldValue(currentLine, currentColIndex, newValue, false);
                            ++currentColIndex;
                            ++j;
                        }
                        ++rowIndex;
                        ++i;
                    }
                    editor2.getCurrentPage().updateHostEditorChain();
                }
            }
        }
    }

    private static List<RecType> prepareRecordsToInsert(FormattedEditor editor2, List<RecType> original, String[] newRecords, boolean insertAtTop) {
        RecType anchorRec = null;
        anchorRec = insertAtTop ? BlockPaste.createTopRecType() : (original == null || original.isEmpty() ? BlockPaste.createTopRecType() : original.get(0));
        ArrayList<RecType> recsToInsert = new ArrayList<RecType>();
        int newItemIndex = 1;
        String[] stringArray = newRecords;
        int n = newRecords.length;
        int n2 = 0;
        while (n2 < n) {
            String newRecHex = stringArray[n2];
            RecType aRecToInsert = FMNXEDITFactory.eINSTANCE.createRecType();
            aRecToInsert.setInsert(true);
            aRecToInsert.setToken(anchorRec.getToken());
            if (anchorRec.isSetSeq()) {
                aRecToInsert.setSeq(anchorRec.getSeq() + newItemIndex);
            } else {
                aRecToInsert.setSeq(newItemIndex);
            }
            ++newItemIndex;
            aRecToInsert.setHex(FormattedEditorUtility.checkRecordLength(newRecHex, editor2.getSessionProperties(), anchorRec, true, FormattedEditorUtility.getSpaceHexValue(editor2.getResource().getPersistentProperty("encoding"))));
            recsToInsert.add(aRecToInsert);
            ++n2;
        }
        return recsToInsert;
    }

    private static RecType createTopRecType() {
        RecType topRec = FMNXEDITFactory.eINSTANCE.createRecType();
        topRec.setToken("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
        topRec.setSeq(0);
        return topRec;
    }
}

